/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.atom.impl;

import com.tydic.payment.pay.atom.PorderPayTransAtomService;
import com.tydic.payment.pay.atom.bo.PorderPayTransAtomReqBo;
import com.tydic.payment.pay.atom.bo.PorderPayTransAtomRspBo;
import com.tydic.payment.pay.config.PaySequenceConfigManager;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.constant.PaySequenceKeys;
import com.tydic.payment.pay.dao.PayMethodMapper;
import com.tydic.payment.pay.dao.PorderPayTransMapper;
import com.tydic.payment.pay.dao.po.DBDatePo;
import com.tydic.payment.pay.dao.po.PorderPayTransPo;
import com.tydic.payment.pay.dao.po.PorderPayTransStatisticResultPo;
import com.tydic.payment.pay.exception.BusinessException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="porderPayTransAtomService")
public class PorderPayTransAtomServiceImpl
implements PorderPayTransAtomService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private PorderPayTransMapper porderPayTransMapper;
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private PayMethodMapper payMethodMapper;
    @Autowired
    private PaySequenceConfigManager paySequenceConfigManager;

    @Override
    public String createOrderPayTrans(PorderPayTransAtomReqBo req) throws Exception {
        if (req == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u65b0\u589e\u652f\u4ed8\u8bf7\u6c42\u539f\u5b50\u670d\u52a1\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getOrderId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u65b0\u589e\u652f\u4ed8\u8bf7\u6c42\u539f\u5b50\u670d\u52a1\u5165\u53c2\u8ba2\u5355\u7f16\u53f7\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getBusiId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u65b0\u589e\u652f\u4ed8\u8bf7\u6c42\u539f\u5b50\u670d\u52a1\u5165\u53c2\u4e1a\u52a1\u7cfb\u7edfid\u3010busiId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String pay_order_id = this.createPayOrderIdNew();
        if (!StringUtils.isEmpty((Object)req.getPayOrderId())) {
            pay_order_id = req.getPayOrderId();
        }
        PorderPayTransPo po = new PorderPayTransPo();
        BeanUtils.copyProperties((Object)req, (Object)po);
        po.setPayOrderId(pay_order_id);
        DBDatePo dbDate = this.payMethodMapper.getDBDate();
        if (req.getCreateTime() != null) {
            po.setCreateTime(req.getCreateTime());
        } else {
            po.setCreateTime(dbDate.getDate());
        }
        po.setUpdateTime(dbDate.getDate());
        po.setRefundFee(0L);
        int count = this.porderPayTransMapper.insert(po);
        if (count < 1) {
            throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", "\u65b0\u589e\u652f\u4ed8\u8bf7\u6c42\u539f\u5b50\u670d\u52a1\uff0c\u65b0\u589e\u5931\u8d25\uff01");
        }
        return pay_order_id;
    }

    private String createPayOrderIdNew() {
        String payOrderId = null;
        try {
            payOrderId = this.payPropertiesVo.getProjectName() + this.paySequenceConfigManager.nextId(PaySequenceKeys.SEQUENCE_PAY_ORDER_ID.getSequenceName());
        }
        catch (SQLException e) {
            throw new BusinessException("1003", "\u83b7\u53d6payOrderId\u5f02\u5e38", (Throwable)e);
        }
        return payOrderId;
    }

    private String createPayOrderId() {
        Calendar now = Calendar.getInstance();
        String month = Integer.toString(now.get(2) + 1);
        String day = Integer.toString(now.get(5));
        String hours = Integer.toString(now.get(11));
        String minutes = Integer.toString(now.get(12));
        String seconds = Integer.toString(now.get(13));
        if (month.length() == 1) {
            month = "0" + month;
        }
        if (day.length() == 1) {
            day = "0" + day;
        }
        if (hours.length() == 1) {
            hours = "0" + hours;
        }
        if (minutes.length() == 1) {
            minutes = "0" + minutes;
        }
        if (seconds.length() == 1) {
            seconds = "0" + seconds;
        }
        Long seq = System.currentTimeMillis();
        String pay_order_id = seq.toString().substring(0, 12);
        pay_order_id = "CQPAY" + now.get(1) + month + day + hours + minutes + seconds + pay_order_id;
        return pay_order_id;
    }

    @Override
    public void updateOrderPayTransByPayOrderId(PorderPayTransAtomReqBo req) throws Exception {
        if (req == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u66f4\u65b0\u652f\u4ed8\u8bf7\u6c42\u4fe1\u606f\u539f\u5b50\u670d\u52a1\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getPayOrderId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u66f4\u65b0\u652f\u4ed8\u8bf7\u6c42\u4fe1\u606f\u539f\u5b50\u670d\u52a1\u5165\u53c2\u3010payOrderId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getOrderId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u66f4\u65b0\u652f\u4ed8\u8bf7\u6c42\u4fe1\u606f\u539f\u5b50\u670d\u52a1\u5165\u53c2\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        PorderPayTransPo po = new PorderPayTransPo();
        BeanUtils.copyProperties((Object)req, (Object)po);
        DBDatePo dbDate = this.payMethodMapper.getDBDate();
        po.setUpdateTime(dbDate.getDate());
        this.porderPayTransMapper.update(po);
    }

    @Override
    public PorderPayTransAtomRspBo queryOrderPayTransByPayOrderId(PorderPayTransAtomReqBo req) throws Exception {
        if (req == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u652f\u4ed8\u8bf7\u6c42\u4fe1\u606f\u539f\u5b50\u670d\u52a1\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getPayOrderId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u652f\u4ed8\u8bf7\u6c42\u4fe1\u606f\u539f\u5b50\u670d\u52a1\u5165\u53c2\u3010payOrderId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        PorderPayTransPo po = new PorderPayTransPo();
        BeanUtils.copyProperties((Object)req, (Object)po);
        PorderPayTransPo porderPayTransPo = this.porderPayTransMapper.getOrderPayTransByPayOrderId(po);
        if (porderPayTransPo != null) {
            PorderPayTransAtomRspBo porderPayTransAtomRspBo = new PorderPayTransAtomRspBo();
            BeanUtils.copyProperties((Object)porderPayTransPo, (Object)porderPayTransAtomRspBo);
            return porderPayTransAtomRspBo;
        }
        return null;
    }

    @Override
    public List<PorderPayTransAtomRspBo> queryOrderPayTransByCondition(PorderPayTransAtomReqBo req) {
        PorderPayTransPo po = new PorderPayTransPo();
        if (req == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u539f\u5b50\u670d\u52a1\u67e5\u8be2\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BeanUtils.copyProperties((Object)req, (Object)po);
        List<PorderPayTransPo> poList = this.porderPayTransMapper.getOrderPayTransByCondition(po);
        ArrayList<PorderPayTransAtomRspBo> rspList = new ArrayList<PorderPayTransAtomRspBo>();
        if (poList != null && poList.size() > 0) {
            for (PorderPayTransPo transPo : poList) {
                PorderPayTransAtomRspBo bo = new PorderPayTransAtomRspBo();
                BeanUtils.copyProperties((Object)transPo, (Object)bo);
                rspList.add(bo);
            }
        }
        return rspList;
    }

    @Override
    public List<PorderPayTransPo> queryOrderPayTrans(PorderPayTransPo po) {
        List<PorderPayTransPo> queryOrderPayTrans;
        if (po == null) {
            po = new PorderPayTransPo();
        }
        if ((queryOrderPayTrans = this.porderPayTransMapper.queryOrderPayTrans(po)) == null || queryOrderPayTrans.isEmpty()) {
            return new ArrayList<PorderPayTransPo>();
        }
        return queryOrderPayTrans;
    }

    @Override
    public PorderPayTransAtomRspBo queryOrderPayTransByPayNotifyTransId(String payNotifyTransId) {
        if (StringUtils.isEmpty((Object)payNotifyTransId)) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u539f\u5b50\u670d\u52a1\u67e5\u8be2\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PorderPayTransAtomRspBo rsp = this.porderPayTransMapper.queryOrderPayTransByPayNotifyTransId(payNotifyTransId);
        return rsp;
    }

    @Override
    public PorderPayTransAtomRspBo queryLastRecordByOrderId(Long orderId) {
        PorderPayTransPo po = this.porderPayTransMapper.queryLastRecordByOrderId(orderId);
        if (po == null) {
            return null;
        }
        PorderPayTransAtomRspBo rsp = new PorderPayTransAtomRspBo();
        BeanUtils.copyProperties((Object)po, (Object)rsp);
        return rsp;
    }

    @Override
    public List<PorderPayTransPo> queryOrderPayTransByOrderStatusSetCondition(PorderPayTransPo qryPorderPayTranasPo, Set<String> orderStatusSet) {
        PorderPayTransPo po = new PorderPayTransPo();
        if (qryPorderPayTranasPo == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u539f\u5b50\u670d\u52a1\u67e5\u8be2\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(orderStatusSet)) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u539f\u5b50\u670d\u52a1\u67e5\u8be2\u5165\u53c2\u8ba2\u5355\u72b6\u6001\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BeanUtils.copyProperties((Object)qryPorderPayTranasPo, (Object)po);
        List<PorderPayTransPo> poList = this.porderPayTransMapper.queryOrderPayTransByOrderStatusSetCondition(po, orderStatusSet);
        return poList;
    }

    @Override
    public List<Long> queryOrderIdOfMerchantIdSetByCondition(PorderPayTransPo qryPorderPayTranasPo, Set<Long> merchantIdSet) {
        PorderPayTransPo po = new PorderPayTransPo();
        if (qryPorderPayTranasPo == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u539f\u5b50\u670d\u52a1\u67e5\u8be2\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(merchantIdSet)) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u539f\u5b50\u670d\u52a1\u67e5\u8be2\u5165\u53c2\u5546\u6237ID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BeanUtils.copyProperties((Object)qryPorderPayTranasPo, (Object)po);
        List<Long> poList = this.porderPayTransMapper.queryOrderIdOfMerchantIdSetByCondition(po, merchantIdSet);
        return poList;
    }

    @Override
    public List<PorderPayTransStatisticResultPo> countIncomeOfMerchants(PorderPayTransPo qryPorderPayTranasPo, Set<Long> merchantIdSet) {
        if (CollectionUtils.isEmpty(merchantIdSet)) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u539f\u5b50\u670d\u52a1\u67e5\u8be2\u5165\u53c2\u5546\u6237ID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<PorderPayTransStatisticResultPo> poList = this.porderPayTransMapper.countIncomeOfMerchants(qryPorderPayTranasPo, merchantIdSet);
        return poList;
    }

    @Override
    public int deleteRecordByPayOrderId(PorderPayTransPo po) {
        return this.porderPayTransMapper.deleteRecordByPayOrderId(po);
    }
}

