/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.payment.pay.atom.BusiSystemInfoAtomService;
import com.tydic.payment.pay.atom.PayOrderAtomService;
import com.tydic.payment.pay.atom.PorderPayTransAtomService;
import com.tydic.payment.pay.bo.CouponEntity;
import com.tydic.payment.pay.bo.NoticePayData;
import com.tydic.payment.pay.busi.CallBackNoticeService;
import com.tydic.payment.pay.busi.QueryDBDateBusiService;
import com.tydic.payment.pay.busi.bo.CallBackNoticeReqBo;
import com.tydic.payment.pay.busi.bo.CallBackNoticeRspBo;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.dao.po.BusiSystemInfoPO;
import com.tydic.payment.pay.dao.po.PorderPayTransPo;
import com.tydic.payment.pay.dao.po.PorderPo;
import com.tydic.payment.pay.exception.BusinessException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="callBackNoticeService")
public class CallBackNoticeServiceImpl
implements CallBackNoticeService {
    private static final Logger log = LoggerFactory.getLogger(CallBackNoticeServiceImpl.class);
    @Autowired
    private PayOrderAtomService payOrderAtomService;
    @Autowired
    private PorderPayTransAtomService porderPayTransAtomService;
    @Autowired
    private BusiSystemInfoAtomService busiSystemInfoAtomService;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Resource(name="callBack")
    private ProxyMessageProducer callBack;

    public CallBackNoticeRspBo dealPayPutMq(CallBackNoticeReqBo callBackNoticeReqBo) {
        CallBackNoticeRspBo callBackNoticeRspBo = new CallBackNoticeRspBo();
        PorderPo orderInfo = new PorderPo();
        try {
            if (callBackNoticeReqBo == null) {
                log.info("\u6d88\u606f\u53d1\u9001\u7684\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u6d88\u606f\u53d1\u9001\u7684\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((Object)callBackNoticeReqBo.getOrderId())) {
                log.info("\u6d88\u606f\u5165\u53c2 \uff1a orderId \u4e0d\u80fd\u4e3a\u7a7a");
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u6d88\u606f\u5165\u53c2 \uff1a orderId \u4e0d\u80fd\u4e3a\u7a7a");
            }
            orderInfo = this.payOrderAtomService.queryPorderInfo(callBackNoticeReqBo.getOrderId());
            if (orderInfo == null) {
                log.info("\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f");
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f");
            }
            if (StringUtils.isEmpty((Object)orderInfo.getNotifyUrl())) {
                callBackNoticeRspBo.setRspCode("0000");
                callBackNoticeRspBo.setRspName("\u8ba2\u5355\u4e0d\u9700\u8981\u8fdb\u884c\u5f02\u6b65\u901a\u77e5\uff1borderId = " + orderInfo.getOrderId());
                log.info("\u8ba2\u5355\u4e0d\u9700\u8981\u8fdb\u884c\u5f02\u6b65\u901a\u77e5\uff1borderId = " + orderInfo.getOrderId());
                return callBackNoticeRspBo;
            }
            PorderPayTransPo porderPayTransPo = new PorderPayTransPo();
            porderPayTransPo.setOrderId(callBackNoticeReqBo.getOrderId());
            porderPayTransPo.setOrderStatus("A10");
            List<PorderPayTransPo> pOrderTrans = this.porderPayTransAtomService.queryOrderPayTrans(porderPayTransPo);
            if (pOrderTrans.size() == 0) {
                log.info("\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f");
                callBackNoticeRspBo.setRspCode("8888");
                callBackNoticeRspBo.setRspName("\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f");
                return callBackNoticeRspBo;
            }
            if (!"01".equals(orderInfo.getOrderType())) {
                log.info("\u8ba2\u5355\u53f7 \u3010orderId \u3011 =" + callBackNoticeReqBo.getOrderId() + "\u4e0d\u662f\u652f\u4ed8\u8ba2\u5355");
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8ba2\u5355\u53f7 \u3010orderId \u3011 =" + callBackNoticeReqBo.getOrderId() + "\u4e0d\u662f\u652f\u4ed8\u8ba2\u5355");
            }
            if ("A00".equals(orderInfo.getOrderStatus())) {
                log.info("\u8ba2\u5355\u53f7 \u3010orderId \u3011 =" + callBackNoticeReqBo.getOrderId() + "\u672a\u652f\u4ed8\uff0c\u4e0d\u80fd\u53d1\u8d77\u901a\u77e5");
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8ba2\u5355\u53f7 \u3010orderId \u3011 =" + callBackNoticeReqBo.getOrderId() + "\u672a\u652f\u4ed8\uff0c\u4e0d\u80fd\u53d1\u8d77\u901a\u77e5");
            }
            BusiSystemInfoPO busiSystemInfoPO = new BusiSystemInfoPO();
            busiSystemInfoPO.setBusiId(orderInfo.getBusiId());
            List<BusiSystemInfoPO> busiSystem = this.busiSystemInfoAtomService.queryBusiSystemInfoByCondition(busiSystemInfoPO);
            if (busiSystem.size() == 0) {
                log.info("\u672a\u67e5\u8be2\u5230 \u4e1a\u52a1\u7cfb\u7edf\u3010busiId = " + orderInfo.getBusiId() + "\u3011\u7684\u4fe1\u606f");
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u672a\u67e5\u8be2\u5230 \u4e1a\u52a1\u7cfb\u7edf\u3010busiId = " + orderInfo.getBusiId() + "\u3011\u7684\u4fe1\u606f\uff0c\u4e0d\u80fd\u53d1\u8d77\u901a\u77e5");
            }
            Object obj = CallBackNoticeServiceImpl.packagPayNoticeData(orderInfo, pOrderTrans);
            String payNotifyTransId = pOrderTrans.get(0).getPayNotifyTransId();
            log.info("\u652f\u4ed8\u4e2d\u5fc3\u56de\u8c03\u7684payNotifyTransId\u4e3a\uff1a" + payNotifyTransId);
            log.info("\u652f\u4ed8\u4e2d\u5fc3\u51c6\u5907\u8c03\u4e86\uff0c\u56de\u8c03\u7c7b\u578b\u4e3a\uff1a" + busiSystem.get(0).getCallType());
            if (2 == busiSystem.get(0).getCallType()) {
                JSONObject data = JSONObject.parseObject((String)obj.toString());
                data.put("callType", (Object)busiSystem.get(0).getCallType());
                data.put("notifyUrl", (Object)orderInfo.getNotifyUrl());
                data.put("payNotifyTransId", (Object)payNotifyTransId);
                log.info("\u652f\u4ed8\u4e2d\u5fc3\u5904\u7406\u5b8c\u6210\u56de\u8c03\u80fd\u529b\u5e73\u53f0\uff1a" + data.toJSONString());
                this.callBack.send(new ProxyMessage(this.payPropertiesVo.getPayNotifyMqTopic(), this.payPropertiesVo.getPayNotifyMqTag(), JSONObject.toJSONString((Object)data)));
            } else if (3 == busiSystem.get(0).getCallType()) {
                JSONObject data = JSONObject.parseObject((String)obj.toString());
                data.put("callType", (Object)busiSystem.get(0).getCallType());
                data.put("notifyUrl", (Object)orderInfo.getNotifyUrl());
                data.put("payNotifyTransId", (Object)payNotifyTransId);
                if (!StringUtils.isEmpty((Object)callBackNoticeReqBo.getPaymentInsReturnData())) {
                    data.put("paymentInsReturnData", (Object)callBackNoticeReqBo.getPaymentInsReturnData());
                }
                log.info("\u652f\u4ed8\u4e2d\u5fc3\u901a\u8fc7http\u56de\u8c03\u7684\u53c2\u6570\uff1a" + data.toJSONString());
                this.callBack.send(new ProxyMessage(this.payPropertiesVo.getPayNotifyMqTopic(), this.payPropertiesVo.getPayNotifyMqTag(), JSONObject.toJSONString((Object)data)));
            } else {
                log.info("\u8bf7\u6dfb\u52a0\u5f02\u6b65\u901a\u77e5\u914d\u7f6e\u3002\u5f02\u6b65\u901a\u77e5\u7c7b\u578b\u4e3a\uff1a callType = " + busiSystem.get(0).getCallType());
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8bf7\u6dfb\u52a0\u5f02\u6b65\u901a\u77e5\u914d\u7f6e\u3002\u5f02\u6b65\u901a\u77e5\u7c7b\u578b\u4e3a\uff1a callType = " + busiSystem.get(0).getCallType());
            }
            callBackNoticeRspBo.setRspCode("0000");
            callBackNoticeRspBo.setRspName("\u53d1\u9001\u6d88\u606f\u4e3a\uff1a" + obj.toString());
            log.info("\u53d1\u9001\u6d88\u606f\u4e3a\uff1a" + obj.toString());
        }
        catch (Exception e) {
            log.error("\u6d88\u606f\u961f\u5217 put  \u5931\u8d25" + e.getMessage(), (Throwable)e);
            callBackNoticeRspBo.setRspCode("8888");
            callBackNoticeRspBo.setRspName("\u53d1\u9001\u6d88\u606f\u5f02\u5e38");
            if (orderInfo != null) {
                orderInfo.setCustNotifyMsg(e.getMessage());
                orderInfo.setCustNotifyTime(this.queryDBDateBusiService.getDBDate());
                orderInfo.setCustyNotifyCode("-");
            }
            this.payOrderAtomService.update(orderInfo);
        }
        return callBackNoticeRspBo;
    }

    public static Object packagPayNoticeData(PorderPo orderInfo, List<PorderPayTransPo> pOrderTrans) {
        NoticePayData data = new NoticePayData();
        try {
            if ("A10".equals(orderInfo.getOrderStatus())) {
                data.setResultCode("SUCCESS");
                data.setResultMsg("");
                data.setCreateOperId(orderInfo.getCreateOperId());
                data.setMerchantId(String.valueOf(orderInfo.getMerchantId()));
                data.setOrderAttrValue1(orderInfo.getOrderAttrValue1());
                data.setOrderAttrValue2(orderInfo.getOrderAttrValue2());
                data.setOrderAttrValue3(orderInfo.getOrderAttrValue3());
                data.setOutOrderId(orderInfo.getOutOrderId());
                data.setRealFee(!StringUtils.isEmpty((Object)orderInfo.getRealFee()) ? String.valueOf(MoneyUtils.haoToFen((Long)orderInfo.getRealFee())) : null);
                data.setRemark(orderInfo.getOutRemark());
                data.setReqWay(orderInfo.getReqWay());
                data.setBusiId(String.valueOf(orderInfo.getBusiCode()));
                data.setTotalFee(String.valueOf(MoneyUtils.haoToFen((Long)orderInfo.getTotalFee())));
                data.setTradeTime(orderInfo.getTradeTime());
                data.setTransactionsId(String.valueOf(orderInfo.getOrderId()));
                ArrayList<CouponEntity> couponList = new ArrayList<CouponEntity>();
                for (PorderPayTransPo transPo : pOrderTrans) {
                    CouponEntity couponEntity = null;
                    if ("71".equals(String.valueOf(transPo.getPayMethod()))) {
                        couponEntity = new CouponEntity();
                        couponEntity.setCouponType("1");
                        couponEntity.setCouponNo(transPo.getCouponNo());
                        couponEntity.setCouponValue(String.valueOf(MoneyUtils.haoToFen((Long)transPo.getPayFee())));
                        couponList.add(couponEntity);
                    } else {
                        data.setPayMethod(String.valueOf(transPo.getPayMethod()));
                    }
                    if (couponList.size() > 0) {
                        data.setCouponEntity(couponList);
                    }
                    if (couponList.size() <= 0 || !StringUtils.isEmpty((Object)data.getPayMethod())) continue;
                    data.setPayMethod(String.valueOf(pOrderTrans.get(0).getPayMethod()));
                }
            } else if ("A20".equals(orderInfo.getOrderStatus())) {
                data.setResultCode("FAIL");
                data.setResultMsg(pOrderTrans.get(0).getPayMsg());
            } else {
                data.setResultCode("FAIL");
                data.setResultMsg("\u8ba2\u5355\u672a\u652f\u4ed8");
            }
        }
        catch (Exception e) {
            log.error("\u5c01\u88c5\u91d1\u989d\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
        }
        return JSONObject.toJSONString((Object)data);
    }
}

