/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.tydic.payment.pay.atom.PCodeListAtomService;
import com.tydic.payment.pay.atom.PCodeTypeAtomService;
import com.tydic.payment.pay.busi.QueryPCodeInfoService;
import com.tydic.payment.pay.busi.bo.QueryPCodeInfoReqBO;
import com.tydic.payment.pay.busi.bo.QueryPCodeInfoRspBO;
import com.tydic.payment.pay.dao.po.PCodeListPO;
import com.tydic.payment.pay.dao.po.PCodeTypePO;
import com.tydic.payment.pay.exception.BusinessException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service(value="queryPCodeInfoService")
@RestController
@RequestMapping(value={"PAY_GROUP_LOCAL/2.0-SNAPSHOT/com.tydic.payment.pay.busi.QueryPCodeInfoService"})
public class QueryPCodeInfoServiceImpl
implements QueryPCodeInfoService {
    private static final Logger log = LoggerFactory.getLogger(QueryPCodeInfoServiceImpl.class);
    @Autowired
    PCodeTypeAtomService pCodeTypeAtomService;
    @Autowired
    PCodeListAtomService pCodeListAtomService;

    @PostMapping(value={"queryPCodeInfo"})
    public QueryPCodeInfoRspBO queryPCodeInfo(@RequestBody QueryPCodeInfoReqBO reqBO) {
        this.validateArg(reqBO);
        QueryPCodeInfoRspBO rspBO = new QueryPCodeInfoRspBO();
        PCodeTypePO pCodeTypePO = new PCodeTypePO();
        pCodeTypePO.setTypeCode(reqBO.getTypeCode());
        List<PCodeTypePO> pCodeTypePOList = this.pCodeTypeAtomService.queryPCodeTypeByCondition(pCodeTypePO);
        if (pCodeTypePOList == null || pCodeTypePOList.isEmpty()) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u67e5\u8be2\u5b57\u5178\u670d\u52a1\uff1a\u672a\u67e5\u8be2\u5230\u6570\u636e\u5b57\u5178\u7c7b\u578b");
            return rspBO;
        }
        PCodeListPO pCodeListPO = new PCodeListPO();
        pCodeListPO.setTypeCode(reqBO.getTypeCode());
        pCodeListPO.setCodeValue(reqBO.getCodeValue());
        List<PCodeListPO> pCodeListPOList = this.pCodeListAtomService.queryPCodeListByCondition(pCodeListPO);
        if (pCodeListPOList.size() > 1) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u67e5\u8be2\u5b57\u5178\u670d\u52a1\uff1a\u67e5\u51fa\u7684\u6570\u636e\u91cf\u8d85\u8fc7\u4e00\u6761\u4e86");
            return rspBO;
        }
        if (pCodeListPOList == null || pCodeListPOList.isEmpty()) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u67e5\u8be2\u5b57\u5178\u670d\u52a1\uff1a\u672a\u67e5\u8be2\u5230\u7ed3\u679c");
            return rspBO;
        }
        rspBO.setCodeInfo(pCodeListPOList.get(0).getCodeName());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void validateArg(QueryPCodeInfoReqBO bo) {
        if (bo == null) {
            log.info("\u67e5\u8be2\u6570\u636e\u5b57\u5178\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u6570\u636e\u5b57\u5178\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (bo.getTypeCode() == null || bo.getTypeCode().trim().isEmpty()) {
            log.info("\u67e5\u8be2\u6570\u636e\u5b57\u5178\u5165\u53c2\u3010typeCode\u3011\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u6570\u636e\u5b57\u5178\u5165\u53c2\u3010typeCode\u3011\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

