/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.comb.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.payment.pay.busi.CallBackNoticeService;
import com.tydic.payment.pay.busi.PayOrderBusiService;
import com.tydic.payment.pay.busi.PayProCreateOrderPayTransBusiService;
import com.tydic.payment.pay.busi.PayProQueryPayParaBusiService;
import com.tydic.payment.pay.busi.PayProUpdateOrderTransBusiService;
import com.tydic.payment.pay.busi.QueryDBDateBusiService;
import com.tydic.payment.pay.busi.bo.CallBackNoticeReqBo;
import com.tydic.payment.pay.busi.bo.CallBackNoticeRspBo;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayRspBo;
import com.tydic.payment.pay.busi.bo.PayOrderRspBo;
import com.tydic.payment.pay.busi.bo.PayProCreateOrderPayTransBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayProCreateOrderPayTransBusiRspBo;
import com.tydic.payment.pay.busi.bo.PayProQueryPayParaBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayProQueryPayParaBusiRspBo;
import com.tydic.payment.pay.busi.bo.PayProUpdateOrderTransBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayProUpdateOrderTransBusiRspBo;
import com.tydic.payment.pay.comb.PayAbleDealPayCombService;
import com.tydic.payment.pay.comb.bo.PayAbleDealPayCombReqBo;
import com.tydic.payment.pay.comb.bo.PayAbleDealPayCombRspBo;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.constant.PayProConstants;
import com.tydic.payment.pay.payable.api.PayAble;
import com.tydic.payment.pay.util.PayAbleManager;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service
@RestController
@RequestMapping(value={"PAY_GROUP_LOCAL/2.0-SNAPSHOT/com.tydic.payment.pay.comb.PayAbleDealPayCombService"})
public class PayAbleDealPayCombServiceImpl
implements PayAbleDealPayCombService {
    private static final Logger LOG = LoggerFactory.getLogger(PayAbleDealPayCombServiceImpl.class);
    @Autowired
    private PayOrderBusiService payOrderBusiService;
    @Autowired
    private PayProCreateOrderPayTransBusiService payProCreateOrderPayTransBusiService;
    @Autowired
    private PayAbleManager payAbleManager;
    @Autowired
    private PayProQueryPayParaBusiService payProQueryPayParaBusiService;
    @Autowired
    private PayProUpdateOrderTransBusiService payProUpdateOrderTransBusiService;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;
    @Autowired
    private CallBackNoticeService callBackNoticeService;

    @PostMapping(value={"dealOrder"})
    public PayAbleDealPayCombRspBo dealOrder(@RequestBody PayAbleDealPayCombReqBo reqBo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("\u7edf\u4e00\u4e0b\u5355\u7ec4\u5408\u670d\u52a1\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        }
        PayAbleDealPayCombRspBo retBo = new PayAbleDealPayCombRspBo();
        String validateArgStr = this.validateArg(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            retBo.setRespCode("3003");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return retBo;
        }
        Long payMethod = reqBo.getPayMethod();
        PayAble payAble = this.payAbleManager.getPayAbleByPayMethod(payMethod);
        Long orderId = reqBo.getOrderId();
        PayOrderRspBo orderInfoBo = this.payOrderBusiService.selectOrderByOrderId(reqBo.getOrderId());
        if (orderInfoBo == null || !"0000".equals(orderInfoBo.getRspCode())) {
            retBo.setRespCode("3003");
            retBo.setRespDesc("\u8be5\u8ba2\u5355(" + orderId + ")\u4e0d\u5b58\u5728");
            return retBo;
        }
        if ("A10".equals(orderInfoBo.getOrderStatus())) {
            retBo.setRespCode("3003");
            retBo.setRespDesc("\u8be5\u8ba2\u5355(" + orderId + ")\u5df2\u652f\u4ed8\u4e86\uff0c\u4e0d\u80fd\u91cd\u590d\u652f\u4ed8");
            return retBo;
        }
        if (!"A00".equals(orderInfoBo.getOrderStatus())) {
            retBo.setRespCode("3003");
            retBo.setRespDesc("\u8be5\u8ba2\u5355(" + orderId + ")\u72b6\u6001\u4e0d\u662f\u5f85\u652f\u4ed8\u72b6\u6001(" + orderInfoBo.getOrderStatus() + ")\uff0c\u4e0d\u80fd\u652f\u4ed8");
            return retBo;
        }
        Long busiId = orderInfoBo.getBusiId();
        Long merchantId = orderInfoBo.getMerchantId();
        Long payFee = MoneyUtils.haoToFen((Long)orderInfoBo.getTotalFee()).longValue();
        PayProCreateOrderPayTransBusiReqBo createTransBo = new PayProCreateOrderPayTransBusiReqBo();
        createTransBo.setPayOrderId(reqBo.getPayOrderId());
        createTransBo.setOrderId(orderId);
        createTransBo.setBusiId(busiId);
        createTransBo.setMerchantId(merchantId);
        createTransBo.setPayMethod(payMethod);
        createTransBo.setPayFee(payFee);
        PayProCreateOrderPayTransBusiRspBo payTrans = this.payProCreateOrderPayTransBusiService.createPayTrans(createTransBo);
        if (!"0000".equals(payTrans.getRespCode())) {
            retBo.setRespCode("3003");
            retBo.setRespDesc("\u8c03\u7528\u5199p_order_pay_trans\u4e1a\u52a1\u670d\u52a1\u9519\u8bef\uff1a" + payTrans.getRespDesc());
            return retBo;
        }
        PayProQueryPayParaBusiReqBo qryParaBo = new PayProQueryPayParaBusiReqBo();
        qryParaBo.setMerchantId(merchantId);
        qryParaBo.setPayMethod(payMethod);
        PayProQueryPayParaBusiRspBo payProQueryPayParaBusiRspBo = this.payProQueryPayParaBusiService.queryPayPara(qryParaBo);
        if (!"0000".equals(payProQueryPayParaBusiRspBo.getRespCode())) {
            retBo.setRespCode("3003");
            retBo.setRespDesc("\u67e5\u8be2\u652f\u4ed8\u53c2\u6570\u9519\u8bef\uff1a" + payProQueryPayParaBusiRspBo.getRespDesc());
            return retBo;
        }
        Map detailAttrs = payProQueryPayParaBusiRspBo.getDetailAttrs();
        String payOrderId = payTrans.getPayOrderId();
        PayAbleDealPayReqBo payAbleDealBo = new PayAbleDealPayReqBo();
        BeanUtils.copyProperties((Object)reqBo, (Object)payAbleDealBo);
        payAbleDealBo.setDetailName(orderInfoBo.getDetailName());
        payAbleDealBo.setOrderId(orderId);
        payAbleDealBo.setParaMap(detailAttrs);
        payAbleDealBo.setPayFee(payFee);
        payAbleDealBo.setPayOrderId(payOrderId);
        payAbleDealBo.setCreateIpAddress(orderInfoBo.getCreateIpAddress());
        payAbleDealBo.setBusiId(busiId);
        payAbleDealBo.setRedirectUrl(orderInfoBo.getRedirectUrl());
        PayAbleDealPayRspBo payAbleDealPayRspBo = payAble.dealPay(payAbleDealBo);
        if ("0000".equals(payAbleDealPayRspBo.getRespCode()) && "SUCCESS".equals(payAbleDealPayRspBo.getPayResultCode())) {
            PayProUpdateOrderTransBusiReqBo updateOrderBo = new PayProUpdateOrderTransBusiReqBo();
            updateOrderBo.setOrderId(reqBo.getOrderId());
            updateOrderBo.setPayOrderId(reqBo.getPayOrderId());
            updateOrderBo.setPayNotifyTime(this.queryDBDateBusiService.getDBDate());
            updateOrderBo.setOrderStatus("A10");
            updateOrderBo.setPayNotifyMsg(payAbleDealPayRspBo.getPayResultMsg());
            updateOrderBo.setPayNotifyTransId(payAbleDealPayRspBo.getPayNotifyTransId());
            updateOrderBo.setTradeTime(payAbleDealPayRspBo.getTradeTime());
            updateOrderBo.setPayNotifyCode("0");
            updateOrderBo.setPayOrderId(payOrderId);
            PayProUpdateOrderTransBusiRspBo payProUpdateOrderTransBusiRspBo = this.payProUpdateOrderTransBusiService.updateOrderData(updateOrderBo);
            if (!"0000".equals(payProUpdateOrderTransBusiRspBo.getRespCode())) {
                retBo.setRespCode("3003");
                retBo.setRespDesc("\u5373\u65f6\u652f\u4ed8\u8fd4\u56de\u65f6\u66f4\u65b0\u6570\u636e\u5931\u8d25\uff1a" + payProUpdateOrderTransBusiRspBo.getRespDesc());
                return retBo;
            }
            CallBackNoticeReqBo callBackNoticeReqBo = new CallBackNoticeReqBo();
            callBackNoticeReqBo.setOrderId(orderId);
            CallBackNoticeRspBo callBackNoticeRspBo = this.callBackNoticeService.dealPayPutMq(callBackNoticeReqBo);
            if ("0000".equals(callBackNoticeRspBo.getRspCode())) {
                LOG.info("\u8ba2\u5355\uff1a" + orderId + "\u53d1\u9001\u6d88\u606f\u961f\u5217\u6210\u529f");
            }
        }
        BeanUtils.copyProperties((Object)payAbleDealPayRspBo, (Object)retBo);
        retBo.setPayOrderId(payOrderId);
        return retBo;
    }

    private String validateArg(PayAbleDealPayCombReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (reqBo.getOrderId() == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027orderId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        Long payMethod = reqBo.getPayMethod();
        if (payMethod == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027payMethod\u4e0d\u80fd\u4e3a\u7a7a";
        }
        long aliBarCodePayMethod = PayProConstants.PayMethod.ALI_BAR.getPayMethod();
        long wxBarCodePayMethod = PayProConstants.PayMethod.WX_BAR.getPayMethod();
        if ((aliBarCodePayMethod == payMethod || wxBarCodePayMethod == payMethod) && StringUtils.isEmpty((Object)reqBo.getAuthCode())) {
            return "\u652f\u4ed8\u5b9d\uff0c\u5fae\u4fe1\u6761\u7801\u652f\u4ed8\u65f6authCode\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

