/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.comb.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.payment.pay.busi.PayInfoContractCreateBusiService;
import com.tydic.payment.pay.busi.PayProCreateOrderPayTransBusiService;
import com.tydic.payment.pay.busi.PayProQueryPayParaBusiService;
import com.tydic.payment.pay.busi.bo.PayAbleBusiReqDataBo;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayRspBo;
import com.tydic.payment.pay.busi.bo.PayInfoContractCreateBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayInfoContractCreateBusiRspBo;
import com.tydic.payment.pay.busi.bo.PayProCreateOrderPayTransBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayProCreateOrderPayTransBusiRspBo;
import com.tydic.payment.pay.busi.bo.PayProQueryPayParaBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayProQueryPayParaBusiRspBo;
import com.tydic.payment.pay.comb.PayProPreparedOrderCombService;
import com.tydic.payment.pay.comb.PayProSignAutoDeductCombService;
import com.tydic.payment.pay.comb.bo.PayProPreparedOrderCombReqBo;
import com.tydic.payment.pay.comb.bo.PayProPreparedOrderCombRspBo;
import com.tydic.payment.pay.comb.bo.PayProSignAutoDeductCombReqBo;
import com.tydic.payment.pay.comb.bo.PayProSignAutoDeductCombRspBo;
import com.tydic.payment.pay.config.PaySequenceConfigManager;
import com.tydic.payment.pay.constant.PaySequenceKeys;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.payable.api.PayAble;
import com.tydic.payment.pay.util.PayAbleManager;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="payProSignAutoDeductCombService")
public class PayProSignAutoDeductCombServiceImpl
implements PayProSignAutoDeductCombService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private PaySequenceConfigManager paySequenceConfigManager;
    @Autowired
    private PayProPreparedOrderCombService payProPreparedOrderCombService;
    @Autowired
    private PayInfoContractCreateBusiService payInfoContractCreateBusiService;
    @Autowired
    private PayProQueryPayParaBusiService payProQueryPayParaBusiService;
    @Autowired
    private PayProCreateOrderPayTransBusiService payProCreateOrderPayTransBusiService;
    @Autowired
    private PayAbleManager payAbleManager;

    public PayProSignAutoDeductCombRspBo signAgreement(PayProSignAutoDeductCombReqBo reqBo) {
        this.LOGGER.info("\u7b7e\u8ba2\u81ea\u52a8\u6263\u6b3e\u534f\u8baecomb\u670d\u52a1\u5165\u53c2\uff1a" + reqBo);
        PayProSignAutoDeductCombRspBo retBo = new PayProSignAutoDeductCombRspBo();
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            this.LOGGER.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("3013");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        PayInfoContractCreateBusiReqBo contractCreateBusiReqBo = new PayInfoContractCreateBusiReqBo();
        BeanUtils.copyProperties((Object)reqBo, (Object)contractCreateBusiReqBo);
        PayProPreparedOrderCombReqBo createOrderReqBo = new PayProPreparedOrderCombReqBo();
        this.sortCreateOrderReqBo(reqBo, createOrderReqBo);
        PayProPreparedOrderCombRspBo createOrderRspBo = this.payProPreparedOrderCombService.createOrder(createOrderReqBo);
        if (!"0000".equals(createOrderRspBo.getRespCode())) {
            this.LOGGER.error("\u521b\u5efa\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\uff1a" + createOrderRspBo.getRespDesc());
            retBo.setRespCode(createOrderRspBo.getRespCode());
            retBo.setRespDesc(createOrderRspBo.getRespDesc());
            return retBo;
        }
        contractCreateBusiReqBo.setOrderId(Long.valueOf(createOrderRspBo.getOrderId()));
        PayProCreateOrderPayTransBusiReqBo createTransBo = new PayProCreateOrderPayTransBusiReqBo();
        this.sortTransBo(reqBo, createOrderRspBo, createTransBo);
        PayProCreateOrderPayTransBusiRspBo createTransRetBo = this.payProCreateOrderPayTransBusiService.createPayTrans(createTransBo);
        if (!"0000".equals(createTransRetBo.getRespCode())) {
            retBo.setRespCode("3007");
            retBo.setRespDesc("\u8c03\u7528\u5199trans\u8868busi\u670d\u52a1\u5931\u8d25\uff1a" + createTransRetBo.getRespDesc());
            return retBo;
        }
        PayProQueryPayParaBusiReqBo qryPayParaBo = new PayProQueryPayParaBusiReqBo();
        qryPayParaBo.setPayMethod(Long.valueOf(reqBo.getPayMethod()));
        qryPayParaBo.setMerchantId(Long.valueOf(reqBo.getMerchantId()));
        PayProQueryPayParaBusiRspBo payProQueryPayParaBusiRspBo = this.payProQueryPayParaBusiService.queryPayPara(qryPayParaBo);
        if (!"0000".equals(payProQueryPayParaBusiRspBo.getRespCode())) {
            retBo.setRespCode(payProQueryPayParaBusiRspBo.getRespCode());
            retBo.setRespDesc("\u67e5\u8be2\u652f\u4ed8\u53c2\u6570\u5931\u8d25\uff1a" + payProQueryPayParaBusiRspBo.getRespDesc());
            return retBo;
        }
        Long payMethod = Long.valueOf(reqBo.getPayMethod());
        PayAble payAble = this.payAbleManager.getPayAbleByPayMethod(payMethod);
        PayAbleDealPayReqBo payAbleReqBo = new PayAbleDealPayReqBo();
        BeanUtils.copyProperties((Object)reqBo, (Object)payAbleReqBo);
        payAbleReqBo.setPayFee(Long.valueOf(reqBo.getTotalFee()));
        payAbleReqBo.setPayOrderId(createTransRetBo.getPayOrderId());
        payAbleReqBo.setParaMap(payProQueryPayParaBusiRspBo.getDetailAttrs());
        payAbleReqBo.setOrderId(Long.valueOf(createOrderRspBo.getOrderId()));
        PayAbleDealPayRspBo payAbleRetBo = null;
        boolean callAble = true;
        try {
            payAbleRetBo = payAble.dealPay(payAbleReqBo);
        }
        catch (Exception e) {
            this.LOGGER.error("\u8c03\u7528payable\u5b9e\u73b0\u7c7b\u4e0b\u5355\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            payAbleRetBo.setRespDesc("\u8c03\u7528payable\u5b9e\u73b0\u7c7b\u4e0b\u5355\u5f02\u5e38\uff1a" + e.getMessage());
            callAble = false;
        }
        BeanUtils.copyProperties((Object)reqBo, (Object)retBo);
        if (callAble && !this.createContractInfo(contractCreateBusiReqBo, reqBo, retBo)) {
            return retBo;
        }
        retBo.setBusiRspData(payAbleRetBo.getBusiRspDataBo());
        retBo.setPayFee(reqBo.getTotalFee());
        retBo.setOrderId(createOrderRspBo.getOrderId());
        retBo.setPayOrderId(createTransRetBo.getPayOrderId());
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        this.LOGGER.info("\u6263\u6b3e\u534f\u8bae\u7b7e\u8ba2comb\u670d\u52a1\u51fa\u53c2\uff1a" + retBo);
        return retBo;
    }

    private boolean createContractInfo(PayInfoContractCreateBusiReqBo contractCreateBusiReqBo, PayProSignAutoDeductCombReqBo reqBo, PayProSignAutoDeductCombRspBo retBo) {
        PayInfoContractCreateBusiRspBo contractCreateBusiRetBo;
        Long contactId;
        try {
            contactId = this.paySequenceConfigManager.nextId(PaySequenceKeys.SEQUENCE_CONTRACT_ID.getSequenceName());
        }
        catch (SQLException e) {
            throw new BusinessException("7004", "\u83b7\u53d6contactId\u5f02\u5e38", (Throwable)e);
        }
        contractCreateBusiReqBo.setContractId(contactId.toString());
        PayAbleBusiReqDataBo busiReqDataBo = (PayAbleBusiReqDataBo)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)reqBo.getBusiReqData()), PayAbleBusiReqDataBo.class);
        contractCreateBusiReqBo.setExpireTime(busiReqDataBo.getContractExtTime());
        contractCreateBusiReqBo.setProductCode(busiReqDataBo.getProductCode());
        contractCreateBusiReqBo.setPeriodType(busiReqDataBo.getPeriodType());
        contractCreateBusiReqBo.setSingleAmount(busiReqDataBo.getSingleAmount());
        if (!StringUtils.isEmpty((Object)busiReqDataBo.getPeriod())) {
            contractCreateBusiReqBo.setPeriod(Long.valueOf(busiReqDataBo.getPeriod()));
        }
        if (!"0000".equals((contractCreateBusiRetBo = this.payInfoContractCreateBusiService.crateContract(contractCreateBusiReqBo)).getRespCode())) {
            this.LOGGER.error("\u63d2\u5165\u534f\u8bae\u534f\u8bae\u4fe1\u606f\u8bb0\u5f55\u5931\u8d25\uff1a" + contractCreateBusiRetBo.getRespDesc());
            retBo.setRespCode(contractCreateBusiRetBo.getRespCode());
            retBo.setRespDesc(contractCreateBusiRetBo.getRespDesc());
            return false;
        }
        retBo.setContractId(contractCreateBusiRetBo.getContractId());
        retBo.setContractStatus(contractCreateBusiRetBo.getContractStatus());
        return true;
    }

    private void sortTransBo(PayProSignAutoDeductCombReqBo reqBo, PayProPreparedOrderCombRspBo createOrderRetBo, PayProCreateOrderPayTransBusiReqBo createTransBo) {
        createTransBo.setOrderId(Long.valueOf(Long.parseLong(createOrderRetBo.getOrderId())));
        createTransBo.setBusiId(createOrderRetBo.getBusiId());
        createTransBo.setPayMethod(Long.valueOf(reqBo.getPayMethod()));
        createTransBo.setMerchantId(Long.valueOf(Long.parseLong(reqBo.getMerchantId())));
        createTransBo.setPayFee(Long.valueOf(Long.parseLong(reqBo.getTotalFee())));
    }

    private void sortCreateOrderReqBo(PayProSignAutoDeductCombReqBo reqBo, PayProPreparedOrderCombReqBo createOrderReqBo) {
        BeanUtils.copyProperties((Object)reqBo, (Object)createOrderReqBo);
        createOrderReqBo.setBusiId(reqBo.getBusiId());
        createOrderReqBo.setOutRemark(reqBo.getRemark());
    }

    private String validateArgs(PayProSignAutoDeductCombReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getReqWay())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'reqWay'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getMerchantId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'merchantId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getOutOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'outOrderId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getTotalFee())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'totalFee'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getDetailName())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'detailName'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayMethod())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'payMethod'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getBusiReqData())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'busiReqDataBo'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getExtTime())) {
            reqBo.setExtTime("5m");
        }
        return null;
    }
}

