/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.payable.impl;

import com.alibaba.fastjson.JSON;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayRequest;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.request.AlipayTradeQueryRequest;
import com.alipay.api.request.AlipayTradeRefundRequest;
import com.alipay.api.response.AlipayTradeQueryResponse;
import com.alipay.api.response.AlipayTradeRefundResponse;
import com.tydic.payment.pay.busi.bo.PayAbleCallBackReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleCallBackRspBo;
import com.tydic.payment.pay.busi.bo.PayAbleQryPayStatusReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleQryPayStatusRspBo;
import com.tydic.payment.pay.busi.bo.PayAbleRefundReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleRefundRspBo;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.constant.PayProConstants;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.payable.api.PayAble;
import java.util.LinkedHashMap;
import java.util.Map;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public abstract class AbstractAliPayAble
implements PayAble {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractAliPayAble.class);
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    private static final String NORMAL_REFUND_DESC = "\u6b63\u5e38\u9000\u6b3e";

    public PayAbleRefundRspBo dealRefund(PayAbleRefundReqBo reqBo) {
        PayAbleRefundRspBo retBo = new PayAbleRefundRspBo();
        String validateArgStr = this.validateRefundArg(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            retBo.setRespCode("2010");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return retBo;
        }
        String aliOpenApiDomain = this.payPropertiesVo.getAliOpenApiDomain();
        if (StringUtils.isEmpty((Object)aliOpenApiDomain)) {
            LOG.error("\u652f\u4ed8\u5b9d\u8bf7\u6c42\u5730\u5740(aliOpenApiDomain)\u672a\u914d\u7f6e");
            throw new BusinessException("6011", "\u652f\u4ed8\u5b9d\u8bf7\u6c42\u5730\u5740(aliOpenApiDomain)\u672a\u914d\u7f6e");
        }
        Map paraMap = reqBo.getParaMap();
        String appId = (String)paraMap.get("appid");
        String privateKey = (String)paraMap.get("privateKey");
        String publicKey = (String)paraMap.get("publicKey");
        DefaultAlipayClient alipayClient = new DefaultAlipayClient(aliOpenApiDomain, appId, privateKey, "json", "UTF-8", publicKey, "RSA2");
        AlipayTradeRefundRequest request = new AlipayTradeRefundRequest();
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
        dataMap.put("out_trade_no", reqBo.getPayOrderId());
        dataMap.put("refund_amount", MoneyUtils.fenToYuan((Long)reqBo.getRefundFee()).toString());
        dataMap.put("refund_reason", StringUtils.isEmpty((Object)reqBo.getRefundReason()) ? NORMAL_REFUND_DESC : reqBo.getRefundReason());
        dataMap.put("out_request_no", reqBo.getRefundOrderId());
        request.setBizContent(JSON.toJSONString(dataMap));
        try {
            AlipayTradeRefundResponse response = (AlipayTradeRefundResponse)alipayClient.execute((AlipayRequest)request);
            if (response.isSuccess()) {
                BeanUtils.copyProperties((Object)reqBo, (Object)retBo);
                if (StringUtils.isEmpty((Object)retBo.getRefundReason())) {
                    retBo.setRefundReason(NORMAL_REFUND_DESC);
                }
            } else {
                LOG.error("\u8c03\u7528\u652f\u4ed8\u5b9d\u9000\u6b3e\u63a5\u53e3\u5931\u8d25\uff1a" + response.getSubMsg());
                retBo.setRespCode("2010");
                retBo.setRespDesc("\u8c03\u7528\u652f\u4ed8\u5b9d\u9000\u6b3e\u63a5\u53e3\u5931\u8d25\uff1a" + response.getSubMsg());
                return retBo;
            }
            retBo.setRefundTransId(response.getTradeNo());
            String tradeTime = new DateTime((Object)response.getGmtRefundPay()).toString("yyyyMMddHHmmss");
            retBo.setTradeTime(tradeTime);
            retBo.setRespCode("0000");
            retBo.setRespDesc("\u652f\u4ed8\u5b9d\u9000\u6b3e\u6210\u529f");
        }
        catch (AlipayApiException e) {
            LOG.error("\u8c03\u7528\u652f\u4ed8\u5b9d\u9000\u6b3e\u5f02\u5e38\uff1a" + (Object)((Object)e));
            throw new BusinessException("6011", "\u8c03\u7528\u652f\u4ed8\u5b9d\u9000\u6b3e\u5f02\u5e38\uff1a" + (Object)((Object)e), (Throwable)e);
        }
        return retBo;
    }

    public PayAbleQryPayStatusRspBo qryPayStatus(PayAbleQryPayStatusReqBo reqBo) {
        PayAbleQryPayStatusRspBo retBo = new PayAbleQryPayStatusRspBo();
        String validateArgStr = this.validateQryArg(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            retBo.setRespCode("2008");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return retBo;
        }
        String aliOpenApiDomain = this.payPropertiesVo.getAliOpenApiDomain();
        LOG.info("\u8c03\u7528\u652f\u4ed8\u5b9d\u63a5\u53e3\u7684\u5730\u5740\uff08\u67e5\u72b6\u6001\uff09\uff1a" + aliOpenApiDomain);
        if (StringUtils.isEmpty((Object)aliOpenApiDomain)) {
            LOG.error("\u652f\u4ed8\u5b9d\u8bf7\u6c42\u5730\u5740(aliOpenApiDomain)\u672a\u914d\u7f6e");
            throw new BusinessException("6010", "\u652f\u4ed8\u5b9d\u8bf7\u6c42\u5730\u5740(aliOpenApiDomain)\u672a\u914d\u7f6e");
        }
        Map paraMap = reqBo.getParaMap();
        String appId = (String)paraMap.get("appid");
        String privateKey = (String)paraMap.get("privateKey");
        String publicKey = (String)paraMap.get("publicKey");
        DefaultAlipayClient alipayClient = new DefaultAlipayClient(aliOpenApiDomain, appId, privateKey, "json", "UTF-8", publicKey, "RSA2");
        AlipayTradeQueryRequest request = new AlipayTradeQueryRequest();
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
        dataMap.put("out_trade_no", reqBo.getPayOrderId());
        request.setBizContent(JSON.toJSONString(dataMap));
        try {
            AlipayTradeQueryResponse response = (AlipayTradeQueryResponse)alipayClient.execute((AlipayRequest)request);
            LOG.info("\u652f\u4ed8\u5b9d\u67e5\u8be2\u51fa\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)response));
            if (!response.isSuccess()) {
                retBo.setRespCode("2008");
                retBo.setRespDesc("\u8c03\u7528\u652f\u4ed8\u5b9d\u67e5\u8be2\u63a5\u53e3\u8fd4\u56de\u5931\u8d25\uff1a" + response.getSubMsg());
                return retBo;
            }
            this.sortQryStatusRetBo(reqBo, retBo, response);
        }
        catch (AlipayApiException e) {
            LOG.error("\u8c03\u7528\u652f\u4ed8\u5b9d\u67e5\u8be2\u63a5\u53e3\u5f02\u5e38\uff1a" + (Object)((Object)e));
            throw new BusinessException("6007", "\u8c03\u7528\u652f\u4ed8\u5b9d\u67e5\u8be2\u63a5\u53e3\u5f02\u5e38\uff1a" + (Object)((Object)e), (Throwable)e);
        }
        return retBo;
    }

    public PayAbleCallBackRspBo dealCallBack(PayAbleCallBackReqBo reqBo) {
        return null;
    }

    public void sortQryStatusRetBo(PayAbleQryPayStatusReqBo reqBo, PayAbleQryPayStatusRspBo retBo, AlipayTradeQueryResponse response) {
        retBo.setOrderId(reqBo.getOrderId());
        retBo.setPayOrderId(reqBo.getPayOrderId());
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u67e5\u8be2\u6210\u529f");
        String tradeStatus = response.getTradeStatus();
        PayProConstants.AliPayTradeStatus aliPayTradeStatus = PayProConstants.AliPayTradeStatus.valueOf(tradeStatus);
        switch (aliPayTradeStatus) {
            case TRADE_SUCCESS: {
                retBo.setTradeTime(new DateTime((Object)response.getSendPayDate()).toString("yyyyMMddHHmmss"));
                retBo.setPayNotifyTransId(response.getTradeNo());
                retBo.setRealFee(Long.valueOf(MoneyUtils.yuanToFen((String)response.getTotalAmount()).longValue()));
                retBo.setPayStatus("SUCCESS");
                retBo.setPayStatusMsg("\u652f\u4ed8\u6210\u529f(alipay)");
                break;
            }
            case TRADE_CLOSED: {
                retBo.setPayStatus("FAIL");
                retBo.setPayStatusMsg("\u8ba2\u5355\u5df2\u5173\u95ed(alipay)");
                break;
            }
            case WAIT_BUYER_PAY: {
                retBo.setPayStatus("PAYING");
                retBo.setPayStatusMsg("\u7528\u6237\u652f\u4ed8\u4e2d(alipay)");
                break;
            }
            case TRADE_FINISHED: {
                if (!StringUtils.isEmpty((Object)response.getSendPayDate())) {
                    retBo.setTradeTime(new DateTime((Object)response.getSendPayDate()).toString("yyyyMMddHHmmss"));
                }
                if (!StringUtils.isEmpty((Object)response.getTotalAmount())) {
                    retBo.setRealFee(Long.valueOf(MoneyUtils.yuanToFen((String)response.getTotalAmount()).longValue()));
                }
                retBo.setPayNotifyTransId(response.getTradeNo());
                retBo.setPayStatus("SUCCESS");
                retBo.setPayStatusMsg("\u652f\u4ed8\u5df2\u5b8c\u6210(alipay)");
                break;
            }
            default: {
                retBo.setRespCode("2008");
                retBo.setRespDesc("\u652f\u4ed8\u5b9d\u8fd4\u56de\u672a\u77e5\u72b6\u6001\u503c");
                retBo.setPayStatus("FAIL");
            }
        }
    }

    public String validateQryArg(PayAbleQryPayStatusReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getParaMap())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027paraMap\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027payOrderId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        String validateMap = this.validateMap(reqBo.getParaMap());
        if (!StringUtils.isEmpty((Object)validateMap)) {
            return validateMap;
        }
        return null;
    }

    public String validateRefundArg(PayAbleRefundReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027payOrderId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getParaMap()) || reqBo.getParaMap().isEmpty()) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027paraMap\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getRefundFee())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027refundFee\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getRefundOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027refundOrderId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getRefundReason())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027refundReason\u4e0d\u80fd\u4e3a\u7a7a";
        }
        String validateMap = this.validateMap(reqBo.getParaMap());
        if (!StringUtils.isEmpty((Object)validateMap)) {
            return validateMap;
        }
        return null;
    }

    private String validateMap(Map<String, String> paraMap) {
        String appId = paraMap.get("appid");
        String privateKey = paraMap.get("privateKey");
        String publicKey = paraMap.get("publicKey");
        if (StringUtils.isEmpty((Object)appId)) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027paraMap\u4e2dkey(appId)\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)privateKey)) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027paraMap\u4e2dkey(privateKey)\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)publicKey)) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027paraMap\u4e2dkey(publicKey)\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

