/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.payable.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayRequest;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.request.AlipayFundTransToaccountTransferRequest;
import com.alipay.api.response.AlipayFundTransToaccountTransferResponse;
import com.tydic.payment.pay.busi.bo.PayAbleBusiReqDataBo;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayRspBo;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.config.PaySequenceConfigManager;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.constant.PayProConstants;
import com.tydic.payment.pay.constant.PaySequenceKeys;
import com.tydic.payment.pay.dao.PorderTransforTransMapper;
import com.tydic.payment.pay.dao.po.PorderTransforTransPo;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.payable.api.PayAble;
import com.tydic.payment.pay.payable.impl.AbstractAliPayAble;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class AliPayTransPayAbleImpl
extends AbstractAliPayAble
implements PayAble {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private static final String ALI_CODE_SUCCESS = "10000";
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private PorderTransforTransMapper pOrderTransforTransMapper;
    @Autowired
    private PaySequenceConfigManager paySequenceConfigManager;

    public Long getPayMethod() {
        return PayProConstants.PayMethod.ALI_TRANS.getPayMethod();
    }

    public PayAbleDealPayRspBo dealPay(PayAbleDealPayReqBo reqBo) {
        AlipayFundTransToaccountTransferResponse response;
        PayAbleDealPayRspBo retBo = new PayAbleDealPayRspBo();
        String validateArgStr = this.validateArg(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            this.LOGGER.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            retBo.setRespCode("2035");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return retBo;
        }
        String aliOpenApiDomain = this.payPropertiesVo.getAliOpenApiDomain();
        String aliNotifyUrl = this.payPropertiesVo.getAliNotifyUrl();
        if (StringUtils.isEmpty((Object)aliOpenApiDomain)) {
            this.LOGGER.error("\u652f\u4ed8\u5b9d\u8bf7\u6c42\u5730\u5740(aliOpenApiDomain)\u672a\u914d\u7f6e");
            throw new BusinessException("6030", "\u652f\u4ed8\u5b9d\u8bf7\u6c42\u5730\u5740(aliOpenApiDomain)\u672a\u914d\u7f6e");
        }
        if (StringUtils.isEmpty((Object)aliNotifyUrl)) {
            this.LOGGER.error("\u652f\u4ed8\u5b9d\u56de\u8c03\u5730\u5740(aliNotifyUrl)\u672a\u914d\u7f6e");
            throw new BusinessException("6030", "\u652f\u4ed8\u5b9d\u56de\u8c03\u5730\u5740(aliNotifyUrl)\u672a\u914d\u7f6e");
        }
        Map paraMap = reqBo.getParaMap();
        String appId = (String)paraMap.get("appid");
        String privateKey = (String)paraMap.get("privateKey");
        String publicKey = (String)paraMap.get("publicKey");
        PayAbleBusiReqDataBo reqDataBo = (PayAbleBusiReqDataBo)JSONObject.toJavaObject((JSON)JSON.parseObject((String)reqBo.getBusiReqData()), PayAbleBusiReqDataBo.class);
        DefaultAlipayClient alipayClient = new DefaultAlipayClient(aliOpenApiDomain, appId, privateKey, "json", "UTF-8", publicKey, "RSA2");
        AlipayFundTransToaccountTransferRequest request = new AlipayFundTransToaccountTransferRequest();
        request.setNotifyUrl(aliNotifyUrl);
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
        dataMap.put("out_biz_no", reqBo.getPayOrderId());
        dataMap.put("amount", MoneyUtils.fenToYuan((Long)reqBo.getPayFee()).toString());
        dataMap.put("payee_type", reqDataBo.getPayeeType());
        dataMap.put("payee_account", reqDataBo.getPayeeAccount());
        dataMap.put("payer_show_name", reqDataBo.getPayerShowName());
        dataMap.put("payee_real_name", reqDataBo.getPayeeRealName());
        dataMap.put("remark", reqBo.getRemark());
        request.setBizContent(JSON.toJSONString(dataMap));
        try {
            response = (AlipayFundTransToaccountTransferResponse)alipayClient.execute((AlipayRequest)request);
            this.LOGGER.info("\u652f\u4ed8\u5b9d\u8f6c\u8d26\u8fd4\u56de\u503c\u4e3a\uff1a" + (response != null ? JSON.toJSONString((Object)response) : "null"));
            if (response == null) {
                this.LOGGER.error("\u8c03\u7528\u652f\u4ed8\u5b9d\u8f6c\u8d26\u63a5\u53e3\u5931\u8d25\uff1a\u8fd4\u56de\u5bf9\u8c61\u4e3a\u7a7a");
                retBo.setRespCode("2035");
                retBo.setRespDesc("\u8c03\u7528\u652f\u4ed8\u5b9d\u8f6c\u8d26\u63a5\u53e3\u5931\u8d25\uff1a\u8fd4\u56de\u5bf9\u8c61\u4e3a\u7a7a");
                return retBo;
            }
            if (response.isSuccess()) {
                BeanUtils.copyProperties((Object)reqBo, (Object)retBo);
                String returnCode = response.getCode();
                if (!ALI_CODE_SUCCESS.equals(returnCode)) {
                    this.LOGGER.error("\u8f6c\u8d26\u5931\u8d25\uff1a" + response.getSubMsg());
                    retBo.setPayResultCode("FAIL");
                    retBo.setRespCode("2035");
                    retBo.setRespDesc(response.getSubMsg());
                    return retBo;
                }
            } else {
                this.LOGGER.error("\u8c03\u7528\u652f\u4ed8\u5b9d\u63a5\u53e3\u5931\u8d25\uff1a" + response.getSubMsg());
                retBo.setPayResultCode("FAIL");
                retBo.setRespCode("2035");
                retBo.setRespDesc("\u8c03\u7528\u652f\u4ed8\u5b9d\u63a5\u53e3\u5931\u8d25\uff1a" + response.getSubMsg());
                return retBo;
            }
            retBo.setPayNotifyTransId(response.getOrderId());
            retBo.setPayResultCode("SUCCESS");
            retBo.setPayResultMsg("\u652f\u4ed8\u5b9d\u8f6c\u8d26\u6210\u529f");
            retBo.setRespCode("0000");
            retBo.setRespDesc("\u6210\u529f");
        }
        catch (AlipayApiException e) {
            this.LOGGER.error("\u8c03\u7528\u652f\u4ed8\u5b9d\u63a5\u53e3\u5f02\u5e38\uff1a" + (Object)((Object)e));
            retBo.setRespCode("2035");
            retBo.setRespDesc("\u8c03\u7528\u652f\u4ed8\u5b9d\u63a5\u53e3\u5f02\u5e38\uff1a" + (Object)((Object)e));
            return retBo;
        }
        this.writeTransform(reqBo, reqDataBo, response);
        return retBo;
    }

    private void writeTransform(PayAbleDealPayReqBo reqBo, PayAbleBusiReqDataBo reqDataBo, AlipayFundTransToaccountTransferResponse response) {
        Long transId;
        try {
            transId = this.paySequenceConfigManager.nextId(PaySequenceKeys.SEQUENCE_TRANS_ID.getSequenceName());
        }
        catch (SQLException e) {
            throw new BusinessException("6002", "\u83b7\u53d6transId\u5f02\u5e38", (Throwable)e);
        }
        PorderTransforTransPo transPo = new PorderTransforTransPo();
        BeanUtils.copyProperties((Object)reqBo, (Object)transPo);
        transPo.setTransId(transId);
        transPo.setPaymentInsId(Long.valueOf("2"));
        transPo.setMerchantId(Long.valueOf(reqBo.getMerchantId()));
        transPo.setPayMethod(PayProConstants.PayMethod.ALI_TRANS.getPayMethod());
        transPo.setPayFee(MoneyUtils.fenToHao((Long)reqBo.getPayFee()).longValue());
        transPo.setPayNotifyTransId(response.getOrderId());
        transPo.setReceiverAccount(reqDataBo.getPayeeAccount());
        transPo.setReceiverName(reqDataBo.getPayeeRealName());
        transPo.setTradeTime(response.getPayDate());
        int result = this.pOrderTransforTransMapper.insert(transPo);
        if (result < 1) {
            throw new BusinessException("6030", "\u5199\u8868\u65f6\u8fd4\u56de\u503c\u5c0f\u4e8e1");
        }
    }

    private String validateArg(PayAbleDealPayReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getParaMap())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'paraMap'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayFee())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'payFee'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'payOrderId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getBusiReqData())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'busiReqData'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        Map paraMap = reqBo.getParaMap();
        String appId = (String)paraMap.get("appid");
        String privateKey = (String)paraMap.get("privateKey");
        String publicKey = (String)paraMap.get("publicKey");
        if (StringUtils.isEmpty((Object)appId)) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'paraMap'\u4e2dkey(appId)\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)privateKey)) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'paraMap'\u4e2dkey(privateKey)\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)publicKey)) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'paraMap'\u4e2dkey(publicKey)\u4e0d\u80fd\u4e3a\u7a7a";
        }
        JSONObject busiReqJson = JSONObject.parseObject((String)reqBo.getBusiReqData());
        String payeeType = (String)busiReqJson.get((Object)"payeeType");
        String payeeAccount = (String)busiReqJson.get((Object)"payeeAccount");
        if (StringUtils.isEmpty((Object)payeeType)) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'busiReqJson'\u4e2d'payeeType'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)payeeAccount)) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'busiReqJson'\u4e2d'payeeAccount'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

