/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.payable.impl;

import com.alibaba.fastjson.JSON;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayRequest;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.request.AlipayTradePagePayRequest;
import com.alipay.api.response.AlipayTradePagePayResponse;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayRspBo;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.constant.PayProConstants;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.payable.api.PayAble;
import com.tydic.payment.pay.payable.impl.AbstractAliPayAble;
import com.tydic.payment.pay.util.BeanUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class AliPayWebPayAbleImpl
extends AbstractAliPayAble
implements PayAble {
    private static final Logger LOG = LoggerFactory.getLogger(AliPayWebPayAbleImpl.class);
    @Autowired
    private PayPropertiesVo payPropertiesVo;

    public Long getPayMethod() {
        return PayProConstants.PayMethod.ALI_WEB.getPayMethod();
    }

    public PayAbleDealPayRspBo dealPay(PayAbleDealPayReqBo reqBo) {
        PayAbleDealPayRspBo retBo = new PayAbleDealPayRspBo();
        String validateArgStr = this.validateArg(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            retBo.setRespCode("2024");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return retBo;
        }
        String aliOpenApiDomain = this.payPropertiesVo.getAliOpenApiDomain();
        String aliNotifyUrl = this.payPropertiesVo.getAliNotifyUrl();
        if (StringUtils.isEmpty((Object)aliOpenApiDomain)) {
            LOG.error("\u652f\u4ed8\u5b9d\u8bf7\u6c42\u5730\u5740(aliOpenApiDomain)\u672a\u914d\u7f6e");
            throw new BusinessException("6021", "\u652f\u4ed8\u5b9d\u8bf7\u6c42\u5730\u5740(aliOpenApiDomain)\u672a\u914d\u7f6e");
        }
        if (StringUtils.isEmpty((Object)aliNotifyUrl)) {
            LOG.error("\u652f\u4ed8\u5b9d\u56de\u8c03\u5730\u5740(aliNotifyUrl)\u672a\u914d\u7f6e");
            throw new BusinessException("6021", "\u652f\u4ed8\u5b9d\u56de\u8c03\u5730\u5740(aliNotifyUrl)\u672a\u914d\u7f6e");
        }
        Map paraMap = reqBo.getParaMap();
        String appId = (String)paraMap.get("appid");
        String privateKey = (String)paraMap.get("privateKey");
        String publicKey = (String)paraMap.get("publicKey");
        DefaultAlipayClient alipayClient = new DefaultAlipayClient(aliOpenApiDomain, appId, privateKey, "json", "UTF-8", publicKey, "RSA2");
        AlipayTradePagePayRequest request = new AlipayTradePagePayRequest();
        request.setNotifyUrl(aliNotifyUrl);
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
        dataMap.put("out_trade_no", reqBo.getPayOrderId());
        dataMap.put("product_code", "FAST_INSTANT_TRADE_PAY");
        dataMap.put("total_amount", MoneyUtils.fenToYuan((Long)reqBo.getPayFee()).toString());
        dataMap.put("subject", reqBo.getDetailName());
        dataMap.put("timeout_express", "3m");
        request.setBizContent(JSON.toJSONString(dataMap));
        try {
            AlipayTradePagePayResponse response = (AlipayTradePagePayResponse)alipayClient.pageExecute((AlipayRequest)request);
            LOG.info("\u652f\u4ed8\u5b9d\u7f51\u7ad9\u652f\u4ed8\u4e0b\u5355\u8fd4\u56de\u503c\u4e3a\uff1a" + (response != null ? JSON.toJSONString((Object)response) : "null"));
            if (response == null) {
                LOG.error("\u8c03\u7528\u652f\u4ed8\u5b9d\u63a5\u53e3\u5931\u8d25\uff1a\u8fd4\u56de\u5bf9\u8c61\u4e3a\u7a7a");
                retBo.setRespCode("2024");
                retBo.setRespDesc("\u8c03\u7528\u652f\u4ed8\u5b9d\u63a5\u53e3\u5931\u8d25\uff1a\u8fd4\u56de\u5bf9\u8c61\u4e3a\u7a7a");
                return retBo;
            }
            if (!response.isSuccess()) {
                LOG.error("\u8c03\u7528\u652f\u4ed8\u5b9d\u63a5\u53e3\u5931\u8d25\uff1a" + response.getSubMsg());
                retBo.setRespCode("2024");
                retBo.setRespDesc("\u8c03\u7528\u652f\u4ed8\u5b9d\u63a5\u53e3\u5931\u8d25\uff1a" + response.getSubMsg());
                return retBo;
            }
            String form = ((AlipayTradePagePayResponse)alipayClient.pageExecute((AlipayRequest)request)).getBody();
            BeanUtils.copyProperties((Object)reqBo, (Object)retBo);
            retBo.setPayOrderId(response.getOutTradeNo());
            retBo.setHtmlBody(form);
            retBo.setPayFee(reqBo.getPayFee());
            retBo.setRespCode("0000");
            retBo.setRespDesc("\u652f\u4ed8\u5b9dPC\u7aef\u4e0b\u5355\u6210\u529f");
        }
        catch (AlipayApiException e) {
            LOG.error("\u8c03\u7528\u652f\u4ed8\u5b9dPC\u7aef\u4e0b\u5355\u5f02\u5e38\uff1a" + (Object)((Object)e));
            throw new BusinessException("6021", "\u8c03\u7528\u652f\u4ed8\u5b9dPC\u7aef\u4e0b\u5355\u5f02\u5e38\uff1a" + (Object)((Object)e), (Throwable)e);
        }
        return retBo;
    }

    private String validateArg(PayAbleDealPayReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61payOrderId\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getDetailName())) {
            return "\u5165\u53c2\u5bf9\u8c61detailName\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getParaMap())) {
            return "\u5165\u53c2\u5bf9\u8c61paraMap\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayFee())) {
            return "\u5165\u53c2\u5bf9\u8c61payFee\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a";
        }
        Map paraMap = reqBo.getParaMap();
        String appId = (String)paraMap.get("appid");
        String privateKey = (String)paraMap.get("privateKey");
        String publicKey = (String)paraMap.get("publicKey");
        if (StringUtils.isEmpty((Object)appId)) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027paraMap\u4e2d(appId)\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)privateKey)) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027paraMap\u4e2d(privateKey)\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)publicKey)) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027paraMap\u4e2d(publicKey)\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

