/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.payable.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.file.FileClient;
import com.sinovatech.unicom.util.sign.CryptUtil;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayRspBo;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.constant.PayProConstants;
import com.tydic.payment.pay.dao.PayMethodMapper;
import com.tydic.payment.pay.payable.impl.AbstractWopayPayAble;
import com.tydic.payment.pay.wopay.util.UniPaySignUtilsCer;
import com.tydic.payment.pay.wopay.util.WopayPayMobileRequestBean;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class WopayMobilePayAbleImpl
extends AbstractWopayPayAble {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private PayMethodMapper payMethodMapper;
    @Resource
    private FileClient fileClient;
    private final String SIGN_TYPE = "RSA_SHA256";
    private final String TRADE_MODE_NOW = "0001";
    private final String INT_VERSION = "2.2.4";
    private final Map<String, File> fileCache = new HashMap<String, File>();

    public Long getPayMethod() {
        return PayProConstants.PayMethod.WOPAY_MOBILE.getPayMethod();
    }

    public PayAbleDealPayRspBo dealPay(PayAbleDealPayReqBo reqBo) {
        PayAbleDealPayRspBo rspBo = new PayAbleDealPayRspBo();
        String validateArgStr = this.validateArg(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            rspBo.setRespCode("1001");
            rspBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return rspBo;
        }
        String wopayMobileRequestUrl = this.payPropertiesVo.getValueByKey("wopay.mobile.request.url");
        if (StringUtils.isEmpty((Object)wopayMobileRequestUrl)) {
            rspBo.setRespCode("1001");
            rspBo.setRespDesc("\u6c83\u652f\u4ed8\u8bf7\u6c42\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\uff1awopay.mobile.request.url");
            return rspBo;
        }
        String wopayMobileCallbackUrl = this.payPropertiesVo.getValueByKey("wopay.mobile.callback.url");
        if (StringUtils.isEmpty((Object)wopayMobileCallbackUrl)) {
            rspBo.setRespCode("1001");
            rspBo.setRespDesc("\u652f\u4ed8\u4e2d\u5fc3\u63a5\u53d7\u6c83\u652f\u4ed8\u56de\u8c03\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\uff1awopay.mobile.callback.url");
            return rspBo;
        }
        WopayPayMobileRequestBean wopayPayMobileRequestBean = this.generateBean(reqBo);
        String generateSignMsgSesult = this.generateSignMsg(reqBo, wopayPayMobileRequestBean);
        if (!StringUtils.isEmpty((Object)generateSignMsgSesult)) {
            rspBo.setRespCode("1001");
            rspBo.setRespDesc(generateSignMsgSesult);
            return rspBo;
        }
        String sendStr = CryptUtil.encryptBeanNokey((Object)wopayPayMobileRequestBean);
        String postData = wopayPayMobileRequestBean.getMerNo() + sendStr;
        HashMap<String, String> extMap = new HashMap<String, String>(16);
        extMap.put("postData", postData);
        extMap.put("postUrl", wopayMobileRequestUrl);
        rspBo.setExtRspDatas(extMap);
        rspBo.setBusiRspDataBo(JSON.toJSONString(extMap));
        rspBo.setPayOrderId(reqBo.getPayOrderId());
        rspBo.setOrderId(reqBo.getOrderId());
        rspBo.setPayFee(reqBo.getPayFee());
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private String generateSignMsg(PayAbleDealPayReqBo reqBo, WopayPayMobileRequestBean wopayPayMobileRequestBean) {
        Map paraMap = reqBo.getParaMap();
        String merSignDir = (String)paraMap.get("merSignDir");
        String merSignKey = (String)paraMap.get("merSignKey");
        File signFile = null;
        signFile = this.fileCache.get(merSignDir) == null ? this.fileClient.downloadToFile("payCenter/" + merSignDir) : this.fileCache.get(merSignDir);
        FileInputStream fis = null;
        try {
            int len;
            fis = new FileInputStream(signFile);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] bb = new byte[4096];
            while ((len = fis.read(bb)) != -1) {
                baos.write(bb, 0, len);
            }
            fis.close();
            String signMsg = UniPaySignUtilsCer.merSign((Map)UniPaySignUtilsCer.obj2LowerMap((Object)wopayPayMobileRequestBean), (String)wopayPayMobileRequestBean.getSignType(), (boolean)false, (byte[])baos.toByteArray(), (String)merSignKey);
            this.LOGGER.info("\u6c83\u652f\u4ed8\u79fb\u52a8\u652f\u4ed8\u751f\u6210\u7684\u7b7e\u540d\u4e32\u4e3a\uff1a" + signMsg);
            wopayPayMobileRequestBean.setSignMsg(signMsg);
            baos.close();
        }
        catch (IOException e) {
            this.LOGGER.error("\u6c83\u652f\u4ed8\u79fb\u52a8\u652f\u4ed8\u4e0b\u5355\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            return "\u6c83\u652f\u4ed8\u79fb\u52a8\u652f\u4ed8\u4e0b\u5355\u5f02\u5e38\uff1a" + e.getMessage();
        }
        return null;
    }

    private WopayPayMobileRequestBean generateBean(PayAbleDealPayReqBo reqBo) {
        String wopayMobileCallbackUrl = this.payPropertiesVo.getValueByKey("wopay.mobile.callback.url");
        Map paraMap = reqBo.getParaMap();
        Date dbDate = this.payMethodMapper.getDBDate().getDate();
        WopayPayMobileRequestBean wopayBean = new WopayPayMobileRequestBean();
        wopayBean.setPayBalance(reqBo.getPayFee().toString());
        wopayBean.setStoreOrderId(reqBo.getPayOrderId());
        wopayBean.setCallbackUrl(reqBo.getRedirectUrl());
        wopayBean.setServerCallUrl(wopayMobileCallbackUrl);
        wopayBean.setMerNo((String)paraMap.get("merNo"));
        wopayBean.setTradeMode("0001");
        wopayBean.setSignType("RSA_SHA256");
        wopayBean.setWostoreTime(new DateTime((Object)dbDate).toString("yyyyMMddHHmmss"));
        wopayBean.setVersion("2.2.4");
        wopayBean.setOrderBalance(reqBo.getPayFee().toString());
        wopayBean.setRespMode("1");
        wopayBean.setStoreName("\u6c83\u652f\u4ed8");
        wopayBean.setStoreIndex(reqBo.getRedirectUrl());
        wopayBean.setGoodsName(reqBo.getDetailName());
        wopayBean.setUsefulTime("30");
        return wopayBean;
    }

    private String validateArg(PayAbleDealPayReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        Map paraMap = reqBo.getParaMap();
        if (paraMap == null || paraMap.isEmpty()) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027paraMap\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty(paraMap.get("merNo"))) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027paraMap\u4e2dmerNo\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty(paraMap.get("merKey"))) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027paraMap\u4e2dmerKey\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty(paraMap.get("merSignDir"))) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027paraMap\u4e2dmerSignDir\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty(paraMap.get("merSignKey"))) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027paraMap\u4e2dmerSignKey\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getRedirectUrl())) {
            return " \u4f7f\u7528(" + this.getPayMethod() + ")\u65f6\uff0credirectUrl\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

