/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.service.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.payment.pay.busi.QueryDBDateBusiService;
import com.tydic.payment.pay.dao.BillCheckConfigMapper;
import com.tydic.payment.pay.dao.po.BillCheckConfigPO;
import com.tydic.payment.pay.web.bo.req.BillCheckConfigCreateWebReqBo;
import com.tydic.payment.pay.web.bo.rsp.BillCheckConfigCreateWebRspBo;
import com.tydic.payment.pay.web.service.BillCheckConfigCreateWebService;
import java.util.List;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service(value="billCheckConfigCreateWebService")
@RestController
@RequestMapping(value={"PAY_GROUP_LOCAL/2.0-SNAPSHOT/com.tydic.payment.pay.web.service.BillCheckConfigCreateWebService"})
public class BillCheckConfigCreateWebServiceImpl
implements BillCheckConfigCreateWebService {
    @Autowired
    private BillCheckConfigMapper billCheckConfigMapper;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;
    private static final String SERVICE_NAME = "\u5bf9\u8d26\u652f\u4ed8\u5546\u6237\u914d\u7f6e\u8868\u65b0\u589eweb\u670d\u52a1 ";
    private static final Logger LOG = LoggerFactory.getLogger(BillCheckConfigCreateWebServiceImpl.class);

    @PostMapping(value={"addBillCheckConfig"})
    public BillCheckConfigCreateWebRspBo addBillCheckConfig(@RequestBody BillCheckConfigCreateWebReqBo reqBo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("\u5bf9\u8d26\u652f\u4ed8\u5546\u6237\u914d\u7f6e\u8868\u65b0\u589eweb\u670d\u52a1 -> \u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        }
        BillCheckConfigCreateWebRspBo rspBo = new BillCheckConfigCreateWebRspBo();
        String validateArgStr = this.validateArg(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u5bf9\u8d26\u652f\u4ed8\u5546\u6237\u914d\u7f6e\u8868\u65b0\u589eweb\u670d\u52a1  -> \u5165\u53c2\u6821\u9a8c\u5931\u8d25:" + validateArgStr);
            return rspBo;
        }
        BillCheckConfigPO addBillCheckConfigPO = new BillCheckConfigPO();
        addBillCheckConfigPO.setPaymentMchId(reqBo.getPaymentMchId());
        List<BillCheckConfigPO> billCheckConfigPoList = this.billCheckConfigMapper.selectBySelective(addBillCheckConfigPO);
        if (!CollectionUtils.isEmpty(billCheckConfigPoList)) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("paymentMchId\u5df2\u5b58\u5728");
            return rspBo;
        }
        BeanUtils.copyProperties((Object)reqBo, (Object)addBillCheckConfigPO);
        addBillCheckConfigPO.setPaymentInsId(Long.valueOf(reqBo.getPaymentInsId()));
        addBillCheckConfigPO.setNextDate(Long.valueOf(reqBo.getNextDate()));
        int result = this.billCheckConfigMapper.insert(addBillCheckConfigPO);
        if (result > 0) {
            rspBo.setConfigId(addBillCheckConfigPO.getConfigId() + "");
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u6210\u529f");
        } else {
            rspBo.setConfigId(addBillCheckConfigPO.getConfigId() + "");
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u540e\u53f0\u63d2\u5165\u6570\u636e\u5e93\u8fd4\u56de\u503c\u4e0d\u5927\u4e8e0");
        }
        return rspBo;
    }

    public String validateArg(BillCheckConfigCreateWebReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPaymentMchId())) {
            return "paymentMchId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPaymentInsId())) {
            return "paymentInsId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        try {
            Long.valueOf(reqBo.getPaymentInsId());
        }
        catch (NumberFormatException e) {
            return "paymentInsId\u4e3a\u7eaf\u6570\u5b57";
        }
        if (StringUtils.isEmpty((Object)reqBo.getNextDate())) {
            reqBo.setNextDate(new DateTime((Object)this.queryDBDateBusiService.getDBDate()).toString("yyyyMMdd"));
        } else {
            try {
                Long.valueOf(reqBo.getNextDate());
            }
            catch (NumberFormatException e) {
                return "NextDate\u4e3a\u7eaf\u6570\u5b57";
            }
        }
        if (StringUtils.isEmpty((Object)reqBo.getLastResult())) {
            reqBo.setLastResult("1");
        }
        if (StringUtils.isEmpty((Object)reqBo.getEffFlag())) {
            reqBo.setEffFlag("1");
        }
        if (StringUtils.isEmpty((Object)reqBo.getLastResultCode())) {
            reqBo.setLastResultCode("0000");
        }
        if (StringUtils.isEmpty((Object)reqBo.getLastResultDesc())) {
            reqBo.setLastResultDesc("SUCCESS");
        }
        return null;
    }
}

