/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.bill.busi.impl;

import com.tydic.payment.bill.busi.BillPayBillDayCreateBusiService;
import com.tydic.payment.bill.busi.PaymentInsIdBusiService;
import com.tydic.payment.bill.busi.QueryOrderBusiService;
import com.tydic.payment.bill.busi.bo.BillPayBillDayCreateReqBO;
import com.tydic.payment.bill.busi.bo.QueryOrderRspBO;
import com.tydic.payment.bill.busi.bo.QueryPayTransRspBO;
import com.tydic.payment.bill.busi.bo.QueryRefundRspBO;
import com.tydic.payment.pay.busi.QueryDBDateBusiService;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.dao.PayBillDayMapper;
import com.tydic.payment.pay.dao.PorderPayTransMapper;
import com.tydic.payment.pay.dao.PorderRefundTransMapper;
import com.tydic.payment.pay.dao.po.PayBillDayPo;
import com.tydic.payment.pay.dao.po.PorderPayTransPo;
import com.tydic.payment.pay.dao.po.PorderRefundTransPo;
import com.tydic.payment.pay.exception.BusinessException;
import java.io.Serializable;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="billPayBillDayCreateBusiService")
public class BillPayBillDayCreateBusiServiceImpl
implements BillPayBillDayCreateBusiService {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private boolean isDebug = this.log.isDebugEnabled();
    @Autowired
    private QueryOrderBusiService queryOrderBusiService;
    @Autowired
    private PayBillDayMapper payBillDayMapper;
    @Autowired
    private PorderRefundTransMapper porderRefundTransMapper;
    @Autowired
    private PorderPayTransMapper porderPayTransMapper;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;
    @Autowired
    private PaymentInsIdBusiService paymentInsIdBusiService;

    public void create(BillPayBillDayCreateReqBO reqBO) {
        Serializable rspPO;
        Serializable reqPO;
        String billDay = String.valueOf(reqBO.getBillDate());
        if (!Objects.equals(reqBO.getPaymentInsId(), this.paymentInsIdBusiService.getPaymentInsIdByPayMethod(reqBO.getPayMethod()))) {
            return;
        }
        if ("01".equals(reqBO.getOrderType())) {
            reqPO = new PorderPayTransPo();
            ((PorderPayTransPo)reqPO).setOrderId(reqBO.getOrderId());
            ((PorderPayTransPo)reqPO).setPayOrderId(reqBO.getPayOrderId());
            rspPO = this.porderPayTransMapper.getOrderPayTransByPayOrderId((PorderPayTransPo)reqPO);
            if (rspPO != null) {
                QueryPayTransRspBO queryPayTransRspBO = new QueryPayTransRspBO();
                BeanUtils.copyProperties((Object)rspPO, (Object)queryPayTransRspBO);
                this.createBillDay(billDay, queryPayTransRspBO, null, reqBO);
                return;
            }
            if (this.isDebug) {
                this.log.debug("\u521b\u5efa\u65e5\u4e34\u65f6\u5bf9\u8d26\u5931\u8d25\uff0c\u67e5\u8be2\u652f\u4ed8\u8ba2\u5355\u4e3a\u7a7a\uff0c\u67e5\u8be2\u6761\u4ef6\uff1a\u652f\u4ed8\u8ba2\u5355ID\uff1a{}", (Object)reqBO.getPayOrderId());
            }
        }
        if ("02".equals(reqBO.getOrderType())) {
            reqPO = new PorderRefundTransPo();
            ((PorderRefundTransPo)reqPO).setRefundOrderId(reqBO.getRefundOrderId());
            ((PorderRefundTransPo)reqPO).setOrderId(reqBO.getOrderId());
            rspPO = this.porderRefundTransMapper.getOrderRfundTransByRefundOrderId((PorderRefundTransPo)reqPO);
            if (rspPO != null) {
                QueryRefundRspBO queryRefundRspBO = new QueryRefundRspBO();
                BeanUtils.copyProperties((Object)rspPO, (Object)queryRefundRspBO);
                this.createBillDay(billDay, null, queryRefundRspBO, reqBO);
                return;
            }
            if (this.isDebug) {
                this.log.debug("\u521b\u5efa\u65e5\u4e34\u65f6\u5bf9\u8d26\u5931\u8d25\uff0c\u67e5\u8be2\u9000\u6b3e\u8ba2\u5355\u4e3a\u7a7a\uff0c\u67e5\u8be2\u6761\u4ef6\uff1a\u9000\u6b3e\u8ba2\u5355ID\uff1a{}", (Object)reqBO.getRefundOrderId());
            }
        }
    }

    private void createBillDay(String billDate, QueryPayTransRspBO payBO, QueryRefundRspBO refundBO, BillPayBillDayCreateReqBO reqBO) {
        if (payBO != null) {
            BillPayBillDayCreateReqBO billDayReqBO = new BillPayBillDayCreateReqBO();
            QueryOrderRspBO order = this.queryOrderBusiService.queryOrder(payBO.getOrderId());
            if (order == null) {
                if (this.isDebug) {
                    this.log.debug("\u67e5\u8be2\u652f\u4ed8\u4e2d\u5fc3\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8ba2\u5355ID\uff1a{}", (Object)payBO.getOrderId());
                }
                return;
            }
            billDayReqBO.setPayOrderId(payBO.getPayOrderId());
            billDayReqBO.setBillDate(Long.valueOf(billDate));
            billDayReqBO.setBillTransId(payBO.getPayNotifyTransId());
            billDayReqBO.setPayMethod(payBO.getPayMethod());
            billDayReqBO.setCreateTime(this.queryDBDateBusiService.getDBDate());
            billDayReqBO.setTradeTime(payBO.getTradeTime());
            billDayReqBO.setPaymentInsId(this.paymentInsIdBusiService.getPaymentInsIdByPayMethod(payBO.getPayMethod()));
            billDayReqBO.setPaymentMchId(payBO.getTransMerchant());
            billDayReqBO.setRealFee(Long.valueOf(MoneyUtils.haoToFen((Long)payBO.getPayFee()).longValue()));
            billDayReqBO.setFlag(reqBO.getFlag());
            this.buildPayBillDayOrderInfo(billDayReqBO, order);
            this.createByReqBO(billDayReqBO);
            return;
        }
        if (refundBO != null) {
            BillPayBillDayCreateReqBO billDayReqBO = new BillPayBillDayCreateReqBO();
            QueryOrderRspBO order = this.queryOrderBusiService.queryOrder(refundBO.getOrderId());
            if (order == null) {
                if (this.isDebug) {
                    this.log.debug("\u67e5\u8be2\u652f\u4ed8\u4e2d\u5fc3\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8ba2\u5355ID\uff1a{}", (Object)refundBO.getOrderId());
                }
                return;
            }
            billDayReqBO.setPayOrderId(refundBO.getPayOrderId());
            billDayReqBO.setRefundOrderId(refundBO.getRefundOrderId());
            billDayReqBO.setBillDate(Long.valueOf(billDate));
            billDayReqBO.setBillTransId(refundBO.getPayNotifyTransId());
            billDayReqBO.setPayMethod(refundBO.getPayMethod());
            billDayReqBO.setCreateTime(this.queryDBDateBusiService.getDBDate());
            billDayReqBO.setTradeTime(refundBO.getTradeTime());
            billDayReqBO.setPaymentInsId(this.paymentInsIdBusiService.getPaymentInsIdByPayMethod(refundBO.getPayMethod()));
            if (StringUtils.isEmpty((Object)reqBO.getPaymentMchId())) {
                PorderPayTransPo reqPO = new PorderPayTransPo();
                reqPO.setOrderId(reqBO.getOrderId());
                reqPO.setPayOrderId(reqBO.getPayOrderId());
                PorderPayTransPo rspPO = this.porderPayTransMapper.getOrderPayTransByPayOrderId(reqPO);
                if (rspPO != null) {
                    billDayReqBO.setPaymentMchId(rspPO.getTransMerchant());
                }
            } else {
                billDayReqBO.setPaymentMchId(reqBO.getPaymentMchId());
            }
            billDayReqBO.setRealFee(Long.valueOf(MoneyUtils.haoToFen((Long)refundBO.getPayFee()).longValue()));
            billDayReqBO.setFlag(reqBO.getFlag());
            this.buildPayBillDayOrderInfo(billDayReqBO, order);
            this.createByReqBO(billDayReqBO);
        }
    }

    private void buildPayBillDayOrderInfo(BillPayBillDayCreateReqBO reqBO, QueryOrderRspBO order) {
        reqBO.setOrderId(order.getOrderId());
        reqBO.setOrderType(order.getOrderType());
        reqBO.setBusiId(order.getBusiId());
        reqBO.setBusiCode(order.getBusiCode());
        reqBO.setMerchantId(order.getMerchantId());
        reqBO.setDetailName(order.getDetailName());
        reqBO.setOutOrderId(order.getOutOrderId());
        reqBO.setRefundNo(order.getOutRefundNo());
        if (order.getTotalFee() == null) {
            reqBO.setTotalFee(Long.valueOf(0L));
        } else {
            reqBO.setTotalFee(Long.valueOf(MoneyUtils.haoToFen((Long)order.getTotalFee()).longValue()));
        }
        if (order.getDiscountFee() == null) {
            reqBO.setDiscountFee(Long.valueOf(0L));
        } else {
            reqBO.setDiscountFee(Long.valueOf(MoneyUtils.haoToFen((Long)order.getDiscountFee()).longValue()));
        }
        if (order.getBalanceFee() == null) {
            reqBO.setBalanceFee(Long.valueOf(0L));
        } else {
            reqBO.setBalanceFee(Long.valueOf(MoneyUtils.haoToFen((Long)order.getBalanceFee()).longValue()));
        }
        if (order.getOnlineFee() == null) {
            reqBO.setOnlineFee(Long.valueOf(0L));
        } else {
            reqBO.setOnlineFee(Long.valueOf(MoneyUtils.haoToFen((Long)order.getOnlineFee()).longValue()));
        }
        reqBO.setProvinceId(order.getProvinceId());
        reqBO.setCityId(order.getCityId());
        reqBO.setDistrictId(order.getDistrictId());
        reqBO.setChannelId(order.getChannelId());
        reqBO.setUserAccount(order.getUserAccount());
        reqBO.setUserMobile(order.getUserMobile());
    }

    private void createByReqBO(BillPayBillDayCreateReqBO reqBO) {
        PayBillDayPo paybillDayPO = new PayBillDayPo();
        BeanUtils.copyProperties((Object)reqBO, (Object)paybillDayPO);
        if (reqBO.getBillDate() != null) {
            paybillDayPO.setBillDate(reqBO.getBillDate());
        }
        if (StringUtils.isEmpty((Object)reqBO.getFlag())) {
            paybillDayPO.setFlag("1");
        }
        try {
            this.payBillDayMapper.insert(paybillDayPO);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("8888", "\u521b\u5efa\u65e5\u4e34\u65f6\u5bf9\u8d26\u8bb0\u5f55\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    public void createTrans(BillPayBillDayCreateReqBO reqBO) {
        QueryOrderRspBO order = this.queryOrderBusiService.queryOrder(reqBO.getOrderId());
        if (order == null) {
            if (this.isDebug) {
                this.log.debug("\u67e5\u8be2\u652f\u4ed8\u4e2d\u5fc3\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8ba2\u5355ID\uff1a{}", (Object)reqBO.getOrderId());
            }
            return;
        }
        this.buildPayBillDayOrderInfo(reqBO, order);
        this.createByReqBO(reqBO);
    }

    public void updateFlag(BillPayBillDayCreateReqBO reqBO) {
        this.payBillDayMapper.updateFlagByOrderId(reqBO.getFlag(), reqBO.getOrderId(), reqBO.getPayOrderId(), reqBO.getRefundOrderId());
    }
}

