/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.gson.Gson;
import com.tydic.payment.pay.atom.BusiSystemMerchantRelAtomService;
import com.tydic.payment.pay.atom.MerchantInfoAtomService;
import com.tydic.payment.pay.busi.CreatePayOrderService;
import com.tydic.payment.pay.busi.bo.CreatePayOrderReqBo;
import com.tydic.payment.pay.busi.bo.CreatePayOrderRspBo;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.dao.PayMethodMapper;
import com.tydic.payment.pay.dao.PorderDetallMapper;
import com.tydic.payment.pay.dao.PorderMapper;
import com.tydic.payment.pay.dao.po.BusiSystemMerchantRelPo;
import com.tydic.payment.pay.dao.po.MerChantInfoPo;
import com.tydic.payment.pay.dao.po.PorderDetallPo;
import com.tydic.payment.pay.dao.po.PorderPo;
import com.tydic.payment.pay.exception.BusinessException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="createPayOrderService")
public class CreatePayOrderServiceImpl
implements CreatePayOrderService {
    private static final Logger log = LoggerFactory.getLogger(CreatePayOrderServiceImpl.class);
    @Autowired
    private PorderMapper porderMapper;
    @Autowired
    private PorderDetallMapper porderDetallMapper;
    @Autowired
    private MerchantInfoAtomService merchantInfoAtomService;
    @Autowired
    private BusiSystemMerchantRelAtomService busiSystemMerchantRelAtomService;
    @Autowired
    private PayMethodMapper payMethodMapper;

    public CreatePayOrderRspBo createPorder(CreatePayOrderReqBo createPorderReqBo) {
        String errorMsg = "";
        Long orderId = 0L;
        CreatePayOrderRspBo createPorderRspBo = new CreatePayOrderRspBo();
        if (createPorderReqBo.getContentMap().isEmpty()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u521b\u5efa\u8ba2\u5355\u4e1a\u52a1\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)createPorderReqBo.getBusiId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u521b\u5efa\u8ba2\u5355\u4e1a\u52a1\u7cfb\u7edfBUSI_ID \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)createPorderReqBo.getIp())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5e38\u89c1\u8ba2\u5355\u8bf7\u6c42\u8bbe\u5907IP\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            String operName;
            Map contentMap = createPorderReqBo.getContentMap();
            String outOrderId = "" + contentMap.get("outOrderId");
            PorderPo pOrderPo = new PorderPo();
            Long busiId = Long.parseLong(createPorderReqBo.getBusiId());
            String merchant_id = "" + contentMap.get("merchantId");
            String reqWay = "" + contentMap.get("reqWay");
            String total_fee = "" + contentMap.get("totalFee");
            String detailName = "" + contentMap.get("detailName");
            String redirectUrl = "" + contentMap.get("redirectUrl");
            String notifyUrl = "" + contentMap.get("notifyUrl");
            String createIpAddress = createPorderReqBo.getIp();
            String operNo = "" + contentMap.get("createOperId");
            if ("null".equals(operNo)) {
                operNo = null;
            }
            if ("null".equals(operName = "" + contentMap.get("createOperIdName"))) {
                operName = null;
            }
            String orderType = "" + contentMap.get("orderType");
            String outRemark = "";
            String orderAttrValue1 = "";
            String orderAttrValue2 = "";
            String orderAttrValue3 = "";
            String userAccount = "";
            String userMobile = "";
            String provinceId = "";
            String cityId = "";
            String channelId = "";
            String districtId = "";
            String busiCode = "";
            String inModeCode = "";
            String storeId = "";
            String deliverType = "";
            String separateAccountFlag = null;
            if (contentMap.get("separateAccountFlag") != null) {
                separateAccountFlag = (String)contentMap.get("separateAccountFlag");
            }
            if (contentMap.containsKey("userAccount")) {
                userAccount = "" + contentMap.get("userAccount");
            }
            if (contentMap.containsKey("userMobile")) {
                userMobile = "" + contentMap.get("userMobile");
            }
            if (contentMap.containsKey("province")) {
                provinceId = "" + contentMap.get("province");
            }
            if (contentMap.containsKey("city")) {
                cityId = "" + contentMap.get("city");
            }
            if (contentMap.containsKey("channelId")) {
                channelId = "" + contentMap.get("channelId");
            }
            if (contentMap.containsKey("district")) {
                districtId = "" + contentMap.get("district");
            }
            if (contentMap.containsKey("remark")) {
                outRemark = "" + contentMap.get("remark");
            }
            if (contentMap.containsKey("orderAttrValue1")) {
                orderAttrValue1 = "" + contentMap.get("orderAttrValue1");
            }
            if (contentMap.containsKey("orderAttrValue2")) {
                orderAttrValue2 = "" + contentMap.get("orderAttrValue2");
            }
            if (contentMap.containsKey("orderAttrValue3")) {
                orderAttrValue3 = "" + contentMap.get("orderAttrValue3");
            }
            busiCode = contentMap.containsKey("busiCode") ? "" + contentMap.get("busiCode") : createPorderReqBo.getBusiCode();
            if (contentMap.containsKey("inModeCode")) {
                inModeCode = "" + contentMap.get("inModeCode");
            }
            if (contentMap.containsKey("storeId")) {
                storeId = "" + contentMap.get("storeId");
            }
            if (contentMap.containsKey("deliverType")) {
                deliverType = "" + contentMap.get("deliverType");
            }
            String orderStatus2 = "A00";
            Object goods_detail = contentMap.get("goodsDetail");
            Long merchantId = Long.parseLong(merchant_id);
            if (StringUtils.isEmpty((Object)orderType)) {
                orderType = "01";
            }
            float total_fee_value = 0.0f;
            BigDecimal totalFee = new BigDecimal(0);
            try {
                total_fee_value = Float.parseFloat(total_fee);
                if ((double)(total_fee_value - 0.0f) < 1.0E-5) {
                    errorMsg = "\u8ba2\u5355\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0";
                }
                totalFee = new BigDecimal(total_fee);
            }
            catch (Exception ee) {
                errorMsg = "total_fee\u6570\u636e\u4e0d\u6b63\u786e";
            }
            MerChantInfoPo merChantInfoPo = new MerChantInfoPo();
            merChantInfoPo.setMerchantId(merchantId);
            List<Object> listMerchant = new ArrayList();
            listMerchant = this.merchantInfoAtomService.queryMerChantInfoByCondition(merChantInfoPo);
            if (listMerchant.size() > 0) {
                MerChantInfoPo merInfoPo;
                BusiSystemMerchantRelPo busiSystemMerchantRelPo = new BusiSystemMerchantRelPo();
                busiSystemMerchantRelPo.setMerchantId(merchantId);
                busiSystemMerchantRelPo.setBusiId(busiId);
                List<BusiSystemMerchantRelPo> listMerchantRel = this.busiSystemMerchantRelAtomService.queryBusiSystemMerchantByCondition(busiSystemMerchantRelPo);
                if (listMerchantRel.size() == 0) {
                    errorMsg = "\u8bf7\u786e\u8ba4\u6b64\u4e1a\u52a1\u7cfb\u7edf\u3010" + busiCode + "\u3011\u662f\u5426\u914d\u7f6e\u6b64\u5546\u6237\u3010" + merchantId + "\u3011\u4fe1\u606f";
                }
                if (!(merInfoPo = (MerChantInfoPo)listMerchant.get(0)).getFlag().equals("1")) {
                    errorMsg = "\u5546\u6237\u72b6\u6001\u4e0d\u662f\u6b63\u5e38\u4f7f\u7528\u72b6\u6001\uff0c\u65e0\u6cd5\u521b\u5efa\u8ba2\u5355";
                }
            } else {
                errorMsg = "\u672a\u67e5\u8be2\u5230\u5546\u6237\u4fe1\u606f";
            }
            if ("".equals(errorMsg)) {
                String merchantName = ((MerChantInfoPo)listMerchant.get(0)).getMerchantName();
                String merchantNameAbb = ((MerChantInfoPo)listMerchant.get(0)).getMerchantNameAbb();
                pOrderPo.setBusiId(busiId);
                pOrderPo.setOrderStatus(orderStatus2);
                pOrderPo.setMerchantId(merchantId);
                pOrderPo.setMerchantName(merchantName);
                pOrderPo.setMerchantNameAbb(merchantNameAbb);
                pOrderPo.setReqWay(reqWay);
                pOrderPo.setDetailName(detailName);
                pOrderPo.setRedirectUrl(redirectUrl);
                if ("null".equals(notifyUrl) || StringUtils.isEmpty((Object)notifyUrl)) {
                    pOrderPo.setNotifyUrl(null);
                } else {
                    pOrderPo.setNotifyUrl(notifyUrl);
                }
                pOrderPo.setOutRemark(outRemark);
                pOrderPo.setOutOrderId(outOrderId);
                pOrderPo.setTotalFee(MoneyUtils.fenToHaoToLong((BigDecimal)totalFee));
                pOrderPo.setCreateIpAddress(createIpAddress);
                pOrderPo.setCreateOperId(operNo);
                pOrderPo.setCreateOperIdName(operName);
                pOrderPo.setOrderType(orderType);
                pOrderPo.setUserAccount(userAccount);
                pOrderPo.setUserMobile(userMobile);
                pOrderPo.setChannelId(channelId);
                pOrderPo.setBalanceFee(0L);
                pOrderPo.setCityId(cityId);
                pOrderPo.setProvinceId(provinceId);
                pOrderPo.setBusiCode(busiCode);
                pOrderPo.setDistrictId(districtId);
                pOrderPo.setOrderAttrValue1(orderAttrValue1);
                pOrderPo.setOrderAttrValue2(orderAttrValue2);
                pOrderPo.setOrderAttrValue3(orderAttrValue3);
                pOrderPo.setDiscountFee(0L);
                pOrderPo.setRefundFee(0L);
                pOrderPo.setInModeCode(inModeCode);
                pOrderPo.setStoreId(storeId);
                pOrderPo.setDeliverType(deliverType);
                pOrderPo.setSeparateAccountFlag("1".equals(separateAccountFlag) ? "1" : "0");
                log.info("\u521b\u5efapoder\u670d\u52a1\u63d2\u5165\u6570\u636e\u5e93\u524d\u7684po\u5165\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)pOrderPo));
                Date now = this.payMethodMapper.getDBDate().getDate();
                pOrderPo.setExpTime(new DateTime((Object)now).plusMinutes(30).toDate());
                Long count = this.porderMapper.insertPorder(pOrderPo);
                if (count != 1L) {
                    log.info("\u8ba2\u5355\u63d2\u5165\u5931\u8d25 -------------");
                    throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8ba2\u5355\u63d2\u5165\u5f02\u5e38");
                }
                orderId = pOrderPo.getOrderId();
                createPorderRspBo.setOrderId(String.valueOf(orderId));
                createPorderRspBo.setCreateOperId(pOrderPo.getCreateOperId());
                createPorderRspBo.setMerchantId(pOrderPo.getMerchantId());
                createPorderRspBo.setOutOrderId(outOrderId);
                createPorderRspBo.setReqWay(reqWay);
                createPorderRspBo.setOutRemark(outRemark);
                createPorderRspBo.setBusiId(String.valueOf(pOrderPo.getBusiId()));
                System.out.println("-------------------------------------------------------");
                System.out.println("\u63d2\u5165\u8bf7\u6c42\u8ba2\u5355\u8fd4\u56de\u7684\u8ba2\u5355\u53f7\u4e3a\uff1a " + orderId);
                JSONArray goodDetailArr = null;
                if (goods_detail instanceof List) {
                    Gson gson = new Gson();
                    String str = gson.toJson(goods_detail);
                    goodDetailArr = JSONObject.parseArray((String)str);
                } else {
                    goodDetailArr = JSONObject.parseArray((String)String.valueOf(goods_detail));
                }
                if (goods_detail != null && goodDetailArr.size() > 0) {
                    this.validateGoodsFee(goodDetailArr, totalFee);
                    this.createGoodsDetail(goods_detail, busiId, orderId, merchant_id);
                } else {
                    log.info("\u672a\u68c0\u6d4b\u5230\u5546\u54c1\u7684\u4fe1\u606f");
                }
                createPorderRspBo.setRspCode("0000");
                createPorderRspBo.setRspName("\u8ba2\u5355\u521b\u5efa\u6210\u529f");
            } else {
                log.info(errorMsg + "\u5f02\u5e38\u4fe1\u606f");
                createPorderRspBo.setRspCode("8888");
                createPorderRspBo.setRspName("\u521b\u5efa\u8ba2\u5355\u5f02\u5e38 " + errorMsg);
            }
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u8ba2\u5355\u5f02\u5e38 " + e.getMessage(), (Throwable)e);
            createPorderRspBo.setRspCode("8888");
            createPorderRspBo.setRspName("\u521b\u5efa\u8ba2\u5355\u5f02\u5e38 " + errorMsg);
        }
        return createPorderRspBo;
    }

    private void createGoodsDetail(Object goods_detail, Long busiId, Long orderId, String merchantId) throws Exception {
        JSONArray goodDetailArr = null;
        ArrayList<PorderDetallPo> goodsDetaiList = new ArrayList<PorderDetallPo>();
        if (goods_detail instanceof List) {
            Gson gson = new Gson();
            String str = gson.toJson(goods_detail);
            goodDetailArr = JSONObject.parseArray((String)str);
        } else {
            goodDetailArr = JSONObject.parseArray((String)goods_detail.toString());
        }
        for (int i = 0; i < goodDetailArr.size(); ++i) {
            JSONObject goodsDetail = goodDetailArr.getJSONObject(i);
            log.info("\u6d4b\u8bd5\u65e5\u5fd7\uff1acreatePorderService");
            log.info(goodsDetail.toJSONString());
            PorderDetallPo porderDetail = new PorderDetallPo();
            porderDetail.setBusiId(busiId);
            porderDetail.setOrderId(orderId);
            porderDetail.setMerchantId(Long.valueOf(merchantId));
            porderDetail.setGoodsName(goodsDetail.getString("goodsName"));
            porderDetail.setGoodsId(goodsDetail.getString("goodsId"));
            porderDetail.setGoodsNum(Integer.parseInt(goodsDetail.getString("goodsNum")));
            porderDetail.setBrandCode(goodsDetail.getString("brandCode"));
            porderDetail.setOfferType(goodsDetail.getString("offerType"));
            porderDetail.setOfferDivide(goodsDetail.getString("offerDivide"));
            porderDetail.setBelongPlatform(goodsDetail.getString("belongPlatform"));
            porderDetail.setOfferSupplier(goodsDetail.getString("offerSupplier"));
            porderDetail.setBelongStock(goodsDetail.getString("belongStock"));
            try {
                if (!StringUtils.isEmpty((Object)goodsDetail.getString("settPrice"))) {
                    porderDetail.setSettPrice(MoneyUtils.fenToHaoToLong((BigDecimal)new BigDecimal(goodsDetail.getString("settPrice"))));
                }
                if (!StringUtils.isEmpty((Object)goodsDetail.getString("offerTax"))) {
                    porderDetail.setOfferTax(Long.parseLong(goodsDetail.getString("offerTax")));
                }
                if (!StringUtils.isEmpty((Object)goodsDetail.getString("offerShareFee"))) {
                    porderDetail.setOfferShareFee(MoneyUtils.fenToHaoToLong((BigDecimal)new BigDecimal(goodsDetail.getString("offerShareFee"))));
                }
            }
            catch (Exception e) {
                log.info("\u5546\u54c1\u4ef7\u683c\u8f6c\u6362\u5f02\u5e38:" + e.getMessage());
            }
            porderDetail.setParentOfferId(goodsDetail.getString("parentOfferId"));
            if (goodsDetail.containsKey((Object)"goodsPrice")) {
                porderDetail.setGoodsPrice(MoneyUtils.fenToHaoToLong((BigDecimal)new BigDecimal(goodsDetail.getString("goodsPrice"))));
            }
            if (goodsDetail.containsKey((Object)"goodPrice")) {
                porderDetail.setGoodsPrice(MoneyUtils.fenToHaoToLong((BigDecimal)new BigDecimal(goodsDetail.getString("goodPrice"))));
            }
            BigDecimal fee = new BigDecimal(porderDetail.getGoodsPrice()).multiply(new BigDecimal(porderDetail.getGoodsNum()));
            porderDetail.setGoodsFee(fee.longValue());
            goodsDetaiList.add(porderDetail);
        }
        this.porderDetallMapper.insertPorderDetall(goodsDetaiList);
    }

    private void validateGoodsFee(JSONArray goodDetails, BigDecimal totalFee) {
        BigDecimal calcTotalFee = new BigDecimal(0);
        boolean doCalc = false;
        for (int i = 0; i < goodDetails.size(); ++i) {
            JSONObject goodsDetail = goodDetails.getJSONObject(i);
            if (!goodsDetail.containsKey((Object)"goodsPrice")) continue;
            BigDecimal goodNum = new BigDecimal(goodsDetail.getString("goodsNum"));
            BigDecimal goodPrice = new BigDecimal(goodsDetail.getString("goodsPrice"));
            BigDecimal goodsPrice = goodPrice.multiply(goodNum);
            if ((calcTotalFee = calcTotalFee.add(goodsPrice)).equals(BigDecimal.ZERO)) continue;
            doCalc = true;
        }
        if (doCalc && totalFee.compareTo(calcTotalFee) != 0) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8ba2\u5355\u7684\u603b\u4ef7\u548c\u5b9e\u9645\u8ba1\u7b97\u4ef7\u683c\u4e0d\u7b49!");
        }
    }
}

