/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.comb.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.payment.pay.busi.PayOrderBusiService;
import com.tydic.payment.pay.busi.PayProQueryPayParaBusiService;
import com.tydic.payment.pay.busi.UniQrCodeCreateScanStateBusiService;
import com.tydic.payment.pay.busi.bo.PayOrderRspBo;
import com.tydic.payment.pay.busi.bo.PayProQueryPayParaBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayProQueryPayParaBusiRspBo;
import com.tydic.payment.pay.busi.bo.UniQrCodeCreateScanStateBusiReqBo;
import com.tydic.payment.pay.comb.PayProOneCodePayCombService;
import com.tydic.payment.pay.comb.PayProOrderCombService;
import com.tydic.payment.pay.comb.bo.PayProOneCodePayCombReqBo;
import com.tydic.payment.pay.comb.bo.PayProOneCodePayCombRspBo;
import com.tydic.payment.pay.comb.bo.PayProOrderCombServiceReqBo;
import com.tydic.payment.pay.comb.bo.PayProOrderCombServiceRspBo;
import com.tydic.payment.pay.comb.bo.PayProOrderCreateCombBusiRspDataBo;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.constant.PayProConstants;
import com.tydic.payment.pay.exception.BusinessException;
import java.io.IOException;
import java.net.URLEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class PayProOneCodePayCombServiceImpl
implements PayProOneCodePayCombService {
    private Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private static final String ALI_PAY_AGENT = "Alipay";
    private static final String WX_PAY_AGENT = "MicroMessenger";
    private static final String WX_GET_OPENID_URL = "https://open.weixin.qq.com/connect/oauth2/authorize?";
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private PayOrderBusiService payOrderBusiService;
    @Autowired
    private PayProOrderCombService payProOrderCombService;
    @Autowired
    private PayProQueryPayParaBusiService payProQueryPayParaBusiService;
    @Autowired
    private UniQrCodeCreateScanStateBusiService uniQrCodeCreateScanStateBusiService;
    @Autowired
    private PayPropertiesVo payPropertiesVo;

    public PayProOneCodePayCombRspBo dealOneCodePay(PayProOneCodePayCombReqBo reqBo) {
        this.LOGGER.info("\u4e00\u7801\u4ed8\u5904\u7406comb\u670d\u52a1\uff1a" + reqBo);
        PayProOneCodePayCombRspBo retBo = new PayProOneCodePayCombRspBo();
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            this.LOGGER.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRspName("3011");
            retBo.setRspName("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        String oneCodePayHtml = this.payPropertiesVo.getValueByKey("pay.one.code.pay.html");
        if (StringUtils.isEmpty((Object)oneCodePayHtml)) {
            this.LOGGER.error("\u4e00\u7801\u4ed8\u652f\u4ed8\u9875\u9762\u5730\u5740\uff08pay.one.code.pay.html\uff09\u672a\u914d\u7f6e");
            throw new BusinessException("7002", "\u4e00\u7801\u4ed8\u652f\u4ed8\u9875\u9762\u5730\u5740\uff08pay.one.code.pay.html\uff09\u672a\u914d\u7f6e");
        }
        StringBuffer basePath = reqBo.getBasePath();
        BeanUtils.copyProperties((Object)reqBo, (Object)retBo);
        PayOrderRspBo orderRetBo = this.payOrderBusiService.selectOrderByOrderId(Long.valueOf(reqBo.getOrderId()));
        if (!"0000".equals(orderRetBo.getRspCode())) {
            this.LOGGER.error("\u672a\u67e5\u8be2\u5230\u8ba2\u5355(" + reqBo.getOrderId() + ")\u7684\u76f8\u5173\u4fe1\u606f");
            retBo.setRspCode("3011");
            retBo.setRspName("\u672a\u67e5\u8be2\u5230\u8ba2\u5355(" + reqBo.getOrderId() + ")\u7684\u76f8\u5173\u4fe1\u606f");
            return retBo;
        }
        if ("A10".equals(orderRetBo.getOrderStatus())) {
            this.LOGGER.error("\u8ba2\u5355\uff08" + reqBo.getOrderId() + "\uff09\u5df2\u652f\u4ed8");
            retBo.setRspCode("3011");
            retBo.setRspName("\u8ba2\u5355\uff08" + reqBo.getOrderId() + "\uff09\u5df2\u652f\u4ed8");
            return retBo;
        }
        this.LOGGER.info("--------------------------\u8ba2\u5355\u6821\u9a8c\u901a\u8fc7-----------------------");
        String key = "PAY_PRO_ONECODE_" + reqBo.getOrderId();
        Object cacheObject = this.cacheClient.get(key);
        if (cacheObject != null) {
            this.LOGGER.info("\u6b64\u8ba2\u5355\u5df2\u6709\u7528\u6237\u626b\u7801\uff0c\u5982\u9700\u91cd\u65b0\u626b\u7801\u8bf71\u5206\u949f\u540e\u518d\u8bd5\uff01\u8c22\u8c22\uff01");
            retBo.setRspCode("3011");
            retBo.setRspName("\u5df2\u6709\u7528\u6237\u626b\u7801\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
            retBo.setDetailName(orderRetBo.getDetailName());
            return retBo;
        }
        if (reqBo.getUserAgent().contains(ALI_PAY_AGENT)) {
            this.LOGGER.info("----------------------\u7528\u6237\u626b\u7801\u4f7f\u7528\u7684\u662f\u652f\u4ed8\u5b9d------------------------");
            this.createScanReCord(reqBo.getOrderId(), "\u652f\u4ed8\u5b9d");
            retBo.setRspCode("0000");
            retBo.setRspName("\u6210\u529f");
            this.assembleAli(reqBo, retBo, orderRetBo, basePath, oneCodePayHtml);
        } else if (reqBo.getUserAgent().contains(WX_PAY_AGENT)) {
            this.LOGGER.info("----------------------\u7528\u6237\u626b\u7801\u4f7f\u7528\u7684\u662f\u5fae\u4fe1-------------------------");
            this.createScanReCord(reqBo.getOrderId(), "\u5fae\u4fe1");
            retBo.setRspCode("0000");
            retBo.setRspName("\u6210\u529f");
            this.assembleWxUrl(reqBo, retBo, orderRetBo, basePath);
        } else {
            this.LOGGER.error("\u7528\u6237\u626b\u7801\u4f7f\u7528\u4e86\u5fae\u4fe1\u53ca\u652f\u4ed8\u5b9d\u4ee5\u5916\u7684\u6d4f\u89c8\u5668\u626b\u7801\uff01\uff01\uff01");
            retBo.setRspCode("3011");
            retBo.setRspName("\u8bf7\u4f7f\u7528\u5fae\u4fe1\u6216\u652f\u4ed8\u5b9d\u626b\u7801!");
        }
        return retBo;
    }

    private void assembleAli(PayProOneCodePayCombReqBo reqBo, PayProOneCodePayCombRspBo retBo, PayOrderRspBo orderRetBo, StringBuffer besePath, String oneCodePayHtml) {
        PayProOrderCombServiceReqBo orderCombReqBo = new PayProOrderCombServiceReqBo();
        BeanUtils.copyProperties((Object)orderRetBo, (Object)orderCombReqBo);
        orderCombReqBo.setMerchantId(orderRetBo.getMerchantId().toString());
        orderCombReqBo.setBusiId(orderRetBo.getBusiId().toString());
        orderCombReqBo.setTotalFee(reqBo.getTotalFee());
        String extTime = this.payPropertiesVo.getValueByKey("pay.one.code.pay.expire.time");
        if (StringUtils.isEmpty((Object)extTime)) {
            this.LOGGER.error("\u4e00\u7801\u4ed8\u626b\u7801\u8bb0\u5f55\u8fc7\u671f\u65f6\u95f4'pay.one.code.pay.expire.time'\u672a\u914d\u7f6e\uff0c\u9ed8\u8ba4\u8bbe\u7f6e\u4e3a1\u5206\u79cd");
            extTime = "1";
        }
        orderCombReqBo.setExtTime(extTime);
        orderCombReqBo.setPayMethod(PayProConstants.PayMethod.ALI_H5.getPayMethod() + "");
        this.LOGGER.info("\u51c6\u5907\u8c03\u7528\u7edf\u4e00\u4e0b\u5355comb\u670d\u52a1\uff1a" + orderCombReqBo);
        PayProOrderCombServiceRspBo orderCombRetBo = this.payProOrderCombService.dealOrder(orderCombReqBo);
        this.LOGGER.info("\u8c03\u7528\u7edf\u4e00\u4e0b\u5355comb\u670d\u52a1\u8fd4\u56de\u7684\u53c2\u6570\uff1a" + orderCombRetBo);
        if (!"0000".equals(orderCombRetBo.getRespCode())) {
            this.LOGGER.error("\u8c03\u7528comb\u670d\u52a1\u4e0b\u5355\u5931\u8d25\uff1a" + orderCombRetBo.getRespDesc());
            retBo.setRspCode("3011");
            retBo.setRspName(orderCombRetBo.getRespDesc());
            return;
        }
        if (StringUtils.isEmpty((Object)orderCombRetBo.getBusiRspData())) {
            this.LOGGER.error("\u4e1a\u52a1\u53c2\u6570busiRspData\u4e3a\u7a7a\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u9700\u8981\u7684\u4fe1\u606f");
            retBo.setRspCode("3011");
            retBo.setRspName("\u4e1a\u52a1\u53c2\u6570busiRspData\u4e3a\u7a7a\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u9700\u8981\u7684\u4fe1\u606f");
            return;
        }
        JSONObject combBusiDataJson = JSONObject.parseObject((String)orderCombRetBo.getBusiRspData());
        PayProOrderCreateCombBusiRspDataBo combBusiDataBo = (PayProOrderCreateCombBusiRspDataBo)JSONObject.toJavaObject((JSON)combBusiDataJson, PayProOrderCreateCombBusiRspDataBo.class);
        this.replaceAliActionUrl(combBusiDataBo);
        BeanUtils.copyProperties((Object)orderRetBo, (Object)retBo);
        retBo.setBody(combBusiDataBo.getHtmlBody());
        int cacheTime = 15;
        String valueByKey = this.payPropertiesVo.getValueByKey("pay.one.code.alipay.cache.time");
        if (!StringUtils.isEmpty((Object)valueByKey)) {
            try {
                cacheTime = Integer.parseInt(valueByKey);
            }
            catch (NumberFormatException e) {
                this.LOGGER.error("\u8b66\u544a\uff1apay.one.code.alipay.cache.time\u914d\u7f6e\u4e0d\u4e3a\u6570\u5b57\uff0c\u5df2\u4f7f\u7528\u9ed8\u8ba4\u65f6\u95f4\uff1a" + cacheTime);
            }
        }
        this.cacheClient.set("ONE_CODE_PAY_ALI_H5_" + reqBo.getOrderId(), (Object)combBusiDataBo.getHtmlBody(), cacheTime);
        retBo.setRedirectUrl(combBusiDataBo.getRedirectUrl());
        retBo.setChannel(PayProConstants.PayMethod.ALI_H5.getPayMethod().toString());
        retBo.setPayOrderId(orderCombRetBo.getPayOrderId());
        retBo.setOrderId(reqBo.getOrderId());
        String respInfo = this.urlEncode(retBo);
        String jumpUrl = besePath.append("/").append(oneCodePayHtml).append("?respInfo=").append(respInfo).toString();
        this.LOGGER.info("\u62fc\u63a5\u5b8c\u6210\u7684\u5730\u5740\u4e3a\uff1a" + jumpUrl);
        retBo.setJumpUrl(jumpUrl);
    }

    private void replaceAliActionUrl(PayProOrderCreateCombBusiRspDataBo combBusiDataBo) {
        this.LOGGER.info("\u51c6\u5907\u66ff\u6362\u652f\u4ed8\u5b9d\u4ee3\u7406\u5730\u5740");
        if ("1".equals(this.payPropertiesVo.getValueByKey("pay.ali.used.proxy"))) {
            String oldStr = this.payPropertiesVo.getValueByKey("aliOpenApiDomain");
            String newStr = this.payPropertiesVo.getValueByKey("pay.ali.real.address");
            if (StringUtils.isEmpty((Object)newStr)) {
                this.LOGGER.error("\u652f\u4ed8\u5b9d\u771f\u5b9e\u5730\u5740(pay.ali.real.address)\u672a\u914d\u7f6e\uff0c\u4f7f\u7528\u9ed8\u8ba4\u503c");
                newStr = "https://openapi.alipay.com/gateway.do";
            }
            combBusiDataBo.setHtmlBody(combBusiDataBo.getHtmlBody().replace(oldStr, newStr));
            this.LOGGER.info("\u66ff\u6362\u652f\u4ed8\u5b9d\u4ee3\u7406\u5730\u5740\u6210\u529f\uff0c\u66ff\u6362\u540e\u7684\u503c\u4e3a\uff1a" + combBusiDataBo.getHtmlBody());
        }
    }

    private void assembleWxUrl(PayProOneCodePayCombReqBo reqBo, PayProOneCodePayCombRspBo retBo, PayOrderRspBo orderRetBo, StringBuffer basePath) {
        String dealWxPath = this.payPropertiesVo.getValueByKey("pay.one.code.pay.wx.scan");
        if (StringUtils.isEmpty((Object)dealWxPath)) {
            this.LOGGER.error("\u5904\u7406\u4e00\u7801\u4ed8\u5fae\u4fe1\u626b\u7801\u5730\u5740\uff08pay.one.code.pay.wx.pay\uff09\u672a\u914d\u7f6e");
            throw new BusinessException("7002", "\u5904\u7406\u4e00\u7801\u4ed8\u5fae\u4fe1\u626b\u7801\u5730\u5740\uff08pay.one.code.pay.wx.pay\uff09\u672a\u914d\u7f6e");
        }
        String redirectUrl = basePath.append("/").append(dealWxPath).append("/").append(reqBo.getOrderId()).append("/").append(reqBo.getTotalFee()).toString();
        this.LOGGER.info("\u5fae\u4fe1\u83b7\u53d6code\u540e\u7684\u56de\u8c03\u5730\u5740\u4e3a\uff1a" + redirectUrl);
        try {
            redirectUrl = URLEncoder.encode(redirectUrl, "UTF-8");
        }
        catch (IOException e) {
            this.LOGGER.error("\u5bf9\u5fae\u4fe1\u83b7\u53d6code\u540e\u7684\u56de\u8c03\u5730\u5740\u7f16\u7801\u5f02\u5e38\uff1a" + e);
            retBo.setRspCode("3011");
            retBo.setRspName("\u5bf9\u5fae\u4fe1\u83b7\u53d6code\u540e\u7684\u56de\u8c03\u5730\u5740\u7f16\u7801\u5f02\u5e38");
            return;
        }
        PayProQueryPayParaBusiReqBo qryPayParaReqBo = new PayProQueryPayParaBusiReqBo();
        qryPayParaReqBo.setPayMethod(PayProConstants.PayMethod.WX_JSP.getPayMethod());
        qryPayParaReqBo.setMerchantId(orderRetBo.getMerchantId());
        PayProQueryPayParaBusiRspBo qryPayParaRetBo = this.payProQueryPayParaBusiService.queryPayPara(qryPayParaReqBo);
        if (!"0000".equals(qryPayParaRetBo.getRespCode())) {
            this.LOGGER.error("\u83b7\u53d6\u5fae\u4fe1\u53c2\u6570\u5931\u8d25\uff1a" + qryPayParaRetBo.getRespDesc());
            retBo.setRspCode("3011");
            retBo.setRspName("\u83b7\u53d6\u53c2\u6570\u4fe1\u606f\u5931\u8d25\uff1a" + qryPayParaRetBo.getRespDesc());
            return;
        }
        this.LOGGER.info("\u67e5\u8be2\u51fa\u7684\u53c2\u6570\u4e3a\uff1a" + qryPayParaRetBo);
        String appId = (String)qryPayParaRetBo.getDetailAttrs().get("appid");
        String urlStr = this.payPropertiesVo.getValueByKey("authorizeUrl");
        if (StringUtils.isEmpty((Object)urlStr)) {
            this.LOGGER.error("\u5fae\u4fe1\u83b7\u53d6code\u7684\u5730\u5740'authorizeUrl'\u672a\u914d\u7f6e\uff0c\u5c06\u4f7f\u7528\u76f4\u63a5\u4f7f\u7528\u5fae\u4fe1\u63d0\u4f9b\u7684\u5730\u5740");
            urlStr = WX_GET_OPENID_URL;
        }
        StringBuilder url = new StringBuilder(urlStr);
        url.append("&appid=").append(appId).append("&redirect_uri=").append(redirectUrl).append("&orderId=").append(reqBo.getOrderId()).append("&totalFee=").append(reqBo.getTotalFee()).append("&response_type=code&scope=snsapi_base#wechat_redirect");
        this.LOGGER.info("\u62fc\u63a5\u540e\u83b7\u53d6code\u7684\u5730\u5740\u4e3a\uff1a" + url);
        retBo.setJumpUrl(url.toString());
    }

    private void createScanReCord(String orderId, String payIns) {
        UniQrCodeCreateScanStateBusiReqBo uniQrCodeCreateScanStateBusiReqBo = new UniQrCodeCreateScanStateBusiReqBo();
        String expireTime = this.payPropertiesVo.getValueByKey("pay.one.code.pay.expire.time");
        if (StringUtils.isEmpty((Object)expireTime)) {
            this.LOGGER.error("\u4e00\u7801\u4ed8\u626b\u7801\u8bb0\u5f55\u8fc7\u671f\u65f6\u95f4'pay.one.code.pay.expire.time'\u672a\u914d\u7f6e\uff0c\u9ed8\u8ba4\u8bbe\u7f6e\u4e3a1\u5206\u79cd");
            expireTime = "1";
        }
        uniQrCodeCreateScanStateBusiReqBo.setExtTime(expireTime);
        uniQrCodeCreateScanStateBusiReqBo.setOrderId(orderId);
        uniQrCodeCreateScanStateBusiReqBo.setPayMethod(payIns);
        this.uniQrCodeCreateScanStateBusiService.createScanState(uniQrCodeCreateScanStateBusiReqBo);
    }

    private String validateArgs(PayProOneCodePayCombReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'orderId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getTotalFee())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'totalFee'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getBasePath())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'basePath'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }

    private String urlEncode(PayProOneCodePayCombRspBo retBo) {
        try {
            return URLEncoder.encode(JSON.toJSONString((Object)retBo), "UTF-8");
        }
        catch (Exception e) {
            this.LOGGER.error("\u5bf9\u6570\u636e\u8fdb\u884cURLEncode\u7684\u65f6\u5019\u53d1\u751f\u5f02\u5e38\uff1a" + e);
            return "\u5bf9\u6570\u636e\u8fdb\u884cURLEncode\u7684\u65f6\u5019\u53d1\u751f\u5f02\u5e38";
        }
    }
}

