/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.payable.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.payment.pay.busi.bo.PayAbleBusiRspDataBo;
import com.tydic.payment.pay.busi.bo.PayAbleCallBackReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleCallBackRspBo;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayRspBo;
import com.tydic.payment.pay.busi.bo.PayAbleQryPayStatusReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleQryPayStatusRspBo;
import com.tydic.payment.pay.busi.bo.PayAbleRefundReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleRefundRspBo;
import com.tydic.payment.pay.busi.bo.PayProWxUnifiedOrderBusiRspBo;
import com.tydic.payment.pay.common.util.EntityConvertUtils;
import com.tydic.payment.pay.common.util.HttpClientUtils;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.constant.PayProConstants;
import com.tydic.payment.pay.dao.PayMethodMapper;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.payable.api.PayAble;
import com.tydic.payment.pay.wx.req.bo.WXApiOrderQueryReqBO;
import com.tydic.payment.pay.wx.req.bo.WXApiRefundReqBO;
import com.tydic.payment.pay.wx.rsp.bo.WXApiOrderQueryRspBO;
import com.tydic.payment.pay.wx.rsp.bo.WXApiRefundRspBO;
import com.tydic.payment.pay.wx.util.HttpsRequest;
import com.tydic.payment.pay.wx.util.RandomStringGenerator;
import com.tydic.payment.pay.wx.util.Signature;
import com.tydic.payment.pay.wx.util.Util;
import java.io.File;
import java.io.FileInputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import sun.misc.BASE64Encoder;

public abstract class AbstractWxPayAble
implements PayAble {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractWxPayAble.class);
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private PayMethodMapper payMethodMapper;
    @Resource
    private FileClient fileClient;
    private static final String SUCCESS = "SUCCESS";
    private static final String OUT_REFUND_FLAG = "1";
    private static final String PAY_CENTER_BASE_PATH = "payCenter/";
    private static final String WX_OUT_RETURN_CODE = "respCode";
    private static final String MD5 = "MD5";

    public PayAbleRefundRspBo dealRefund(PayAbleRefundReqBo reqBo) {
        WXApiRefundRspBO rsp;
        PayAbleRefundRspBo retBo;
        block17: {
            retBo = new PayAbleRefundRspBo();
            String validataArgStr = this.validateRefundArg(reqBo);
            if (!StringUtils.isEmpty((Object)validataArgStr)) {
                retBo.setRespCode("2015");
                retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validataArgStr);
                return retBo;
            }
            String wxRefundUrl = this.payPropertiesVo.getWXRefund();
            if (StringUtils.isEmpty((Object)wxRefundUrl)) {
                LOG.error("\u5fae\u4fe1\u9000\u6b3e\u5730\u5740(wxRefundUrl)\u672a\u914d\u7f6e");
                throw new BusinessException("6018", "\u5fae\u4fe1\u9000\u6b3e\u5730\u5740(wxReFundURl)\u672a\u914d\u7f6e");
            }
            Map paraMap = reqBo.getParaMap();
            String appId = null;
            appId = PayProConstants.PayMethod.WX_APPLET.equals(this.getPayMethod()) ? reqBo.getAppletAppId() : (String)paraMap.get("appid");
            String mchId = (String)paraMap.get("mchid");
            String signKey = (String)paraMap.get("signkey");
            String certPath = (String)paraMap.get("certname");
            String certPassword = (String)paraMap.get("certpassword");
            WXApiRefundReqBO refundReqData = new WXApiRefundReqBO().setAppid(appId).setMch_id(mchId).setOut_trade_no(reqBo.getPayOrderId()).setOut_refund_no(reqBo.getRefundOrderId()).setTotal_fee(Integer.parseInt(reqBo.getTotalFee() + "")).setRefund_fee(Integer.parseInt(reqBo.getRefundFee() + "")).setNonce_str("").setKey(signKey);
            if (StringUtils.isEmpty((Object)refundReqData)) {
                LOG.error("\u5fae\u4fe1\u9000\u6b3e\u5bf9\u8c61(WXApiRefundReqBO)\u4e3a\u7a7a");
                throw new BusinessException("6018", "\u5fae\u4fe1\u9000\u6b3e\u5bf9\u8c61(WXApiRefundReqBO)\u4e3a\u7a7a");
            }
            try {
                File downLoadFile = this.fileClient.downloadToFile(PAY_CENTER_BASE_PATH + certPath);
                certPath = downLoadFile.getAbsolutePath();
            }
            catch (Exception e) {
                LOG.error("\u83b7\u53d6\u8bc1\u4e66\u5f02\u5e38\uff1a" + e);
                throw new BusinessException("6018", "\u83b7\u53d6\u8bc1\u4e66\u5f02\u5e38\uff1a" + e);
            }
            String outRefundFlag = this.payPropertiesVo.getWXOutRefundFlag();
            String resultString = null;
            if (outRefundFlag.equals(OUT_REFUND_FLAG)) {
                LOG.info("\u5fae\u4fe1\u8d70\u5916\u90e8\u7a0b\u5e8f\u9000\u6b3e");
                String outReFundUrl = this.payPropertiesVo.getWXOutRefundUrl();
                LOG.info("\u8c03\u7528\u5916\u90e8\u9000\u6b3e\u5730\u5740\u4e3a\uff1a" + outReFundUrl);
                try {
                    resultString = this.doOutRefund(certPath, certPassword, outReFundUrl, refundReqData);
                    LOG.info("\u8c03\u7528\u5916\u90e8\u9000\u6b3e\u8fd4\u56de\u7ed3\u679c\u4e3a\uff1a" + resultString);
                }
                catch (Exception e) {
                    LOG.error("\u8c03\u7528\u5916\u90e8\u9000\u6b3e\u63a5\u53e3\u5f02\u5e38\uff1a" + e);
                    throw new BusinessException("6018", "\u8c03\u7528\u5916\u90e8\u9000\u6b3e\u63a5\u53e3\u5f02\u5e38\uff1a" + e);
                }
                Map resultMap = (Map)JSONObject.parseObject((String)resultString, (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
                resultString = (String)resultMap.get("resultStr");
                LOG.info("\u8c03\u7528\u5916\u90e8\u9000\u6b3e,\u5fae\u4fe1\u8fd4\u56de\u7ed3\u679c\u4e3a\uff1a" + resultString);
            } else {
                try {
                    HttpsRequest httpsRequest = new HttpsRequest(certPath, certPassword);
                    resultString = httpsRequest.sendPostPayPro(wxRefundUrl, (Object)refundReqData);
                }
                catch (Exception e) {
                    LOG.error("\u8c03\u7528\u5fae\u4fe1\u9000\u6b3e\u63a5\u53e3\u5931\u8d25\uff1a" + e);
                    throw new BusinessException("6018", "\u8c03\u7528\u5fae\u4fe1\u9000\u6b3e\u63a5\u53e3\u5931\u8d25\uff1a" + e);
                }
            }
            if (StringUtils.isEmpty((Object)resultString)) {
                LOG.error("\u5fae\u4fe1\u9000\u6b3e\u63a5\u53e3\u8fd4\u56de\u5b57\u7b26\u4e32\u4e3a\u7a7a");
                throw new BusinessException("6018", "\u5fae\u4fe1\u9000\u6b3e\u8fd4\u56de\u5b57\u7b26\u4e32\u4e3a\u7a7a");
            }
            rsp = (WXApiRefundRspBO)Util.getObjectFromXMLGeneric((String)resultString, WXApiRefundRspBO.class);
            if (rsp != null && SUCCESS.equals(rsp.getReturn_code()) && SUCCESS.equals(rsp.getResult_code())) {
                try {
                    if (!Signature.checkIsSignValidFromResponseString((String)resultString, (String)refundReqData.getKey())) {
                        LOG.error("\u5fae\u4fe1\u9000\u6b3e\u8fd4\u56de\u540e\u7b7e\u540d\u9519\u8bef");
                        throw new BusinessException("6018", "\u5fae\u4fe1\u67e5\u8be2\u8ba2\u5355\u8fd4\u56de\u540e\u7b7e\u540d\u9519\u8bef");
                    }
                    break block17;
                }
                catch (Exception e) {
                    LOG.error("\u5fae\u4fe1\u9000\u6b3e\u8fd4\u56de\u540e\u7b7e\u540d\u5f02\u5e38\uff1a" + e);
                    throw new BusinessException("6018", "\u5fae\u4fe1\u67e5\u8be2\u8ba2\u5355\u8fd4\u56de\u540e\u7b7e\u540d\u5f02\u5e38\uff1a" + e);
                }
            }
            retBo.setRespCode("2015");
            if (rsp != null) {
                retBo.setRespDesc("\u5fae\u4fe1\u9000\u6b3e\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1a" + rsp.getErr_code_des());
                retBo.setRefundMsg(rsp.getErr_code_des());
            }
            return retBo;
        }
        retBo = this.sortRefundRetBo(reqBo, retBo, rsp);
        return retBo;
    }

    public PayAbleQryPayStatusRspBo qryPayStatus(PayAbleQryPayStatusReqBo reqBo) {
        PayAbleQryPayStatusRspBo retBo = new PayAbleQryPayStatusRspBo();
        String validateArgStr = this.validateQryArg(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            retBo.setRespCode("2013");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return retBo;
        }
        String wxOrderQueryUrl = this.payPropertiesVo.getWXOrderQueryUrl();
        if (StringUtils.isEmpty((Object)wxOrderQueryUrl)) {
            LOG.error("\u5fae\u4fe1\u67e5\u8be2\u8ba2\u5355\u5730\u5740(WX_ORDER_QUERY_URL)\u672a\u914d\u7f6e");
            throw new BusinessException("6015", "\u5fae\u4fe1\u67e5\u8be2\u8ba2\u5355\u5730\u5740(WX_ORDER_QUERY_URL)\u672a\u914d\u7f6e");
        }
        Map paraMap = reqBo.getParaMap();
        String appId = null;
        appId = PayProConstants.PayMethod.WX_APPLET.equals(this.getPayMethod()) ? reqBo.getAppletAppId() : (PayProConstants.PayMethod.WX_APP.equals(this.getPayMethod()) ? reqBo.getAppPayAppId() : (String)paraMap.get("appid"));
        String mchId = (String)paraMap.get("mchid");
        String signKey = (String)paraMap.get("signkey");
        WXApiOrderQueryReqBO orderQueryReqData = new WXApiOrderQueryReqBO().setAppid(appId).setMch_id(mchId).setOut_trade_no(reqBo.getPayOrderId()).setNonce_str("").setKey(signKey);
        if (orderQueryReqData == null) {
            LOG.error("\u5fae\u4fe1\u67e5\u8be2\u8ba2\u5355\u5bf9\u8c61(WXApiOrderQueryReqBO)\u4e3a\u7a7a");
            throw new BusinessException("6015", "\u5fae\u4fe1\u67e5\u8be2\u8ba2\u5355\u5bf9\u8c61(WXApiOrderQueryReqBO)\u4e3a\u7a7a");
        }
        LOG.info("\u5fae\u4fe1\u67e5\u8be2\u8ba2\u5355api" + orderQueryReqData);
        String resultString = null;
        try {
            HttpsRequest httpsRequest = new HttpsRequest();
            resultString = httpsRequest.sendPostPayPro(wxOrderQueryUrl, (Object)orderQueryReqData);
        }
        catch (Exception e) {
            LOG.error("\u5411\u5fae\u4fe1\u67e5\u8be2\u8ba2\u5355\u5f02\u5e38\uff1a" + e);
            throw new BusinessException("6015", "\u5411\u5fae\u4fe1\u67e5\u8be2\u8ba2\u5355\u5f02\u5e38\uff1a" + e);
        }
        if (StringUtils.isEmpty((Object)resultString)) {
            LOG.error("\u5fae\u4fe1\u67e5\u8be2\u8ba2\u5355\u8fd4\u56de\u5b57\u7b26\u4e32\u4e3a\u7a7a");
            throw new BusinessException("6015", "\u5fae\u4fe1\u67e5\u8be2\u8ba2\u5355\u8fd4\u56de\u5b57\u7b26\u4e32\u4e3a\u7a7a");
        }
        WXApiOrderQueryRspBO rsp = (WXApiOrderQueryRspBO)Util.getObjectFromXMLGeneric((String)resultString, WXApiOrderQueryRspBO.class);
        if (rsp != null && SUCCESS.equals(rsp.getReturn_code()) && SUCCESS.equals(rsp.getResult_code())) {
            try {
                if (!Signature.checkIsSignValidFromResponseString((String)resultString, (String)orderQueryReqData.getKey())) {
                    LOG.error("\u5fae\u4fe1\u67e5\u8be2\u8ba2\u5355\u8fd4\u56de\u540e\u7b7e\u540d\u9519\u8bef");
                    throw new BusinessException("6015", "\u5fae\u4fe1\u67e5\u8be2\u8ba2\u5355\u8fd4\u56de\u540e\u7b7e\u540d\u9519\u8bef");
                }
            }
            catch (Exception e) {
                LOG.error("\u5fae\u4fe1\u67e5\u8be2\u8ba2\u5355\u8fd4\u56de\u540e\u7b7e\u540d\u5f02\u5e38\uff1a" + e);
                throw new BusinessException("6015", "\u5fae\u4fe1\u67e5\u8be2\u8ba2\u5355\u8fd4\u56de\u540e\u7b7e\u540d\u5f02\u5e38\uff1a" + e);
            }
        }
        retBo = this.sortQryStatusRetBo(reqBo, retBo, rsp);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u67e5\u8be2\u6210\u529f");
        return retBo;
    }

    public PayAbleCallBackRspBo dealCallBack(PayAbleCallBackReqBo reqBo) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String doOutRefund(String certPath, String certPassword, String outReFundUrl, WXApiRefundReqBO refundReqData) throws Exception {
        String resultStr;
        File file = new File(certPath);
        String certPathStr = "";
        try (FileInputStream inputFile = new FileInputStream(file);){
            byte[] buffer = new byte[(int)file.length()];
            int read = inputFile.read(buffer);
            if (read > 0) {
                certPathStr = new BASE64Encoder().encode(buffer);
            }
        }
        Map paraMap = EntityConvertUtils.entityToMap((Object)refundReqData);
        paraMap.put("fileBase64Str", certPathStr);
        paraMap.put("certPassword", certPassword);
        paraMap.put("realSignStr", refundReqData.getSign());
        try {
            resultStr = HttpClientUtils.doPost((String)outReFundUrl, (Map)paraMap);
        }
        catch (Exception e) {
            LOG.error("\u8c03\u7528\u5916\u90e8\u5fae\u4fe1\u9000\u6b3e\u63a5\u53e3\u5f02\u5e38\uff1a" + e);
            throw new BusinessException("6018", "\u8c03\u7528\u5916\u90e8\u5fae\u4fe1\u9000\u6b3e\u63a5\u53e3\u5f02\u5e38\uff1a" + e);
        }
        return resultStr;
    }

    public PayAbleRefundRspBo sortRefundRetBo(PayAbleRefundReqBo reqBo, PayAbleRefundRspBo retBo, WXApiRefundRspBO rsp) {
        if (!SUCCESS.equals(rsp.getResult_code())) {
            retBo.setRespCode("0000");
            retBo.setRespDesc(rsp.getReturn_msg());
            retBo.setRefundMsg(rsp.getErr_code_des());
            return retBo;
        }
        if (!SUCCESS.equals(rsp.getResult_code()) || !StringUtils.isEmpty((Object)rsp.getErr_code())) {
            retBo.setRespCode("8888");
            retBo.setRespDesc(rsp.getReturn_msg());
            retBo.setRefundMsg(rsp.getErr_code_des());
            return retBo;
        }
        BeanUtils.copyProperties((Object)reqBo, (Object)retBo);
        Date dbDate = this.payMethodMapper.getDBDate().getDate();
        String tradeTime = new DateTime((Object)dbDate).toString("yyyyMMddHHmmss");
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        retBo.setRefundTransId(rsp.getRefund_id());
        retBo.setTradeTime(tradeTime);
        return retBo;
    }

    public PayAbleQryPayStatusRspBo sortQryStatusRetBo(PayAbleQryPayStatusReqBo reqBo, PayAbleQryPayStatusRspBo retBo, WXApiOrderQueryRspBO rsp) {
        BeanUtils.copyProperties((Object)reqBo, (Object)retBo);
        if (!SUCCESS.equals(rsp.getReturn_code())) {
            retBo.setRespCode("0000");
            retBo.setRespDesc(rsp.getReturn_msg());
            retBo.setPayStatus("FAIL");
            return retBo;
        }
        if (!SUCCESS.equals(rsp.getResult_code())) {
            retBo.setRespCode("0000");
            retBo.setRespDesc(rsp.getErr_code_des());
            retBo.setPayStatus("FAIL");
            return retBo;
        }
        String tradeStatus = rsp.getTrade_state();
        PayProConstants.WxPayTradeStatus wxPayTradeStatus = PayProConstants.WxPayTradeStatus.valueOf(tradeStatus);
        switch (wxPayTradeStatus) {
            case SUCCESS: {
                retBo.setTradeTime(rsp.getTime_end());
                retBo.setPayNotifyTransId(rsp.getTransaction_id());
                retBo.setRealFee(Long.valueOf(rsp.getTotal_fee()));
                retBo.setPayStatus(SUCCESS);
                retBo.setPayStatusMsg("\u652f\u4ed8\u6210\u529f(wxpay)");
                break;
            }
            case NOTPAY: {
                retBo.setPayStatus("PAYING");
                retBo.setPayStatusMsg("\u7528\u6237\u652f\u4ed8\u4e2d(wxpay)");
                break;
            }
            case USERPAYING: {
                retBo.setPayStatus("PAYING");
                retBo.setPayStatusMsg("\u7528\u6237\u652f\u4ed8\u4e2d(wxpay)");
                break;
            }
            case REVOKED: {
                retBo.setPayStatus("CLOSED");
                retBo.setPayStatusMsg("\u8ba2\u5355\u5df2\u64a4\u9500(wxpay)");
            }
            case PAYERROR: {
                retBo.setPayStatus("FAIL");
                retBo.setPayStatusMsg(rsp.getErr_code_des() + "(wxpay)");
                break;
            }
            case CLOSED: {
                retBo.setPayStatus("CLOSED");
                retBo.setPayStatusMsg("\u8ba2\u5355\u5df2\u5173\u95ed(wxpay)");
                break;
            }
            case REFUND: {
                retBo.setPayStatus(SUCCESS);
                retBo.setPayStatusMsg(rsp.getTrade_state_desc() + "(wxpay)");
                break;
            }
            default: {
                retBo.setPayStatusMsg("\u5fae\u4fe1\u8fd4\u56de\u672a\u77e5\u72b6\u6001\u503c");
                retBo.setPayStatus("FAIL");
            }
        }
        return retBo;
    }

    public String validateQryArg(PayAbleQryPayStatusReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getParaMap())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027paraMap\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027payOrderId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (PayProConstants.PayMethod.WX_APPLET.equals(this.getPayMethod()) && StringUtils.isEmpty((Object)reqBo.getAppletAppId())) {
            return "\u67e5\u8be2\u5c0f\u7a0b\u5e8f\u6240\u4e0b\u8ba2\u5355\u65f6\uff0c\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027appletAppId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (PayProConstants.PayMethod.WX_APP.equals(this.getPayMethod()) && StringUtils.isEmpty((Object)reqBo.getAppPayAppId())) {
            return "\u67e5\u8be2APP\u652f\u4ed8\u7684\u8ba2\u5355\u65f6\uff0c\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027appPayAppId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        String validateMap = this.validateMap(reqBo.getParaMap());
        if (!StringUtils.isEmpty((Object)validateMap)) {
            return validateMap;
        }
        return null;
    }

    public String validateRefundArg(PayAbleRefundReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getRefundFee())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027refundFee\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getTotalFee())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027totalFee\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getRefundOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027refundOrderId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027payOrderId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getParaMap())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027paraMap\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (PayProConstants.PayMethod.WX_APPLET.equals(this.getPayMethod()) && StringUtils.isEmpty((Object)reqBo.getAppletAppId())) {
            return "\u5c0f\u7a0b\u5e8f\u6240\u4e0b\u8ba2\u5355\u9000\u6b3e\u65f6\uff0c\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027appletAppId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        Map paraMap = reqBo.getParaMap();
        String validateMap = this.validateMap(paraMap);
        if (!StringUtils.isEmpty((Object)validateMap)) {
            return validateMap;
        }
        String certPath = (String)paraMap.get("certname");
        String certPassword = (String)paraMap.get("certpassword");
        if (StringUtils.isEmpty((Object)certPath)) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027paraMap\u4e2d(certname)\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)certPassword)) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027paraMap\u4e2d(certpassword)\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }

    private String validateMap(Map<String, String> paraMap) {
        String appId = paraMap.get("appid");
        String mchId = paraMap.get("mchid");
        if (StringUtils.isEmpty((Object)mchId)) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027paraMap\u4e2d(mchid)\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)appId) && !PayProConstants.PayMethod.WX_APP.equals(this.getPayMethod()) && !PayProConstants.PayMethod.WX_APPLET.equals(this.getPayMethod())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027paraMap\u4e2d(appid)\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }

    protected void sortRetBo(PayAbleDealPayReqBo reqBo, PayAbleDealPayRspBo retBo, String signKey, PayProWxUnifiedOrderBusiRspBo unfiedRetBo) {
        BeanUtils.copyProperties((Object)reqBo, (Object)retBo);
        String appId = unfiedRetBo.getAppId();
        String prepayId = unfiedRetBo.getPrepayId();
        unfiedRetBo.getCodeUrl();
        unfiedRetBo.getMwebUrl();
        String timeStamp = String.valueOf(System.currentTimeMillis() / 1000L);
        String packageBody = "prepay_id=" + prepayId;
        String nonceStr = RandomStringGenerator.getRandomStringByLength((int)32);
        HashMap<String, String> signMsg = new HashMap<String, String>(16);
        PayAbleBusiRspDataBo busiRspData = new PayAbleBusiRspDataBo();
        if (PayProConstants.PayMethod.WX_APP.getPayMethod().equals(this.getPayMethod())) {
            String mchId = (String)reqBo.getParaMap().get("mchid");
            signMsg.put("appid", appId);
            signMsg.put("partnerid", mchId);
            signMsg.put("prepayid", prepayId);
            signMsg.put("package", "Sign=WXPay");
            signMsg.put("noncestr", nonceStr);
            signMsg.put("timestamp", timeStamp);
            String sign = Signature.getSign(signMsg, (String)signKey);
            busiRspData.setAppId(appId);
            busiRspData.setPartnerId(mchId);
            busiRspData.setPrepayId(prepayId);
            busiRspData.setPackageBody("Sign=WXPay");
            busiRspData.setTimeStamp(timeStamp);
            busiRspData.setNonceStr(nonceStr);
            busiRspData.setSignType(MD5);
            busiRspData.setPaySign(sign);
        } else {
            signMsg.put("appId", appId);
            signMsg.put("timeStamp", timeStamp);
            signMsg.put("nonceStr", nonceStr);
            signMsg.put("package", packageBody);
            signMsg.put("signType", MD5);
            String sign = Signature.getSign(signMsg, (String)signKey);
            busiRspData.setAppId(appId);
            busiRspData.setTimeStamp(timeStamp);
            busiRspData.setNonceStr(nonceStr);
            busiRspData.setPackageBody(packageBody);
            busiRspData.setSignType(MD5);
            busiRspData.setPaySign(sign);
        }
        retBo.setBusiRspDataBo(JSON.toJSONString((Object)busiRspData));
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
    }

    protected String validWxJsapiaArgs(PayAbleDealPayReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'payOrderId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getParaMap())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'paraMap'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getDetailName())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'detailName'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getBusiReqData())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'busiReqData'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayFee())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'payFee'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getCreateIpAddress())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'createIpAddress'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

