/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.payable.impl;

import com.alibaba.fastjson.JSON;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayRequest;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.request.AlipayTradeWapPayRequest;
import com.alipay.api.response.AlipayTradeWapPayResponse;
import com.tydic.payment.pay.busi.QueryCashierService;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayRspBo;
import com.tydic.payment.pay.busi.bo.QueryCashierReqBo;
import com.tydic.payment.pay.busi.bo.QueryCashierRspBo;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.common.util.OrderCiphertext;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.constant.PayProConstants;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.payable.api.PayAble;
import com.tydic.payment.pay.payable.impl.AbstractAliPayAble;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class AliPayH5PayAbleImpl
extends AbstractAliPayAble
implements PayAble {
    private static final Logger LOG = LoggerFactory.getLogger(AliPayH5PayAbleImpl.class);
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private QueryCashierService queryCashierService;

    public Long getPayMethod() {
        return PayProConstants.PayMethod.ALI_H5.getPayMethod();
    }

    public PayAbleDealPayRspBo dealPay(PayAbleDealPayReqBo reqBo) {
        LOG.info("\u652f\u4ed8\u5b9dH5\u652f\u4ed8\u80fd\u529b\u5b9e\u73b0\uff1a" + reqBo);
        PayAbleDealPayRspBo retBo = new PayAbleDealPayRspBo();
        String validateArgStr = this.validateArg(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            retBo.setRespCode("2022");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return retBo;
        }
        String aliOpenApiDomain = this.payPropertiesVo.getAliOpenApiDomain();
        String aliNotifyUrl = this.payPropertiesVo.getAliNotifyUrl();
        if (StringUtils.isEmpty((Object)aliOpenApiDomain)) {
            LOG.error("\u652f\u4ed8\u5b9d\u8bf7\u6c42\u5730\u5740(aliOpenApiDomain)\u672a\u914d\u7f6e");
            throw new BusinessException("6019", "\u652f\u4ed8\u5b9d\u8bf7\u6c42\u5730\u5740(aliOpenApiDomain)\u672a\u914d\u7f6e");
        }
        if (StringUtils.isEmpty((Object)aliNotifyUrl)) {
            LOG.error("\u652f\u4ed8\u5b9d\u56de\u8c03\u5730\u5740(aliNotifyUrl)\u672a\u914d\u7f6e");
            throw new BusinessException("6019", "\u652f\u4ed8\u5b9d\u56de\u8c03\u5730\u5740(aliNotifyUrl)\u672a\u914d\u7f6e");
        }
        Map paraMap = reqBo.getParaMap();
        String appId = (String)paraMap.get("appid");
        String privateKey = (String)paraMap.get("privateKey");
        String publicKey = (String)paraMap.get("publicKey");
        DefaultAlipayClient alipayClient = new DefaultAlipayClient(aliOpenApiDomain, appId, privateKey, "json", "UTF-8", publicKey, "RSA2");
        QueryCashierReqBo queryCashierReqBo = new QueryCashierReqBo();
        queryCashierReqBo.setBusiId(reqBo.getBusiId() + "");
        queryCashierReqBo.setReqWay("3");
        QueryCashierRspBo queryCashierRspBo = this.queryCashierService.queryCashier(queryCashierReqBo);
        if (!"0000".equals(queryCashierRspBo.getRspCode())) {
            retBo.setRespCode(queryCashierRspBo.getRspCode());
            retBo.setRespDesc(queryCashierRspBo.getRspName());
            return retBo;
        }
        String cashierTemplateUrl = queryCashierRspBo.getCashierTemplateUrl();
        if (StringUtils.isEmpty((Object)cashierTemplateUrl)) {
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u8be5\u63a5\u5165\u65b9\u5f0f\u5bf9\u5e94\u7684\u6536\u94f6\u53f0\u6ca1\u6709\u914d\u7f6e\u6536\u94f6\u53f0\u5730\u5740");
            return retBo;
        }
        String secreteOrder = OrderCiphertext.encode((byte[])reqBo.getOrderId().toString().getBytes());
        String returnUrl = this.payPropertiesVo.getValueByKey("pay.one.code.result.url") + "&orderId=" + reqBo.getOrderId() + "&detailName=" + reqBo.getDetailName() + "&totalFee=" + reqBo.getPayFee() + "&channel=23";
        LOG.info("\u9875\u9762\u5de5\u7a0b\u83b7\u53d6\u652f\u4ed8\u5b9dH5\u652f\u4ed8\u9875\u9762\u56de\u8c03\u5730\u5740\u4e3a\uff1a" + returnUrl);
        AlipayTradeWapPayRequest request = new AlipayTradeWapPayRequest();
        request.setNotifyUrl(aliNotifyUrl);
        request.setReturnUrl(returnUrl);
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
        dataMap.put("subject", reqBo.getDetailName());
        dataMap.put("out_trade_no", reqBo.getPayOrderId());
        dataMap.put("total_amount", MoneyUtils.fenToYuan((Long)reqBo.getPayFee()).toString());
        dataMap.put("product_code", "QUICK_WAP_WAY");
        dataMap.put("timeout_express", reqBo.getExtTime() + "m");
        request.setBizContent(JSON.toJSONString(dataMap));
        BeanUtils.copyProperties((Object)reqBo, (Object)retBo);
        try {
            AlipayTradeWapPayResponse response = (AlipayTradeWapPayResponse)alipayClient.pageExecute((AlipayRequest)request);
            LOG.info("\u652f\u4ed8\u5b9d\u6761\u7801\u4e0b\u5355\u8fd4\u56de\u503c\u4e3a\uff1a" + (response != null ? JSON.toJSONString((Object)response) : "null"));
            if (response == null) {
                LOG.error("\u8c03\u7528\u652f\u4ed8\u5b9d\u63a5\u53e3\u5931\u8d25\uff1a\u8fd4\u56de\u5bf9\u8c61\u4e3a\u7a7a");
                retBo.setRespCode("2022");
                retBo.setRespDesc("\u8c03\u7528\u652f\u4ed8\u5b9d\u63a5\u53e3\u5931\u8d25\uff1a\u8fd4\u56de\u5bf9\u8c61\u4e3a\u7a7a");
                return retBo;
            }
            if (!response.isSuccess()) {
                LOG.error("\u8c03\u7528\u652f\u4ed8\u5b9d\u63a5\u53e3\u5931\u8d25\uff1a" + response.getSubMsg());
                retBo.setRespCode("2022");
                retBo.setRespDesc("\u8c03\u7528\u652f\u4ed8\u5b9d\u63a5\u53e3\u5931\u8d25\uff1a" + response.getSubMsg());
                return retBo;
            }
            String form = response.getBody();
            retBo.setHtmlBody(form);
            retBo.setPayOrderId(reqBo.getPayOrderId());
            retBo.setOrderId(reqBo.getOrderId());
            retBo.setPayFee(reqBo.getPayFee());
            retBo.setRespCode("0000");
            retBo.setRespDesc("\u652f\u4ed8\u5b9dPC\u7aef\u4e0b\u5355\u6210\u529f");
        }
        catch (AlipayApiException e) {
            LOG.error("\u8c03\u7528\u652f\u4ed8\u5b9dPC\u7aef\u4e0b\u5355\u5f02\u5e38\uff1a" + (Object)((Object)e));
            throw new BusinessException("6019", "\u8c03\u7528\u652f\u4ed8\u5b9dPC\u7aef\u4e0b\u5355\u5f02\u5e38\uff1a" + (Object)((Object)e), (Throwable)e);
        }
        return retBo;
    }

    private String validateArg(PayAbleDealPayReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027payOrderId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getDetailName())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027detailName\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayFee())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027payFee\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getParaMap())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027paraMap\u4e0d\u80fd\u4e3a\u7a7a";
        }
        Map paraMap = reqBo.getParaMap();
        String appId = (String)paraMap.get("appid");
        String privateKey = (String)paraMap.get("privateKey");
        String publicKey = (String)paraMap.get("publicKey");
        if (StringUtils.isEmpty((Object)appId)) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027paraMap\u4e2dkey(appId)\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)privateKey)) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027paraMap\u4e2dkey(privateKey)\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)publicKey)) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027paraMap\u4e2dkey(publicKey)\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getExtTime())) {
            reqBo.setExtTime("3");
        }
        return null;
    }
}

