/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.payable.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.payment.pay.busi.PayProWxUnifiedOrderBusiService;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayRspBo;
import com.tydic.payment.pay.busi.bo.PayProWxUnifiedOrderBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayProWxUnifiedOrderBusiRspBo;
import com.tydic.payment.pay.constant.PayProConstants;
import com.tydic.payment.pay.payable.api.PayAble;
import com.tydic.payment.pay.payable.impl.AbstractWxPayAble;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class WxPayH5PayAbleImpl
extends AbstractWxPayAble
implements PayAble {
    private static final Logger LOG = LoggerFactory.getLogger(WxPayH5PayAbleImpl.class);
    private static final String MWEB = "MWEB";
    private static final String WAP_URL = "https://pay.qq.com";
    @Autowired
    private PayProWxUnifiedOrderBusiService payProWxUnifiedOrderBusiService;

    public Long getPayMethod() {
        return PayProConstants.PayMethod.WX_H5.getPayMethod();
    }

    public PayAbleDealPayRspBo dealPay(PayAbleDealPayReqBo reqBo) {
        PayAbleDealPayRspBo retBo = new PayAbleDealPayRspBo();
        String validataArgStr = this.validataArg(reqBo);
        if (!StringUtils.isEmpty((Object)validataArgStr)) {
            retBo.setRespCode("2018");
            retBo.setRespDesc("\u5fae\u4fe1H5\u652f\u4ed8\u80fd\u529b\u5b9e\u73b0\u7c7b\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validataArgStr);
            return retBo;
        }
        JSONObject h5_info = new JSONObject();
        JSONObject jsonInfo = new JSONObject();
        h5_info.put("type", (Object)"Wap");
        h5_info.put("wap_url", (Object)WAP_URL);
        h5_info.put("wap_name", (Object)h5_info);
        jsonInfo.put("h5_info", (Object)h5_info);
        String SceneInfo = jsonInfo.toJSONString();
        PayProWxUnifiedOrderBusiReqBo payProWxUnifiedOrderBusiReqBo = new PayProWxUnifiedOrderBusiReqBo();
        payProWxUnifiedOrderBusiReqBo.setParaMap(reqBo.getParaMap());
        payProWxUnifiedOrderBusiReqBo.setTotalFee(reqBo.getPayFee() + "");
        payProWxUnifiedOrderBusiReqBo.setPayOrderId(reqBo.getPayOrderId());
        payProWxUnifiedOrderBusiReqBo.setSpbillCreateIp(reqBo.getCreateIpAddress());
        payProWxUnifiedOrderBusiReqBo.setTradeType(MWEB);
        payProWxUnifiedOrderBusiReqBo.setPayMethod(PayProConstants.PayMethod.WX_H5.getPayMethod() + "");
        payProWxUnifiedOrderBusiReqBo.setBody(reqBo.getDetailName());
        payProWxUnifiedOrderBusiReqBo.setSceneInfo(SceneInfo);
        PayProWxUnifiedOrderBusiRspBo unifiedRetData = this.payProWxUnifiedOrderBusiService.unifiedOrder(payProWxUnifiedOrderBusiReqBo);
        LOG.info("\u8c03\u7528\u7edf\u4e00\u4e0b\u5355\u8fd4\u56de\u503c\u4e3a\uff1a" + unifiedRetData);
        if (!"0000".equals(unifiedRetData.getRespCode())) {
            retBo.setRespCode("2018");
            retBo.setRespDesc("\u8c03\u7528\u5fae\u4fe1\u7edf\u4e00\u4e0b\u5355busi\u670d\u52a1\u5931\u8d25\uff1a" + unifiedRetData.getRespDesc());
            return retBo;
        }
        BeanUtils.copyProperties((Object)reqBo, (Object)retBo);
        retBo.setQrCodeUrl(unifiedRetData.getCodeUrl());
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        retBo.setPayOrderId(unifiedRetData.getPayOrderId());
        return retBo;
    }

    private String validataArg(PayAbleDealPayReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getParaMap())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027paraMap\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027parOrderId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayFee())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027payFee\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getDetailName())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027detailName\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getCreateIpAddress())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027createIpAddress\u4e0d\u80fd\u4e3a\u7a7a";
        }
        Map paraMap = reqBo.getParaMap();
        String validataMapStr = this.validataMap(paraMap);
        if (!StringUtils.isEmpty((Object)validataMapStr)) {
            return validataMapStr;
        }
        return null;
    }

    private String validataMap(Map<String, String> paraMap) {
        String appId = paraMap.get("appid");
        String mchId = paraMap.get("mchid");
        String signKey = paraMap.get("signkey");
        if (StringUtils.isEmpty((Object)appId)) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027paraMap\u4e2d(appid)\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)mchId)) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027paraMap\u4e2d(mchId)\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)signKey)) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027paraMap\u4e2d(signKey)\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

