/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.bill.busi.impl;

import com.ohaotian.plugin.base.bo.TopologyBO;
import com.tydic.payment.bill.busi.QueryPayTransBusiService;
import com.tydic.payment.bill.busi.bo.QueryPayTransByGroupNameReqBO;
import com.tydic.payment.bill.busi.bo.QueryPayTransReqBO;
import com.tydic.payment.bill.busi.bo.QueryPayTransRspBO;
import com.tydic.payment.pay.dao.PorderPayTransMapper;
import com.tydic.payment.pay.dao.po.PorderPayTransPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="queryPayTransBusiService")
public class QueryPayTransBusiServiceImpl
implements QueryPayTransBusiService {
    @Autowired
    private PorderPayTransMapper porderPayTransMapper;

    public QueryPayTransRspBO queryByPayOrderId(String payOrderId) {
        PorderPayTransPo reqPO = new PorderPayTransPo();
        reqPO.setPayOrderId(payOrderId);
        PorderPayTransPo rspPO = this.porderPayTransMapper.getOrderPayTransByPayOrderId(reqPO);
        if (rspPO == null) {
            return null;
        }
        QueryPayTransRspBO rspBO = new QueryPayTransRspBO();
        BeanUtils.copyProperties((Object)rspPO, (Object)rspBO);
        return rspBO;
    }

    public Collection<QueryPayTransRspBO> queryPayTrans(QueryPayTransReqBO queryPayTransReqBO) {
        List<PorderPayTransPo> payTransPos = this.porderPayTransMapper.queryPayTrans(queryPayTransReqBO.getPayMethods(), queryPayTransReqBO.getStatus(), queryPayTransReqBO.getTradeTime());
        if (payTransPos == null || payTransPos.size() < 1) {
            return null;
        }
        ArrayList<QueryPayTransRspBO> payTransBos = new ArrayList<QueryPayTransRspBO>(payTransPos.size());
        QueryPayTransRspBO queryPayTransRspBO = null;
        for (PorderPayTransPo payTransPo : payTransPos) {
            queryPayTransRspBO = new QueryPayTransRspBO();
            BeanUtils.copyProperties((Object)payTransPo, (Object)queryPayTransRspBO);
            payTransBos.add(queryPayTransRspBO);
        }
        return payTransBos;
    }

    public Collection<QueryPayTransRspBO> listPayTrans(QueryPayTransReqBO reqBO) {
        List<PorderPayTransPo> pos = this.porderPayTransMapper.listPayTrans(reqBO.getStatus(), reqBO.getTradeTime());
        if (pos == null || pos.size() < 1) {
            return null;
        }
        ArrayList<QueryPayTransRspBO> bos = new ArrayList<QueryPayTransRspBO>(pos.size());
        for (PorderPayTransPo po : pos) {
            QueryPayTransRspBO bo = new QueryPayTransRspBO();
            BeanUtils.copyProperties((Object)po, (Object)bo);
            bos.add(bo);
        }
        return bos;
    }

    public QueryPayTransRspBO queryByOrderId(Long orderId) {
        PorderPayTransPo reqPO = new PorderPayTransPo();
        reqPO.setOrderId(orderId);
        PorderPayTransPo rspPO = this.porderPayTransMapper.getOrderPayTransByOrderId(reqPO);
        if (rspPO == null) {
            return null;
        }
        QueryPayTransRspBO rspBO = new QueryPayTransRspBO();
        BeanUtils.copyProperties((Object)rspPO, (Object)rspBO);
        return rspBO;
    }

    public List<QueryPayTransRspBO> listByOrderId(Long orderId) {
        List<PorderPayTransPo> pos = this.porderPayTransMapper.listSuccessByOrderId(orderId);
        if (pos == null || pos.size() < 1) {
            return null;
        }
        ArrayList<QueryPayTransRspBO> bos = new ArrayList<QueryPayTransRspBO>(pos.size());
        for (PorderPayTransPo po : pos) {
            QueryPayTransRspBO bo = new QueryPayTransRspBO();
            BeanUtils.copyProperties((Object)po, (Object)bo);
            bos.add(bo);
        }
        return bos;
    }

    public LinkedList<TopologyBO> listDrdsGroupNames() {
        return this.porderPayTransMapper.listDrdsGroupNames();
    }

    public List<QueryPayTransRspBO> listSuccessTransByGroupName(QueryPayTransByGroupNameReqBO reqBO) {
        List<PorderPayTransPo> pos = this.porderPayTransMapper.listSuccessTransByGroupName(reqBO.getPayMethods(), reqBO.getMerchantIds(), reqBO.getBillDate(), reqBO.getGroupName());
        if (pos == null || pos.size() < 1) {
            return new ArrayList<QueryPayTransRspBO>();
        }
        ArrayList<QueryPayTransRspBO> bos = new ArrayList<QueryPayTransRspBO>(pos.size());
        for (PorderPayTransPo po : pos) {
            QueryPayTransRspBO bo = new QueryPayTransRspBO();
            BeanUtils.copyProperties((Object)po, (Object)bo);
            bos.add(bo);
        }
        return bos;
    }

    public List<QueryPayTransRspBO> listSuccessTransSingleDatabase(QueryPayTransByGroupNameReqBO reqBO) {
        List<PorderPayTransPo> pos = this.porderPayTransMapper.listSuccessTransSingleDatabase(reqBO.getPayMethods(), reqBO.getMerchantIds(), reqBO.getBillDate());
        if (pos == null || pos.size() < 1) {
            return new ArrayList<QueryPayTransRspBO>();
        }
        ArrayList<QueryPayTransRspBO> bos = new ArrayList<QueryPayTransRspBO>(pos.size());
        for (PorderPayTransPo po : pos) {
            QueryPayTransRspBO bo = new QueryPayTransRspBO();
            BeanUtils.copyProperties((Object)po, (Object)bo);
            bos.add(bo);
        }
        return bos;
    }
}

