/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.tydic.payment.pay.LoggerProUtils;
import com.tydic.payment.pay.ability.GdBankAliMiniProPayAbilityService;
import com.tydic.payment.pay.ability.bo.GdBankAliMiniProPayAbilityReqBo;
import com.tydic.payment.pay.ability.bo.GdBankAliMiniProPayAbilityRspBo;
import com.tydic.payment.pay.bo.GoodsDetail;
import com.tydic.payment.pay.comb.GdBankAliMiniProPayCombService;
import com.tydic.payment.pay.comb.bo.GdBankAliMiniProPayCombReqBo;
import com.tydic.payment.pay.comb.bo.GdBankAliMiniProPayCombRspBo;
import com.tydic.payment.pay.exception.BusinessException;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="gdBankAliMiniProPayAbilityService")
@HSFProvider(serviceVersion="2.0-SNAPSHOT", serviceGroup="PAY_GROUP_LOCAL", serviceInterface=GdBankAliMiniProPayAbilityService.class)
public class GdBankAliMiniProPayAbilityServiceImpl
implements GdBankAliMiniProPayAbilityService {
    private static final Logger LOG = LoggerFactory.getLogger(GdBankAliMiniProPayAbilityServiceImpl.class);
    private static final String SERVICE_NAME = "\u5149\u5927\u94f6\u884c\u652f\u4ed8\u5b9d\u5c0f\u7a0b\u5e8f\u4e0b\u5355ability\u670d\u52a1";
    @Autowired
    private GdBankAliMiniProPayCombService gdBankAliMiniProPayCombService;

    public GdBankAliMiniProPayAbilityRspBo dealGdBankAliMiniProgram(GdBankAliMiniProPayAbilityReqBo reqBo) {
        LoggerProUtils.debug(LOG, "\u5149\u5927\u94f6\u884c\u652f\u4ed8\u5b9d\u5c0f\u7a0b\u5e8f\u4e0b\u5355ability\u670d\u52a1 -> \u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        this.validateArg(reqBo);
        GdBankAliMiniProPayAbilityRspBo retBo = new GdBankAliMiniProPayAbilityRspBo();
        GdBankAliMiniProPayCombReqBo combReq = new GdBankAliMiniProPayCombReqBo();
        BeanUtils.copyProperties((Object)reqBo, (Object)combReq);
        combReq.setGoodsDetail(reqBo.getGoodsDetail());
        GdBankAliMiniProPayCombRspBo gdAliPayRspBo = this.gdBankAliMiniProPayCombService.dealGdBankAliMiniProgram(combReq);
        if (gdAliPayRspBo == null) {
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u5149\u5927\u94f6\u884c\u652f\u4ed8\u5b9d\u5c0f\u7a0b\u5e8f\u4e0b\u5355ability\u670d\u52a1 :\u8c03\u7528\u9884\u8ba2\u5355\u7ec4\u5408\u670d\u52a1\u8fd4\u56de\u4e3a\u7a7a\u5bf9\u8c61");
        }
        BeanUtils.copyProperties((Object)gdAliPayRspBo, (Object)retBo);
        return retBo;
    }

    private String validateArg(GdBankAliMiniProPayAbilityReqBo reqBo) {
        String errMsg = "TRUE";
        if (reqBo == null) {
            errMsg = "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a";
            return errMsg;
        }
        if (StringUtils.isEmpty((Object)reqBo.getBusiId())) {
            errMsg = "\u5165\u53c2\u3010busiId\u3011 \u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getOutOrderId())) {
            errMsg = "\u5165\u53c2\u3010outOrderId\u3011 \u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (reqBo.getOutOrderId() != null && reqBo.getOutOrderId().length() > 32) {
            errMsg = "\u5165\u53c2\u3010outOrderId\u3011 \u957f\u5ea6\u8d85\u957f\u5566";
        }
        if (!reqBo.getRedirectUrl().startsWith("http://") && !reqBo.getRedirectUrl().startsWith("https://")) {
            errMsg = "redirect_url \u8df3\u8f6c\u5730\u5740\u4e0d\u5408\u6cd5";
        }
        if (StringUtils.isEmpty((Object)reqBo.getNotifyUrl())) {
            errMsg = "\u5165\u53c2\u3010notifyUrl\u3011 \u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (!(reqBo.getNotifyUrl().startsWith("http://") || reqBo.getNotifyUrl().startsWith("https://") || reqBo.getNotifyUrl().equals("MQ"))) {
            errMsg = "notify_url \u56de\u8c03\u5730\u5740\u4e0d\u5408\u6cd5";
        }
        if (StringUtils.isEmpty((Object)reqBo.getDetailName())) {
            errMsg = "\u5165\u53c2\u3010detailName\u3011 \u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getOrderType()) || !"01".equals(reqBo.getOrderType())) {
            errMsg = "\u5165\u53c2\u3010orderType\u3011 \u4e0d\u6b63\u786e";
        }
        if (StringUtils.isEmpty((Object)reqBo.getTotalFee())) {
            errMsg = "\u5165\u53c2\u3010totalFee\u3011 \u4e0d\u80fd\u4e3a\u7a7a";
            return errMsg;
        }
        if (StringUtils.isEmpty((Object)reqBo.getCreateOperId())) {
            errMsg = "\u5165\u53c2\u3010createOperId\u3011 \u4e0d\u80fd\u4e3a\u7a7a";
        }
        try {
            int a = Integer.valueOf(reqBo.getTotalFee());
            if (new BigDecimal(reqBo.getTotalFee()).compareTo(new BigDecimal("0")) < 0) {
                errMsg = "\u5165\u53c2\u3010totalFee\u3011 \u91d1\u989d\u5fc5\u987b\u5927\u4e8e0";
            }
        }
        catch (Exception e) {
            errMsg = "\u8bf7\u4f20\u5165\u6709\u6548\u3010totalFee\u3011 \u6570\u636e";
            LOG.info("\u8bf7\u4f20\u5165\u6709\u6548\u3010totalFee\u3011 \u6570\u636e\uff1a" + e.getMessage());
        }
        if (!(!StringUtils.isEmpty((Object)reqBo.getReqWay()) && ("2".equals(reqBo.getReqWay()) || "3".equals(reqBo.getReqWay()) || "4".equals(reqBo.getReqWay()) || "6".equals(reqBo.getReqWay()) || "1".equals(reqBo.getReqWay()) || "5".equals(reqBo.getReqWay())))) {
            errMsg = "\u8bf7\u4f20\u5165\u6709\u6548\u7684\u3010reqWay\u3011\u6570\u636e";
        }
        if (reqBo.getGoodsDetail() != null && reqBo.getGoodsDetail().size() > 0) {
            for (GoodsDetail goods : reqBo.getGoodsDetail()) {
                if (StringUtils.isEmpty((Object)goods.getGoodsId())) {
                    errMsg = "\u3010goodsId \u3011 \u5546\u54c1ID\u4e3a\u5fc5\u4f20\u5b57\u6bb5";
                    break;
                }
                if (StringUtils.isEmpty((Object)goods.getGoodsNum()) || "0".equals(goods.getGoodsNum())) {
                    errMsg = "\u3010goodsNum \u3011 \u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a";
                    break;
                }
                if (!StringUtils.isEmpty((Object)goods.getGoodsNum())) {
                    try {
                        int n = Integer.valueOf(goods.getGoodsNum());
                    }
                    catch (Exception e) {
                        errMsg = "\u8bf7\u786e\u8ba4 \u3010goodsNum\u3011 \u5546\u54c1\u6570\u91cf";
                    }
                }
                if (StringUtils.isEmpty((Object)goods.getGoodsName())) {
                    errMsg = "\u3010goodsName \u3011\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a";
                    break;
                }
                if (StringUtils.isEmpty((Object)goods.getGoodsPrice()) || "0".equals(goods.getGoodsNum())) {
                    errMsg = "\u3010goodsPrice \u3011 \u5546\u54c1\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a";
                    break;
                }
                if (StringUtils.isEmpty((Object)goods.getGoodsPrice())) continue;
                try {
                    BigDecimal price = new BigDecimal(goods.getGoodsPrice());
                    if (price.compareTo(new BigDecimal(0)) > 0) continue;
                    errMsg = "\u3010goodsPrice \u3011 \u8bf7\u786e\u8ba4\u5546\u54c1\u4ef7\u683c";
                }
                catch (Exception e) {
                    errMsg = "\u3010goodsPrice \u3011 \u8bf7\u786e\u8ba4\u5546\u54c1\u4ef7\u683c";
                }
                break;
            }
        }
        return errMsg;
    }
}

