/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.payment.pay.ability.PayProRefundAbilityService;
import com.tydic.payment.pay.ability.PayProRefundEncryptAbilityService;
import com.tydic.payment.pay.ability.bo.PayProRefundAbilityReqBo;
import com.tydic.payment.pay.ability.bo.PayProRefundAbilityRspBo;
import com.tydic.payment.pay.ability.bo.PayProRefundEncryptAbilityReqBo;
import com.tydic.payment.pay.ability.bo.PayProRefundEncryptAbilityRspBo;
import com.tydic.payment.pay.busi.DataEncryptionService;
import com.tydic.payment.pay.busi.DataValidationService;
import com.tydic.payment.pay.busi.PayProQueryInfoBusiSystemByConditionService;
import com.tydic.payment.pay.busi.bo.DataEncryptionReqBo;
import com.tydic.payment.pay.busi.bo.DataEncryptionRspBo;
import com.tydic.payment.pay.busi.bo.DataValidationReqBO;
import com.tydic.payment.pay.busi.bo.DataValidationRspBO;
import com.tydic.payment.pay.busi.bo.PayProQueryInfoBusiSystemByConditionBusiInfoRspBo;
import com.tydic.payment.pay.common.util.MapUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
@HSFProvider(serviceVersion="2.0-SNAPSHOT", serviceGroup="PAY_GROUP_LOCAL", serviceInterface=PayProRefundEncryptAbilityService.class)
public class PayProRefundEncryptAbilityServiceImpl
implements PayProRefundEncryptAbilityService {
    private static final Logger LOG = LoggerFactory.getLogger(PayProRefundEncryptAbilityServiceImpl.class);
    private static final String SERVICE_NAME = "\u4ea7\u54c1\u52a0\u5bc6\u9000\u6b3eability\u670d\u52a1";
    @Autowired
    private PayProRefundAbilityService payProRefundAbilityService;
    @Autowired
    private PayProQueryInfoBusiSystemByConditionService queryInfoBusiSystemByConditionService;
    @Autowired
    private DataValidationService dataValidationService;
    @Autowired
    private DataEncryptionService dataEncryptionService;

    public PayProRefundEncryptAbilityRspBo dealRefund(PayProRefundEncryptAbilityReqBo reqBo) {
        PayProRefundAbilityReqBo orderBo;
        DataValidationRspBO dataValidationRspBO;
        if (LOG.isDebugEnabled()) {
            LOG.debug("\u4ea7\u54c1\u52a0\u5bc6\u9000\u6b3eability\u670d\u52a1 -> \u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        }
        PayProRefundEncryptAbilityRspBo retBo = new PayProRefundEncryptAbilityRspBo();
        String validateArgStr = this.validateArg(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            retBo.setRespCode("4013");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return retBo;
        }
        String busiCode = reqBo.getBusiCode();
        PayProQueryInfoBusiSystemByConditionBusiInfoRspBo busiCodeRspBo = this.queryInfoBusiSystemByConditionService.queryBusiSysByBusiCode(busiCode);
        if (!"0000".equals(busiCodeRspBo.getRespCode())) {
            retBo.setRespCode("4013");
            retBo.setRespDesc("\u67e5\u8be2\u4e1a\u52a1\u7cfb\u7edf\u5931\u8d25:" + busiCodeRspBo.getRespDesc());
            return retBo;
        }
        if (!"1".equals(busiCodeRspBo.getState())) {
            retBo.setRespCode("4013");
            retBo.setRespDesc("\u8be5\u4e1a\u52a1\u7cfb\u7edf(" + busiCode + ")\u5df2\u5931\u6548");
            return retBo;
        }
        DataValidationReqBO dataValidationReqBO = new DataValidationReqBO();
        dataValidationReqBO.setBusiId(busiCodeRspBo.getBusiId() + "");
        dataValidationReqBO.setContent(reqBo.getContent());
        try {
            dataValidationRspBO = this.dataValidationService.validation(dataValidationReqBO);
        }
        catch (Exception e) {
            LOG.error("\u4ea7\u54c1\u52a0\u5bc6\u9000\u6b3eability\u670d\u52a1 -> \u89e3\u5bc6\u5f02\u5e38\uff1a" + e);
            retBo.setRespCode("4013");
            retBo.setRespDesc("\u89e3\u5bc6\u5f02\u5e38\uff1a" + e.getMessage());
            return retBo;
        }
        if (!"0000".equals(dataValidationRspBO.getRspCode())) {
            LOG.error("\u4ea7\u54c1\u52a0\u5bc6\u9000\u6b3eability\u670d\u52a1 -> \u89e3\u5bc6\u5931\u8d25:" + JSON.toJSONString((Object)dataValidationRspBO));
            retBo.setRespCode("4013");
            retBo.setRespDesc(dataValidationRspBO.getRspName());
            return retBo;
        }
        if (!dataValidationRspBO.isSign()) {
            retBo.setRespCode("4013");
            retBo.setRespDesc("\u9a8c\u8bc1\u7b7e\u540d\u4e0d\u901a\u8fc7");
            return retBo;
        }
        try {
            orderBo = (PayProRefundAbilityReqBo)MapUtils.mapToObject((Map)dataValidationRspBO.getContentMap(), PayProRefundAbilityReqBo.class);
            orderBo.setBusiCode(reqBo.getBusiCode());
        }
        catch (Exception e) {
            retBo.setRespCode("4013");
            retBo.setRespDesc("\u4ea7\u54c1\u52a0\u5bc6\u9000\u6b3eability\u670d\u52a1 -> \u89e3\u5bc6\u540e\u8f6c\u6362\u5bf9\u8c61\u5f02\u5e38\uff1a" + e);
            return retBo;
        }
        PayProRefundAbilityRspBo payProRefundAbilityRspBo = this.payProRefundAbilityService.dealRefund(orderBo);
        if (!"0000".equals(payProRefundAbilityRspBo.getRespCode())) {
            retBo.setRespCode("4013");
            retBo.setRespDesc(payProRefundAbilityRspBo.getRespDesc());
            return retBo;
        }
        DataEncryptionReqBo dataEncryptionReqBo = new DataEncryptionReqBo();
        JSONObject content = JSONObject.parseObject((String)JSONObject.toJSONString((Object)payProRefundAbilityRspBo));
        content.remove((Object)"respCode");
        content.remove((Object)"respDesc");
        dataEncryptionReqBo.setBusiId(busiCodeRspBo.getBusiId() + "");
        dataEncryptionReqBo.setContent(content.toString());
        DataEncryptionRspBo dataEncryptionRspBo = this.dataEncryptionService.dataEncryption(dataEncryptionReqBo);
        if (!"0000".equals(dataEncryptionRspBo.getRspCode())) {
            retBo.setRespCode("4013");
            retBo.setRespDesc("\u4ea7\u54c1\u52a0\u5bc6\u9000\u6b3eability\u670d\u52a1 -> RSA\u52a0\u5bc6\u5f02\u5e38\uff1a" + dataEncryptionRspBo.getRspName());
            return retBo;
        }
        retBo.setBusiCode(reqBo.getBusiCode());
        retBo.setContent(dataEncryptionRspBo.getEncrypData());
        retBo.setRespDesc(payProRefundAbilityRspBo.getRespDesc());
        retBo.setRespCode("0000");
        return retBo;
    }

    private String validateArg(PayProRefundEncryptAbilityReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getBusiCode())) {
            return "busiCode\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getContent())) {
            return "content\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

