/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.payment.pay.ability.QueryPayParametersAbilityService;
import com.tydic.payment.pay.ability.bo.QueryPayParametersAbilityReqBO;
import com.tydic.payment.pay.ability.bo.QueryPayParametersAbilityRspBO;
import com.tydic.payment.pay.bo.PayParaInfoAttrBo;
import com.tydic.payment.pay.busi.PayOrderBusiService;
import com.tydic.payment.pay.busi.QueryCashierInfoPayParaAttrService;
import com.tydic.payment.pay.busi.bo.PayOrderRspBo;
import com.tydic.payment.pay.busi.bo.QueryCashierInfoPayParaAttrReqBo;
import com.tydic.payment.pay.busi.bo.QueryCashierInfoPayParaAttrRspBo;
import com.tydic.payment.pay.exception.BusinessException;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="queryPayParametersAbilityService")
@HSFProvider(serviceVersion="2.0-SNAPSHOT", serviceGroup="PAY_GROUP_LOCAL", serviceInterface=QueryPayParametersAbilityService.class)
public class QueryPayParametersAbilityServiceImpl
implements QueryPayParametersAbilityService {
    @Autowired
    private PayOrderBusiService payOrderBusiService;
    @Autowired
    private QueryCashierInfoPayParaAttrService queryCashierInfoPayParaAttrService;

    public QueryPayParametersAbilityRspBO queryPayParameters(QueryPayParametersAbilityReqBO req) {
        this.checkInputParas(req);
        if (StringUtils.isEmpty((Object)req.getMerchantId())) {
            PayOrderRspBo orderInfo = this.payOrderBusiService.selectOrderByOrderId(Long.valueOf(req.getOrderId()));
            if (!"0000".equals(orderInfo.getRspCode())) {
                throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u83b7\u53d6\u652f\u4ed8\u53c2\u6570\u6839\u636e\u8ba2\u5355id\u3010ORDER_ID=" + req.getOrderId() + "\u3011\u67e5\u8be2\u4e0d\u5230\u8ba2\u5355\u4fe1\u606f\uff01");
            }
            if (StringUtils.isEmpty((Object)orderInfo.getMerchantId())) {
                throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u83b7\u53d6\u652f\u4ed8\u53c2\u6570\u6839\u636e\u8ba2\u5355id\u3010ORDER_ID=" + req.getOrderId() + "\u3011\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f\u4e2d\u65e0\u5546\u6237\u53f7\uff01");
            }
            req.setMerchantId(String.valueOf(orderInfo.getMerchantId()));
        }
        QueryCashierInfoPayParaAttrReqBo paraReq = new QueryCashierInfoPayParaAttrReqBo();
        paraReq.setMerchantId(req.getMerchantId());
        paraReq.setPayMethod(req.getPayMethod());
        QueryCashierInfoPayParaAttrRspBo paraInfo = this.queryCashierInfoPayParaAttrService.queryPayParaAttr(paraReq);
        if (paraInfo == null || !"0000".equals(paraInfo.getRspCode())) {
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u83b7\u53d6\u652f\u4ed8\u53c2\u6570\u6839\u636e\u5546\u6237\u53f7\u3010" + req.getMerchantId() + "\u3011\u67e5\u8be2\u652f\u4ed8\u53c2\u6570\u914d\u7f6e\u5931\u8d25\uff01");
        }
        if (paraInfo.getInfoPayParaAttrList() == null || paraInfo.getInfoPayParaAttrList().size() < 1) {
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u83b7\u53d6\u652f\u4ed8\u53c2\u6570\u6839\u636e\u5546\u6237\u53f7\u3010" + req.getMerchantId() + "\u3011\u67e5\u8be2\u65e0\u652f\u4ed8\u53c2\u6570\u914d\u7f6e\uff01");
        }
        HashMap<String, String> payParameters = new HashMap<String, String>();
        for (PayParaInfoAttrBo para : paraInfo.getInfoPayParaAttrList()) {
            payParameters.put(para.getAttrCode(), para.getAttrValue());
        }
        QueryPayParametersAbilityRspBO rsp = new QueryPayParametersAbilityRspBO();
        rsp.setRspCode("0000");
        rsp.setRspName("\u67e5\u8be2\u652f\u4ed8\u53c2\u6570\u6210\u529f");
        rsp.setPayParameters(payParameters);
        return rsp;
    }

    private void checkInputParas(QueryPayParametersAbilityReqBO req) {
        if (req == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5fae\u4fe1\u516c\u4f17\u53f7\u652f\u4ed8\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getOrderId()) && StringUtils.isEmpty((Object)req.getMerchantId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u83b7\u53d6\u652f\u4ed8\u53c2\u6570\u5165\u53c2\u3010orderId\u3011\u3001\u3010merchantId\u3011\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getPayMethod())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u83b7\u53d6\u652f\u4ed8\u53c2\u6570\u5165\u53c2\u3010payMethod\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

