/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.tydic.payment.pay.LoggerProUtils;
import com.tydic.payment.pay.atom.BusiSystemInfoAtomService;
import com.tydic.payment.pay.atom.BusiSystemMerchantRelAtomService;
import com.tydic.payment.pay.atom.MerchantInfoAtomService;
import com.tydic.payment.pay.atom.MerchantPayMethodRelAtomService;
import com.tydic.payment.pay.atom.PayInfoFileMappingAtomService;
import com.tydic.payment.pay.atom.PayParaInfoAtomService;
import com.tydic.payment.pay.atom.PayParaInfoAttrAtomService;
import com.tydic.payment.pay.atom.RelBusiCashierAtomService;
import com.tydic.payment.pay.busi.AddInfoMerchantBusiService;
import com.tydic.payment.pay.busi.BusiPaymentMerchantCreateBusiService;
import com.tydic.payment.pay.busi.QueryDBDateBusiService;
import com.tydic.payment.pay.busi.QueryRulePayParaService;
import com.tydic.payment.pay.busi.ValidatePaymentInsBusiService;
import com.tydic.payment.pay.busi.bo.AddInfoMerchantPayMethodBo;
import com.tydic.payment.pay.busi.bo.AddInfoMerchantPayParaAttrBo;
import com.tydic.payment.pay.busi.bo.AddInfoMerchantPaymentInsBo;
import com.tydic.payment.pay.busi.bo.AddInfoMerchantReqBo;
import com.tydic.payment.pay.busi.bo.AddInfoMerchantRspBo;
import com.tydic.payment.pay.busi.bo.QueryRulePayParaListRspBo;
import com.tydic.payment.pay.busi.bo.QueryRulePayParaReqBo;
import com.tydic.payment.pay.busi.bo.QueryRulePayParaRspBo;
import com.tydic.payment.pay.busi.bo.ValidatePaymentInsReqBo;
import com.tydic.payment.pay.busi.bo.ValidatePaymentInsRspBo;
import com.tydic.payment.pay.constant.PayConfigConstants;
import com.tydic.payment.pay.dao.BusiCashierRelMapper;
import com.tydic.payment.pay.dao.po.BusiCashierRelPo;
import com.tydic.payment.pay.dao.po.BusiSystemInfoPO;
import com.tydic.payment.pay.dao.po.BusiSystemMerchantRelPo;
import com.tydic.payment.pay.dao.po.MerChantInfoPo;
import com.tydic.payment.pay.dao.po.MerchantPayMethodRelPo;
import com.tydic.payment.pay.dao.po.PayInfoFileMappingPO;
import com.tydic.payment.pay.dao.po.PayParaInfoAttrPo;
import com.tydic.payment.pay.dao.po.PayParaInfoPo;
import com.tydic.payment.pay.dao.po.RelBusiCashierPo;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.util.RelBusiMerchantPayMerchantUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="addInfoMerchantBusiService")
@HSFProvider(serviceVersion="2.0-SNAPSHOT", serviceGroup="PAY_GROUP_LOCAL", serviceInterface=AddInfoMerchantBusiService.class)
public class AddInfoMerchantBusiServiceImpl
implements AddInfoMerchantBusiService {
    private static final Logger LOG = LoggerFactory.getLogger(AddInfoMerchantBusiServiceImpl.class);
    private static final String SERVICE_NAME = "\u5546\u6237\u65b0\u589ebusi\u670d\u52a1";
    @Autowired
    private BusiSystemInfoAtomService busiSystemInfoAtomService;
    @Autowired
    private MerchantInfoAtomService merchantInfoAtomService;
    @Autowired
    private BusiSystemMerchantRelAtomService busiSystemMerchantRelAtomService;
    @Autowired
    private PayParaInfoAtomService payParaInfoAtomService;
    @Autowired
    private MerchantPayMethodRelAtomService merchantPayMethodRelAtomService;
    @Autowired
    private PayParaInfoAttrAtomService payParaInfoAttrAtomService;
    @Autowired
    private RelBusiCashierAtomService relBusiCashierAtomService;
    @Autowired
    private ValidatePaymentInsBusiService validatePaymentInsBusiService;
    @Autowired
    private BusiCashierRelMapper busiCashierRelMapper;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;
    @Autowired
    private PayInfoFileMappingAtomService payInfoFileMappingAtomService;
    @Autowired
    private QueryRulePayParaService queryRulePayParaService;
    @Autowired
    private BusiPaymentMerchantCreateBusiService busiPaymentMerchantCreateBusiService;

    public AddInfoMerchantRspBo addInfoMerchant(AddInfoMerchantReqBo bo) {
        LoggerProUtils.debug(LOG, "\u5546\u6237\u65b0\u589ebusi\u670d\u52a1 -> \u5165\u53c2\uff1a" + JSON.toJSONString((Object)bo));
        Date dbDate = this.queryDBDateBusiService.getDBDate();
        AddInfoMerchantRspBo retBo = new AddInfoMerchantRspBo();
        MerChantInfoPo createMerPo = new MerChantInfoPo();
        BeanUtils.copyProperties((Object)bo, (Object)createMerPo);
        createMerPo.setCreateTime(dbDate);
        createMerPo.setMerchantType(PayConfigConstants.MERCHANT_TYPE_FATHER);
        Long createMerChantInfo = this.merchantInfoAtomService.createMerChantInfo(createMerPo);
        List infoBusiList = bo.getInfoBusiList();
        for (Object busiBo : infoBusiList) {
            String busiId = busiBo.getBusiId();
            BusiSystemInfoPO busiPo = new BusiSystemInfoPO();
            busiPo.setBusiId(Long.valueOf(busiId));
            List<BusiSystemInfoPO> queryBusiSystemInfoByCondition = this.busiSystemInfoAtomService.queryBusiSystemInfoByCondition(busiPo);
            if (queryBusiSystemInfoByCondition.isEmpty()) {
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u65b0\u589e\u5546\u6237\u5931\u8d25\uff1a\u4e1a\u52a1\u7cfb\u7edf " + busiId + " \u4e0d\u5b58\u5728");
            }
            List reqWayList = busiBo.getReqWayList();
            if (reqWayList != null && !reqWayList.isEmpty()) {
                BusiCashierRelPo busiCPo = new BusiCashierRelPo();
                busiCPo.setBusiId(Long.valueOf(busiId));
                List<BusiCashierRelPo> queryBusiCashierRelByCondition = this.busiCashierRelMapper.queryBusiCashierRelByCondition(busiCPo);
                HashSet busiReqSet = new HashSet();
                for (BusiCashierRelPo bpo : queryBusiCashierRelByCondition) {
                    busiReqSet.add(bpo.getReqWay());
                }
                for (String reqStr : reqWayList) {
                    if (!busiReqSet.contains(reqStr)) {
                        throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u4e1a\u52a1\u7cfb\u7edf" + busiId + "\u65e0\u6b64\u63a5\u5165\u65b9\u5f0f\uff1a" + reqStr);
                    }
                    BusiSystemMerchantRelPo busiMerRelPo = new BusiSystemMerchantRelPo();
                    busiMerRelPo.setBusiId(Long.valueOf(busiId));
                    busiMerRelPo.setMerchantId(createMerChantInfo);
                    busiMerRelPo.setUpdateTime(dbDate);
                    busiMerRelPo.setReqWay(reqStr);
                    this.busiSystemMerchantRelAtomService.createBusiSystemMerchantRel(busiMerRelPo);
                }
                continue;
            }
            RelBusiCashierPo qryBCRelPo = new RelBusiCashierPo();
            qryBCRelPo.setBusiId(Long.valueOf(busiId));
            List<RelBusiCashierPo> queryRelBusiCashier = this.relBusiCashierAtomService.queryRelBusiCashier(qryBCRelPo);
            if (queryRelBusiCashier.isEmpty()) {
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u4e1a\u52a1\u7cfb\u7edf" + busiId + "\u6ca1\u6709\u4e00\u4e2a\u63a5\u5165\u65b9\u5f0f");
            }
            for (RelBusiCashierPo bpo : queryRelBusiCashier) {
                BusiSystemMerchantRelPo busiMerRelPo = new BusiSystemMerchantRelPo();
                busiMerRelPo.setBusiId(Long.valueOf(busiId));
                busiMerRelPo.setMerchantId(createMerChantInfo);
                busiMerRelPo.setReqWay(bpo.getReqWay());
                busiMerRelPo.setUpdateTime(dbDate);
                this.busiSystemMerchantRelAtomService.createBusiSystemMerchantRel(busiMerRelPo);
            }
        }
        List infoPaymentInsList2 = bo.getInfoPaymentInsList();
        for (AddInfoMerchantPaymentInsBo pbo : infoPaymentInsList2) {
            Object tmpo2;
            String paymentInsId = pbo.getPaymentInsId();
            ValidatePaymentInsReqBo validateBo = new ValidatePaymentInsReqBo();
            validateBo.setPaymentInsId(Long.valueOf(paymentInsId));
            ArrayList<Long> payMethodList = new ArrayList<Long>();
            for (Object tmpo2 : pbo.getPayMethodList()) {
                payMethodList.add(Long.valueOf(tmpo2.getPayMethod()));
            }
            validateBo.setPayMethodList(payMethodList);
            ArrayList<String> payParaList = new ArrayList<String>();
            validateBo.setPayParaList(payParaList);
            tmpo2 = pbo.getRulePayParaList().iterator();
            while (tmpo2.hasNext()) {
                AddInfoMerchantPayParaAttrBo tmbo = (AddInfoMerchantPayParaAttrBo)tmpo2.next();
                payParaList.add(tmbo.getAttrCode());
            }
            ValidatePaymentInsRspBo validatePaymentIns = this.validatePaymentInsBusiService.validatePaymentIns(validateBo);
            if ("0000".equals(validatePaymentIns.getRspCode())) continue;
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", validatePaymentIns.getRspName());
        }
        List infoPaymentInsList = bo.getInfoPaymentInsList();
        this.writeAttrAndMethod(infoPaymentInsList, createMerChantInfo, dbDate);
        retBo.setRspCode("0000");
        retBo.setRspName("\u65b0\u589e\u5546\u6237\u6210\u529f");
        retBo.setMerchantId(createMerChantInfo + "");
        LoggerProUtils.debug(LOG, "\u5546\u6237\u65b0\u589ebusi\u670d\u52a1 -> \u51fa\u53c2\uff1a" + JSON.toJSONString((Object)retBo));
        return retBo;
    }

    private void writeAttrAndMethod(List<AddInfoMerchantPaymentInsBo> infoPaymentInsList, Long merchantId, Date dbDate) {
        for (AddInfoMerchantPaymentInsBo bo : infoPaymentInsList) {
            List rulePayParaList = bo.getRulePayParaList();
            List payMethodList = bo.getPayMethodList();
            String paymentInsId = bo.getPaymentInsId();
            PayParaInfoPo payParaPo = new PayParaInfoPo();
            payParaPo.setParaName("\u5546\u6237(" + merchantId + ")\u7684\u652f\u4ed8\u53c2\u6570(" + paymentInsId + ")");
            payParaPo.setPaymentInsId(Long.valueOf(paymentInsId));
            payParaPo.setState("1");
            payParaPo.setCreateTime(dbDate);
            Long createPayParaInfo = this.payParaInfoAtomService.createPayParaInfo(payParaPo);
            QueryRulePayParaReqBo paraReqBo = new QueryRulePayParaReqBo();
            paraReqBo.setPaymentInsId(paymentInsId);
            QueryRulePayParaRspBo paraRspBo = this.queryRulePayParaService.queryRulePayPara(paraReqBo);
            List paraList = paraRspBo.getParaList();
            HashMap<String, QueryRulePayParaListRspBo> rulePayParaMap = new HashMap<String, QueryRulePayParaListRspBo>();
            for (QueryRulePayParaListRspBo temp : paraList) {
                String mapId = temp.getParameterCode();
                rulePayParaMap.put(mapId, temp);
            }
            for (AddInfoMerchantPayParaAttrBo attrBo : rulePayParaList) {
                PayParaInfoAttrPo attrPo = new PayParaInfoAttrPo();
                BeanUtils.copyProperties((Object)attrBo, (Object)attrPo);
                attrPo.setPayParaId(createPayParaInfo);
                attrPo.setCreateTime(dbDate);
                this.payParaInfoAttrAtomService.createPayParaInfoAttr(attrPo);
                boolean relMerchantAndPayMerchant = RelBusiMerchantPayMerchantUtils.createRelMerchantAndPayMerchant(merchantId, Long.valueOf(paymentInsId), attrPo, this.busiPaymentMerchantCreateBusiService);
                if (!relMerchantAndPayMerchant) {
                    throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5546\u6237\u65b0\u589ebusi\u670d\u52a1 -> \u5f02\u5e38\uff1a\u63d2\u5165\u4e1a\u52a1\u5546\u6237-\u652f\u4ed8\u5546\u6237\u5931\u8d25\uff01");
                }
                QueryRulePayParaListRspBo rBo = (QueryRulePayParaListRspBo)rulePayParaMap.get(attrBo.getAttrCode());
                if (!rBo.getStoreType().equals("2")) continue;
                PayInfoFileMappingPO fileMappingPo = new PayInfoFileMappingPO();
                fileMappingPo.setFileId(attrBo.getAttrValue());
                fileMappingPo.setFileName(attrBo.getFilename());
                int AddFileMappingFlag = this.payInfoFileMappingAtomService.addFile(fileMappingPo);
                if (AddFileMappingFlag >= 1) continue;
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5546\u6237\u65b0\u589ebusi\u670d\u52a1 -> \u5f02\u5e38\uff1a\u63d2\u5165\u6587\u4ef6\u5173\u7cfb\u6620\u5c04\u8868\u5931\u8d25\uff01");
            }
            for (AddInfoMerchantPayMethodBo meBo : payMethodList) {
                MerchantPayMethodRelPo mPo = new MerchantPayMethodRelPo();
                mPo.setPaymentInsId(Long.valueOf(paymentInsId));
                mPo.setMerchantId(merchantId);
                mPo.setPayMethod(Long.valueOf(meBo.getPayMethod()));
                mPo.setPayParaId(createPayParaInfo);
                mPo.setCreateTime(dbDate);
                this.merchantPayMethodRelAtomService.createMerchantPayMethodRel(mPo);
            }
        }
    }
}

