/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.druid.util.StringUtils;
import com.tydic.payment.pay.ali.model.AlipayF2FQueryResult;
import com.tydic.payment.pay.ali.model.AlipayTradeQueryRequestBuilder;
import com.tydic.payment.pay.ali.service.impl.AlipayTradeServiceImpl;
import com.tydic.payment.pay.atom.PayOrderAtomService;
import com.tydic.payment.pay.atom.PorderPayTransAtomService;
import com.tydic.payment.pay.atom.bo.PorderPayTransAtomReqBo;
import com.tydic.payment.pay.atom.bo.PorderPayTransAtomRspBo;
import com.tydic.payment.pay.busi.AliPayQueryService;
import com.tydic.payment.pay.busi.CallBackNoticeService;
import com.tydic.payment.pay.busi.QueryDBDateBusiService;
import com.tydic.payment.pay.busi.bo.AliPayQueryReqBo;
import com.tydic.payment.pay.busi.bo.AliPayQueryRspBo;
import com.tydic.payment.pay.busi.bo.CallBackNoticeReqBo;
import com.tydic.payment.pay.busi.bo.CallBackNoticeRspBo;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.dao.po.PorderPo;
import com.tydic.payment.pay.exception.BusinessException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="aliPayQueryService")
@HSFProvider(serviceVersion="2.0-SNAPSHOT", serviceGroup="PAY_GROUP_LOCAL", serviceInterface=AliPayQueryService.class)
public class AliPayQueryServiceImpl
implements AliPayQueryService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AliPayQueryServiceImpl.class);
    @Autowired
    private PorderPayTransAtomService porderPayTransAtomService;
    @Autowired
    private PayOrderAtomService payOrderAtomService;
    @Autowired
    private CallBackNoticeService callBackNoticeService;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;

    public AliPayQueryRspBo dealQuery(AliPayQueryReqBo aliPayQueryReqBo) {
        if (aliPayQueryReqBo == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u652f\u4ed8\u7ed3\u679c\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)aliPayQueryReqBo.getPayOrderId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u5165\u53c2 payOrderId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (aliPayQueryReqBo.getOrderId() == 0L) {
            // empty if block
        }
        if (aliPayQueryReqBo.getParamMap() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u5165\u53c2 \u652f\u4ed8\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        AliPayQueryRspBo aliPayQueryRspBo = new AliPayQueryRspBo();
        try {
            AlipayTradeQueryRequestBuilder queryBuiler;
            PorderPayTransAtomReqBo orderPayTransAtomReq = new PorderPayTransAtomReqBo();
            orderPayTransAtomReq.setOrderId(aliPayQueryReqBo.getOrderId());
            orderPayTransAtomReq.setPayOrderId(aliPayQueryReqBo.getPayOrderId());
            PorderPayTransAtomRspBo orderPayTransAtomRsp = this.porderPayTransAtomService.queryOrderPayTransByPayOrderId(orderPayTransAtomReq);
            if (orderPayTransAtomRsp == null) {
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2\u5fae\u4fe1\u652f\u4ed8\u8ba2\u5355\u4e1a\u52a1\u670d\u3010payOrderId=" + aliPayQueryReqBo.getPayOrderId() + "\u3011\u67e5\u8be2\u4e0d\u5230\u652f\u4ed8\u8bf7\u6c42\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u6d41\u6c34\u662f\u5426\u6b63\u786e\uff01");
            }
            if ("A10".equals(orderPayTransAtomRsp.getOrderStatus())) {
                aliPayQueryRspBo.setPayStatus("SUCCESS");
                aliPayQueryRspBo.setRspCode("0000");
                aliPayQueryRspBo.setRspName("\u652f\u4ed8\u6210\u529f");
                return aliPayQueryRspBo;
            }
            AlipayTradeServiceImpl tradeService = new AlipayTradeServiceImpl.ClientBuilder().build(String.valueOf(aliPayQueryReqBo.getParamMap().get("appid")), String.valueOf(aliPayQueryReqBo.getParamMap().get("privateKey")), String.valueOf(aliPayQueryReqBo.getParamMap().get("publicKey")), "");
            AlipayF2FQueryResult result = tradeService.queryTradeResult(queryBuiler = new AlipayTradeQueryRequestBuilder().setOutTradeNo(aliPayQueryReqBo.getPayOrderId()));
            if (result == null) {
                LOGGER.error("\u652f\u4ed8\u5b9d\u8fd4\u56de\u5bf9\u8c61\u4e3a\u7a7a");
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u652f\u4ed8\u5b9d\u8fd4\u56de\u5bf9\u8c61\u4e3a\u7a7a");
            }
            LOGGER.info("\u652f\u4ed8\u5b9d\u67e5\u8be2\u8fd4\u56de\u4e3a\uff1a " + result.getResponse().getMsg());
            String trade_time = "";
            if ("10000".equals(result.getResponse().getCode())) {
                switch (result.getResponse().getTradeStatus()) {
                    case "TRADE_SUCCESS": {
                        aliPayQueryRspBo.setPayStatus("SUCCESS");
                        trade_time = new SimpleDateFormat("yyyyMMddHHmmss").format(result.getResponse().getSendPayDate());
                        aliPayQueryRspBo.setPayNotifyTransId(result.getResponse().getTradeNo());
                        break;
                    }
                    case "TRADE_FINISHED": {
                        aliPayQueryRspBo.setPayStatus("SUCCESS");
                        aliPayQueryRspBo.setRspName(result.getResponse().getMsg());
                        aliPayQueryRspBo.setMsg(result.getResponse().getMsg());
                        trade_time = new SimpleDateFormat("yyyyMMddHHmmss").format(result.getResponse().getSendPayDate());
                        break;
                    }
                    case "TRADE_CLOSED": {
                        aliPayQueryRspBo.setPayStatus("FAIL");
                        aliPayQueryRspBo.setRspName(result.getResponse().getMsg());
                        aliPayQueryRspBo.setMsg(result.getResponse().getMsg());
                        trade_time = new SimpleDateFormat("yyyyMMddHHmmss").format(result.getResponse().getSendPayDate());
                        break;
                    }
                    case "WAIT_BUYER_PAY": {
                        aliPayQueryRspBo.setPayStatus("PAYING");
                        aliPayQueryRspBo.setRspName("\u7b49\u5f85\u652f\u4ed8");
                        break;
                    }
                    default: {
                        aliPayQueryRspBo.setPayStatus("FAIL");
                        aliPayQueryRspBo.setRspName("\u672a\u77e5\u5f02\u5e38");
                        Date dbDate = this.queryDBDateBusiService.getDBDate();
                        trade_time = new SimpleDateFormat("yyyyMMddHHmmss").format(dbDate);
                    }
                }
                aliPayQueryRspBo.setTradeTime(trade_time);
                aliPayQueryRspBo.setRspName("\u67e5\u8be2\u6210\u529f");
            } else if ("40004".equals(result.getResponse().getCode()) && "ACQ.TRADE_NOT_EXIST".equals(result.getResponse().getSubCode())) {
                aliPayQueryRspBo.setPayStatus("PAYING");
                aliPayQueryRspBo.setRspName("\u7b49\u5f85\u652f\u4ed8");
            } else {
                aliPayQueryRspBo.setPayStatus("FAIL");
                aliPayQueryRspBo.setRspName(result.getResponse().getMsg());
                aliPayQueryRspBo.setMsg(result.getResponse().getMsg());
            }
            BeanUtils.copyProperties((Object)orderPayTransAtomReq, (Object)orderPayTransAtomRsp);
            if ("FAIL".equals(aliPayQueryRspBo.getPayStatus())) {
                orderPayTransAtomReq.setOrderStatus("A20");
                orderPayTransAtomReq.setPayMsg(result.getResponse().getMsg());
            }
            if ("SUCCESS".equals(aliPayQueryRspBo.getPayStatus())) {
                orderPayTransAtomReq.setOrderStatus("A10");
                orderPayTransAtomReq.setPayNotifyTransId(result.getResponse().getTradeNo());
                orderPayTransAtomReq.setTradeTime(trade_time);
            }
            if (!"PAYING".equals(aliPayQueryRspBo.getPayStatus())) {
                orderPayTransAtomReq.setTradeTime(aliPayQueryRspBo.getTradeTime());
                this.porderPayTransAtomService.updateOrderPayTransByPayOrderId(orderPayTransAtomReq);
                PorderPo updateOrderPo = this.payOrderAtomService.queryPorderInfo(orderPayTransAtomReq.getOrderId());
                updateOrderPo.setOrderId(orderPayTransAtomReq.getOrderId());
                updateOrderPo.setOrderStatus(orderPayTransAtomReq.getOrderStatus());
                if (!StringUtils.isEmpty((String)result.getResponse().getTotalAmount())) {
                    updateOrderPo.setOnlineFee(MoneyUtils.yuanToHaoToLong((BigDecimal)new BigDecimal(result.getResponse().getTotalAmount())));
                    updateOrderPo.setRealFee(MoneyUtils.yuanToHaoToLong((BigDecimal)new BigDecimal(result.getResponse().getTotalAmount())));
                }
                updateOrderPo.setPayNotifyCode("0");
                updateOrderPo.setPayNotifyTime(this.queryDBDateBusiService.getDBDate());
                updateOrderPo.setTradeTime(aliPayQueryRspBo.getTradeTime());
                this.payOrderAtomService.update(updateOrderPo);
                CallBackNoticeReqBo callBackNoticeReqBo = new CallBackNoticeReqBo();
                callBackNoticeReqBo.setOrderId(orderPayTransAtomReq.getOrderId());
                CallBackNoticeRspBo callBackNoticeRspBo = this.callBackNoticeService.dealPayPutMq(callBackNoticeReqBo);
                if ("0000".equals(callBackNoticeRspBo.getRspCode())) {
                    LOGGER.info(orderPayTransAtomReq.getOrderId() + "\u53d1\u9001\u6d88\u606f\u961f\u5217\u6210\u529f");
                }
            }
            LOGGER.info("\u652f\u4ed8\u67e5\u8be2\u7ed3\u679c\u4e3a\uff1a" + aliPayQueryRspBo.getPayStatus());
            aliPayQueryRspBo.setRspCode("0000");
            aliPayQueryRspBo.setPayOrderId(aliPayQueryReqBo.getPayOrderId());
        }
        catch (Exception e) {
            LOGGER.error("\u652f\u4ed8\u5b9d\u67e5\u8be2\u5f02\u5e38" + e.getMessage(), (Throwable)e);
            aliPayQueryRspBo.setRspCode("8888");
            aliPayQueryRspBo.setRspName("\u652f\u4ed8\u5b9d\u67e5\u8be2\u8c03\u7528\u5f02\u5e38:" + e.getMessage());
        }
        return aliPayQueryRspBo;
    }
}

