/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.payment.pay.atom.AbilityToPayPlatformService;
import com.tydic.payment.pay.atom.PayOrderAtomService;
import com.tydic.payment.pay.atom.PorderPayTransAtomService;
import com.tydic.payment.pay.atom.bo.PorderPayTransAtomReqBo;
import com.tydic.payment.pay.busi.QueryDBDateBusiService;
import com.tydic.payment.pay.busi.WXPayApiBusiService;
import com.tydic.payment.pay.busi.WXUnifiedOrderService;
import com.tydic.payment.pay.busi.bo.WXUnifiedOrderReqBO;
import com.tydic.payment.pay.busi.bo.WXUnifiedOrderRspBO;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.common.util.ParseAbilityResponse;
import com.tydic.payment.pay.common.util.ParseInfo;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.dao.po.PorderPo;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.wx.req.bo.WXApiUnifiedOrderReqBO;
import com.tydic.payment.pay.wx.rsp.bo.WXApiUnifiedOrderRspBO;
import com.tydic.payment.pay.wx.util.Signature;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="wXUnifiedOrderService")
public class WXUnifiedOrderServiceImpl
implements WXUnifiedOrderService {
    private static final Logger LOGGER = LoggerFactory.getLogger(WXUnifiedOrderServiceImpl.class);
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private AbilityToPayPlatformService abilityToPayPlatformService;
    @Autowired
    private PayOrderAtomService payOrderAtomService;
    @Autowired
    private PorderPayTransAtomService porderPayTransAtomService;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;
    @Autowired
    private WXPayApiBusiService wXPayApiBusiService;

    public WXUnifiedOrderRspBO dealUnifiedOrder(WXUnifiedOrderReqBO req) throws Exception {
        LOGGER.info("\u5fae\u4fe1\u7edf\u4e00\u4e0b\u5355\u4e1a\u52a1\u670d\u52a1\uff1a" + req);
        WXUnifiedOrderRspBO rsp = new WXUnifiedOrderRspBO();
        PorderPo orderInfo = this.payOrderAtomService.queryPorderInfo(Long.valueOf(req.getOrderId()));
        if (orderInfo == null) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u7edf\u4e00\u4e0b\u5355\u670d\u52a1\u6839\u636e\u8ba2\u5355id\u3010ORDER_ID=" + req.getOrderId() + "\u3011\u67e5\u8be2\u4e0d\u5230\u8ba2\u5355\u4fe1\u606f\uff01");
        }
        PorderPayTransAtomReqBo orderPayTransAtomReq = new PorderPayTransAtomReqBo();
        orderPayTransAtomReq.setOrderId(orderInfo.getOrderId());
        orderPayTransAtomReq.setBusiId(orderInfo.getBusiId());
        orderPayTransAtomReq.setMerchantId(Long.parseLong(req.getMerchantId()));
        orderPayTransAtomReq.setPayMethod(Long.parseLong(req.getPayMethod()));
        orderPayTransAtomReq.setOrderStatus("A00");
        orderPayTransAtomReq.setPayFee(MoneyUtils.fenToHaoToLong((BigDecimal)req.getTotalFee()));
        String outTradeNo = this.porderPayTransAtomService.createOrderPayTrans(orderPayTransAtomReq);
        Date startTime = this.queryDBDateBusiService.getDBDate();
        int total_Fee = req.getTotalFee().intValue();
        String notifyUrl = "";
        if ("1".equals(this.payPropertiesVo.getAbilitySwitch())) {
            notifyUrl = this.payPropertiesVo.getAbilityPayResultNotifyUrl();
        } else if ("0".equals(this.payPropertiesVo.getAbilitySwitch())) {
            notifyUrl = this.payPropertiesVo.getWxPayResultNotifyUrl();
        }
        String sub_mch_id = req.getSubMchId();
        String spbill_create_ip = orderInfo.getCreateIpAddress();
        String product_id = "";
        String body = orderInfo.getDetailName();
        WXApiUnifiedOrderReqBO unifiedOrderReqData = new WXApiUnifiedOrderReqBO().setAppid(req.getAppId()).setMch_id(req.getMchId()).setDevice_info(req.getDeviceInfo()).setBody(body).setOut_trade_no(outTradeNo).setTotal_fee(total_Fee).setSpbill_create_ip(spbill_create_ip).setProduct_id(product_id).setTrade_type(req.getTradeType()).setOpenid(req.getOpenId()).setNotify_url(notifyUrl).setScene_info(req.getSceneInfo()).setSub_mch_id(sub_mch_id).setTime_start(startTime).setTime_expire(null).setNonce_str("").setKey(req.getKey());
        rsp = "1".equals(this.payPropertiesVo.getAbilitySwitch()) ? this.unifiedOrderByAbility(unifiedOrderReqData) : this.unifiedOrderByWxApi(unifiedOrderReqData);
        rsp.setPayOrderId(outTradeNo);
        Date now = this.queryDBDateBusiService.getDBDate();
        String time_expire = unifiedOrderReqData.getTime_expire();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        Date date_expire = sdf.parse(time_expire);
        long seconds = (date_expire.getTime() - now.getTime()) / 1000L;
        String effectiveSeconds = String.valueOf(seconds);
        rsp.setEffectiveSeconds(effectiveSeconds);
        return rsp;
    }

    private WXUnifiedOrderRspBO unifiedOrderByWxApi(WXApiUnifiedOrderReqBO unifiedOrderReqData) {
        WXApiUnifiedOrderRspBO unifiedOrderResData;
        WXUnifiedOrderRspBO rsp = new WXUnifiedOrderRspBO();
        try {
            unifiedOrderResData = this.wXPayApiBusiService.unifiedOrder(unifiedOrderReqData);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new BusinessException("6004", "\u5fae\u4fe1\u7edf\u4e00\u4e0b\u5355\u5f02\u5e38\uff1a" + e);
        }
        if (unifiedOrderResData == null || unifiedOrderResData.getReturn_code() == null) {
            rsp.setRspCode("0000");
            rsp.setRspName("\u5fae\u4fe1\u7edf\u4e00\u4e0b\u5355\u83b7\u53d6\u4e0d\u5230\u8fd4\u56de\u4fe1\u606f");
            return rsp;
        }
        if (!"SUCCESS".equals(unifiedOrderResData.getReturn_code())) {
            rsp.setRspCode("8888");
            rsp.setRspName(unifiedOrderResData.getErr_code_des());
            return rsp;
        }
        if (!"SUCCESS".equals(unifiedOrderResData.getResult_code())) {
            rsp.setRspCode("8888");
            rsp.setRspName(unifiedOrderResData.getErr_code_des());
            return rsp;
        }
        rsp.setRspCode("0000");
        rsp.setRspName("\u6210\u529f");
        rsp.setCodeUrl(unifiedOrderResData.getCode_url());
        rsp.setMwebUrl(unifiedOrderResData.getMweb_url());
        rsp.setPrepayId(unifiedOrderResData.getPrepay_id());
        return rsp;
    }

    private WXUnifiedOrderRspBO unifiedOrderByAbility(WXApiUnifiedOrderReqBO unifiedOrderReqData) {
        WXUnifiedOrderRspBO rsp = new WXUnifiedOrderRspBO();
        try {
            JSONObject body = new JSONObject();
            JSONObject bodyInfo = new JSONObject();
            bodyInfo.put("APP_ID", (Object)unifiedOrderReqData.getAppid());
            bodyInfo.put("MCH_ID", (Object)unifiedOrderReqData.getMch_id());
            bodyInfo.put("SUB_MCH_ID", (Object)unifiedOrderReqData.getSub_mch_id());
            bodyInfo.put("DEVICE_INFO", (Object)unifiedOrderReqData.getDevice_info());
            bodyInfo.put("NONCE_STR", (Object)unifiedOrderReqData.getNonce_str());
            bodyInfo.put("SIGN", (Object)unifiedOrderReqData.getSign());
            bodyInfo.put("BODY", (Object)unifiedOrderReqData.getBody());
            bodyInfo.put("ATTACH", (Object)"");
            bodyInfo.put("OUT_TRADE_NO", (Object)unifiedOrderReqData.getOut_trade_no());
            bodyInfo.put("FEE_TYPE", (Object)"");
            bodyInfo.put("TOTAL_FEE", (Object)String.valueOf(unifiedOrderReqData.getTotal_fee()));
            bodyInfo.put("SPBILL_CREATE_IP", (Object)unifiedOrderReqData.getSpbill_create_ip());
            bodyInfo.put("TIME_START", (Object)unifiedOrderReqData.getTime_start());
            bodyInfo.put("TIME_EXPIRE", (Object)unifiedOrderReqData.getTime_expire());
            bodyInfo.put("GOODS_TAG", (Object)"");
            bodyInfo.put("NOTIFY_URL", (Object)unifiedOrderReqData.getNotify_url());
            bodyInfo.put("TRADE_TYPE", (Object)unifiedOrderReqData.getTrade_type());
            bodyInfo.put("PRODUCT_ID", (Object)unifiedOrderReqData.getProduct_id());
            bodyInfo.put("LIMIT_PAY", (Object)"");
            bodyInfo.put("OPEN_ID", (Object)unifiedOrderReqData.getOpenid());
            bodyInfo.put("SCENE_INFO", JSONObject.parse((String)unifiedOrderReqData.getScene_info()));
            body.put("UNIFIED_ORDER_REQ", (Object)bodyInfo);
            String resultStr = this.abilityToPayPlatformService.abilityToPayPlatform(this.payPropertiesVo.getAbilityWxUnifiedOrderUrl(), body);
            ParseInfo parseInfo = ParseAbilityResponse.getRspBodyInfo((String)resultStr, (String)"UNIFIED_ORDER_RSP");
            if (!"0000".equals(parseInfo.getRsp_code())) {
                rsp.setRspCode(parseInfo.getRsp_code());
                rsp.setRspName(parseInfo.getRsp_msg());
                return rsp;
            }
            if (!Signature.checkIsSignValidFromAbilityResponse((JSONObject)parseInfo.getJsonInfo(), (String)unifiedOrderReqData.getKey())) {
                rsp.setRspCode("8888");
                rsp.setRspName("\u6821\u9a8c\u7edf\u4e00\u4e0b\u5355api\u8fd4\u56de\u7b7e\u540d\u5931\u8d25");
                return rsp;
            }
            rsp.setCodeUrl(parseInfo.getJsonInfo().getString("CODE_URL"));
            rsp.setMwebUrl(parseInfo.getJsonInfo().getString("MWEB_URL"));
            rsp.setPrepayId(parseInfo.getJsonInfo().getString("PREPAY_ID"));
            rsp.setRspCode("0000");
            rsp.setRspName("\u6210\u529f");
        }
        catch (Exception e) {
            rsp.setRspCode("8888");
            rsp.setRspName("\u5fae\u4fe1\u7edf\u4e00\u4e0b\u5355\u670d\u52a1\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return rsp;
    }
}

