/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.comb.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.payment.pay.LoggerProUtils;
import com.tydic.payment.pay.atom.BusiSystemInfoAtomService;
import com.tydic.payment.pay.atom.MerchantInfoAtomService;
import com.tydic.payment.pay.atom.PayOrderAtomService;
import com.tydic.payment.pay.atom.PorderPayTransAtomService;
import com.tydic.payment.pay.atom.bo.PorderPayTransAtomReqBo;
import com.tydic.payment.pay.atom.bo.PorderPayTransAtomRspBo;
import com.tydic.payment.pay.bo.BaseRspInfoBO;
import com.tydic.payment.pay.bo.PayParaInfoAttrBo;
import com.tydic.payment.pay.busi.CreatePayOrderService;
import com.tydic.payment.pay.busi.OrderQueryConstructionBusiService;
import com.tydic.payment.pay.busi.QueryCashierInfoPayParaAttrService;
import com.tydic.payment.pay.busi.bo.CreatePayOrderReqBo;
import com.tydic.payment.pay.busi.bo.CreatePayOrderRspBo;
import com.tydic.payment.pay.busi.bo.OrderQueryConstructionReqBo;
import com.tydic.payment.pay.busi.bo.OrderQueryConstructionRspBo;
import com.tydic.payment.pay.busi.bo.QueryCashierInfoPayParaAttrReqBo;
import com.tydic.payment.pay.busi.bo.QueryCashierInfoPayParaAttrRspBo;
import com.tydic.payment.pay.comb.GdBankAliMiniProPayCombService;
import com.tydic.payment.pay.comb.bo.GdBankAliMiniProPayCombReqBo;
import com.tydic.payment.pay.comb.bo.GdBankAliMiniProPayCombRspBo;
import com.tydic.payment.pay.common.util.HttpUtil;
import com.tydic.payment.pay.common.util.MapUtils;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.dao.po.BusiSystemInfoPO;
import com.tydic.payment.pay.dao.po.PorderPo;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.util.BankPayUtil;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="gdBankAliMiniProPayCombService")
@HSFProvider(serviceVersion="2.0-SNAPSHOT", serviceGroup="PAY_GROUP_LOCAL", serviceInterface=GdBankAliMiniProPayCombService.class)
public class GdBankAliMiniProPayCombServiceImpl
implements GdBankAliMiniProPayCombService {
    private static final Logger LOGGER = LoggerFactory.getLogger(GdBankAliMiniProPayCombServiceImpl.class);
    private static final String SERVICE_NAME = "\u5149\u5927\u94f6\u884c\u652f\u4ed8\u5b9d\u5c0f\u7a0b\u5e8f\u4e0b\u5355Busi\u670d\u52a1";
    @Autowired
    private CreatePayOrderService createPayOrderService;
    @Autowired
    private PayOrderAtomService payOrderAtomService;
    @Autowired
    private PorderPayTransAtomService porderPayTransAtomService;
    @Autowired
    private OrderQueryConstructionBusiService orderQueryConstructionBusiService;
    @Autowired
    private BusiSystemInfoAtomService busiSystemInfoAtomService;
    @Autowired
    private MerchantInfoAtomService merchantInfoAtomService;
    @Autowired
    private QueryCashierInfoPayParaAttrService queryCashierInfoPayParaAttrService;
    @Autowired
    private PayPropertiesVo payPropertiesVo;

    public GdBankAliMiniProPayCombRspBo dealGdBankAliMiniProgram(GdBankAliMiniProPayCombReqBo reqBo) {
        LoggerProUtils.debug(LOGGER, "\u5149\u5927\u94f6\u884c\u652f\u4ed8\u5b9d\u5c0f\u7a0b\u5e8f\u4e0b\u5355Busi\u670d\u52a1 -> \u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        GdBankAliMiniProPayCombRspBo rspBo = new GdBankAliMiniProPayCombRspBo();
        rspBo.setRspCode("8888");
        rspBo.setRspName("\u5931\u8d25");
        BaseRspInfoBO checkRsp = this.checkInputReqBo(reqBo);
        if (!checkRsp.getRspCode().equals("0000")) {
            rspBo.setRspName(checkRsp.getRspName());
            return rspBo;
        }
        try {
            PorderPayTransAtomReqBo orderPayTransAtomReq;
            String outTradeNo;
            boolean flag;
            PorderPo orderInfo;
            Map<String, String> merParamMap;
            block21: {
                QueryCashierInfoPayParaAttrReqBo paraReq = new QueryCashierInfoPayParaAttrReqBo();
                paraReq.setMerchantId(reqBo.getMerchantId());
                paraReq.setPayMethod("121");
                QueryCashierInfoPayParaAttrRspBo paraInfo = this.queryCashierInfoPayParaAttrService.queryPayParaAttr(paraReq);
                if (paraInfo == null || !"0000".equals(paraInfo.getRspCode())) {
                    throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u7edf\u4e00\u652f\u4ed8\u7ec4\u5408\u670d\u52a1\u6839\u636e\u5546\u6237\u53f7\u3010" + reqBo.getMerchantId() + "\u3011\u67e5\u8be2\u652f\u4ed8\u53c2\u6570\u914d\u7f6e\u5931\u8d25\uff01");
                }
                if (paraInfo.getInfoPayParaAttrList() == null || paraInfo.getInfoPayParaAttrList().size() < 1) {
                    throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u7edf\u4e00\u652f\u4ed8\u7ec4\u5408\u670d\u52a1\u6839\u636e\u5546\u6237\u53f7\u3010" + reqBo.getMerchantId() + "\u3011\u67e5\u8be2\u65e0\u652f\u4ed8\u53c2\u6570\u914d\u7f6e\uff01");
                }
                merParamMap = this.getParamMap(paraInfo);
                if (StringUtils.isEmpty((Object)reqBo.getOrderType())) {
                    reqBo.setOrderType("01");
                }
                String ip = reqBo.getIp();
                Map params = MapUtils.objectToMap((Object)reqBo);
                params.put("goodsDetail", reqBo.getGoodsDetail());
                CreatePayOrderReqBo createPayOrderReqBo = new CreatePayOrderReqBo();
                createPayOrderReqBo.setBusiId(reqBo.getBusiId());
                createPayOrderReqBo.setBusiCode(reqBo.getBusiCode());
                createPayOrderReqBo.setIp(ip == null ? "127.0.0.1" : ip);
                createPayOrderReqBo.setContentMap(params);
                CreatePayOrderRspBo createPayOrderRspBo = this.createPayOrderService.createPorder(createPayOrderReqBo);
                if (createPayOrderRspBo.getRspCode().equals("8888")) {
                    rspBo.setRspName(createPayOrderRspBo.getRspName());
                    return rspBo;
                }
                orderInfo = this.payOrderAtomService.queryByOrderId(Long.valueOf(createPayOrderRspBo.getOrderId()));
                OrderQueryConstructionReqBo orderQueryConReq = new OrderQueryConstructionReqBo();
                orderQueryConReq.setOutOrderId(reqBo.getOutOrderId());
                orderQueryConReq.setBusiId(Long.valueOf(reqBo.getBusiId()));
                orderQueryConReq.setOrderId(orderInfo.getOrderId());
                OrderQueryConstructionRspBo orderQueryConRsp = this.orderQueryConstructionBusiService.insertConstruction(orderQueryConReq);
                if (orderQueryConRsp.getRspCode().equals("8888")) {
                    rspBo.setRspName(orderQueryConRsp.getRspName());
                    return rspBo;
                }
                flag = true;
                outTradeNo = null;
                orderPayTransAtomReq = new PorderPayTransAtomReqBo();
                if (!StringUtils.isEmpty((Object)orderInfo.getOutRemark())) {
                    outTradeNo = orderInfo.getOutRemark();
                    try {
                        orderPayTransAtomReq.setPayOrderId(outTradeNo);
                        PorderPayTransAtomRspBo porderPayTransAtomRspBo = this.porderPayTransAtomService.queryOrderPayTransByPayOrderId(orderPayTransAtomReq);
                        if (porderPayTransAtomRspBo == null) {
                            orderPayTransAtomReq.setOrderId(orderInfo.getOrderId());
                            orderPayTransAtomReq.setBusiId(orderInfo.getBusiId());
                            orderPayTransAtomReq.setMerchantId(Long.parseLong(reqBo.getMerchantId()));
                            orderPayTransAtomReq.setPayMethod(Long.parseLong("121"));
                            orderPayTransAtomReq.setOrderStatus("A00");
                            String gdMerid = merParamMap.get("merid");
                            orderPayTransAtomReq.setTransMerchant(gdMerid);
                            BigDecimal totalFeeInBigDecimal = new BigDecimal(reqBo.getTotalFee());
                            orderPayTransAtomReq.setPayFee(MoneyUtils.fenToHaoToLong((BigDecimal)totalFeeInBigDecimal));
                            break block21;
                        }
                        if (porderPayTransAtomRspBo != null && !"A10".equals(porderPayTransAtomRspBo.getOrderStatus())) {
                            flag = false;
                            break block21;
                        }
                        throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8ba2\u5355id\u3010ORDER_ID=" + orderInfo.getOrderId() + "\u3011\u5df2\u7ecf\u652f\u4ed8\u6210\u529f\uff01");
                    }
                    catch (Exception e) {
                        LOGGER.error(e.getMessage(), (Throwable)e);
                    }
                } else {
                    orderPayTransAtomReq.setOrderId(orderInfo.getOrderId());
                    orderPayTransAtomReq.setBusiId(orderInfo.getBusiId());
                    orderPayTransAtomReq.setMerchantId(Long.parseLong(reqBo.getMerchantId()));
                    orderPayTransAtomReq.setPayMethod(Long.parseLong("121"));
                    orderPayTransAtomReq.setOrderStatus("A00");
                    BigDecimal totalFeeInBigDecimal = new BigDecimal(reqBo.getTotalFee());
                    orderPayTransAtomReq.setPayFee(MoneyUtils.fenToHaoToLong((BigDecimal)totalFeeInBigDecimal));
                    orderPayTransAtomReq.setTransMerchant(merParamMap.get("merid"));
                }
            }
            if (flag) {
                try {
                    outTradeNo = this.porderPayTransAtomService.createOrderPayTrans(orderPayTransAtomReq);
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
            PorderPayTransAtomReqBo payTransAtomReq = new PorderPayTransAtomReqBo();
            payTransAtomReq.setPayOrderId(outTradeNo);
            PorderPayTransAtomRspBo payTransAtomRsp = this.porderPayTransAtomService.queryOrderPayTransByPayOrderId(payTransAtomReq);
            if (payTransAtomRsp == null) {
                rspBo.setRspName("\u63d2\u5165p_order_pay_trans\u8868\u5931\u8d25");
                return rspBo;
            }
            String timeEnd = "1800";
            JSONObject jo = new JSONObject(new LinkedHashMap());
            jo.put("ordernumber", (Object)payTransAtomRsp.getPayOrderId());
            jo.put("ordertime", (Object)new DateTime().toString("yyyy-MM-dd HH:mm:ss"));
            jo.put("merid", (Object)merParamMap.get("merid"));
            jo.put("paytype", (Object)"alipay");
            jo.put("transtype", (Object)"0000");
            jo.put("signmethon", (Object)"md5");
            jo.put("charset", (Object)"utf8");
            jo.put("notifyurl", (Object)this.payPropertiesVo.getGdBankPayNotifyUrl());
            jo.put("backurl", (Object)this.payPropertiesVo.getGdBankPayNotifyUrl());
            jo.put("amount", (Object)reqBo.getTotalFee());
            jo.put("customerip", (Object)orderInfo.getCreateIpAddress());
            jo.put("remark1", (Object)timeEnd);
            jo.put("remark2", (Object)orderInfo.getDetailName());
            jo.put("remark3", (Object)orderInfo.getOrderAttrValue1());
            jo.put("remark4", (Object)orderInfo.getOrderAttrValue2());
            jo.put("remark5", (Object)orderInfo.getOrderAttrValue3());
            jo.put("remark6", (Object)"");
            jo.put("remark7", (Object)"");
            jo.put("remark8", (Object)"");
            jo.put("remark9", (Object)"");
            jo.put("remark10", (Object)"");
            jo.put("remark11", (Object)"");
            jo.put("remark12", (Object)"");
            JSONArray dataArray = new JSONArray(new LinkedList());
            JSONObject dataObj1 = new JSONObject(new LinkedHashMap());
            dataObj1.put("banknumber", (Object)merParamMap.get("banknumber"));
            dataObj1.put("numbername", (Object)merParamMap.get("numbername"));
            dataObj1.put("remark1", (Object)"");
            dataObj1.put("remark2", (Object)"");
            JSONArray listArray = new JSONArray(new LinkedList());
            JSONObject listObj1 = new JSONObject(new LinkedHashMap());
            listObj1.put("title", (Object)orderInfo.getDetailName());
            listObj1.put("id", (Object)"11111");
            listObj1.put("category_name", (Object)"");
            listObj1.put("price", (Object)reqBo.getTotalFee());
            String uuid = UUID.randomUUID().toString().replaceAll("-", "");
            listObj1.put("suborderid", (Object)(uuid + payTransAtomRsp.getPayOrderId()));
            listObj1.put("remark1", (Object)"");
            listObj1.put("remark2", (Object)"");
            listArray.add((Object)listObj1);
            dataObj1.put("list", (Object)listArray);
            dataArray.add((Object)dataObj1);
            jo.put("data", (Object)dataArray);
            String key = merParamMap.get("key");
            String prepareOrderUrl = this.payPropertiesVo.getGdBankAliMiniProgramPrepareOrderUrl();
            LoggerProUtils.debug(LOGGER, "data:" + jo);
            String sign = BankPayUtil.generateSignature(key, jo.toString());
            LoggerProUtils.debug(LOGGER, "sign:" + sign);
            LoggerProUtils.debug(LOGGER, "\u9884\u4e0b\u5355\u8bf7\u6c42\u62a5\u6587\uff1aresult=" + JSONObject.toJSONString((Object)jo) + sign);
            LoggerProUtils.debug(LOGGER, "\u9884\u4e0b\u5355\u8bf7\u6c42\u5730\u5740\uff1a" + prepareOrderUrl);
            String result = HttpUtil.sendRequest((String)("result=" + JSONObject.toJSONString((Object)jo) + sign), (String)prepareOrderUrl, (String)"POST", (String)"UTF-8");
            LoggerProUtils.debug(LOGGER, "\u9884\u4e0b\u5355\u8fd4\u56de\u7ed3\u679c\uff1a" + result);
            if (StringUtils.isEmpty((Object)result)) {
                JSONObject err = JSONObject.parseObject((String)result);
                rspBo.setRspCode("8888");
                rspBo.setRspName("\u5149\u5927\u94f6\u884c\u652f\u4ed8\u5b9d\u5c0f\u7a0b\u5e8f\u9884\u4e0b\u5355\uff1a\u8fd4\u56de\u8ba2\u5355\u53f7\u4e3a\u7a7a");
                return rspBo;
            }
            if (result.equals(payTransAtomRsp.getPayOrderId())) {
                String phone = "18602966522";
                String requetUrl = this.payPropertiesVo.getGdBankAliMiniProgramPayUrl() + "?phone=" + phone + "&orderid=" + payTransAtomRsp.getPayOrderId();
                LoggerProUtils.debug(LOGGER, "\u5c0f\u7a0b\u5e8f\u652f\u4ed8\u8bf7\u6c42\u5730\u5740\uff1a" + requetUrl);
                String payResponse = HttpUtil.sendRequest((String)"", (String)requetUrl, (String)"GET", (String)"UTF-8");
                LoggerProUtils.debug(LOGGER, "\u5c0f\u7a0b\u5e8f\u652f\u4ed8\u8fd4\u56de\u5185\u5bb9\uff1a" + payResponse);
                if (payResponse.startsWith("https:") || payResponse.startsWith("http:")) {
                    rspBo.setPayOrderId(payTransAtomRsp.getPayOrderId());
                    rspBo.setPayStatus("PAYING");
                    rspBo.setUrl(payResponse);
                    rspBo.setOutOrderId(reqBo.getOutOrderId());
                    rspBo.setRspCode("0000");
                    rspBo.setRspName("\u6210\u529f");
                    return rspBo;
                }
                JSONObject err = JSONObject.parseObject((String)result);
                rspBo.setRspCode("8888");
                rspBo.setRspName(err.getString("info"));
                return rspBo;
            }
            rspBo.setRspCode("8888");
            rspBo.setRspName("\u5149\u5927\u94f6\u884c\u652f\u4ed8\u5b9d\u5c0f\u7a0b\u5e8f\u9884\u4e0b\u5355\uff1a\u8fd4\u56de\u8ba2\u5355\u53f7\u4e0e\u539f\u59cb\u8ba2\u5355\u53f7\u4e0d\u540c");
            return rspBo;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            rspBo.setRspName("\u8c03\u7528\u5149\u5927\u94f6\u884c\u5c0f\u7a0b\u5e8fBusi\u670d\u52a1\u51fa\u9519");
            return rspBo;
        }
    }

    private Map<String, String> getParamMap(QueryCashierInfoPayParaAttrRspBo paraInfo) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        for (PayParaInfoAttrBo para : paraInfo.getInfoPayParaAttrList()) {
            paramMap.put(para.getAttrCode(), para.getAttrValue());
        }
        return paramMap;
    }

    private BaseRspInfoBO checkInputReqBo(GdBankAliMiniProPayCombReqBo reqBo) {
        BaseRspInfoBO checkRsp = new BaseRspInfoBO();
        checkRsp.setRspCode("8888");
        checkRsp.setRspName("\u5931\u8d25");
        Long busiId = Long.parseLong(reqBo.getBusiId());
        BusiSystemInfoPO busiPo = this.busiSystemInfoAtomService.queryBusiSystemInfoById(busiId);
        if (busiPo == null) {
            checkRsp.setRspName("\u5149\u5927\u94f6\u884c\u652f\u4ed8\u5b9d\u5c0f\u7a0b\u5e8f\u4e0b\u5355Busi\u670d\u52a1\uff1a\u4e1a\u52a1\u7cfb\u7edf\u4e0d\u5b58\u5728\uff01(" + busiId + ")");
            LoggerProUtils.error(LOGGER, "\u5149\u5927\u94f6\u884c\u652f\u4ed8\u5b9d\u5c0f\u7a0b\u5e8f\u4e0b\u5355Busi\u670d\u52a1\uff1a\u4e1a\u52a1\u7cfb\u7edf\u4e0d\u5b58\u5728\uff01(" + busiId + ")");
            return checkRsp;
        }
        String outOrderId = reqBo.getOutOrderId();
        OrderQueryConstructionReqBo orderQueryConstructionReqBo = new OrderQueryConstructionReqBo();
        orderQueryConstructionReqBo.setBusiId(busiId);
        orderQueryConstructionReqBo.setOutOrderId(outOrderId);
        OrderQueryConstructionRspBo rsp = this.orderQueryConstructionBusiService.queryConstruction(orderQueryConstructionReqBo);
        if ("0000".equals(rsp.getRspCode())) {
            checkRsp.setRspName("\u5149\u5927\u94f6\u884c\u652f\u4ed8\u5b9d\u5c0f\u7a0b\u5e8f\u4e0b\u5355Busi\u670d\u52a1\uff1a\u91cd\u590d\u7684\u5916\u90e8\u8ba2\u5355\uff01(" + outOrderId + ")");
            LoggerProUtils.error(LOGGER, "\u5149\u5927\u94f6\u884c\u652f\u4ed8\u5b9d\u5c0f\u7a0b\u5e8f\u4e0b\u5355Busi\u670d\u52a1\uff1a\u91cd\u590d\u7684\u5916\u90e8\u8ba2\u5355\uff01(" + outOrderId + ")");
            return checkRsp;
        }
        checkRsp.setRspCode("0000");
        checkRsp.setRspName("\u6210\u529f");
        return checkRsp;
    }
}

