/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.config.vo;

import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.env.OriginTrackedMapPropertySource;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class PayPropertiesVo {
    @Autowired
    private Environment environment;
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private Properties properties = new Properties();

    public Properties getProperties() {
        return this.properties;
    }

    public void setValue(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public String getValueByKey(String key) {
        if (StringUtils.isEmpty((Object)key)) {
            this.LOGGER.error("\u83b7\u53d6key\u5165\u53c2\u4e3a\u7a7a\u4e86(" + key + ")");
            return null;
        }
        String value = this.properties.getProperty(key);
        this.LOGGER.info("\u6839\u636ekey(" + key + ")\u83b7\u53d6value\u4e3a(" + value + ")");
        return value;
    }

    public boolean isUseMulitpleCallBack() {
        String callBackSwitch = this.getValueByKey("mulitple.callback.switch");
        return "1".equals(callBackSwitch);
    }

    public String getFkMqTopic() {
        return this.properties.getProperty("PMCFK_NOTIFY_TOPIC");
    }

    public String getPayNotifyMqTopic() {
        return this.properties.getProperty("PAY_NOTIFY_TOPIC");
    }

    public String getPayNotifyMqTag() {
        return this.properties.getProperty("PAY_NOTIFY_TAG");
    }

    public String getFkMqTag() {
        return this.properties.getProperty("PMCFK_NOTIFY_TAG");
    }

    public String getSequenceName() {
        return this.properties.getProperty("sequence_name");
    }

    public String getSequenceChoose() {
        String sequenceChoose = this.properties.getProperty("sequence_choose");
        if (StringUtils.isEmpty((Object)sequenceChoose)) {
            sequenceChoose = "0";
        }
        return sequenceChoose;
    }

    public String getAbilityPayNotifyUrl() {
        return this.properties.getProperty("ability_pay_notify_url");
    }

    public String getProjectName() {
        return this.properties.getProperty("project_name");
    }

    public String getAliReturnUrl() {
        return this.properties.getProperty("aliReturnUrl");
    }

    public String getAliPcWebReturnUrl() {
        return this.properties.getProperty("aliPcWebReturnUrl");
    }

    public String getAliNotifyUrl() {
        return this.properties.getProperty("aliPayNotifyUrl");
    }

    public String getAbilityWxUnifiedOrderUrl() {
        return this.properties.getProperty("ability_wx_unified_order_url");
    }

    public String getAbilityAppId() {
        return this.properties.getProperty("ability_app_id");
    }

    public String getAbilityAppSecret() {
        return this.properties.getProperty("ability_app_secret");
    }

    public String getWxPayResultNotifyUrl() {
        return this.properties.getProperty("wx_pay_result_notify_url");
    }

    public String getAbilityWxOrderQueryUrl() {
        return this.properties.getProperty("ability_wx_order_query_url");
    }

    public String getAbilityWxCloseOrderUrl() {
        return this.properties.getProperty("ability_wx_close_order_url");
    }

    public String getAliOpenApiDomain() {
        return this.properties.getProperty("aliOpenApiDomain");
    }

    public String getAliMcloudApiDomain() {
        return this.properties.getProperty("aliMcloudApiDomain");
    }

    public String getAliSignature() {
        return this.properties.getProperty("aliSignature");
    }

    public String getAliSignType() {
        return this.properties.getProperty("aliSignType");
    }

    public String getAbilityWxRefundUrl() {
        return this.properties.getProperty("ability_wx_refund_url");
    }

    public String getAbilityWxMicropayUrl() {
        return this.properties.getProperty("ability_wx_micropay_url");
    }

    public String getAbilitySwitch() {
        return this.properties.getProperty("ability_switch");
    }

    public String getAbilityWxReverseUrl() {
        return this.properties.getProperty("ability_wx_reverse_url");
    }

    public String getAbilityPayResultNotifyUrl() {
        return this.properties.getProperty("ability_pay_result_notify_url");
    }

    public String getAbilityDownLoadBillUrl() {
        return this.properties.getProperty("ability_down_load_bill_url");
    }

    public String getPayAccessIp() {
        return this.properties.getProperty("PAY_ACCESS_IP");
    }

    public String getPayAccessProjectName() {
        return this.properties.getProperty("PAY_ACCESS_PROJECT_NAME");
    }

    public String getPayContactIp() {
        return this.properties.getProperty("PAY_CONTACT_IP");
    }

    public String getPayContactProjectName() {
        return this.properties.getProperty("PAY_CONTACT_PROJECT_NAME");
    }

    public Boolean getAcpSdkIfValidateCnName() {
        if (Boolean.FALSE.toString().equalsIgnoreCase(this.properties.getProperty("ACP_SDK_IF_VALIDATE_CN_NAME"))) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public Boolean getAcpSdkIfValidateRemoteCert() {
        if (Boolean.FALSE.toString().equalsIgnoreCase(this.properties.getProperty("ACP_SDK_IF_VALIDATE_REMOTE_CERT"))) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public String getUnionPayAcpNotifyUrl() {
        return this.properties.getProperty("UNION_PAY_ACP_NOTIFY_URL");
    }

    public String getUnionPayAcpFrontUrl() {
        return this.properties.getProperty("UNION_PAY_ACP_FRONT_URL");
    }

    public String getAcpSdkFrontTransUrl() {
        return this.properties.getProperty("ACP_SDK_FRONT_TRANS_URL");
    }

    public String getAcpSdkBackTransUrl() {
        return this.properties.getProperty("ACP_SDK_BACK_TRANS_URL");
    }

    public String getAcpSdkSingleQueryUrl() {
        return this.properties.getProperty("ACP_SDK_SINGLE_QUERY_URL");
    }

    public String getAcpSdkBatchTransUrl() {
        return this.properties.getProperty("ACP_SDK_BATCH_TRANS_URL");
    }

    public String getAcpSdkFileTransUrl() {
        return this.properties.getProperty("ACP_SDK_FILE_TRANS_URL");
    }

    public String getAcpSdkAppTransUrl() {
        return this.properties.getProperty("ACP_SDK_APP_TRANS_URL");
    }

    public String getAcpSdkCardTransUrl() {
        return this.properties.getProperty("ACP_SDK_CARD_TRANS_URL");
    }

    public String getUnicodeAliH5PayReturnUrl() {
        return this.properties.getProperty("UNICODE_ALI_H5_PAY_RETURN_URL");
    }

    public String getGdBankPay4Url() {
        return this.properties.getProperty("GD_BANK_PAY4_URL");
    }

    public String getGdBankPayNotifyUrl() {
        return this.properties.getProperty("GD_BANK_PAY4__NOTIFY_URL");
    }

    public String getGdBankPay4QueryOrderUrl() {
        return this.properties.getProperty("GD_BANK_PAY4_QUERY_ORDER_URL");
    }

    public String getGdBankAliMiniProgramPrepareOrderUrl() {
        return this.properties.getProperty("GD_BANK_ALI_MINI_PROGRAM_PREPARE_ORDER_URL");
    }

    public String getGdBankAliMiniProgramPayUrl() {
        return this.properties.getProperty("GD_BANK_ALI_MINI_PROGRAM_PAY_URL");
    }

    public String getWXUnifiedOrderUrl() {
        return this.properties.getProperty("WX_UNIFIED_ORDER_URL");
    }

    public String getWXMicoPayUrl() {
        return this.properties.getProperty("WX_MICO_PAY_URL");
    }

    public String getWXOrderQueryUrl() {
        return this.properties.getProperty("WX_ORDER_QUERY_URL");
    }

    public String getWXReverse() {
        return this.properties.getProperty("WX_REVERSE_URL");
    }

    public String getWXRefund() {
        return this.properties.getProperty("WX_REFUND_URL");
    }

    public String getWXCloseOrder() {
        return this.properties.getProperty("WX_CLOSE_ORDER_URL");
    }

    public String getWXDownloadBill() {
        return this.properties.getProperty("WX_DOWNLOAD_BILL_URL");
    }

    public String getWXOutRefundFlag() {
        return this.properties.getProperty("WX_OUT_REFUND_FLAG");
    }

    public String getWXOutRefundUrl() {
        return this.properties.getProperty("WX_OUT_REFUND_URL");
    }

    public String getQueryPayBillRequestCode() {
        return this.properties.getProperty("QUERY_PAY_BILL_REQUEST_CODE");
    }

    @PostConstruct
    public void initVo() {
        if (this.environment instanceof AbstractEnvironment) {
            MutablePropertySources propertySources = ((AbstractEnvironment)this.environment).getPropertySources();
            Iterator iterator = propertySources.iterator();
            System.err.println("PayPropertiesVo\u5f00\u59cb\u586b\u5145\u5c5e\u6027");
            while (iterator.hasNext()) {
                PropertySource propertySource = (PropertySource)iterator.next();
                if (propertySource == null || !(propertySource instanceof OriginTrackedMapPropertySource)) continue;
                Map propertiesMap = (Map)((OriginTrackedMapPropertySource)propertySource).getSource();
                for (String key : propertiesMap.keySet()) {
                    if (this.properties.containsKey(key)) continue;
                    this.properties.setProperty(key, this.environment.getProperty(key));
                    this.LOGGER.info("\u5c5e\u6027\u503c\uff1a" + key + " = " + this.environment.getProperty(key));
                }
            }
            System.err.println("PayPropertiesVo\u5b8c\u6210\u586b\u5145\u5c5e\u6027\uff0c\u4e00\u5171\u586b\u5145\u4e86\uff1a(" + this.properties.size() + ")\u4e2a");
        } else {
            System.err.println("PayProperties\u83b7\u53d6\u5c5e\u6027\u5931\u8d25");
            System.exit(0);
        }
    }
}

