/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.constant;

import java.util.ArrayList;
import java.util.List;

public class PayProConstants {

    public static enum CashPayStatus {
        A10("A10"),
        A20("A20"),
        B10("B10"),
        B20("B20");

        private String value;

        private CashPayStatus(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum WxPayTradeStatus {
        SUCCESS("SUCCESS"),
        NOTPAY("NOTPAY"),
        USERPAYING("USERPAYING"),
        REVOKED("REVOKED"),
        PAYERROR("PAYERROR"),
        CLOSED("CLOSED"),
        REFUND("REFUND");

        private String value;

        private WxPayTradeStatus(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public class GenericConstants {
        public static final String REAL_QUERY_FLAG_YES = "1";
        public static final String PAY_NOTIFY_CODE_YES = "0";
        public static final String PAY_NOTIFY_CODE_NOT = "1";
        public static final String QUERY_PAY_TRANS_REVERSE = "1";
        public static final String WX_REFUND_FLAG_OUTTER = "1";
        public static final String PAY_CENTER_FILE_SERVER_PATH = "payCenter/";
        public static final String PAY_TRANS = "Trans";
    }

    public class AliPayConstants {
        public static final String FORMAT = "json";
        public static final String CHARSET = "UTF-8";
        public static final String SIGNTYPE = "RSA2";
    }

    public static enum AliPayTradeStatus {
        WAIT_BUYER_PAY("WAIT_BUYER_PAY"),
        TRADE_CLOSED("TRADE_CLOSED"),
        TRADE_SUCCESS("TRADE_SUCCESS"),
        TRADE_FINISHED("TRADE_FINISHED");

        private String value;

        private AliPayTradeStatus(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum PayMethod {
        WX_BAR(10L),
        WX_QR(11L),
        WX_APP(12L),
        WX_H5(13L),
        WX_JSP(14L),
        WX_APPLET(15L),
        ALI_BAR(20L),
        ALI_QR(21L),
        ALI_APP(22L),
        ALI_H5(23L),
        ALI_WEB(24L),
        ALI_HB_FQ(26L),
        ALI_XCX(27L),
        ALI_TRANS(28L),
        ALI_SING(29L),
        CASH_PAY(30L),
        WOPAY_MOBILE(50L),
        UNION_PAY_ACP(110L),
        UNION_PAY_QR_CB(112L),
        UNION_PAY_WAP(113L),
        UMC_PAY_BALANCE(140L),
        BEST_PAY(150L);

        private Long payMethod;

        private PayMethod(Long payMethod) {
            this.payMethod = payMethod;
        }

        public static List<Long> getAllPayMethod() {
            ArrayList<Long> payMethods = new ArrayList<Long>();
            for (PayMethod payMethod : PayMethod.values()) {
                payMethods.add(payMethod.getPayMethod());
            }
            return payMethods;
        }

        public static boolean containsPayMethod(Long payMethod) {
            if (payMethod == null) {
                return false;
            }
            List<Long> allPayMethod = PayMethod.getAllPayMethod();
            for (Long method : allPayMethod) {
                if (method.longValue() != payMethod.longValue()) continue;
                return true;
            }
            return false;
        }

        public Long getPayMethod() {
            return this.payMethod;
        }
    }
}

