/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.payable.impl;

import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.payment.pay.atom.PorderPayTransAtomService;
import com.tydic.payment.pay.atom.PorderRefundTransAtomService;
import com.tydic.payment.pay.atom.bo.PorderPayTransAtomReqBo;
import com.tydic.payment.pay.atom.bo.PorderPayTransAtomRspBo;
import com.tydic.payment.pay.atom.bo.PorderRefundTransAtomReqBo;
import com.tydic.payment.pay.atom.bo.PorderRefundTransAtomRspBo;
import com.tydic.payment.pay.busi.bo.PayAbleCallBackReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleCallBackRspBo;
import com.tydic.payment.pay.busi.bo.PayAbleQryPayStatusReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleQryPayStatusRspBo;
import com.tydic.payment.pay.busi.bo.PayAbleRefundReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleRefundRspBo;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.dao.PayMethodMapper;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.payable.api.PayAble;
import com.tydic.payment.pay.sdk.unionpay.AcpService;
import com.tydic.payment.pay.sdk.unionpay.SdkConfig;
import com.tydic.payment.pay.util.UnionPayAcpSdkConfigUtils;
import com.tydic.payment.pay.util.UnionPayAcpSdkRspUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public abstract class AbstractUnionPayAble
implements PayAble {
    private static Logger LOG = LoggerFactory.getLogger(AbstractUnionPayAble.class);
    @Autowired
    private PorderPayTransAtomService pOrderPayTransAtomService;
    @Autowired
    private PorderRefundTransAtomService porderRefundTransAtomService;
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private PayMethodMapper payMethodMapper;
    @Resource
    private FileClient fileClient;

    public PayAbleRefundRspBo dealRefund(PayAbleRefundReqBo reqBo) {
        if (LOG.isDebugEnabled()) {
            LOG.info("\u94f6\u8054\u7f51\u5173\u652f\u4ed8\u9000\u6b3e\u670d\u52a1\uff1a" + reqBo);
        }
        PayAbleRefundRspBo retBo = new PayAbleRefundRspBo();
        String validataRefundArgStr = this.validataRefundArg(reqBo);
        if (StringUtils.isEmpty((Object)validataRefundArgStr)) {
            retBo.setRespCode("2029");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validataRefundArgStr);
        }
        String payOrderId = reqBo.getPayOrderId();
        PorderPayTransAtomRspBo orderInfo = this.getOrderPayTrans(payOrderId);
        String refundOrderId = reqBo.getRefundOrderId();
        PorderRefundTransAtomRspBo refundTransInfo = this.getOrderRefundTrans(refundOrderId);
        String txnType = this.getTxnType(orderInfo);
        Map paraMap = reqBo.getParaMap();
        this.loadProperties(paraMap);
        Map<String, String> requestData = this.createRefundReqData(reqBo, orderInfo, txnType, refundTransInfo);
        Map reqData = AcpService.sign(requestData, (String)"UTF-8");
        String reqUrl = SdkConfig.getConfig().getBackRequestUrl();
        Map rspData = AcpService.post((Map)reqData, (String)reqUrl, (String)"UTF-8");
        if (rspData.isEmpty()) {
            LOG.error("\u94f6\u8054\u9000\u6b3e\u63a5\u53e3\u8fd4\u56de\u7a7a\u503c");
            throw new BusinessException("6026", "\u94f6\u8054\u9000\u6b3e\u63a5\u53e3\u8fd4\u56de\u7a7a\u503c");
        }
        try {
            if (!AcpService.validate((Map)rspData, (String)"UTF-8")) {
                LOG.error("\u94f6\u8054\u63a5\u53e3\u8fd4\u56de\u540e\u6821\u9a8c\u7b7e\u540d\u5931\u8d25");
                throw new BusinessException("6026", "\u94f6\u8054\u63a5\u53e3\u8fd4\u56de\u540e\u6821\u9a8c\u7b7e\u540d\u5931\u8d25");
            }
        }
        catch (Exception e) {
            LOG.error("\u94f6\u8054\u63a5\u53e3\u8fd4\u56de\u540e\u6821\u9a8c\u7b7e\u540d\u5f02\u5e38\uff1a" + e);
            throw new BusinessException("6026", "\u94f6\u8054\u63a5\u53e3\u8fd4\u56de\u540e\u6821\u9a8c\u7b7e\u540d\u5f02\u5e38\uff1a" + e);
        }
        this.sortRefundRetBo(rspData, reqBo, retBo);
        return retBo;
    }

    public PayAbleQryPayStatusRspBo qryPayStatus(PayAbleQryPayStatusReqBo reqBo) {
        if (LOG.isDebugEnabled()) {
            LOG.info("\u94f6\u8054\u7f51\u5173\u652f\u4ed8\u4ea4\u6613\u72b6\u6001\u67e5\u8be2\u670d\u52a1\uff1a" + reqBo);
        }
        PayAbleQryPayStatusRspBo retBo = new PayAbleQryPayStatusRspBo();
        String validataQryArgStr = this.validataQryArg(reqBo);
        if (StringUtils.isEmpty((Object)validataQryArgStr)) {
            retBo.setRespCode("2028");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validataQryArgStr);
        }
        String payOrderId = reqBo.getPayOrderId();
        PorderPayTransAtomRspBo orderInfo = this.getOrderPayTrans(payOrderId);
        Map paraMap = reqBo.getParaMap();
        this.loadProperties(paraMap);
        Map<String, String> requestData = this.createRequestData(reqBo, orderInfo);
        Map reqData = AcpService.sign(requestData, (String)"UTF-8");
        String requestUrl = SdkConfig.getConfig().getSingleQueryUrl();
        Map rspData = AcpService.post((Map)reqData, (String)requestUrl, (String)"UTF-8");
        try {
            if (!AcpService.validate((Map)rspData, (String)"UTF-8")) {
                LOG.error("\u94f6\u8054\u67e5\u8be2\u63a5\u53e3\u8fd4\u56de\u540e\u6821\u9a8c\u7b7e\u540d\u5931\u8d25");
                throw new BusinessException("6025", "\u94f6\u8054\u67e5\u8be2\u63a5\u53e3\u8fd4\u56de\u540e\u6821\u9a8c\u7b7e\u540d\u5931\u8d25");
            }
        }
        catch (Exception e) {
            LOG.error("\u94f6\u8054\u67e5\u8be2\u63a5\u53e3\u8fd4\u56de\u540e\u6821\u9a8c\u7b7e\u540d\u5f02\u5e38\uff1a" + e);
            throw new BusinessException("6025", "\u94f6\u8054\u67e5\u8be2\u63a5\u53e3\u8fd4\u56de\u540e\u6821\u9a8c\u7b7e\u540d\u5f02\u5e38\uff1a" + e);
        }
        this.sortQueryRetBo(reqBo, retBo, rspData);
        return retBo;
    }

    public PayAbleCallBackRspBo dealCallBack(PayAbleCallBackReqBo reqBo) {
        return null;
    }

    private void loadProperties(Map<String, String> paraMap) {
        UnionPayAcpSdkConfigUtils.setMerInfoByMap(this.payPropertiesVo, this.fileClient, paraMap);
    }

    private Map<String, String> createRefundReqData(PayAbleRefundReqBo reqBo, PorderPayTransAtomRspBo orderInfo, String txnType, PorderRefundTransAtomRspBo refundTransInfo) {
        HashMap<String, String> requestData = new HashMap<String, String>(32);
        requestData.put("version", SdkConfig.getConfig().getVersion());
        requestData.put("encoding", "UTF-8");
        requestData.put("signMethod", SdkConfig.getConfig().getSignMethod());
        requestData.put("txnType", txnType);
        requestData.put("txnSubType", "00");
        requestData.put("bizType", "000201");
        requestData.put("channelType", "07");
        requestData.put("merId", (String)reqBo.getParaMap().get("merId"));
        requestData.put("accessType", "0");
        requestData.put("orderId", reqBo.getRefundOrderId());
        String txnTime = DateUtils.dateToStr((Date)refundTransInfo.getCreateTime(), (String)"yyyyMMddHHmmss");
        requestData.put("txnTime", txnTime);
        requestData.put("currencyCode", "156");
        requestData.put("txnAmt", new BigDecimal(reqBo.getRefundFee()).longValue() + "");
        requestData.put("backUrl", SdkConfig.getConfig().getBackUrl());
        requestData.put("origQryId", orderInfo.getPayNotifyTransId());
        return requestData;
    }

    private Map<String, String> createRequestData(PayAbleQryPayStatusReqBo reqBo, PorderPayTransAtomRspBo orderInfo) {
        HashMap<String, String> requestData = new HashMap<String, String>(32);
        requestData.put("version", SdkConfig.getConfig().getVersion());
        requestData.put("encoding", "UTF-8");
        requestData.put("signMethod", SdkConfig.getConfig().getSignMethod());
        requestData.put("txnType", "00");
        requestData.put("txnSubType", "00");
        requestData.put("bizType", "000201");
        String merId = (String)reqBo.getParaMap().get("merId");
        requestData.put("merId", merId);
        requestData.put("accessType", "0");
        requestData.put("orderId", reqBo.getPayOrderId());
        requestData.put("txnTime", new DateTime((Object)orderInfo.getCreateTime()).toString("yyyyMMddHHmmss"));
        return requestData;
    }

    private PayAbleRefundRspBo sortRefundRetBo(Map<String, String> rspData, PayAbleRefundReqBo reqBo, PayAbleRefundRspBo retBo) {
        if (!UnionPayAcpSdkRspUtils.isSuccess(rspData.get("respCode"))) {
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u5931\u8d25");
            retBo.setRefundMsg(rspData.get("respMsg"));
            return retBo;
        }
        BeanUtils.copyProperties((Object)reqBo, (Object)retBo);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        retBo.setRefundTransId(rspData.get("queryId"));
        retBo.setTradeTime(rspData.get("txnTime"));
        return retBo;
    }

    private PayAbleQryPayStatusRspBo sortQueryRetBo(PayAbleQryPayStatusReqBo reqBo, PayAbleQryPayStatusRspBo retBo, Map<String, String> rspData) {
        String respcode = rspData.get("respCode");
        if (!UnionPayAcpSdkRspUtils.isSuccess(respcode)) {
            retBo.setRespCode("2028");
            retBo.setRespDesc(rspData.get("respMsg"));
            return retBo;
        }
        String oriRespCode = rspData.get("origRespCode");
        if ("00".equals(oriRespCode)) {
            retBo.setPayStatus("SUCCESS");
            retBo.setPayStatusMsg(rspData.get("origRespMsg"));
            retBo.setRespCode("0000");
            retBo.setRespDesc("\u94f6\u8054\u652f\u4ed8\u72b6\u6001\u67e5\u8be2\u6210\u529f");
        } else if ("03".equals(oriRespCode) || "04".equals(oriRespCode) || "05".equals(oriRespCode)) {
            retBo.setPayStatus("PAYING");
            retBo.setPayStatusMsg(rspData.get("origRespMsg"));
            retBo.setRespCode("0000");
            retBo.setRespDesc(rspData.get("respMsg"));
        } else {
            retBo.setPayStatus("FAIL");
            retBo.setPayStatusMsg(rspData.get("origRespMsg"));
            retBo.setRespCode("0000");
            retBo.setRespDesc(rspData.get("respMsg"));
        }
        if (!StringUtils.isEmpty((Object)rspData.get("txnAmt"))) {
            retBo.setRealFee(Long.valueOf(rspData.get("txnAmt")));
        }
        BeanUtils.copyProperties((Object)reqBo, (Object)retBo);
        retBo.setPayNotifyTransId(rspData.get("queryId"));
        retBo.setTradeTime(rspData.get("txnTime"));
        return retBo;
    }

    public PorderPayTransAtomRspBo getOrderPayTrans(String payOrderId) {
        PorderPayTransAtomRspBo orderInfo;
        PorderPayTransAtomReqBo queryOrderInfoReq = new PorderPayTransAtomReqBo();
        queryOrderInfoReq.setPayOrderId(payOrderId);
        try {
            orderInfo = this.pOrderPayTransAtomService.queryOrderPayTransByPayOrderId(queryOrderInfoReq);
        }
        catch (Exception e) {
            LOG.error("\u67e5\u8be2\u652f\u4ed8\u6d41\u6c34(payOrderId = " + payOrderId + ")\u5f02\u5e38");
            throw new BusinessException("6025", "\u67e5\u8be2\u652f\u4ed8\u6d41\u6c34(payOrderId = " + payOrderId + ")\u5f02\u5e38");
        }
        if (orderInfo == null) {
            LOG.error("\u67e5\u8be2\u652f\u4ed8\u6d41\u6c34(payOrderId = " + payOrderId + ")\u8fd4\u56de\u7a7a\u503c");
            throw new BusinessException("6025", "\u67e5\u8be2\u652f\u4ed8\u6d41\u6c34(payOrderId = " + payOrderId + ")\u8fd4\u56de\u7a7a\u503c");
        }
        return orderInfo;
    }

    public PorderRefundTransAtomRspBo getOrderRefundTrans(String refundOrderId) {
        PorderRefundTransAtomRspBo refundTransInfo;
        PorderRefundTransAtomReqBo queryRefundTrans = new PorderRefundTransAtomReqBo();
        queryRefundTrans.setRefundOrderId(refundOrderId);
        try {
            refundTransInfo = this.porderRefundTransAtomService.queryOrderRefundTransByRefundOrderId(queryRefundTrans);
        }
        catch (Exception e) {
            LOG.error("\u67e5\u8be2\u9000\u6b3e\u6d41\u6c34(refundOrderId=" + refundOrderId + ")\u5f02\u5e38");
            throw new BusinessException("6025", "\u67e5\u8be2\u9000\u6b3e\u6d41\u6c34(refundOrderId=" + refundOrderId + ")\u5f02\u5e38");
        }
        if (refundTransInfo == null) {
            LOG.error("\u67e5\u8be2\u9000\u6b3e\u6d41\u6c34(refundOrderId = " + refundOrderId + ")\u8fd4\u56de\u7a7a\u503c");
            throw new BusinessException("6025", "\u67e5\u8be2\u9000\u6b3e\u6d41\u6c34(refundOrderId = " + refundOrderId + ")\u8fd4\u56de\u7a7a\u503c");
        }
        return refundTransInfo;
    }

    private String getTxnType(PorderPayTransAtomRspBo orderInfo) {
        String tradeTime;
        String nowTime = DateUtils.dateToStrYYYYMMdd((Date)this.payMethodMapper.getDBDate().getDate());
        if (Objects.equals(nowTime, tradeTime = orderInfo.getTradeTime())) {
            return "31";
        }
        return "04";
    }

    private String validataQryArg(PayAbleQryPayStatusReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027payOrderId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getParaMap())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027paraMap\u4e0d\u80fd\u4e3a\u7a7a";
        }
        String merId = (String)reqBo.getParaMap().get("merId");
        if (StringUtils.isEmpty((Object)merId)) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027paraMap\u4e2d(merid)\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }

    private String validataRefundArg(PayAbleRefundReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027payOrderId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getParaMap())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027paraMap\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getRefundFee())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027refundFee\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getRefundOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027refundOrderId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        String merId = (String)reqBo.getParaMap().get("merId");
        if (StringUtils.isEmpty((Object)merId)) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027paraMap\u4e2d(merid)\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

