/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.service.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.tydic.payment.pay.atom.BusiSystemInfoAtomService;
import com.tydic.payment.pay.atom.CashierTemplateAtomService;
import com.tydic.payment.pay.atom.RelBusiCashierAtomService;
import com.tydic.payment.pay.bo.BaseRspInfoBO;
import com.tydic.payment.pay.busi.QueryDBDateBusiService;
import com.tydic.payment.pay.busi.QueryPCodeInfoService;
import com.tydic.payment.pay.busi.bo.QueryPCodeInfoReqBO;
import com.tydic.payment.pay.busi.bo.QueryPCodeInfoRspBO;
import com.tydic.payment.pay.dao.po.BusiSystemInfoPO;
import com.tydic.payment.pay.dao.po.CashierTemplatePo;
import com.tydic.payment.pay.dao.po.RelBusiCashierPo;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.rsa.util.RsaEncodeUtil;
import com.tydic.payment.pay.web.bo.req.AddBusiSystemRelReqWayWebReqBo;
import com.tydic.payment.pay.web.bo.req.AddInfoBusiSystemWebReqBo;
import com.tydic.payment.pay.web.bo.rsp.AddInfoBusiSystemWebRspBo;
import com.tydic.payment.pay.web.service.AddInfoBusiSystemSimpleWebService;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="addInfoBusiSystemSimpleWebService")
@HSFProvider(serviceVersion="2.0-SNAPSHOT", serviceGroup="PAY_GROUP_LOCAL", serviceInterface=AddInfoBusiSystemSimpleWebService.class)
public class AddInfoBusiSystemSimpleWebServiceImpl
implements AddInfoBusiSystemSimpleWebService {
    private static final Logger log = LoggerFactory.getLogger(AddInfoBusiSystemSimpleWebServiceImpl.class);
    private static String SERVICE = "AddInfoBusiSystemSimpleWebService";
    private static String SERVICE_NAME = "\u65b0\u589e\u4e1a\u52a1\u7cfb\u7edf\u670d\u52a1\u7b80\u5355\u7248";
    @Autowired
    private BusiSystemInfoAtomService busiSystemInfoAtomService;
    @Autowired
    private RelBusiCashierAtomService relBusiCashierAtomService;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;
    @Autowired
    private CashierTemplateAtomService cashierTemplateAtomService;
    @Autowired
    QueryPCodeInfoService queryPCodeInfoService;

    public AddInfoBusiSystemWebRspBo addBusiSystemInfo(AddInfoBusiSystemWebReqBo reqBo) {
        log.info(SERVICE_NAME + " -> " + SERVICE + " \uff1a\u5f53\u524d\u65b9\u6cd5\u4e3aaddBusiSystemInfo [\u6dfb\u52a0\u4e1a\u52a1\u7cfb\u7edf\u57fa\u672c\u4fe1\u606f]");
        log.info(SERVICE + " -> addBusiSystemInfo()\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        AddInfoBusiSystemWebRspBo rspBo = new AddInfoBusiSystemWebRspBo();
        String validateArgStr = this.validateArgWithBaseInfo(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            rspBo.setRspCode("RSP_CODE_PARA_NOT_NULL");
            rspBo.setRspName("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return rspBo;
        }
        BusiSystemInfoPO addPo = new BusiSystemInfoPO();
        addPo.setBusiCode(reqBo.getBusiCode());
        List<BusiSystemInfoPO> qryBusiCodeSystemList = this.busiSystemInfoAtomService.queryBusiSystemInfoByCondition(addPo);
        if (!CollectionUtils.isEmpty(qryBusiCodeSystemList)) {
            rspBo.setRspCode("8888");
            rspBo.setRspName("\u65b0\u589e\u4e1a\u52a1\u7cfb\u7edf\u670d\u52a1\u5931\u8d25\uff1a\u5bf9\u5e94\u4e1a\u52a1\u7cfb\u7edfbusiCode\u5df2\u5b58\u5728");
            return rspBo;
        }
        BusiSystemInfoPO insertBusiPo = new BusiSystemInfoPO();
        Map map = new HashMap();
        try {
            map = RsaEncodeUtil.generateRSAKeys();
            BeanUtils.copyProperties((Object)reqBo, (Object)insertBusiPo);
            insertBusiPo.setCallType(Integer.valueOf(reqBo.getCallType()));
            insertBusiPo.setRsaPrivateKey((String)map.get("private"));
            insertBusiPo.setRsaPublicKey((String)map.get("public"));
            insertBusiPo.setSignKey(RsaEncodeUtil.getRandomStringByLength((int)32));
            if (!StringUtils.isEmpty((Object)reqBo.getOperId())) {
                insertBusiPo.setCreateOperId(reqBo.getOperId());
            }
            insertBusiPo.setCreateTime(this.queryDBDateBusiService.getDBDate());
        }
        catch (NoSuchAlgorithmException e) {
            log.error("\u65b0\u589e\u4e1a\u52a1\u7cfb\u7edf\u5931\u8d25\uff1a\u751f\u6210\u516c\u94a5\u79c1\u94a5\u5f02\u5e38");
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u65b0\u589e\u4e1a\u52a1\u7cfb\u7edf\u5931\u8d25\uff1a\u751f\u6210\u516c\u94a5\u79c1\u94a5\u5f02\u5e38");
        }
        Long crateBusiSystemId = this.busiSystemInfoAtomService.crateBusiSystemInfo(insertBusiPo);
        if (crateBusiSystemId == null) {
            rspBo.setRspCode("8888");
            rspBo.setRspName("\u65b0\u589e\u4e1a\u52a1\u7cfb\u7edf\u672a\u8fd4\u56de\u4e1a\u52a1\u7cfb\u7edfID");
            return rspBo;
        }
        BusiSystemInfoPO qryBusiInfo = this.busiSystemInfoAtomService.queryBusiSystemInfoById(crateBusiSystemId);
        if (qryBusiInfo == null) {
            rspBo.setRspCode("8888");
            rspBo.setRspName("\u63d2\u5165\u5931\u8d25\uff0c\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728\u8be5\u4e1a\u52a1\u7cfb\u7edf\u4fe1\u606f");
            return rspBo;
        }
        BeanUtils.copyProperties((Object)qryBusiInfo, (Object)rspBo);
        rspBo.setBusiId(crateBusiSystemId.toString());
        rspBo.setCreateTime(qryBusiInfo.getCreateTime() == null ? "" : new DateTime((Object)qryBusiInfo.getCreateTime()).toString("yyyy-MM-dd HH:mm:ss"));
        if (!StringUtils.isEmpty((Object)qryBusiInfo.getState())) {
            rspBo.setState(qryBusiInfo.getState());
            QueryPCodeInfoReqBO qryStateReq = new QueryPCodeInfoReqBO();
            qryStateReq.setTypeCode("BUSI_SYSTEM_STATE");
            qryStateReq.setCodeValue(qryBusiInfo.getState());
            QueryPCodeInfoRspBO qryStateRsp = this.queryPCodeInfoService.queryPCodeInfo(qryStateReq);
            if (qryStateRsp.getRespCode().equals("0000")) {
                rspBo.setStateName(qryStateRsp.getCodeInfo());
            }
        }
        if (qryBusiInfo.getCallType() != null) {
            rspBo.setCallType(qryBusiInfo.getCallType().toString());
            QueryPCodeInfoReqBO qryCallTypeReq = new QueryPCodeInfoReqBO();
            qryCallTypeReq.setTypeCode("BUSI_SYSTEM_CALL_TYPE");
            qryCallTypeReq.setCodeValue(qryBusiInfo.getCallType().toString());
            QueryPCodeInfoRspBO qryCallTypeRsp = this.queryPCodeInfoService.queryPCodeInfo(qryCallTypeReq);
            if (qryCallTypeRsp.getRespCode().equals("0000")) {
                rspBo.setCallTypeName(qryCallTypeRsp.getCodeInfo());
            }
        }
        if (!StringUtils.isEmpty((Object)qryBusiInfo.getEncrypt())) {
            rspBo.setEncrypt(qryBusiInfo.getEncrypt());
            QueryPCodeInfoReqBO qryEncryptReq = new QueryPCodeInfoReqBO();
            qryEncryptReq.setTypeCode("BUSI_SYSTEM_ENCRYPT");
            qryEncryptReq.setCodeValue(qryBusiInfo.getEncrypt());
            QueryPCodeInfoRspBO qryEncryptRsp = this.queryPCodeInfoService.queryPCodeInfo(qryEncryptReq);
            if (qryEncryptRsp.getRespCode().equals("0000")) {
                rspBo.setEncryptName(qryEncryptRsp.getCodeInfo());
            }
        }
        rspBo.setRspCode("0000");
        rspBo.setRspName("\u65b0\u589e\u6210\u529f");
        return rspBo;
    }

    private String validateArgWithBaseInfo(AddInfoBusiSystemWebReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2bo\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getBusiName())) {
            return "BusiName\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getState())) {
            return "State\u4e0d\u80fd\u4e3a\u7a7a";
        }
        String reqBoState = reqBo.getState().trim();
        if (!("1".equals(reqBoState) || "-1".equals(reqBoState) || "0".equals(reqBoState))) {
            return "State\u5fc5\u987b\u4e3a1\uff0c-1\u6216\u80050";
        }
        return null;
    }

    public BaseRspInfoBO addBusiSystemRelCashierTemplate(AddBusiSystemRelReqWayWebReqBo reqBo) {
        log.info(SERVICE_NAME + " -> " + SERVICE + " \uff1a\u5f53\u524d\u65b9\u6cd5\u4e3aaddBusiSystemRelCashierTemplate [\u6dfb\u52a0\u4e1a\u52a1\u7cfb\u7edf\u3001reqWay\u3001cashierTemplate\u5173\u8054\u4fe1\u606f]");
        log.info(SERVICE + " -> addBusiSystemRelCashierTemplate()\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        BaseRspInfoBO rspBo = new BaseRspInfoBO();
        String validateArgStr = this.validateArgWithBusiRelReqWay(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            rspBo.setRspCode("RSP_CODE_PARA_NOT_NULL");
            rspBo.setRspCode("\u5165\u53c2\u6821\u9a8c\u5931\u8d25" + validateArgStr);
            return rspBo;
        }
        rspBo.setRspCode("8888");
        rspBo.setRspName("\u5931\u8d25");
        Long busiId = Long.valueOf(reqBo.getBusiId());
        BusiSystemInfoPO busiIsExit = this.busiSystemInfoAtomService.queryBusiSystemInfoById(busiId);
        if (busiIsExit == null) {
            rspBo.setRspName("\u4e1a\u52a1\u7cfb\u7edfID\u4e0d\u5b58\u5728");
            return rspBo;
        }
        QueryPCodeInfoReqBO qryReqWayBo = new QueryPCodeInfoReqBO();
        qryReqWayBo.setTypeCode("BUSI_SYSTEM_REQ_WAY");
        qryReqWayBo.setCodeValue(reqBo.getReqWay());
        QueryPCodeInfoRspBO qryReqWayRsp = this.queryPCodeInfoService.queryPCodeInfo(qryReqWayBo);
        if (qryReqWayRsp.getRespCode().equals("0000")) {
            if (StringUtils.isEmpty((Object)qryReqWayRsp.getCodeInfo())) {
                log.info("\u8c03\u7528\u670d\u52a1 -> com.tydic.payment.pay.busi.api.QueryPCodeInfoService\u51fa\u9519");
                rspBo.setRspCode("8888");
                rspBo.setRspName("\u67e5\u8be2\u5931\u8d25\uff0c\u672a\u8fd4\u56de\u63a5\u5165\u65b9\u5f0f\u76f8\u5173\u4fe1\u606f");
                return rspBo;
            }
        } else {
            rspBo.setRspCode("8888");
            rspBo.setRspName("\u63a5\u5165\u65b9\u5f0f\u5728\u6570\u636e\u5b57\u5178\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u914d\u7f6e\u6570\u636e\u5b57\u5178");
            return rspBo;
        }
        RelBusiCashierPo qryRelBusiPo = new RelBusiCashierPo();
        qryRelBusiPo.setBusiId(Long.valueOf(reqBo.getBusiId()));
        qryRelBusiPo.setReqWay(reqBo.getReqWay());
        List<RelBusiCashierPo> qrtRelBusiList = this.relBusiCashierAtomService.queryRelBusiCashier(qryRelBusiPo);
        if (!CollectionUtils.isEmpty(qrtRelBusiList)) {
            rspBo.setRspName("\u8be5\u63a5\u5165\u65b9\u5f0f\u5df2\u5b58\u5728\uff0c\u65e0\u6cd5\u65b0\u589e\uff0c\u8bf7\u9009\u62e9\u4fee\u6539\u64cd\u4f5c");
            rspBo.setRspCode("8888");
            return rspBo;
        }
        String cashierTemps = reqBo.getCashierTemplate();
        ArrayList<Long> cashierL = new ArrayList<Long>();
        if (!StringUtils.isEmpty((Object)cashierTemps)) {
            try {
                String[] cashierListStr = cashierTemps.split(",");
                if (cashierListStr.length == 0) {
                    rspBo.setRspCode("8888");
                    rspBo.setRspName("\u4f20\u5165\u6536\u94f6\u53f0\u6a21\u677f\u683c\u5f0f\u4e0d\u7b26\u5408\u8981\u6c42");
                    return rspBo;
                }
                cashierL = new ArrayList(cashierListStr.length);
                for (String cashierId : cashierListStr) {
                    cashierL.add(Long.parseLong(cashierId));
                }
            }
            catch (NumberFormatException e) {
                rspBo.setRspCode("8888");
                rspBo.setRspName("\u5b57\u6bb5\u3010attrIds\u3011\u683c\u5f0f\u9519\u8bef");
                return rspBo;
            }
        }
        for (Long tempCash : cashierL) {
            CashierTemplatePo queryCashierTemplateByCondition = this.cashierTemplateAtomService.queryCashierTemplateById(tempCash);
            if (queryCashierTemplateByCondition == null) {
                log.error("\u6a21\u677f" + reqBo.getCashierTemplate() + "\u4e0d\u5b58\u5728");
                continue;
            }
            RelBusiCashierPo qryRelBusiCashier = new RelBusiCashierPo();
            qryRelBusiCashier.setBusiId(busiId);
            qryRelBusiCashier.setCashierTemplate(tempCash);
            qryRelBusiCashier.setReqWay(reqBo.getReqWay());
            List<RelBusiCashierPo> qryRelList = this.relBusiCashierAtomService.queryRelBusiCashier(qryRelBusiCashier);
            if (!CollectionUtils.isEmpty(qryRelList)) continue;
            RelBusiCashierPo relBCPo = new RelBusiCashierPo();
            relBCPo.setBusiId(Long.valueOf(reqBo.getBusiId()));
            relBCPo.setReqWay(reqBo.getReqWay());
            relBCPo.setCashierTemplate(tempCash);
            if (!StringUtils.isEmpty((Object)reqBo.getOperId())) {
                relBCPo.setCreateOperId(reqBo.getOperId());
            }
            relBCPo.setCreateTime(this.queryDBDateBusiService.getDBDate());
            this.relBusiCashierAtomService.createRelBusiCashier(relBCPo);
        }
        rspBo.setRspCode("0000");
        rspBo.setRspName("\u751f\u6210\u4e1a\u52a1\u7cfb\u7edf\u63a5\u5165\u65b9\u5f0f\u6210\u529f\uff01");
        return rspBo;
    }

    private String validateArgWithBusiRelReqWay(AddBusiSystemRelReqWayWebReqBo reqBo) {
        if (reqBo == null) {
            return "bo\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getBusiId())) {
            return "BusiId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getReqWay())) {
            return "\u63a5\u5165\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getCashierTemplate())) {
            return "\u6536\u94f6\u53f0\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

