/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.service.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.payment.pay.atom.MerchantInfoAtomService;
import com.tydic.payment.pay.busi.QueryDBDateBusiService;
import com.tydic.payment.pay.busi.QueryPCodeInfoService;
import com.tydic.payment.pay.busi.bo.QueryPCodeInfoReqBO;
import com.tydic.payment.pay.busi.bo.QueryPCodeInfoRspBO;
import com.tydic.payment.pay.dao.po.MerChantInfoPo;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.web.bo.req.AddMechartBaseInfoWebReqBo;
import com.tydic.payment.pay.web.bo.rsp.AddInfoMechartWebRspBo;
import com.tydic.payment.pay.web.service.AddInfoMechartWebService;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="addInfoMechartWebService")
@HSFProvider(serviceVersion="2.0-SNAPSHOT", serviceGroup="PAY_GROUP_LOCAL", serviceInterface=AddInfoMechartWebService.class)
public class AddInfoMechartWebServiceImpl
implements AddInfoMechartWebService {
    private static final Logger log = LoggerFactory.getLogger(AddInfoMechartWebServiceImpl.class);
    @Autowired
    private MerchantInfoAtomService merchantInfoAtomService;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;
    @Autowired
    private QueryPCodeInfoService queryPCodeInfoService;

    public AddInfoMechartWebRspBo addMainMerchant(AddMechartBaseInfoWebReqBo reqBo) {
        log.info("AddInfoMechartWebService-\u4e3b\u5546\u6237\u65b0\u589e\u5165\u53c2\uff1a" + reqBo);
        AddInfoMechartWebRspBo rsp = new AddInfoMechartWebRspBo();
        try {
            QueryPCodeInfoRspBO qryPCodeRsp;
            this.validateReqWithMainMerchant(reqBo);
            MerChantInfoPo createMerPo = new MerChantInfoPo();
            BeanUtils.copyProperties((Object)reqBo, (Object)createMerPo);
            createMerPo.setMerchantType(Integer.valueOf("1"));
            if (!StringUtils.isEmpty((Object)reqBo.getOperId())) {
                createMerPo.setCreateOperId(reqBo.getOperId());
            }
            createMerPo.setCreateTime(this.queryDBDateBusiService.getDBDate());
            Long createMerChantId = this.merchantInfoAtomService.createMerChantInfo(createMerPo);
            MerChantInfoPo resultPo = this.merchantInfoAtomService.queryMerchantInfoById(createMerChantId);
            BeanUtils.copyProperties((Object)resultPo, (Object)rsp);
            rsp.setMerchantId(resultPo.getMerchantId().toString());
            rsp.setCreateTime(resultPo.getCreateTime() == null ? "" : new DateTime((Object)resultPo.getCreateTime()).toString("yyyy-MM-dd HH:mm:ss"));
            if (!StringUtils.isEmpty((Object)resultPo.getFlag())) {
                QueryPCodeInfoReqBO qryPCodeReqF = new QueryPCodeInfoReqBO();
                qryPCodeReqF.setTypeCode("MERCHANT_FLAG");
                qryPCodeReqF.setCodeValue(resultPo.getFlag());
                qryPCodeRsp = this.queryPCodeInfoService.queryPCodeInfo(qryPCodeReqF);
                if (qryPCodeRsp.getRespCode().equals("0000")) {
                    rsp.setFlag(qryPCodeRsp.getCodeInfo());
                }
            }
            if (resultPo.getMerchantType() != null) {
                rsp.setMerchantType(resultPo.getMerchantType() == null ? "" : resultPo.getMerchantType().toString());
                QueryPCodeInfoReqBO qryPCodeReq = new QueryPCodeInfoReqBO();
                qryPCodeReq.setTypeCode("MERCHANT_TYPE");
                qryPCodeReq.setCodeValue(resultPo.getMerchantType().toString().trim());
                qryPCodeRsp = this.queryPCodeInfoService.queryPCodeInfo(qryPCodeReq);
                if (qryPCodeRsp.getRespCode().equals("0000")) {
                    rsp.setMerchantType(qryPCodeRsp.getCodeInfo());
                }
            }
            rsp.setRspCode("0000");
            rsp.setRspName("\u6210\u529f");
        }
        catch (Exception e) {
            log.info("AddInfoMechartWebService-\u4e3b\u5546\u6237\u65b0\u589e\u5f02\u5e38" + e);
            rsp.setRspCode("8888");
            rsp.setRspCode("\u670d\u52a1\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return rsp;
    }

    private void validateReqWithMainMerchant(AddMechartBaseInfoWebReqBo req) {
        if (req == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getMerchantName())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u3010merchantName\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!StringUtils.isEmpty((Object)req.getMainMerchantId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u6b64\u65b9\u6cd5\u53ea\u80fd\u65b0\u589e\u4e3b\u5546\u6237\uff0c\u4e0d\u80fd\u65b0\u589e\u5b50\u5546\u6237\uff01");
        }
    }

    public AddInfoMechartWebRspBo addSubMerchant(AddMechartBaseInfoWebReqBo reqBo) {
        log.info("AddInfoMechartWebService-\u5b50\u5546\u6237\u65b0\u589e\u5165\u53c2\uff1a" + reqBo);
        AddInfoMechartWebRspBo rsp = new AddInfoMechartWebRspBo();
        try {
            QueryPCodeInfoRspBO qryPCodeRsp;
            this.validateReqWithSubMerchant(reqBo);
            MerChantInfoPo createMerPo = new MerChantInfoPo();
            BeanUtils.copyProperties((Object)reqBo, (Object)createMerPo);
            createMerPo.setMerchantType(Integer.valueOf("2"));
            createMerPo.setMainMerchantId(Long.valueOf(reqBo.getMainMerchantId()));
            if (!StringUtils.isEmpty((Object)reqBo.getOperId())) {
                createMerPo.setCreateOperId(reqBo.getOperId());
            }
            createMerPo.setCreateTime(this.queryDBDateBusiService.getDBDate());
            Long createMerChantId = this.merchantInfoAtomService.createMerChantInfo(createMerPo);
            MerChantInfoPo result = this.merchantInfoAtomService.queryMerchantInfoById(createMerChantId);
            BeanUtils.copyProperties((Object)result, (Object)rsp);
            rsp.setMerchantId(result.getMerchantId().toString());
            rsp.setCreateTime(result.getCreateTime() == null ? "" : new DateTime((Object)result.getCreateTime()).toString("yyyy-MM-dd HH:mm:ss"));
            if (!StringUtils.isEmpty((Object)result.getFlag())) {
                QueryPCodeInfoReqBO qryPCodeReqF = new QueryPCodeInfoReqBO();
                qryPCodeReqF.setCodeValue(result.getFlag());
                qryPCodeReqF.setTypeCode("MERCHANT_FLAG");
                qryPCodeRsp = this.queryPCodeInfoService.queryPCodeInfo(qryPCodeReqF);
                if (qryPCodeRsp.getRespCode().equals("0000")) {
                    rsp.setFlag(qryPCodeRsp.getCodeInfo());
                }
            }
            if (result.getMerchantType() != null) {
                rsp.setMerchantType(result.getMerchantType() == null ? "" : result.getMerchantType().toString());
                QueryPCodeInfoReqBO qryPCodeReq = new QueryPCodeInfoReqBO();
                qryPCodeReq.setCodeValue(result.getMerchantType().toString().trim());
                qryPCodeReq.setTypeCode("MERCHANT_TYPE");
                qryPCodeRsp = this.queryPCodeInfoService.queryPCodeInfo(qryPCodeReq);
                if (qryPCodeRsp.getRespCode().equals("0000")) {
                    rsp.setMerchantType(qryPCodeRsp.getCodeInfo());
                }
            }
            rsp.setRspCode("0000");
            rsp.setRspName("\u5b50\u5546\u6237\u65b0\u589e\u6210\u529f");
        }
        catch (Exception e) {
            log.info("AddInfoMechartWebService-\u5b50\u5546\u6237\u65b0\u589e\u5f02\u5e38" + e);
            rsp.setRspCode("8888");
            rsp.setRspCode("\u670d\u52a1\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return rsp;
    }

    private void validateReqWithSubMerchant(AddMechartBaseInfoWebReqBo req) {
        if (req == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getMerchantName())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u3010merchantName\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getMainMerchantId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u65b0\u589e\u5b50\u5546\u6237\uff0c\u5e94\u5f53\u4f20\u5165\u4e3b\u5546\u6237ID\uff01");
        }
    }
}

