/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.service.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.tydic.payment.pay.atom.PayMethodAtomService;
import com.tydic.payment.pay.atom.PayRuleParaAtomService;
import com.tydic.payment.pay.atom.PaymentInsAtomService;
import com.tydic.payment.pay.bo.BaseRspInfoBO;
import com.tydic.payment.pay.busi.QueryDBDateBusiService;
import com.tydic.payment.pay.dao.po.PayMethodPo;
import com.tydic.payment.pay.dao.po.PayRuleParaPo;
import com.tydic.payment.pay.dao.po.PaymentInsPo;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.web.bo.req.AddPaymentBaseInfoReqBo;
import com.tydic.payment.pay.web.bo.req.AddPaymentPayMethodWebReqBo;
import com.tydic.payment.pay.web.bo.req.AddPaymentPayRuleParaWebReqBo;
import com.tydic.payment.pay.web.bo.rsp.AddPaymentBaseInfoRspBo;
import com.tydic.payment.pay.web.service.AddPaymentInsForPaycenterWebService;
import java.util.List;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="addPaymentInsForPaycenterWebService")
@HSFProvider(serviceVersion="2.0-SNAPSHOT", serviceGroup="PAY_GROUP_LOCAL", serviceInterface=AddPaymentInsForPaycenterWebService.class)
public class AddPaymentInsForPaycenterWebServiceImpl
implements AddPaymentInsForPaycenterWebService {
    private static final Logger log = LoggerFactory.getLogger(AddPaymentInsForPaycenterWebServiceImpl.class);
    @Autowired
    private PaymentInsAtomService paymentInsAtomService;
    @Autowired
    private PayRuleParaAtomService payRuleParaAtomService;
    @Autowired
    private PayMethodAtomService payMethodAtomService;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;

    public AddPaymentBaseInfoRspBo addPaymentInsBaseInfo(AddPaymentBaseInfoReqBo reqBo) {
        log.info("\u65b0\u589e\u652f\u4ed8\u673a\u6784\u57fa\u672c\u4fe1\u606fweb\u670d\u52a1\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        AddPaymentBaseInfoRspBo rspBo = new AddPaymentBaseInfoRspBo();
        this.validateArg(reqBo);
        if (!StringUtils.isEmpty((Object)reqBo.getPaymentInsId())) {
            Long addPaymentInsId;
            PaymentInsPo paymentInsPo = new PaymentInsPo();
            paymentInsPo.setPaymentInsId(Long.valueOf(reqBo.getPaymentInsId()));
            List<PaymentInsPo> paymentList = this.paymentInsAtomService.queryPaymentInf(paymentInsPo);
            if (paymentList.size() > 0) {
                rspBo.setRspCode("8888");
                rspBo.setRspName("\u65b0\u589e\u5931\u8d25:\u652f\u4ed8\u673a\u6784ID\u5df2\u5b58\u5728\uff0c\u8bf7\u6362\u4e00\u4e2a\u652f\u4ed8\u673a\u6784ID\uff0c\u6216\u8005\u4e0d\u586b\u5165");
                log.info("\u65b0\u589e\u652f\u4ed8\u673a\u6784\u5931\u8d25\uff0c\u652f\u4ed8\u673a\u6784ID\u5728\u8868\u4e2d\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u6362\u4e00\u4e2a\u652f\u4ed8\u673a\u6784ID\uff0c\u6216\u8005\u4e0d\u586b\u5165\u652f\u4ed8\u673a\u6784ID");
                return rspBo;
            }
            PaymentInsPo addPaymentPo = new PaymentInsPo();
            BeanUtils.copyProperties((Object)reqBo, (Object)addPaymentPo);
            addPaymentPo.setPaymentInsId(Long.valueOf(reqBo.getPaymentInsId()));
            addPaymentPo.setCreateTime(this.queryDBDateBusiService.getDBDate());
            if (StringUtils.isEmpty((Object)reqBo.getOperId())) {
                addPaymentPo.setCreateOperId(reqBo.getOperId());
            }
            if ((addPaymentInsId = this.paymentInsAtomService.createPaymentInfWithId(addPaymentPo)) == null) {
                rspBo.setRspCode("8888");
                rspBo.setRspName("\u63d2\u5165\u6210\u529f\u540e\uff0c\u6ca1\u6709\u8fd4\u56de\u652f\u4ed8\u673a\u6784ID");
                return rspBo;
            }
            PaymentInsPo qryPaymentInsPo = new PaymentInsPo();
            qryPaymentInsPo.setPaymentInsId(addPaymentInsId);
            List<PaymentInsPo> qryPaymentList = this.paymentInsAtomService.queryPaymentInf(qryPaymentInsPo);
            if (CollectionUtils.isEmpty(qryPaymentList)) {
                rspBo.setRspCode("8888");
                rspBo.setRspName("\u63d2\u5165\u5931\u8d25\uff0c\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728\u8be5\u652f\u4ed8\u673a\u6784\u4fe1\u606f");
                return rspBo;
            }
            PaymentInsPo resultPo = qryPaymentList.get(0);
            BeanUtils.copyProperties((Object)resultPo, (Object)rspBo);
            rspBo.setCreateTime(resultPo.getCreateTime() == null ? "" : new DateTime((Object)resultPo.getCreateTime()).toString("yyyy-MM-dd HH:mm:ss"));
            rspBo.setPaymentInsId(resultPo.getPaymentInsId().toString());
            rspBo.setRspCode("0000");
            rspBo.setRspName("\u65b0\u589e\u6210\u529f");
            return rspBo;
        }
        PaymentInsPo addPaymentPo = new PaymentInsPo();
        BeanUtils.copyProperties((Object)reqBo, (Object)addPaymentPo);
        if (!StringUtils.isEmpty((Object)reqBo.getOperId())) {
            addPaymentPo.setCreateOperId(reqBo.getOperId());
        }
        addPaymentPo.setCreateTime(this.queryDBDateBusiService.getDBDate());
        Long addPayId = this.paymentInsAtomService.createPaymentInf(addPaymentPo);
        if (addPayId == null) {
            rspBo.setRspCode("8888");
            rspBo.setRspName("\u63d2\u5165\u6210\u529f\u540e\uff0c\u6ca1\u6709\u8fd4\u56de\u652f\u4ed8\u673a\u6784ID");
            return rspBo;
        }
        PaymentInsPo qryPaymentInsPo = new PaymentInsPo();
        qryPaymentInsPo.setPaymentInsId(addPayId);
        List<PaymentInsPo> qryPaymentList = this.paymentInsAtomService.queryPaymentInf(qryPaymentInsPo);
        if (CollectionUtils.isEmpty(qryPaymentList)) {
            rspBo.setRspCode("8888");
            rspBo.setRspName("\u63d2\u5165\u5931\u8d25\uff0c\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728\u8be5\u652f\u4ed8\u673a\u6784\u4fe1\u606f");
            return rspBo;
        }
        PaymentInsPo resultPo = qryPaymentList.get(0);
        BeanUtils.copyProperties((Object)resultPo, (Object)rspBo);
        rspBo.setCreateTime(resultPo.getCreateTime() == null ? "" : new DateTime((Object)resultPo.getCreateTime()).toString("yyyy-MM-dd HH:mm:ss"));
        rspBo.setPaymentInsId(resultPo.getPaymentInsId().toString());
        rspBo.setRspCode("0000");
        rspBo.setRspName("\u65b0\u589e\u6210\u529f");
        return rspBo;
    }

    private void validateArg(AddPaymentBaseInfoReqBo reqBo) {
        if (reqBo == null) {
            log.info("\u65b0\u589e\u652f\u4ed8\u673a\u6784web\u670d\u52a1\u5f02\u5e38\uff1a\u5165\u53c2bo\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getPaymentInsName())) {
            log.info("\u65b0\u589e\u652f\u4ed8\u673a\u6784web\u670d\u52a1\u5f02\u5e38\uff1a\u5165\u53c2bo\u5bf9\u8c61\u5c5e\u6027PaymentInsName\u4e0d\u80fd\u4e3a\u7a7a");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u673a\u6784\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public BaseRspInfoBO addPaymentPayRulePara(AddPaymentPayRuleParaWebReqBo reqBo) {
        log.info("\u65b0\u589e\u652f\u4ed8\u673a\u6784\u652f\u4ed8\u53c2\u6570web\u670d\u52a1\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        BaseRspInfoBO rspBo = new BaseRspInfoBO();
        this.validateArgWithPayRulePara(reqBo);
        PaymentInsPo qryPaymentInsPo = new PaymentInsPo();
        qryPaymentInsPo.setPaymentInsId(reqBo.getPaymentInsId());
        List<PaymentInsPo> qryPaymentList = this.paymentInsAtomService.queryPaymentInf(qryPaymentInsPo);
        if (CollectionUtils.isEmpty(qryPaymentList)) {
            rspBo.setRspCode("8888");
            rspBo.setRspName("\u652f\u4ed8\u53c2\u6570\u65b0\u589e\u5931\u8d25\uff0c\u652f\u4ed8\u673a\u6784\u4fe1\u606f\u4e0d\u5b58\u5728");
            return rspBo;
        }
        PayRuleParaPo qryPara = new PayRuleParaPo();
        qryPara.setPaymentInsId(reqBo.getPaymentInsId());
        qryPara.setParameterCode(reqBo.getParameterCode());
        List<PayRuleParaPo> qryParaList = this.payRuleParaAtomService.queryPayRuleParaByCondition(qryPara);
        if (!CollectionUtils.isEmpty(qryParaList)) {
            rspBo.setRspCode("8888");
            rspBo.setRspName("\u652f\u4ed8\u53c2\u6570\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u63d2\u5165\u76f8\u540c\u7684\u652f\u4ed8\u53c2\u6570\u7f16\u7801");
            return rspBo;
        }
        PayRuleParaPo tpo = new PayRuleParaPo();
        BeanUtils.copyProperties((Object)reqBo, (Object)tpo);
        if (!StringUtils.isEmpty((Object)reqBo.getNoNeedInput())) {
            tpo.setNoNeedInput(reqBo.getNoNeedInput());
        }
        if (!StringUtils.isEmpty((Object)reqBo.getOperId())) {
            tpo.setCreateOperId(reqBo.getOperId());
        }
        tpo.setPaymentInsId(reqBo.getPaymentInsId());
        tpo.setCreateTime(this.queryDBDateBusiService.getDBDate());
        Long addParaId = this.payRuleParaAtomService.createPayRulePara(tpo);
        if (addParaId != null) {
            PayRuleParaPo qryParaPo2 = new PayRuleParaPo();
            qryParaPo2.setId(addParaId);
            PayRuleParaPo resultPo = this.payRuleParaAtomService.queryPayRuleParaById(qryParaPo2);
            if (resultPo == null) {
                rspBo.setRspCode("8888");
                rspBo.setRspName("\u65b0\u589e\u5931\u8d25\uff0c\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728\u8be5\u652f\u4ed8\u53c2\u6570\u7684\u4fe1\u606f");
                return rspBo;
            }
        }
        rspBo.setRspCode("0000");
        rspBo.setRspName("\u652f\u4ed8\u53c2\u6570\u65b0\u589e\u6210\u529f");
        return rspBo;
    }

    private void validateArgWithPayRulePara(AddPaymentPayRuleParaWebReqBo reqBo) {
        if (reqBo == null) {
            log.info("\u65b0\u589e\u652f\u4ed8\u673a\u6784\u652f\u4ed8\u53c2\u6570web\u670d\u52a1\u5f02\u5e38\uff1a\u5165\u53c2bo\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getPaymentInsId())) {
            log.info("\u65b0\u589e\u652f\u4ed8\u673a\u6784\u652f\u4ed8\u53c2\u6570web\u670d\u52a1\u5f02\u5e38\uff1a\u5165\u53c2bo\u5bf9\u8c61\u5c5e\u6027PaymentInsId\u4e0d\u80fd\u4e3a\u7a7a");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u673a\u6784ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getParameterCode())) {
            log.info("\u65b0\u589e\u652f\u4ed8\u673a\u6784\u652f\u4ed8\u53c2\u6570web\u670d\u52a1\u5f02\u5e38\uff1a\u5165\u53c2bo\u5bf9\u8c61\u5c5e\u6027ParameterCode\u4e0d\u80fd\u4e3a\u7a7a");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u53c2\u6570\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getStoreType())) {
            log.info("\u65b0\u589e\u652f\u4ed8\u673a\u6784\u652f\u4ed8\u53c2\u6570web\u670d\u52a1\u5f02\u5e38\uff1a\u5165\u53c2bo\u5bf9\u8c61\u5c5e\u6027\u5b58\u50a8\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u53c2\u6570\u5b58\u50a8\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!reqBo.getStoreType().equals("2") && !reqBo.getStoreType().equals("1")) {
            log.info("\u65b0\u589e\u652f\u4ed8\u673a\u6784\u652f\u4ed8\u53c2\u6570web\u670d\u52a1\u5f02\u5e38\uff1a\u5165\u53c2bo\u5bf9\u8c61\u5c5e\u6027\u5b58\u50a8\u7c7b\u578b\u4e0d\u7b26\u5408\u89c4\u8303\uff0c\u8bf7\u9009\u62e91\u62162");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u53c2\u6570\u5b58\u50a8\u7c7b\u578b\u4e0d\u7b26\u5408\u89c4\u8303");
        }
    }

    public BaseRspInfoBO addPaymentPayMethod(AddPaymentPayMethodWebReqBo reqBo) {
        log.info("\u65b0\u589e\u652f\u4ed8\u673a\u6784\u652f\u4ed8\u53c2\u6570web\u670d\u52a1\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        BaseRspInfoBO rspBo = new BaseRspInfoBO();
        this.validateArgWithPayMethod(reqBo);
        PaymentInsPo qryPaymentInsPo = new PaymentInsPo();
        qryPaymentInsPo.setPaymentInsId(Long.valueOf(reqBo.getPaymentInsId()));
        List<PaymentInsPo> qryPaymentList = this.paymentInsAtomService.queryPaymentInf(qryPaymentInsPo);
        if (CollectionUtils.isEmpty(qryPaymentList)) {
            rspBo.setRspCode("8888");
            rspBo.setRspName("\u652f\u4ed8\u53c2\u6570\u65b0\u589e\u5931\u8d25\uff0c\u652f\u4ed8\u673a\u6784\u4fe1\u606f\u4e0d\u5b58\u5728");
            return rspBo;
        }
        PayMethodPo qryPayM = new PayMethodPo();
        qryPayM.setPaymentInsId(Long.valueOf(reqBo.getPaymentInsId()));
        qryPayM.setPayMethodName(reqBo.getPayMethodName());
        List<PayMethodPo> qryPayMList = this.payMethodAtomService.queryPayMethod(qryPayM);
        if (!CollectionUtils.isEmpty(qryPayMList)) {
            rspBo.setRspCode("8888");
            rspBo.setRspName("\u652f\u4ed8\u65b9\u5f0f\u540d\u79f0\u91cd\u590d\uff0c\u540c\u4e00\u652f\u4ed8\u673a\u6784\u4e0d\u80fd\u6709\u4e24\u4e2a\u76f8\u540c\u7684\u652f\u4ed8\u65b9\u5f0f\u540d\u79f0");
            return rspBo;
        }
        if (!StringUtils.isEmpty((Object)reqBo.getPayMethod())) {
            PayMethodPo resultPo;
            Long addPayMId;
            PayMethodPo qryPo = new PayMethodPo();
            qryPo.setPayMethod(Long.valueOf(reqBo.getPayMethod()));
            List<PayMethodPo> qryPayMethodL = this.payMethodAtomService.queryPayMethod(qryPo);
            if (qryPayMethodL.size() > 0) {
                rspBo.setRspCode("8888");
                rspBo.setRspName("\u652f\u4ed8\u65b9\u5f0f\u7f16\u7801" + reqBo.getPayMethod() + "\u5df2\u5b58\u5728,\u8bf7\u6362\u4e00\u4e2a\uff0c\u6216\u8005\u4e0d\u586b\u5165");
                log.info("\u65b0\u589e\u652f\u4ed8\u673a\u6784\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff1a\u63d2\u5165\u652f\u4ed8\u65b9\u5f0f\u5931\u8d25\uff0c\u652f\u4ed8\u65b9\u5f0f\u7f16\u7801\u51b2\u7a81(" + reqBo.getPayMethod() + "),\u8bf7\u6362\u4e00\u4e2a\u652f\u4ed8\u65b9\u5f0f\u7f16\u7801\uff0c\u6216\u8005\u4e0d\u4f20\u5165\u652f\u4ed8\u65b9\u5f0f\u7f16\u7801");
                return rspBo;
            }
            PayMethodPo addPo = new PayMethodPo();
            BeanUtils.copyProperties((Object)reqBo, (Object)addPo);
            addPo.setPayMethod(Long.valueOf(reqBo.getPayMethod()));
            addPo.setPaymentInsId(Long.valueOf(reqBo.getPaymentInsId()));
            addPo.setCreateTime(this.queryDBDateBusiService.getDBDate());
            if (!StringUtils.isEmpty((Object)reqBo.getOperId())) {
                addPo.setCreateOperId(reqBo.getOperId());
            }
            if ((addPayMId = this.payMethodAtomService.createPayMethodWithId(addPo)) != null && (resultPo = this.payMethodAtomService.queryPayMethodById(addPayMId)) == null) {
                rspBo.setRspCode("8888");
                rspBo.setRspName("\u65b0\u589e\u5931\u8d25\uff0c\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728\u8be5\u652f\u4ed8\u65b9\u5f0f\u7684\u4fe1\u606f");
                return rspBo;
            }
        } else {
            PayMethodPo resultPo;
            Long addPayMethodId;
            PayMethodPo tpo = new PayMethodPo();
            BeanUtils.copyProperties((Object)reqBo, (Object)tpo);
            tpo.setPaymentInsId(Long.valueOf(reqBo.getPaymentInsId()));
            tpo.setCreateTime(this.queryDBDateBusiService.getDBDate());
            if (!StringUtils.isEmpty((Object)reqBo.getOperId())) {
                tpo.setCreateOperId(reqBo.getOperId());
            }
            if ((addPayMethodId = this.payMethodAtomService.createPayMethod(tpo)) != null && (resultPo = this.payMethodAtomService.queryPayMethodById(addPayMethodId)) == null) {
                rspBo.setRspName("\u65b0\u589e\u5931\u8d25\uff0c\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728\u8be5\u652f\u4ed8\u65b9\u5f0f\u7684\u4fe1\u606f");
                rspBo.setRspCode("8888");
                return rspBo;
            }
        }
        rspBo.setRspName("\u65b0\u589e\u652f\u4ed8\u65b9\u5f0f\u6210\u529f");
        rspBo.setRspCode("0000");
        return rspBo;
    }

    private void validateArgWithPayMethod(AddPaymentPayMethodWebReqBo reqBo) {
        if (reqBo == null) {
            log.info("\u65b0\u589e\u652f\u4ed8\u673a\u6784\u652f\u4ed8\u65b9\u5f0fweb\u670d\u52a1\u5f02\u5e38\uff1a\u5165\u53c2bo\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getPaymentInsId())) {
            log.info("\u65b0\u589e\u652f\u4ed8\u673a\u6784\u652f\u4ed8\u65b9\u5f0fweb\u670d\u52a1\u5f02\u5e38\uff1a\u5165\u53c2bo\u5bf9\u8c61\u5c5e\u6027PaymentInsId\u4e0d\u80fd\u4e3a\u7a7a");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u673a\u6784ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayMethodName())) {
            log.info("\u65b0\u589e\u652f\u4ed8\u673a\u6784\u652f\u4ed8\u65b9\u5f0fweb\u670d\u52a1\u5f02\u5e38\uff1a\u5165\u53c2bo\u5bf9\u8c61\u5c5e\u6027payMethodName\u4e0d\u80fd\u4e3a\u7a7a");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u65b9\u5f0f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayType())) {
            log.info("\u65b0\u589e\u652f\u4ed8\u673a\u6784\u652f\u4ed8\u65b9\u5f0fweb\u670d\u52a1\u5f02\u5e38\uff1a\u5165\u53c2bo\u5bf9\u8c61\u5c5e\u6027\u652f\u4ed8\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u65b9\u5f0f\u652f\u4ed8\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!(reqBo.getPayType().equals("1") || reqBo.getPayType().equals("2") || reqBo.getPayType().equals("3") || reqBo.getPayType().equals("4"))) {
            log.info("\u65b0\u589e\u652f\u4ed8\u673a\u6784\u652f\u4ed8\u53c2\u6570web\u670d\u52a1\u5f02\u5e38\uff1a\u5165\u53c2bo\u5bf9\u8c61\u5c5e\u6027\u5b58\u50a8\u7c7b\u578b\u4e0d\u7b26\u5408\u89c4\u8303\uff0c\u8bf7\u9009\u62e91\u62162");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u65b9\u5f0f\u652f\u4ed8\u7c7b\u578b\u4e0d\u7b26\u5408\u89c4\u8303");
        }
    }
}

