/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.service.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.oss.OssConfig;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.web.bo.req.GetBillFileWebServiceReqBo;
import com.tydic.payment.pay.web.bo.rsp.GetBillFileWebServiceRspBo;
import com.tydic.payment.pay.web.service.GetBillFileWebService;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="getBillFileWebService")
@HSFProvider(serviceVersion="2.0-SNAPSHOT", serviceGroup="PAY_GROUP_LOCAL", serviceInterface=GetBillFileWebService.class)
public class GetBillFileWebServiceImpl
implements GetBillFileWebService {
    private static final Logger log = LoggerFactory.getLogger(GetBillFileWebServiceImpl.class);
    private static final String SERVICE_NAME = "oss\u6587\u4ef6\u4e0b\u8f7d\u670d\u52a1";
    @Autowired
    private FileClient fileClient;
    @Autowired
    private OssConfig ossConfig;
    private Map<String, String> fileMap = new ConcurrentHashMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetBillFileWebServiceRspBo downloadSingleBillFile(GetBillFileWebServiceReqBo reqBo) throws IOException {
        log.info("oss\u6587\u4ef6\u4e0b\u8f7d\u670d\u52a1 -> \u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        if (StringUtils.isEmpty((Object)reqBo.getFileName())) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5bf9\u8d26\u6587\u4ef6\u4e0b\u8f7d\u4e1a\u52a1\u670d\u52a1PmcGetFileService:\u4ece\u8fdc\u7a0bOSS\u670d\u52a1\u5668\u83b7\u53d6\u6587\u4ef6\u4e3a\u7a7a");
        }
        GetBillFileWebServiceRspBo retBo = new GetBillFileWebServiceRspBo();
        String fileName = reqBo.getFileName();
        File file = null;
        if (this.fileMap.containsKey(fileName) && !StringUtils.isEmpty((Object)this.fileMap.containsKey(fileName))) {
            file = new File(this.fileMap.get(fileName));
        } else {
            String filePath = "payCenter/billResultFiles/" + fileName;
            try {
                File downloadToFile = this.fileClient.downloadToFile(filePath);
                if (downloadToFile == null) {
                    retBo.setRspCode("8888");
                    retBo.setRspName("oss\u6587\u4ef6\u4e0b\u8f7d\u670d\u52a1 -> \u4e0b\u8f7d\u56de\u6765\u7684\u6587\u4ef6\u4e3anull");
                    return retBo;
                }
                this.fileMap.put(fileName, downloadToFile.getAbsolutePath());
                file = downloadToFile;
            }
            catch (Exception e) {
                retBo.setRspCode("8888");
                retBo.setRspName("oss\u6587\u4ef6\u4e0b\u8f7d\u670d\u52a1 -> \u4e0b\u8f7d\u6587\u4ef6\u5f02\u5e38\uff1a" + e);
                return retBo;
            }
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (FileInputStream in = new FileInputStream(file);){
            byte[] buffer = new byte[4096];
            int n = 0;
            while ((n = in.read(buffer)) != -1) {
                out.write(buffer, 0, n);
            }
        }
        retBo.setDateByte(out.toByteArray());
        retBo.setRspCode("0000");
        retBo.setRspName("\u4e0b\u8f7d\u6210\u529f");
        return retBo;
    }
}

