/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.service.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.tydic.payment.pay.bo.BaseRspInfoBO;
import com.tydic.payment.pay.busi.QueryDBDateBusiService;
import com.tydic.payment.pay.dao.BusiSystemInfoMapper;
import com.tydic.payment.pay.dao.BusiSystemMerchantRelMapper;
import com.tydic.payment.pay.dao.MerChantInfoMapper;
import com.tydic.payment.pay.dao.po.BusiSystemMerchantRelPo;
import com.tydic.payment.pay.dao.po.MerChantInfoPo;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.web.bo.req.BusiSystemReqWayReqBO;
import com.tydic.payment.pay.web.bo.req.MerchantBusiSystemManagerReqBO;
import com.tydic.payment.pay.web.service.MerchantBusiSystemManagerService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="merchantBusiSystemManagerService")
@HSFProvider(serviceVersion="2.0-SNAPSHOT", serviceGroup="PAY_GROUP_LOCAL", serviceInterface=MerchantBusiSystemManagerService.class)
public class MerchantBusiSystemManagerServiceImpl
implements MerchantBusiSystemManagerService {
    private static final Logger log = LoggerFactory.getLogger(MerchantBusiSystemManagerServiceImpl.class);
    private static final String OPER_TYPE_CREATE = "0";
    private static final String OPER_TYPE_UPDATE = "1";
    private static final String OPER_TYPE_DELETE = "2";
    @Autowired
    private BusiSystemMerchantRelMapper busiSystemMerchantRelMapper;
    @Autowired
    private BusiSystemInfoMapper busiSystemInfoMapper;
    @Autowired
    private MerChantInfoMapper merChantInfoMapper;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;

    public BaseRspInfoBO busiSystemManager(MerchantBusiSystemManagerReqBO reqBo) {
        BaseRspInfoBO rspBO = new BaseRspInfoBO();
        try {
            if (!StringUtils.isEmpty((Object)reqBo.getBusiSystemListStr())) {
                List busiSystemList = JSON.parseArray((String)reqBo.getBusiSystemListStr(), BusiSystemReqWayReqBO.class);
                reqBo.setBusiSystemList(busiSystemList);
            } else if (!OPER_TYPE_DELETE.equals(reqBo.getOperType())) {
                rspBO.setRspCode("8888");
                rspBO.setRspName("\u5165\u53c2\u3010busiSystemListStr\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                return rspBO;
            }
            this.checkData(reqBo);
            String checkResult = this.checkDataIllegal(reqBo);
            if (!StringUtils.isEmpty((Object)checkResult)) {
                rspBO.setRspCode("8888");
                rspBO.setRspName(checkResult);
                return rspBO;
            }
            if (Objects.equals(OPER_TYPE_CREATE, reqBo.getOperType())) {
                this.dealByCreate(reqBo);
            }
            if (Objects.equals(OPER_TYPE_UPDATE, reqBo.getOperType())) {
                this.dealByUpdate(reqBo);
            }
            if (Objects.equals(OPER_TYPE_DELETE, reqBo.getOperType())) {
                this.dealByDelete(reqBo);
            }
            rspBO.setRspCode("0000");
            rspBO.setRspName("\u6210\u529f");
        }
        catch (Exception e) {
            log.info("\u5546\u6237\u4e1a\u52a1\u7cfb\u7edf\u7ba1\u7406\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38\uff1a" + e);
            rspBO.setRspCode("8888");
            rspBO.setRspName(e.getMessage());
        }
        return rspBO;
    }

    private String checkDataIllegal(MerchantBusiSystemManagerReqBO reqBO) {
        Long merchantId = Long.valueOf(reqBO.getMerchantId());
        if (this.checkMerchant(merchantId)) {
            return "\u8bf7\u6c42\u53c2\u6570 \u5546\u6237ID " + reqBO.getMerchantId() + " \u9519\u8bef";
        }
        for (BusiSystemReqWayReqBO busiSystemReqWayBO : reqBO.getBusiSystemList()) {
            Long busiId = Long.valueOf(busiSystemReqWayBO.getBusiId());
            if (this.checkBusiId(busiId)) {
                return "\u8bf7\u6c42\u53c2\u6570 \u4e1a\u52a1\u7cfb\u7edfID " + busiSystemReqWayBO.getBusiId() + "\u9519\u8bef";
            }
            if (CollectionUtils.isEmpty((Collection)busiSystemReqWayBO.getReqWayList())) continue;
            for (String reqWay : busiSystemReqWayBO.getReqWayList()) {
                if (!MerchantBusiSystemManagerServiceImpl.checkReqWay(reqWay)) continue;
                return "\u8bf7\u6c42\u53c2\u6570 \u63a5\u5165\u65b9\u5f0f " + reqWay + " \u9519\u8bef";
            }
        }
        return null;
    }

    private void checkData(MerchantBusiSystemManagerReqBO reqBO) {
        if (reqBO == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5546\u6237\u4e1a\u52a1\u7cfb\u7edf\u7ba1\u7406\u4e1a\u52a1\u670d\u52a1BO\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getMerchantId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u7f3a\u5c11\u5fc5\u4f20\u53c2\u6570 merchantId");
        }
        if (StringUtils.isEmpty((Object)reqBO.getOperType())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u7f3a\u5c11\u5fc5\u4f20\u53c2\u6570 operType");
        }
        if (!OPER_TYPE_DELETE.equals(reqBO.getOperType())) {
            if (CollectionUtils.isEmpty((Collection)reqBO.getBusiSystemList())) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u7f3a\u5c11\u5fc5\u4f20\u53c2\u6570 busiSystemList");
            }
            for (BusiSystemReqWayReqBO busiSystemReqWayBO : reqBO.getBusiSystemList()) {
                if (!StringUtils.isEmpty((Object)busiSystemReqWayBO.getBusiId())) continue;
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u7f3a\u5c11\u5fc5\u4f20\u53c2\u6570 busiId");
            }
            if ((OPER_TYPE_CREATE.equals(reqBO.getOperType()) || OPER_TYPE_UPDATE.equals(reqBO.getOperType())) && StringUtils.isEmpty((Object)reqBO.getOperId())) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u7f3a\u5c11\u5fc5\u4f20\u53c2\u6570 operId");
            }
        }
    }

    private void dealByDelete(MerchantBusiSystemManagerReqBO reqBO) {
        for (BusiSystemReqWayReqBO busiSystemReqWayBO : reqBO.getBusiSystemList()) {
            BusiSystemMerchantRelPo reqPO = new BusiSystemMerchantRelPo();
            reqPO.setMerchantId(Long.valueOf(reqBO.getMerchantId()));
            reqPO.setBusiId(Long.valueOf(busiSystemReqWayBO.getBusiId()));
            this.busiSystemMerchantRelMapper.deleteBusiSystemMerchantRelByBusiReqWayMerchant(reqPO);
        }
    }

    private void dealByUpdate(MerchantBusiSystemManagerReqBO reqBO) {
        this.dealByDelete(reqBO);
        this.dealByCreate(reqBO);
    }

    private void dealByCreate(MerchantBusiSystemManagerReqBO reqBO) {
        BusiSystemMerchantRelPo qryReqPO = new BusiSystemMerchantRelPo();
        for (BusiSystemReqWayReqBO busiSystemReqWayBO : reqBO.getBusiSystemList()) {
            if (!OPER_TYPE_UPDATE.equals(reqBO.getOperType())) {
                qryReqPO.setMerchantId(Long.valueOf(reqBO.getMerchantId()));
                qryReqPO.setBusiId(Long.valueOf(busiSystemReqWayBO.getBusiId()));
                List<BusiSystemMerchantRelPo> poList = this.busiSystemMerchantRelMapper.queryBusiSystemMerchantByCondition(qryReqPO);
                if (poList != null && poList.size() > 0) {
                    throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8be5\u5546\u6237\u3010" + reqBO.getMerchantId() + "\u3011\u5df2\u7ecf\u65b0\u589e\u8fc7\u8be5\u673a\u6784\u3010" + busiSystemReqWayBO.getBusiId() + "\u3011\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u65b0\u589e\uff01");
                }
            }
            List reqWayList = MerchantBusiSystemManagerServiceImpl.listReqWay();
            if (CollectionUtils.isEmpty((Collection)busiSystemReqWayBO.getReqWayList())) {
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u65b0\u589e\u4e1a\u52a1\u7cfb\u7edf" + busiSystemReqWayBO.getBusiId() + "\u63a5\u5165\u65b9\u5f0f\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            reqWayList = busiSystemReqWayBO.getReqWayList();
            for (String reqWay : reqWayList) {
                BusiSystemMerchantRelPo reqPO = new BusiSystemMerchantRelPo();
                reqPO.setMerchantId(Long.valueOf(reqBO.getMerchantId()));
                reqPO.setBusiId(Long.valueOf(busiSystemReqWayBO.getBusiId()));
                reqPO.setReqWay(reqWay);
                reqPO.setCreateOperId(reqBO.getOperId());
                reqPO.setCreateTime(this.queryDBDateBusiService.getDBDate());
                reqPO.setRemark(reqBO.getRemark());
                this.busiSystemMerchantRelMapper.createBusiSystemMerchantRel(reqPO);
            }
        }
    }

    private boolean checkBusiId(Long busiId) {
        return this.busiSystemInfoMapper.selectBusiSystemInfoByBusiId(busiId) == null;
    }

    private boolean checkMerchant(Long merchantId) {
        MerChantInfoPo reqPO = new MerChantInfoPo();
        reqPO.setMerchantId(merchantId);
        return this.merChantInfoMapper.queryMerChantInfoById(reqPO) == null;
    }

    private static List<String> listReqWay() {
        ArrayList<String> reqWay = new ArrayList<String>(16);
        reqWay.add(OPER_TYPE_UPDATE);
        reqWay.add(OPER_TYPE_DELETE);
        reqWay.add("3");
        reqWay.add("4");
        reqWay.add("5");
        reqWay.add("6");
        return reqWay;
    }

    private static boolean checkReqWay(String reqWay) {
        for (String temp : MerchantBusiSystemManagerServiceImpl.listReqWay()) {
            if (!Objects.equals(temp, reqWay)) continue;
            return false;
        }
        return true;
    }
}

