/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.service.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.db.Page;
import com.tydic.payment.pay.atom.BusiSystemInfoAtomService;
import com.tydic.payment.pay.atom.PayMethodAtomService;
import com.tydic.payment.pay.atom.PayOrderAtomService;
import com.tydic.payment.pay.atom.PorderPayTransAtomService;
import com.tydic.payment.pay.atom.PorderRefundTransAtomService;
import com.tydic.payment.pay.atom.bo.PorderPayTransAtomRspBo;
import com.tydic.payment.pay.busi.OrderQueryConstructionBusiService;
import com.tydic.payment.pay.busi.QueryPCodeInfoService;
import com.tydic.payment.pay.busi.bo.OrderQueryConstructionReqBo;
import com.tydic.payment.pay.busi.bo.OrderQueryConstructionRspBo;
import com.tydic.payment.pay.busi.bo.QueryPCodeInfoReqBO;
import com.tydic.payment.pay.busi.bo.QueryPCodeInfoRspBO;
import com.tydic.payment.pay.busi.bo.RefundOrderListQryReqBO;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.dao.po.BusiSystemInfoPO;
import com.tydic.payment.pay.dao.po.PayMethodPo;
import com.tydic.payment.pay.dao.po.PorderPo;
import com.tydic.payment.pay.dao.po.PorderRefundTransPo;
import com.tydic.payment.pay.web.bo.req.RefundOrderListQryWebReqBO;
import com.tydic.payment.pay.web.bo.rsp.RefundOrderListRspBO;
import com.tydic.payment.pay.web.service.RefundOrderListQryWebService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="refundOrderListQryWebService")
@HSFProvider(serviceVersion="2.0-SNAPSHOT", serviceGroup="PAY_GROUP_LOCAL", serviceInterface=RefundOrderListQryWebService.class)
public class RefundOrderListQryWebServiceImpl
implements RefundOrderListQryWebService {
    private static final Logger log = LoggerFactory.getLogger(RefundOrderListQryWebServiceImpl.class);
    @Autowired
    private PayOrderAtomService payOrderAtomService;
    @Autowired
    private PorderRefundTransAtomService porderRefundTransAtomService;
    @Autowired
    private BusiSystemInfoAtomService busiSystemInfoAtomService;
    @Autowired
    QueryPCodeInfoService queryPCodeInfoService;
    @Autowired
    private PayMethodAtomService payMethodAtomService;
    @Autowired
    private OrderQueryConstructionBusiService orderQueryConstructionBusiService;
    @Autowired
    private PorderPayTransAtomService porderPayTransAtomService;

    /*
     * Enabled aggressive block sorting
     */
    public RspPage<RefundOrderListRspBO> qryRefundOrderList(RefundOrderListQryWebReqBO reqBo) {
        log.info("\u9000\u6b3e\u8ba2\u5355\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        if (reqBo == null) {
            reqBo = new RefundOrderListQryWebReqBO();
        }
        RspPage retBo = new RspPage();
        ArrayList<RefundOrderListRspBO> rspList = new ArrayList<RefundOrderListRspBO>();
        retBo.setRows(rspList);
        if (!StringUtils.isEmpty((Object)reqBo.getOutOrderId())) {
            OrderQueryConstructionReqBo queryConstructionReqBo = new OrderQueryConstructionReqBo();
            queryConstructionReqBo.setOutOrderId(reqBo.getOutOrderId());
            OrderQueryConstructionRspBo queryConstructionRspBo = this.orderQueryConstructionBusiService.queryConstructionByOutOrderId(queryConstructionReqBo);
            if (queryConstructionRspBo.getOrderId() == null) {
                log.info("\u9000\u6b3e\u8ba2\u5355\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\uff1a\u672a\u67e5\u8be2\u5230\u5916\u90e8\u8ba2\u5355\u53f7\u5173\u8054\u7684\u8ba2\u5355\u53f7");
                retBo.setPageNo(1);
                retBo.setTotal(0);
                retBo.setRecordsTotal(0);
                return retBo;
            }
            if (!StringUtils.isEmpty((Object)reqBo.getOrderId())) {
                String qryOrderId = queryConstructionRspBo.getOrderId().toString();
                if (!reqBo.getOrderId().equals(qryOrderId)) {
                    log.info("\u9000\u6b3e\u8ba2\u5355ID\uff08outOrderId\uff09\u4e0e\u5546\u6237\u8ba2\u5355ID\uff08orderId\uff09\u65e0\u6cd5\u5bf9\u5e94\uff0c\u4e0d\u662f\u540c\u4e00\u7b14\u8ba2\u5355");
                    retBo.setPageNo(1);
                    retBo.setTotal(0);
                    retBo.setRecordsTotal(0);
                    return retBo;
                }
                reqBo.setOrderId("" + queryConstructionRspBo.getOrderId());
            } else {
                reqBo.setOrderId(queryConstructionRspBo.getOrderId().toString());
            }
        }
        PorderPo porderPo = new PorderPo();
        if (!StringUtils.isEmpty((Object)reqBo.getOrderId())) {
            porderPo.setOrderId(Long.valueOf(reqBo.getOrderId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getBusiId())) {
            porderPo.setBusiId(Long.valueOf(reqBo.getBusiId()));
        }
        porderPo.setOrderType("02");
        List<PorderPo> porderList = this.payOrderAtomService.queryRefundListByCondition(porderPo);
        if (porderList == null || porderList.isEmpty()) {
            log.info("\u6570\u636e\u5e93\u8868\u4e2d\u6ca1\u6709\u9000\u6b3e\u8ba2\u5355");
            retBo.setPageNo(1);
            retBo.setTotal(0);
            retBo.setRecordsTotal(0);
            return retBo;
        }
        Date startDate = null;
        Date endDate = null;
        if (!StringUtils.isEmpty((Object)reqBo.getDateBegin())) {
            startDate = new DateTime((Object)reqBo.getDateBegin()).withMillisOfDay(0).toDate();
            log.info("\u5f00\u59cb\u65e5\u671f\uff1a" + startDate);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getDateEnd())) {
            endDate = new DateTime((Object)reqBo.getDateEnd()).plusDays(1).withMillisOfDay(0).toDate();
        }
        HashSet<Long> orderIdSet = new HashSet<Long>();
        HashMap<Long, PorderPo> orderMap = new HashMap<Long, PorderPo>();
        for (PorderPo tempo : porderList) {
            orderIdSet.add(tempo.getOrderId());
            Long torder = tempo.getOrderId();
            orderMap.put(torder, tempo);
        }
        PorderRefundTransPo refundPo = new PorderRefundTransPo();
        if (!StringUtils.isEmpty((Object)reqBo.getPayMethod())) {
            refundPo.setPayMethod(Long.valueOf(reqBo.getPayMethod()));
        }
        log.info("\u5f00\u59cb\u65f6\u95f4\uff1a" + startDate + "   \u7ed3\u675f\u65f6\u95f4\uff1a" + endDate);
        Page page = null;
        if (reqBo.getPageNo() > 1) {
            page = new Page(reqBo.getPageNo(), reqBo.getPageSize());
        } else {
            page = new Page();
            BeanUtils.copyProperties((Object)reqBo, (Object)page);
            if (page.getPageNo() < 1) {
                page.setPageNo(1);
            }
            if (page.getPageSize() < 1) {
                page.setPageSize(10);
            }
        }
        List<PorderRefundTransPo> refundList = this.porderRefundTransAtomService.queryOrderRefundBetweenTime((Page<RefundOrderListQryReqBO>)page, refundPo, startDate, endDate, orderIdSet);
        if (refundList == null || refundList.isEmpty()) {
            log.info("\u5728p_order_refund_trans\u8868\u4e2d\u65e0\u6cd5\u67e5\u627e\u5230\u7b26\u5408\u67e5\u8be2\u6761\u4ef6\u7684\u8bb0\u5f55");
            retBo.setPageNo(1);
            retBo.setTotal(0);
            retBo.setRecordsTotal(0);
            return retBo;
        }
        Iterator<PorderRefundTransPo> iterator = refundList.iterator();
        while (true) {
            Long torderId;
            PorderPo torderPo;
            if (!iterator.hasNext()) {
                log.info("rspList:" + JSON.toJSONString(rspList));
                retBo.setTotal(page.getTotalPages());
                retBo.setRecordsTotal(page.getTotalCount());
                retBo.setPageNo(page.getPageNo());
                return retBo;
            }
            PorderRefundTransPo temp = iterator.next();
            RefundOrderListRspBO rebo = new RefundOrderListRspBO();
            if (temp.getOrderId() != null) {
                rebo.setOrderId(String.valueOf(temp.getOrderId()));
            }
            if (temp.getBusiId() != null) {
                rebo.setBusiId(temp.getBusiId().toString());
                BusiSystemInfoPO qryBusiPo = new BusiSystemInfoPO();
                qryBusiPo.setBusiId(temp.getBusiId());
                List<BusiSystemInfoPO> qryBusiL = this.busiSystemInfoAtomService.queryBusiSystemInfoByCondition(qryBusiPo);
                if (qryBusiL == null || qryBusiL.size() < 1) {
                    log.info("\u67e5\u8be2\u51fa\u53c2\u5c01\u88c5\u62a5\u9519\uff0c\u4e1a\u52a1\u7cfb\u7edfID\u4e3a\uff1a" + temp.getBusiId() + "\u7684\u4e1a\u52a1\u7cfb\u7edf\u4fe1\u606f\u4e0d\u5b58\u5728");
                    retBo.setPageNo(1);
                    retBo.setTotal(0);
                    retBo.setRecordsTotal(0);
                    return retBo;
                }
                rebo.setBusiName(qryBusiL.get(0).getBusiName());
            }
            if (temp.getCreateTime() != null) {
                rebo.setCreateTime(new DateTime((Object)temp.getCreateTime()).toString("yyyy-MM-dd HH:mm:ss"));
            }
            if (temp.getPayMethod() != null) {
                rebo.setPayMethod(String.valueOf(temp.getPayMethod()));
                PayMethodPo qryPayMPo = new PayMethodPo();
                qryPayMPo.setPayMethod(temp.getPayMethod());
                List<PayMethodPo> qryPayML = this.payMethodAtomService.queryPayMethod(qryPayMPo);
                if (qryPayML == null || qryPayML.size() < 1) {
                    log.info("\u67e5\u8be2\u51fa\u53c2\u5c01\u88c5\u62a5\u9519\uff0c\u6570\u636e\u5b57\u5178\u65e0\u6cd5\u7ffb\u8bd1payMethod(\u652f\u4ed8\u65b9\u5f0f)");
                    retBo.setPageNo(1);
                    retBo.setTotal(0);
                    retBo.setRecordsTotal(0);
                    return retBo;
                }
                rebo.setPayMethodName(qryPayML.get(0).getPayMethodName());
            }
            if ((torderPo = (PorderPo)orderMap.get(torderId = temp.getOrderId())) == null) {
                log.info("\u51fa\u53c2\u5c01\u88c5\u9519\u8bef\uff0c\u8be5\u8ba2\u5355\u5728p_order\u8868\u4e2d\u4e0d\u5b58\u5728\uff0c\u4ee3\u7801\u5185\u90e8\u9519\u8bef");
                retBo.setPageNo(1);
                retBo.setTotal(0);
                retBo.setRecordsTotal(0);
                return retBo;
            }
            rebo.setOutOrderId(torderPo.getOutOrderId());
            rebo.setMerchantName(torderPo.getMerchantName());
            rebo.setOrderType(torderPo.getOrderType());
            rebo.setOrderStatus(torderPo.getOrderStatus());
            QueryPCodeInfoReqBO qryPCodePo = new QueryPCodeInfoReqBO();
            qryPCodePo.setTypeCode("P_ORDER_ORDER_TYPE");
            qryPCodePo.setCodeValue(torderPo.getOrderType());
            QueryPCodeInfoRspBO qryPCL = this.queryPCodeInfoService.queryPCodeInfo(qryPCodePo);
            if (qryPCL.getRespCode().equals("0000")) {
                rebo.setOrderTypeName(qryPCL.getCodeInfo());
            } else {
                rebo.setOrderTypeName(torderPo.getOrderType());
            }
            QueryPCodeInfoReqBO qryPCodePo2 = new QueryPCodeInfoReqBO();
            qryPCodePo2.setTypeCode("P_ORDER_ORDER_STATUS");
            qryPCodePo2.setCodeValue(torderPo.getOrderStatus());
            QueryPCodeInfoRspBO qryPCL2 = this.queryPCodeInfoService.queryPCodeInfo(qryPCodePo2);
            if (qryPCL2.getRespCode().equals("0000")) {
                rebo.setOrderStatusName(qryPCL2.getCodeInfo());
            } else {
                rebo.setOrderStatusName(torderPo.getOrderStatus());
            }
            BigDecimal totalFB = MoneyUtils.haoToFen((String)torderPo.getTotalFee().toString());
            rebo.setTotalFee(totalFB.toPlainString());
            BigDecimal refundFB = MoneyUtils.haoToFen((Long)torderPo.getRefundFee());
            rebo.setRefundFee(refundFB.toPlainString());
            PorderPayTransAtomRspBo porderPayTransAtomRspBo = this.porderPayTransAtomService.queryLastRecordByOrderId(torderPo.getOrderId());
            if (porderPayTransAtomRspBo != null) {
                BigDecimal realFB = MoneyUtils.haoToFen((String)porderPayTransAtomRspBo.getPayFee().toString());
                rebo.setRealFee(realFB.toPlainString());
            } else {
                rebo.setRealFee("");
            }
            rspList.add(rebo);
        }
    }
}

