/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.bill.busi.impl;

import com.tydic.payment.bill.busi.BillPaymentParamQueryBusiService;
import com.tydic.payment.pay.dao.PayParaInfoAttrMapper;
import com.tydic.payment.pay.dao.PayParaInfoMapper;
import com.tydic.payment.pay.dao.po.PayParaInfoAttrPo;
import com.tydic.payment.pay.dao.po.PayParaInfoPo;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ReflectionUtils;

@Service(value="billPaymentParamQueryBusiService")
public class BillPaymentParamQueryBusiServiceImpl
implements BillPaymentParamQueryBusiService {
    private static final String PAY_PARA_STATE_OK = "1";
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private boolean isDebug = this.log.isDebugEnabled();
    @Autowired
    private PayParaInfoMapper payParaInfoMapper;
    @Autowired
    private PayParaInfoAttrMapper payParaInfoAttrMapper;

    public <T> Collection<T> query(Class<T> beanType, Long paymentInsId) {
        PayParaInfoPo payParaInfoPo = new PayParaInfoPo();
        payParaInfoPo.setPaymentInsId(paymentInsId);
        List<PayParaInfoPo> paras = this.payParaInfoMapper.queryPayParaInfoByCondition(payParaInfoPo);
        if (paras == null || paras.size() < 1) {
            return new ArrayList(0);
        }
        HashSet parasAttrs = new HashSet(paras.size());
        for (PayParaInfoPo para : paras) {
            if (!PAY_PARA_STATE_OK.equals(para.getState())) continue;
            PayParaInfoAttrPo payParaInfoAttrPo = new PayParaInfoAttrPo();
            payParaInfoAttrPo.setPayParaId(para.getPayParaId());
            List<PayParaInfoAttrPo> attrs = this.payParaInfoAttrMapper.queryPayParaInfoAttrByCondition(payParaInfoAttrPo);
            if (attrs == null || attrs.size() < 1) continue;
            try {
                this.addNotNullParaAttr(parasAttrs, this.createParaAttr(beanType, attrs));
            }
            catch (Exception e) {
                if (!this.isDebug) continue;
                this.log.debug("\u67e5\u8be2\u652f\u4ed8\u673a\u6784\u53c2\u6570\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                e.printStackTrace();
            }
        }
        if (this.isDebug) {
            this.log.debug("\u652f\u4ed8\u673a\u6784\u7684\u53c2\u6570\uff1a{}", parasAttrs);
        }
        return parasAttrs;
    }

    public <T> T queryByPayParaId(Class<T> beanType, Long payParaId) {
        PayParaInfoAttrPo payParaInfoAttrPo = new PayParaInfoAttrPo();
        payParaInfoAttrPo.setPayParaId(payParaId);
        List<PayParaInfoAttrPo> attrs = this.payParaInfoAttrMapper.queryPayParaInfoAttrByCondition(payParaInfoAttrPo);
        if (attrs == null || attrs.size() < 1) {
            return null;
        }
        try {
            T bean = beanType.newInstance();
            for (PayParaInfoAttrPo para : attrs) {
                Field field = ReflectionUtils.findField(beanType, (String)para.getAttrCode());
                if (field == null) continue;
                field.setAccessible(true);
                field.set(bean, para.getAttrValue());
            }
            return bean;
        }
        catch (Exception e) {
            return null;
        }
    }

    private <T> void addNotNullParaAttr(Collection<T> parasAttrs, T paraAttr) throws Exception {
        Field[] fields;
        for (Field field : fields = paraAttr.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            Object value = field.get(paraAttr);
            if (value == null) {
                return;
            }
            if (!Objects.equals("null", value)) continue;
            return;
        }
        parasAttrs.add(paraAttr);
    }

    private <T> T createParaAttr(Class<T> beanType, List<PayParaInfoAttrPo> attrs) throws Exception {
        T bean = beanType.newInstance();
        for (PayParaInfoAttrPo para : attrs) {
            Field field = ReflectionUtils.findField(beanType, (String)para.getAttrCode());
            if (field == null) continue;
            field.setAccessible(true);
            field.set(bean, para.getAttrValue());
        }
        return bean;
    }
}

