/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.ability.impl;

import com.tydic.payment.pay.LoggerProUtils;
import com.tydic.payment.pay.ability.AppetOrderAbilityService;
import com.tydic.payment.pay.ability.bo.AppetOrderAbilityReqBo;
import com.tydic.payment.pay.ability.bo.AppetOrderAbilityRspBo;
import com.tydic.payment.pay.atom.PorderPayTransAtomService;
import com.tydic.payment.pay.bo.PayParaInfoAttrBo;
import com.tydic.payment.pay.busi.OrderQueryConstructionBusiService;
import com.tydic.payment.pay.busi.PayOrderBusiService;
import com.tydic.payment.pay.busi.QueryCashierInfoPayParaAttrService;
import com.tydic.payment.pay.busi.QueryInfoBusiSystemService;
import com.tydic.payment.pay.busi.WXJsapiPayBusiService;
import com.tydic.payment.pay.busi.bo.OrderQueryConstructionReqBo;
import com.tydic.payment.pay.busi.bo.OrderQueryConstructionRspBo;
import com.tydic.payment.pay.busi.bo.PayOrderRspBo;
import com.tydic.payment.pay.busi.bo.QueryCashierInfoPayParaAttrReqBo;
import com.tydic.payment.pay.busi.bo.QueryCashierInfoPayParaAttrRspBo;
import com.tydic.payment.pay.busi.bo.QueryInfoBusiSystemBo;
import com.tydic.payment.pay.busi.bo.QueryInfoBusiSystemReqBo;
import com.tydic.payment.pay.busi.bo.QueryInfoBusiSystemRspBo;
import com.tydic.payment.pay.busi.bo.WXJsapiPayBusiReqBO;
import com.tydic.payment.pay.busi.bo.WXJsapiPayBusiRspBO;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.exception.BusinessException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service(value="appetOrderAbilityService")
@RestController
@RequestMapping(value={"PAY_GROUP_LOCAL/2.0-SNAPSHOT/com.tydic.payment.pay.ability.AppetOrderAbilityService"})
public class AppetOrderAbilityServiceImpl
implements AppetOrderAbilityService {
    private static final Logger LOG = LoggerFactory.getLogger(AppetOrderAbilityServiceImpl.class);
    private static final String SERVICE_NAME = "\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u4e0b\u5355\u670d\u52a1";
    @Autowired
    private WXJsapiPayBusiService wxJsapiPayBusiService;
    @Autowired
    private QueryCashierInfoPayParaAttrService queryCashierInfoPayParaAttrService;
    @Autowired
    private QueryInfoBusiSystemService queryInfoBusiSystemService;
    @Autowired
    private OrderQueryConstructionBusiService orderQueryConstructionBusiService;
    @Autowired
    private PayOrderBusiService payOrderBusiService;
    @Autowired
    private PorderPayTransAtomService porderPayTransAtomService;

    @PostMapping(value={"appletOrder"})
    public AppetOrderAbilityRspBo appletOrder(@RequestBody AppetOrderAbilityReqBo bo) {
        WXJsapiPayBusiRspBO wxJsapiPayBusiRspBO;
        AppetOrderAbilityRspBo retBo = new AppetOrderAbilityRspBo();
        QueryInfoBusiSystemReqBo qryBusiBO = new QueryInfoBusiSystemReqBo();
        qryBusiBO.setBusiCode(bo.getBusiCode());
        QueryInfoBusiSystemRspBo queryInfoBusiSystemRspBo = this.queryInfoBusiSystemService.queryInfoBusiSystem(qryBusiBO);
        if (!"0000".equals(queryInfoBusiSystemRspBo.getRspCode())) {
            LoggerProUtils.error(LOG, "\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u4e0b\u5355\u670d\u52a1 -> \u67e5\u8be2\u4e1a\u52a1\u7cfb\u7edf\u5931\u8d25");
            retBo.setRspCode("4001");
            retBo.setRspName("\u67e5\u8be2\u4e1a\u52a1\u7cfb\u7edf\u5f02\u5e38");
            return retBo;
        }
        Long busiId = Long.valueOf(((QueryInfoBusiSystemBo)queryInfoBusiSystemRspBo.getInfoBusiBoList().get(0)).getBusiId());
        OrderQueryConstructionReqBo qryOrderIdBo = new OrderQueryConstructionReqBo();
        qryOrderIdBo.setBusiId(busiId);
        qryOrderIdBo.setOutOrderId(bo.getOutOrderId());
        OrderQueryConstructionRspBo orderQueryConstructionRspBo = this.orderQueryConstructionBusiService.queryConstruction(qryOrderIdBo);
        if (orderQueryConstructionRspBo == null || !"0000".equals(orderQueryConstructionRspBo.getRspCode())) {
            LoggerProUtils.error(LOG, "\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u4e0b\u5355\u670d\u52a1 -> \u4ecep_query_order\u8868\u67e5\u8be2orderId\u5931\u8d25");
            retBo.setRspCode("4001");
            retBo.setRspName("\u4ecep_query_order\u8868\u67e5\u8be2orderId\u5931\u8d25");
            return retBo;
        }
        Long orderId = orderQueryConstructionRspBo.getOrderId();
        PayOrderRspBo payOrderRspBo = this.payOrderBusiService.selectOrderByOrderId(orderId);
        String merchantId = payOrderRspBo.getMerchantId() + "";
        Map<String, Object> payParaMap = this.queryPayPara(merchantId, bo.getReqWay());
        String appId = payParaMap.get("applets_appid") + "";
        WXJsapiPayBusiReqBO wxJsapiPayBusiReqBO = new WXJsapiPayBusiReqBO();
        wxJsapiPayBusiReqBO.setOrderId(orderId + "");
        wxJsapiPayBusiReqBO.setMerchantId(merchantId);
        wxJsapiPayBusiReqBO.setTotalFee(MoneyUtils.haoToFen((Long)payOrderRspBo.getTotalFee()));
        wxJsapiPayBusiReqBO.setOpenid(bo.getOpenId());
        wxJsapiPayBusiReqBO.setParamMap(payParaMap);
        if ("4".equals(bo.getReqWay())) {
            wxJsapiPayBusiReqBO.setPayMethod("14");
        } else if ("5".equals(bo.getReqWay())) {
            wxJsapiPayBusiReqBO.setPayMethod("15");
        }
        try {
            wxJsapiPayBusiRspBO = this.wxJsapiPayBusiService.dealWxJsapiPay(wxJsapiPayBusiReqBO);
        }
        catch (Exception e) {
            LoggerProUtils.error(LOG, "\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u4e0b\u5355\u670d\u52a1 -> \u8c03\u7528\u5c0f\u7a0b\u5e8f\u4e0b\u5355\u5931\u8d25");
            retBo.setRspCode("4001");
            retBo.setRspName("\u8c03\u7528\u5c0f\u7a0b\u5e8f\u4e0b\u5355\u5931\u8d25");
            return retBo;
        }
        retBo.setRspCode(wxJsapiPayBusiRspBO.getRspCode());
        retBo.setRspName(wxJsapiPayBusiRspBO.getRspName());
        if (!"0000".equals(wxJsapiPayBusiRspBO.getRspCode())) {
            return retBo;
        }
        retBo.setAppId(appId);
        retBo.setTimeStamp(wxJsapiPayBusiRspBO.getTimeStamp());
        retBo.setNonceStr(wxJsapiPayBusiRspBO.getNonceStr());
        retBo.setPackageBody(wxJsapiPayBusiRspBO.getPackage_());
        retBo.setSignType(wxJsapiPayBusiRspBO.getSignType());
        retBo.setPaySign(wxJsapiPayBusiRspBO.getPaySign());
        retBo.setBusiId(busiId + "");
        retBo.setOutOrderId(bo.getOutOrderId());
        retBo.setMerchantId(merchantId);
        retBo.setRemark(payOrderRspBo.getOutRemark());
        retBo.setOrderAttrValue1(payOrderRspBo.getOrderAttrValue1());
        retBo.setOrderAttrValue2(payOrderRspBo.getOrderAttrValue2());
        retBo.setOrderAttrValue3(payOrderRspBo.getOrderAttrValue3());
        return retBo;
    }

    private Map<String, Object> queryPayPara(String merchantId, String reqWay) {
        String payMethod = null;
        if ("4".equals(reqWay)) {
            payMethod = "14";
        }
        if ("5".equals(reqWay)) {
            payMethod = "15";
        }
        if (null == payMethod) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u4e0d\u652f\u6301\u7684\u3010" + reqWay + "\u3011\u8bf7\u6c42\u65b9\u5f0f");
        }
        QueryCashierInfoPayParaAttrReqBo paraReqBO = new QueryCashierInfoPayParaAttrReqBo();
        paraReqBO.setMerchantId(merchantId);
        paraReqBO.setPayMethod(payMethod);
        QueryCashierInfoPayParaAttrRspBo paraRspBO = this.queryCashierInfoPayParaAttrService.queryPayParaAttr(paraReqBO);
        if (paraRspBO == null || !"0000".equals(paraRspBO.getRspCode())) {
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u6839\u636e\u5546\u6237\u53f7\u3010" + merchantId + "\u3011\u67e5\u8be2\u652f\u4ed8\u53c2\u6570\u914d\u7f6e\u5931\u8d25\uff01");
        }
        if (paraRspBO.getInfoPayParaAttrList() == null || paraRspBO.getInfoPayParaAttrList().size() < 1) {
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u6839\u636e\u5546\u6237\u53f7\u3010" + merchantId + "\u3011\u67e5\u8be2\u65e0\u652f\u4ed8\u53c2\u6570\u914d\u7f6e\uff01");
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>(4);
        for (PayParaInfoAttrBo para : paraRspBO.getInfoPayParaAttrList()) {
            if (StringUtils.isEmpty((Object)para.getAttrCode()) || StringUtils.isEmpty((Object)para.getAttrValue())) continue;
            paramMap.put(para.getAttrCode(), para.getAttrValue());
        }
        return paramMap;
    }
}

