/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.payment.pay.ability.PayProSignAutoDeductAbilityService;
import com.tydic.payment.pay.ability.PayProSignAutoDeductEncryptAbilityService;
import com.tydic.payment.pay.ability.bo.PayProSignAutoDeductAbilityReqBo;
import com.tydic.payment.pay.ability.bo.PayProSignAutoDeductAbilityRspBo;
import com.tydic.payment.pay.ability.bo.PayProSignAutoDeductEncryptAbilityReqBo;
import com.tydic.payment.pay.ability.bo.PayProSignAutoDeductEncryptAbilityRspBo;
import com.tydic.payment.pay.busi.DataEncryptionService;
import com.tydic.payment.pay.busi.DataValidationService;
import com.tydic.payment.pay.busi.PayProQueryInfoBusiSystemByConditionService;
import com.tydic.payment.pay.busi.bo.DataEncryptionReqBo;
import com.tydic.payment.pay.busi.bo.DataEncryptionRspBo;
import com.tydic.payment.pay.busi.bo.DataValidationReqBO;
import com.tydic.payment.pay.busi.bo.DataValidationRspBO;
import com.tydic.payment.pay.busi.bo.PayProQueryInfoBusiSystemByConditionBusiInfoRspBo;
import com.tydic.payment.pay.common.util.MapUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service(value="payProSignAutoDeductEncryptAbilityService")
@RestController
@RequestMapping(value={"PAY_GROUP_LOCAL/2.0-SNAPSHOT/com.tydic.payment.pay.ability.PayProSignAutoDeductEncryptAbilityService"})
public class PayProSignAutoDeductEncryptAbilityServiceImpl
implements PayProSignAutoDeductEncryptAbilityService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private static final String SERVICE_NAME = "\u7b7e\u7ea6\u5468\u671f\u6263\u6b3eability\u52a0\u5bc6\u670d\u52a1";
    @Autowired
    private PayProSignAutoDeductAbilityService payProSignAutoDeductAbilityService;
    @Autowired
    private PayProQueryInfoBusiSystemByConditionService queryInfoBusiSystemByConditionService;
    @Autowired
    private DataValidationService dataValidationService;
    @Autowired
    private DataEncryptionService dataEncryptionService;

    @PostMapping(value={"signAgreement"})
    public PayProSignAutoDeductEncryptAbilityRspBo signAgreement(@RequestBody PayProSignAutoDeductEncryptAbilityReqBo reqBo) {
        PayProSignAutoDeductAbilityReqBo signReqBo;
        DataValidationRspBO dataValidationRspBO;
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.info("\u7b7e\u7ea6\u5468\u671f\u6263\u6b3eability\u52a0\u5bc6\u670d\u52a1-> \u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        }
        PayProSignAutoDeductEncryptAbilityRspBo retBo = new PayProSignAutoDeductEncryptAbilityRspBo();
        String validateArgStr = this.validateArg(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            retBo.setRespCode("4026");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return retBo;
        }
        String busiCode = reqBo.getBusiCode();
        PayProQueryInfoBusiSystemByConditionBusiInfoRspBo busiCodeRspBo = this.queryInfoBusiSystemByConditionService.queryBusiSysByBusiCode(busiCode);
        if (!"0000".equals(busiCodeRspBo.getRespCode())) {
            retBo.setRespCode("4026");
            retBo.setRespDesc("\u67e5\u8be2\u4e1a\u52a1\u7cfb\u7edf\u5931\u8d25:" + busiCodeRspBo.getRespDesc());
            return retBo;
        }
        if (!"1".equals(busiCodeRspBo.getState())) {
            retBo.setRespCode("4026");
            retBo.setRespDesc("\u8be5\u4e1a\u52a1\u7cfb\u7edf(" + busiCode + ")\u5df2\u5931\u6548");
            return retBo;
        }
        Long busiId = busiCodeRspBo.getBusiId();
        DataValidationReqBO dataValidationReqBO = new DataValidationReqBO();
        dataValidationReqBO.setBusiId(busiCodeRspBo.getBusiId() + "");
        dataValidationReqBO.setContent(reqBo.getContent());
        try {
            dataValidationRspBO = this.dataValidationService.validation(dataValidationReqBO);
        }
        catch (Exception e) {
            this.LOGGER.error("\u7b7e\u7ea6\u5468\u671f\u6263\u6b3eability\u52a0\u5bc6\u670d\u52a1 -> \u89e3\u5bc6\u5f02\u5e38\uff1a" + e);
            retBo.setRespCode("4026");
            retBo.setRespDesc("\u89e3\u5bc6\u5f02\u5e38\uff1a" + e.getMessage());
            return retBo;
        }
        if (!"0000".equals(dataValidationRspBO.getRspCode())) {
            this.LOGGER.error("\u7b7e\u7ea6\u5468\u671f\u6263\u6b3eability\u52a0\u5bc6\u670d\u52a1 -> \u89e3\u5bc6\u5931\u8d25:" + JSON.toJSONString((Object)dataValidationRspBO));
            retBo.setRespCode("4026");
            retBo.setRespDesc(dataValidationRspBO.getRspName());
            return retBo;
        }
        if (!dataValidationRspBO.isSign()) {
            retBo.setRespCode("4026");
            retBo.setRespDesc("\u9a8c\u8bc1\u7b7e\u540d\u4e0d\u901a\u8fc7");
            return retBo;
        }
        try {
            signReqBo = (PayProSignAutoDeductAbilityReqBo)MapUtils.mapToObject((Map)dataValidationRspBO.getContentMap(), PayProSignAutoDeductAbilityReqBo.class);
        }
        catch (Exception e) {
            retBo.setRespCode("4026");
            retBo.setRespDesc("\u7b7e\u7ea6\u5468\u671f\u6263\u6b3eability\u52a0\u5bc6\u670d\u52a1 -> \u89e3\u5bc6\u540e\u8f6c\u6362\u5bf9\u8c61\u5f02\u5e38\uff1a" + e);
            return retBo;
        }
        PayProSignAutoDeductAbilityRspBo signRetBo = this.payProSignAutoDeductAbilityService.signAgreement(signReqBo);
        if (!"0000".equals(signRetBo.getRespCode())) {
            retBo.setRespCode(signRetBo.getRespCode());
            retBo.setRespDesc("\u8c03\u7528\u4e0d\u52a0\u5bc6\u670d\u52a1\u5931\u8d25\uff1a" + signRetBo.getRespDesc());
            return retBo;
        }
        DataEncryptionReqBo dataReqBo = new DataEncryptionReqBo();
        JSONObject content = JSONObject.parseObject((String)JSONObject.toJSONString((Object)signRetBo));
        content.remove((Object)"respCode");
        content.remove((Object)"respDesc");
        dataReqBo.setBusiId(busiId + "");
        dataReqBo.setContent(content.toString());
        DataEncryptionRspBo dataEncryptionRspBo = this.dataEncryptionService.dataEncryption(dataReqBo);
        if (!"0000".equals(dataEncryptionRspBo.getRspCode())) {
            retBo.setRespCode("4018");
            retBo.setRespDesc("\u7b7e\u7ea6\u5468\u671f\u6263\u6b3eability\u52a0\u5bc6\u670d\u52a1 -> RSA\u52a0\u5bc6\u5f02\u5e38\uff1a" + dataEncryptionRspBo.getRspName());
            return retBo;
        }
        retBo.setBusiCode(reqBo.getBusiCode());
        retBo.setContent(dataEncryptionRspBo.getEncrypData());
        retBo.setRespDesc(signRetBo.getRespDesc());
        retBo.setRespCode("0000");
        return retBo;
    }

    private String validateArg(PayProSignAutoDeductEncryptAbilityReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getBusiCode())) {
            return "busiCode\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getContent())) {
            return "content\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

