/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.payment.pay.ability.WspPayOutAbilityService;
import com.tydic.payment.pay.ability.bo.WspPayOutAbilityReqBO;
import com.tydic.payment.pay.ability.bo.WspPayOutAbilityRspBO;
import com.tydic.payment.pay.busi.DataEncryptionService;
import com.tydic.payment.pay.busi.DataValidationService;
import com.tydic.payment.pay.busi.QueryInfoBusiSystemService;
import com.tydic.payment.pay.busi.bo.DataEncryptionReqBo;
import com.tydic.payment.pay.busi.bo.DataEncryptionRspBo;
import com.tydic.payment.pay.busi.bo.DataValidationReqBO;
import com.tydic.payment.pay.busi.bo.DataValidationRspBO;
import com.tydic.payment.pay.busi.bo.QueryInfoBusiSystemBo;
import com.tydic.payment.pay.busi.bo.QueryInfoBusiSystemReqBo;
import com.tydic.payment.pay.busi.bo.QueryInfoBusiSystemRspBo;
import com.tydic.payment.pay.comb.WspPayCombService;
import com.tydic.payment.pay.comb.bo.WspPayComReqBO;
import com.tydic.payment.pay.comb.bo.WspPayComRspBO;
import com.tydic.payment.pay.exception.BusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service(value="pmcWspPayOutAbilityService")
@RestController
@RequestMapping(value={"PAY_GROUP_LOCAL/2.0-SNAPSHOT/com.tydic.payment.pay.ability.WspPayOutAbilityService"})
public class WspPayOutAbilityServiceImpl
implements WspPayOutAbilityService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    @Autowired
    private WspPayCombService wspPayCombService;
    @Autowired
    private DataEncryptionService dataEncryptionService;
    @Autowired
    private DataValidationService dataValidationService;
    @Autowired
    private QueryInfoBusiSystemService queryInfoBusiSystemService;

    @PostMapping(value={"wspPayAbility"})
    public WspPayOutAbilityRspBO wspPayAbility(@RequestBody WspPayOutAbilityReqBO wspPayOutAbilityReqBO) {
        this.checkReqBO(wspPayOutAbilityReqBO);
        return this.encryptRspBO(this.wspPayCombService.wspPay(this.decryptReqBO(wspPayOutAbilityReqBO)));
    }

    private WspPayComReqBO decryptReqBO(WspPayOutAbilityReqBO wspPayOutAbilityReqBO) {
        DataValidationRspBO dataValidationRspBO;
        this.debugLog("\u5c0f\u7a0b\u5e8f\u6216\u516c\u4f17\u53f7\u652f\u4ed8\u4e0b\u5355\u8bf7\u6c42\u53c2\u6570\u89e3\u5bc6\u524d\uff1a{}", wspPayOutAbilityReqBO);
        DataValidationReqBO dataValidationReqBO = new DataValidationReqBO();
        QueryInfoBusiSystemReqBo bo = new QueryInfoBusiSystemReqBo();
        String busiId = wspPayOutAbilityReqBO.getBusiId();
        bo.setBusiCode(busiId);
        QueryInfoBusiSystemRspBo queryInfoBusiSystemRspBo = this.queryInfoBusiSystemService.queryInfoBusiSystem(bo);
        if (!"0000".equals(queryInfoBusiSystemRspBo.getRspCode()) || queryInfoBusiSystemRspBo.getInfoBusiBoList() == null || queryInfoBusiSystemRspBo.getInfoBusiBoList().isEmpty()) {
            this.logger.error("\u6e05\u7b97\u8ba2\u5355\u4e2d\u5fc3\u4e0b\u5355\u5f02\u5e38\uff1a\u672a\u67e5\u8be2\u5230\u7cfb\u7edf\u7f16\u7801\uff1a" + busiId);
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u6839\u636ebusi_code\u67e5\u8be2busi_id\u4e3a\u7a7a");
        }
        String realBusiId = ((QueryInfoBusiSystemBo)queryInfoBusiSystemRspBo.getInfoBusiBoList().get(0)).getBusiId();
        String busiCode = ((QueryInfoBusiSystemBo)queryInfoBusiSystemRspBo.getInfoBusiBoList().get(0)).getBusiCode();
        this.logger.info("\u5c0f\u7a0b\u5e8f\u4e0b\u5355\u670d\u52a1\u67e5\u8be2\u771f\u5b9ebusi_id\u4e3a\uff1a" + realBusiId);
        dataValidationReqBO.setBusiId(realBusiId);
        dataValidationReqBO.setContent(wspPayOutAbilityReqBO.getContent());
        try {
            dataValidationRspBO = this.dataValidationService.validation(dataValidationReqBO);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8bf7\u6c42\u53c2\u6570\u6821\u9a8c\u5f02\u5e38\uff1a" + e.getMessage());
        }
        if (null == dataValidationRspBO || !"0000".equals(dataValidationRspBO.getRspCode())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8bf7\u6c42\u53c2\u6570\u6821\u9a8c\u5f02\u5e38");
        }
        if (!dataValidationRspBO.isSign()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u6570\u636e\u6821\u9a8c\u5931\u8d25");
        }
        WspPayComReqBO wspPayReqBO = (WspPayComReqBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)dataValidationRspBO.getContentMap()), WspPayComReqBO.class);
        wspPayReqBO.setBusiId(realBusiId);
        wspPayReqBO.setBusiCode(busiCode);
        this.debugLog("\u5c0f\u7a0b\u5e8f\u6216\u516c\u4f17\u53f7\u652f\u4ed8\u4e0b\u5355\u8bf7\u6c42\u53c2\u6570\u89e3\u5bc6\u540e\uff1a{}", wspPayReqBO);
        return wspPayReqBO;
    }

    private WspPayOutAbilityRspBO encryptRspBO(WspPayComRspBO wspPayRspBO) {
        this.debugLog("\u5c0f\u7a0b\u5e8f\u6216\u516c\u4f17\u53f7\u652f\u4ed8\u4e0b\u5355\u54cd\u5e94\u53c2\u6570\u52a0\u5bc6\u524d\uff1a{}", wspPayRspBO);
        WspPayOutAbilityRspBO wspPayOutAbilityRspBO = new WspPayOutAbilityRspBO();
        DataEncryptionReqBo dataEncryptionReqBo = new DataEncryptionReqBo();
        dataEncryptionReqBo.setBusiId(wspPayRspBO.getBusiId());
        dataEncryptionReqBo.setContent(JSONObject.toJSONString((Object)wspPayRspBO));
        DataEncryptionRspBo dataEncryptionRspBo = this.dataEncryptionService.dataEncryption(dataEncryptionReqBo);
        if (null == dataEncryptionRspBo || !"0000".equals(dataEncryptionRspBo.getRspCode())) {
            wspPayOutAbilityRspBO.setRspCode("0000");
            wspPayOutAbilityRspBO.setRspName("\u54cd\u5e94\u53c2\u6570\u52a0\u5bc6\u5f02\u5e38");
            return wspPayOutAbilityRspBO;
        }
        QueryInfoBusiSystemReqBo bo = new QueryInfoBusiSystemReqBo();
        bo.setBusiId(wspPayRspBO.getBusiId());
        QueryInfoBusiSystemRspBo queryInfoBusiSystemRspBo = this.queryInfoBusiSystemService.queryInfoBusiSystem(bo);
        wspPayOutAbilityRspBO.setRspCode("0000");
        wspPayOutAbilityRspBO.setRspName("\u6210\u529f");
        wspPayOutAbilityRspBO.setContent(dataEncryptionRspBo.getEncrypData());
        wspPayOutAbilityRspBO.setBusiId(((QueryInfoBusiSystemBo)queryInfoBusiSystemRspBo.getInfoBusiBoList().get(0)).getBusiCode());
        this.debugLog("\u5c0f\u7a0b\u5e8f\u6216\u516c\u4f17\u53f7\u652f\u4ed8\u4e0b\u5355\u54cd\u5e94\u53c2\u6570\u52a0\u5bc6\u540e\uff1a{}", wspPayOutAbilityRspBO);
        return wspPayOutAbilityRspBO;
    }

    private void checkReqBO(WspPayOutAbilityReqBO reqBO) {
        this.debugLog("\u5c0f\u7a0b\u5e8f\u6216\u516c\u4f17\u53f7\u652f\u4ed8\u4e0b\u5355\u8bf7\u6c42\u53c2\u6570\uff1a{}", reqBO);
        if (null == reqBO) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getBusiId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9274\u6743 BUSI_ID \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getContent())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9274\u6743 CONTENT \u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void debugLog(String str, Object o) {
        if (this.isDebug) {
            this.logger.debug(str, o);
        }
    }
}

