/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.tydic.payment.pay.busi.PayProCreateOrderRefundTransBusiService;
import com.tydic.payment.pay.busi.bo.PayProCreateOrderRefundTransBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayProCreateOrderRefundTransBusiRspBo;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.config.PaySequenceConfigManager;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.constant.PaySequenceKeys;
import com.tydic.payment.pay.dao.PayMethodMapper;
import com.tydic.payment.pay.dao.PorderRefundTransMapper;
import com.tydic.payment.pay.dao.po.PorderRefundTransPo;
import com.tydic.payment.pay.exception.BusinessException;
import java.sql.SQLException;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class PayProCreateOrderRefundTransBusiServiceImpl
implements PayProCreateOrderRefundTransBusiService {
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private PaySequenceConfigManager paySequenceConfigManager;
    @Autowired
    private PayMethodMapper payMethodMapper;
    @Autowired
    private PorderRefundTransMapper porderRefundTransMapper;
    private static final String RE_PAY_ORDER_ID_STR = "\u91cd\u590d\u7684\u5916\u90e8\u8ba2\u5355";

    public PayProCreateOrderRefundTransBusiRspBo addRefundTrans(PayProCreateOrderRefundTransBusiReqBo reqBo) {
        PayProCreateOrderRefundTransBusiRspBo retBo = new PayProCreateOrderRefundTransBusiRspBo();
        String validateArgStr = this.validateArg(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            retBo.setRespCode("2011");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return retBo;
        }
        String refundOrderId = this.createNewRefundOrderId(reqBo);
        if (refundOrderId.startsWith(RE_PAY_ORDER_ID_STR)) {
            retBo.setRespCode("2011");
            retBo.setRespDesc(refundOrderId);
            return retBo;
        }
        PorderRefundTransPo insertPo = new PorderRefundTransPo();
        BeanUtils.copyProperties((Object)reqBo, (Object)insertPo);
        insertPo.setRefundOrderId(refundOrderId);
        insertPo.setPayFee(MoneyUtils.fenToHao((Long)reqBo.getPayFee()).longValue());
        insertPo.setRefundFlag(2L);
        int insert = this.porderRefundTransMapper.insert(insertPo);
        if (insert != 1) {
            retBo.setRespCode("2011");
            retBo.setRespDesc("\u63d2\u5165p_order_refund_trans\u5931\u8d25\uff1asql\u8fd4\u56de\u503c\u4e0d\u4e3a1");
            return retBo;
        }
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u521b\u5efa\u6210\u529f");
        retBo.setRefundOrderId(refundOrderId);
        return retBo;
    }

    private String createNewRefundOrderId(PayProCreateOrderRefundTransBusiReqBo reqBo) {
        String inputRefundOrderId = reqBo.getRefundOrderId();
        String refundOrderId = null;
        if (!StringUtils.isEmpty((Object)inputRefundOrderId)) {
            refundOrderId = inputRefundOrderId;
            PorderRefundTransPo qryPo = new PorderRefundTransPo();
            qryPo.setRefundOrderId(refundOrderId);
            List<PorderRefundTransPo> orderRefundTransByCondition = this.porderRefundTransMapper.getOrderRefundTransByCondition(qryPo);
            if (!CollectionUtils.isEmpty(orderRefundTransByCondition)) {
                return "\u91cd\u590d\u7684\u5916\u90e8\u8ba2\u5355[" + inputRefundOrderId + "]";
            }
        } else {
            String projectName = this.payPropertiesVo.getProjectName();
            try {
                refundOrderId = projectName + "REFUND" + this.paySequenceConfigManager.nextId(PaySequenceKeys.SEQUENCE_PAY_ORDER_ID.getSequenceName());
            }
            catch (SQLException e) {
                throw new BusinessException("6012", "\u83b7\u53d6refundOrderId\u5f02\u5e38", (Throwable)e);
            }
        }
        return refundOrderId;
    }

    private String validateArg(PayProCreateOrderRefundTransBusiReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027payOrderId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027orderId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getBusiId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027busiId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getMerchantId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027merchantId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayMethod())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027payMethod\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayFee())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027payFee\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getOrderStatus())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027orderStatus\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getCreateTime())) {
            reqBo.setCreateTime(this.payMethodMapper.getDBDate().getDate());
        }
        return null;
    }
}

