/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.tydic.payment.pay.atom.PorderPayTransAtomService;
import com.tydic.payment.pay.atom.bo.PorderPayTransAtomReqBo;
import com.tydic.payment.pay.atom.bo.PorderPayTransAtomRspBo;
import com.tydic.payment.pay.busi.PayInfoContractQueryBusiService;
import com.tydic.payment.pay.busi.PayProGetParamsBusiService;
import com.tydic.payment.pay.busi.PayProQueryPayParaBusiService;
import com.tydic.payment.pay.busi.bo.PayInfoContractQueryBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayInfoContractQueryBusiRspBo;
import com.tydic.payment.pay.busi.bo.PayProGetParamsBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayProGetParamsBusiRspBo;
import com.tydic.payment.pay.busi.bo.PayProQueryPayParaBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayProQueryPayParaBusiRspBo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="payProGetParamsBusiService")
public class PayProGetParamsBusiServiceImpl
implements PayProGetParamsBusiService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private PayProQueryPayParaBusiService payProQueryPayParaBusiService;
    @Autowired
    private PorderPayTransAtomService porderPayTransAtomService;
    @Autowired
    private PayInfoContractQueryBusiService payInfoContractQueryBusiService;

    public PayProGetParamsBusiRspBo getParamMap(PayProGetParamsBusiReqBo reqBo) {
        PayProQueryPayParaBusiRspBo qryParamRspBo;
        this.LOGGER.info("\u83b7\u53d6\u652f\u4ed8\u673a\u6784\u53c2\u6570busi\u670d\u52a1\uff1a" + reqBo);
        PayProGetParamsBusiRspBo retBo = new PayProGetParamsBusiRspBo();
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            this.LOGGER.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("2054");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        PayProQueryPayParaBusiReqBo qryParamReqBo = new PayProQueryPayParaBusiReqBo();
        if (!StringUtils.isEmpty((Object)reqBo.getPayOrderId())) {
            this.LOGGER.info("\u67e5\u8be2\u652f\u4ed8\u4fe1\u606f");
            PorderPayTransAtomReqBo porderPayTransAtomReqBo = new PorderPayTransAtomReqBo();
            porderPayTransAtomReqBo.setPayOrderId(reqBo.getPayOrderId());
            PorderPayTransAtomRspBo porderPayTransAtomRspBo = this.porderPayTransAtomService.queryOrderPayTransByPayOrderId(porderPayTransAtomReqBo);
            if (porderPayTransAtomRspBo == null) {
                this.LOGGER.error("\u6839\u636epayOrderId\uff1a" + reqBo.getPayOrderId() + "\u67e5\u8be2\u652f\u4ed8\u6d41\u6c34\u4e3a\u7a7a");
                retBo.setRespCode("2054");
                retBo.setRespDesc("\u6839\u636epayOrderId\uff1a" + reqBo.getPayOrderId() + "\u67e5\u8be2\u652f\u4ed8\u6d41\u6c34\u4e3a\u7a7a");
                return retBo;
            }
            qryParamReqBo.setPayMethod(porderPayTransAtomRspBo.getPayMethod());
            qryParamReqBo.setMerchantId(porderPayTransAtomRspBo.getMerchantId());
        }
        if (!StringUtils.isEmpty((Object)reqBo.getContractId())) {
            this.LOGGER.info("\u67e5\u8be2\u534f\u8bae\u4fe1\u606f");
            PayInfoContractQueryBusiReqBo qryContractReqBo = new PayInfoContractQueryBusiReqBo();
            qryContractReqBo.setContractId(reqBo.getContractId());
            PayInfoContractQueryBusiRspBo qryContractRspBo = this.payInfoContractQueryBusiService.queryContractInfo(qryContractReqBo);
            if (!"0000".equals(qryContractRspBo.getRespCode())) {
                this.LOGGER.error("\u6839\u636econtractId\uff1a" + reqBo.getContractId() + "\u67e5\u8be2\u534f\u8bae\u4fe1\u606f\u4e3a\u7a7a");
                retBo.setRespCode(qryContractRspBo.getRespCode());
                retBo.setRespDesc(qryContractRspBo.getRespDesc());
                return retBo;
            }
            qryParamReqBo.setPayMethod(qryContractRspBo.getPayMethod());
            qryParamReqBo.setMerchantId(qryContractRspBo.getMerchantId());
        }
        if (!"0000".equals((qryParamRspBo = this.payProQueryPayParaBusiService.queryPayPara(qryParamReqBo)).getRespCode())) {
            retBo.setRespCode(qryParamRspBo.getRespCode());
            retBo.setRespDesc("\u67e5\u8be2\u652f\u4ed8\u53c2\u6570\u5931\u8d25\uff1a" + qryParamRspBo.getRespDesc());
            return retBo;
        }
        retBo.setParamMap(qryParamRspBo.getDetailAttrs());
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private String validateArgs(PayProGetParamsBusiReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getContractId()) && StringUtils.isEmpty((Object)reqBo.getPayOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'payOrderId'\u548c'contractId'\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a";
        }
        return null;
    }
}

