/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.tydic.payment.pay.busi.PayProUpdatePayOrderInfoAfterRefundBusiService;
import com.tydic.payment.pay.busi.bo.PayProUpdatePayOrderInfoAfterRefundBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayProUpdatePayOrderInfoAfterRefundBusiRspBo;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.dao.PayMethodMapper;
import com.tydic.payment.pay.dao.PorderMapper;
import com.tydic.payment.pay.dao.PorderPayTransMapper;
import com.tydic.payment.pay.dao.po.PorderPayTransPo;
import com.tydic.payment.pay.dao.po.PorderPo;
import com.tydic.payment.pay.exception.BusinessException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class PayProUpdatePayOrderInfoAfterRefundBusiServiceImpl
implements PayProUpdatePayOrderInfoAfterRefundBusiService {
    private static final Logger LOG = LoggerFactory.getLogger(PayProUpdatePayOrderInfoAfterRefundBusiServiceImpl.class);
    @Autowired
    private PorderPayTransMapper porderPayTransMapper;
    @Autowired
    private PorderMapper porderMapper;
    @Autowired
    private PayMethodMapper payMethodMapper;

    public PayProUpdatePayOrderInfoAfterRefundBusiRspBo updatePayOrderInfo(PayProUpdatePayOrderInfoAfterRefundBusiReqBo reqBo) {
        PayProUpdatePayOrderInfoAfterRefundBusiRspBo retBo = new PayProUpdatePayOrderInfoAfterRefundBusiRspBo();
        String validateArgStr = this.validateArg(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return retBo;
        }
        Date dbDate = this.payMethodMapper.getDBDate().getDate();
        long payRefundFeeHao = MoneyUtils.fenToHao((Long)(reqBo.getRefundedFee() + reqBo.getRefundFee())).longValue();
        PorderPo updatePayOrderPo = new PorderPo();
        updatePayOrderPo.setOrderId(reqBo.getOrderId());
        updatePayOrderPo.setUpdateTime(dbDate);
        updatePayOrderPo.setOrderRefundId(reqBo.getOrderRefundIdStr());
        updatePayOrderPo.setRefundFee(payRefundFeeHao);
        int updatePayOrderRet = this.porderMapper.update(updatePayOrderPo);
        PorderPayTransPo updatePayTransPo = new PorderPayTransPo();
        updatePayTransPo.setPayOrderId(reqBo.getPayOrderId());
        updatePayTransPo.setOrderId(reqBo.getOrderId());
        updatePayTransPo.setUpdateTime(dbDate);
        updatePayTransPo.setRefundFee(payRefundFeeHao);
        int updatePayTransRet = this.porderPayTransMapper.update(updatePayTransPo);
        if (updatePayTransRet != 1 && updatePayOrderRet != 1) {
            LOG.error("\u9000\u6b3e\u4e4b\u540e\u66f4\u65b0\u652f\u4ed8\u6570\u636e\u5f02\u5e38\uff1a\u66f4\u65b0\u6ca1\u6709\u5168\u90e8\u8fd4\u56de1");
            throw new BusinessException("6014", "\u9000\u6b3e\u4e4b\u540e\u66f4\u65b0\u652f\u4ed8\u6570\u636e\u5f02\u5e38\uff1a\u66f4\u65b0\u6ca1\u6709\u5168\u90e8\u8fd4\u56de1");
        }
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u8c03\u7528\u6210\u529f");
        return retBo;
    }

    private String validateArg(PayProUpdatePayOrderInfoAfterRefundBusiReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027payOrderId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027oriOrderId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getOrderRefundIdStr())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027payOrderRefundIdStr\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getRefundedFee())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027refundedFee\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getRefundFee())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027refundFee\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

