/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.payment.pay.atom.PayOrderAtomService;
import com.tydic.payment.pay.atom.PorderPayTransAtomService;
import com.tydic.payment.pay.atom.bo.PorderPayTransAtomReqBo;
import com.tydic.payment.pay.busi.QueryDBDateBusiService;
import com.tydic.payment.pay.busi.UnionQrCodePayBusiService;
import com.tydic.payment.pay.busi.bo.UnionQrCodePayBusiReqBO;
import com.tydic.payment.pay.busi.bo.UnionQrCodePayBusiRspBO;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.dao.po.PorderPo;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.sdk.unionpay.AcpService;
import com.tydic.payment.pay.sdk.unionpay.SdkConfig;
import com.tydic.payment.pay.util.UnionPayAcpSdkConfigUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="unionQrCodePayBusiService")
public class UnionQrCodePayBusiServiceImpl
implements UnionQrCodePayBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnionQrCodePayBusiServiceImpl.class);
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private PayOrderAtomService payOrderAtomService;
    @Autowired
    private PorderPayTransAtomService porderPayTransAtomService;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;
    @Resource
    FileClient fileClient;

    public UnionQrCodePayBusiRspBO dealUnionQrCodePay(UnionQrCodePayBusiReqBO req) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u94f6\u8054\u4e8c\u7ef4\u7801\uff08\u4e3b\u626b-C\u626bB\u6a21\u5f0f\uff09\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)req));
        }
        PorderPo orderInfo = this.queryOrderInfo(req.getOrderId());
        Date createTime = this.queryDBDateBusiService.getDBDate();
        long timeExpire = createTime.getTime() + 180000L;
        String payOrderId = this.createPayTrans(orderInfo, createTime);
        this.loadProperties(req);
        Map<String, String> payReqContent = this.createPayReqContent(req, orderInfo, payOrderId, createTime, timeExpire);
        Map reqData = AcpService.sign(payReqContent, (String)"UTF-8");
        String requestAppUrl = SdkConfig.getConfig().getBackRequestUrl();
        Map rspData = AcpService.post((Map)reqData, (String)requestAppUrl, (String)"UTF-8");
        UnionQrCodePayBusiRspBO rsp = new UnionQrCodePayBusiRspBO();
        rsp.setPayOrderId(payOrderId);
        if (rspData.isEmpty()) {
            rsp.setRspCode("2000");
            rsp.setRspName("\u94f6\u8054\u63a5\u53e3\u8fd4\u56de\u5185\u5bb9\u4e3a\u7a7a\uff01");
            return rsp;
        }
        if (!AcpService.validate((Map)rspData, (String)"UTF-8")) {
            rsp.setRspCode("2001");
            rsp.setRspName("\u6821\u9a8c\u8fd4\u56de\u7b7e\u540d\u5931\u8d25\uff01");
            return rsp;
        }
        String respCode = (String)rspData.get("respCode");
        if (!"00".equals(respCode)) {
            rsp.setRspCode("8888");
            rsp.setRspName((String)rspData.get("respMsg"));
            return rsp;
        }
        String qrCode = (String)rspData.get("qrCode");
        rsp.setRspCode("0000");
        rsp.setRspName("\u83b7\u53d6\u4e8c\u7ef4\u7801\u6210\u529f\uff01");
        rsp.setQrCode(qrCode);
        Date now = this.queryDBDateBusiService.getDBDate();
        long seconds = (timeExpire - now.getTime()) / 1000L;
        String effectiveSeconds = String.valueOf(seconds);
        rsp.setEffectiveSeconds(effectiveSeconds);
        return rsp;
    }

    private PorderPo queryOrderInfo(String orderId) {
        return this.payOrderAtomService.queryPorderInfo(Long.valueOf(orderId));
    }

    private String createPayTrans(PorderPo orderInfo, Date createTime) {
        PorderPayTransAtomReqBo orderPayTransAtomReq = new PorderPayTransAtomReqBo();
        orderPayTransAtomReq.setOrderId(orderInfo.getOrderId());
        orderPayTransAtomReq.setBusiId(orderInfo.getBusiId());
        orderPayTransAtomReq.setMerchantId(orderInfo.getMerchantId());
        orderPayTransAtomReq.setPayMethod(Long.parseLong("112"));
        orderPayTransAtomReq.setOrderStatus("A00");
        orderPayTransAtomReq.setPayFee(orderInfo.getTotalFee());
        orderPayTransAtomReq.setCreateTime(createTime);
        try {
            return this.porderPayTransAtomService.createOrderPayTrans(orderPayTransAtomReq);
        }
        catch (Exception e) {
            throw new BusinessException("\u7cfb\u7edf\u5f02\u5e38", "\u521b\u5efa\u652f\u4ed8\u6d41\u6c34\u5931\u8d25\uff1a", (Throwable)e);
        }
    }

    private void loadProperties(UnionQrCodePayBusiReqBO req) {
        HashMap<String, String> payParaMap = new HashMap<String, String>(req.getParamMap().size());
        Set set = req.getParamMap().keySet();
        for (String key : set) {
            payParaMap.put(key, (String)req.getParamMap().get(key));
        }
        UnionPayAcpSdkConfigUtils.setMerInfoByMap(this.payPropertiesVo, this.fileClient, payParaMap);
    }

    private Map<String, String> createPayReqContent(UnionQrCodePayBusiReqBO req, PorderPo orderInfo, String payOrderId, Date createTime, long timeExpire) {
        String merId = (String)req.getParamMap().get("merId");
        HashMap<String, String> payReqContent = new HashMap<String, String>(64);
        payReqContent.put("version", SdkConfig.getConfig().getVersion());
        payReqContent.put("encoding", "UTF-8");
        payReqContent.put("signMethod", SdkConfig.getConfig().getSignMethod());
        payReqContent.put("txnType", "01");
        payReqContent.put("txnSubType", "07");
        payReqContent.put("bizType", "000000");
        payReqContent.put("channelType", "08");
        payReqContent.put("merId", merId);
        payReqContent.put("accessType", "0");
        payReqContent.put("orderId", payOrderId);
        payReqContent.put("txnTime", DateUtils.dateToStr((Date)createTime, (String)"yyyyMMddHHmmss"));
        payReqContent.put("txnAmt", String.valueOf(MoneyUtils.haoToFen((Long)orderInfo.getTotalFee()).longValue()));
        payReqContent.put("currencyCode", "156");
        payReqContent.put("backUrl", SdkConfig.getConfig().getBackUrl());
        payReqContent.put("payTimeout", new SimpleDateFormat("yyyyMMddHHmmss").format(timeExpire));
        return payReqContent;
    }
}

