/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.comb.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.payment.pay.busi.CallBackNoticeService;
import com.tydic.payment.pay.busi.PayProCreateOrderPayTransBusiService;
import com.tydic.payment.pay.busi.PayProQueryPayParaBusiService;
import com.tydic.payment.pay.busi.PayProUpdateOrderTransBusiService;
import com.tydic.payment.pay.busi.QueryCashierService;
import com.tydic.payment.pay.busi.QueryDBDateBusiService;
import com.tydic.payment.pay.busi.bo.CallBackNoticeReqBo;
import com.tydic.payment.pay.busi.bo.CallBackNoticeRspBo;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayRspBo;
import com.tydic.payment.pay.busi.bo.PayProCreateOrderPayTransBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayProCreateOrderPayTransBusiRspBo;
import com.tydic.payment.pay.busi.bo.PayProQueryPayParaBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayProQueryPayParaBusiRspBo;
import com.tydic.payment.pay.busi.bo.PayProUpdateOrderTransBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayProUpdateOrderTransBusiRspBo;
import com.tydic.payment.pay.busi.bo.QueryCashierReqBo;
import com.tydic.payment.pay.busi.bo.QueryCashierRspBo;
import com.tydic.payment.pay.comb.PayProOrderCombService;
import com.tydic.payment.pay.comb.PayProOrderRevertCombService;
import com.tydic.payment.pay.comb.PayProPreparedOrderCombService;
import com.tydic.payment.pay.comb.bo.PayProOrderCombServiceReqBo;
import com.tydic.payment.pay.comb.bo.PayProOrderCombServiceRspBo;
import com.tydic.payment.pay.comb.bo.PayProOrderCreateCombBusiReqDataBo;
import com.tydic.payment.pay.comb.bo.PayProOrderCreateCombBusiRspDataBo;
import com.tydic.payment.pay.comb.bo.PayProOrderCreateCombOrderReqDataBo;
import com.tydic.payment.pay.comb.bo.PayProOrderRevertCombServiceReqBo;
import com.tydic.payment.pay.comb.bo.PayProOrderRevertCombServiceRspBo;
import com.tydic.payment.pay.comb.bo.PayProPreparedOrderCombReqBo;
import com.tydic.payment.pay.comb.bo.PayProPreparedOrderCombRspBo;
import com.tydic.payment.pay.common.util.OrderCiphertext;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.constant.PayProConstants;
import com.tydic.payment.pay.payable.api.PayAble;
import com.tydic.payment.pay.util.BeanUtils;
import com.tydic.payment.pay.util.PayAbleManager;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class PayProOrderCombServiceImpl
implements PayProOrderCombService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PayProOrderCombServiceImpl.class);
    private static final String HTTP_PREFIX = "http://";
    private static final String HTTPS_PREFIX = "https://";
    private static final int OUT_ORDER_ID_MAX_SIZE = 64;
    private static final String DEFAULT_EXPIRE_TIME = "3";
    @Autowired
    private PayProCreateOrderPayTransBusiService payProCreateOrderPayTransBusiService;
    @Autowired
    private PayProPreparedOrderCombService payProPreparedOrderCombService;
    @Autowired
    private PayProQueryPayParaBusiService payProQueryPayParaBusiService;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;
    @Autowired
    private PayProUpdateOrderTransBusiService payProUpdateOrderTransBusiService;
    @Autowired
    private CallBackNoticeService callBackNoticeService;
    @Autowired
    private PayProOrderRevertCombService payProOrderRevertCombService;
    @Autowired
    private QueryCashierService queryCashierService;
    @Autowired
    private PayAbleManager payAbleManager;
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    private Set<String> uniPayMethodSet = new HashSet<String>();

    @PostConstruct
    public void initObject() {
        String uniPayMethod = this.payPropertiesVo.getValueByKey("uni.pay.method");
        if (!StringUtils.isEmpty((Object)uniPayMethod)) {
            Collections.addAll(this.uniPayMethodSet, uniPayMethod.split(","));
        }
    }

    public PayProOrderCombServiceRspBo dealOrder(PayProOrderCombServiceReqBo reqBo) {
        PayProPreparedOrderCombRspBo createOrderRetBo;
        PayProOrderCreateCombBusiReqDataBo busiDataBo;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u7edf\u4e00\u652f\u4ed8comb\u670d\u52a1\u5165\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)reqBo));
        }
        PayProOrderCombServiceRspBo retBo = new PayProOrderCombServiceRspBo();
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            LOGGER.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("3007");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        JSONObject busiJson = JSONObject.parseObject((String)reqBo.getBusiReqData());
        JSONObject orderJson = JSONObject.parseObject((String)reqBo.getOrderReqData());
        LOGGER.info("busiReqData:" + busiJson);
        LOGGER.info("orderReqData\uff1a" + orderJson);
        try {
            busiDataBo = (PayProOrderCreateCombBusiReqDataBo)JSONObject.toJavaObject((JSON)busiJson, PayProOrderCreateCombBusiReqDataBo.class);
            PayProOrderCreateCombOrderReqDataBo orderDataBo = (PayProOrderCreateCombOrderReqDataBo)JSONObject.toJavaObject((JSON)orderJson, PayProOrderCreateCombOrderReqDataBo.class);
        }
        catch (Exception e) {
            LOGGER.error("\u5c06\u53c2\u6570\u5b57\u7b26\u4e32\u8f6c\u6362\u4e3a\u53c2\u6570\u5bf9\u8c61\u65f6\u5f02\u5e38\uff1a" + e);
            retBo.setRespCode("3007");
            retBo.setRespDesc("\u5c06\u53c2\u6570\u5b57\u7b26\u4e32\u8f6c\u6362\u4e3a\u53c2\u6570\u5bf9\u8c61\u65f6\u5f02\u5e38\uff1a" + e);
            return retBo;
        }
        boolean isReturnUrl = false;
        String cashierTemplateUrl = null;
        if (StringUtils.isEmpty((Object)reqBo.getPayMethod())) {
            isReturnUrl = true;
            cashierTemplateUrl = this.queryCashierTemplate(reqBo, retBo);
            if (StringUtils.isEmpty((Object)cashierTemplateUrl)) {
                return retBo;
            }
        } else if (!this.uniPayMethodSet.contains(reqBo.getPayMethod())) {
            LOGGER.error("\u6b64\u63a5\u53e3\u6682\u4e0d\u652f\u6301\u6b64\u652f\u4ed8\u65b9\u5f0f\uff1a'payMethod = " + reqBo.getPayMethod() + "'");
            retBo.setRespCode("3007");
            retBo.setRespDesc("\u6b64\u63a5\u53e3\u6682\u4e0d\u652f\u6301\u6b64\u652f\u4ed8\u65b9\u5f0f\uff1a'payMethod = " + reqBo.getPayMethod() + "'");
            return retBo;
        }
        PayProPreparedOrderCombReqBo createOrderBo = new PayProPreparedOrderCombReqBo();
        this.sortCreateOrderBo(reqBo, createOrderBo);
        createOrderBo.setOrderType("01");
        if (!StringUtils.isEmpty((Object)reqBo.getPayMethod()) && PayProConstants.PayMethod.ALI_TRANS.getPayMethod().equals(Long.valueOf(reqBo.getPayMethod()))) {
            createOrderBo.setOrderType("07");
        }
        if (!"0000".equals((createOrderRetBo = this.payProPreparedOrderCombService.createOrder(createOrderBo)).getRespCode())) {
            retBo.setRespCode("3007");
            retBo.setRespDesc("\u8c03\u7528\u4e0b\u5355\u7ec4\u5408\u670d\u52a1\u5931\u8d25\uff1a" + createOrderRetBo.getRespDesc());
            return retBo;
        }
        String orderId = createOrderRetBo.getOrderId();
        if (isReturnUrl) {
            String secreteOrde = OrderCiphertext.encode((byte[])orderId.getBytes());
            cashierTemplateUrl = cashierTemplateUrl + "?orderId=" + secreteOrde;
            BeanUtils.copyProperties((Object)reqBo, (Object)retBo);
            PayProOrderCreateCombBusiRspDataBo combBusiRspDataBo = new PayProOrderCreateCombBusiRspDataBo();
            String payOneCodeUrl = this.payPropertiesVo.getValueByKey("pay.one.code.url");
            if (StringUtils.isEmpty((Object)payOneCodeUrl)) {
                LOGGER.error("\u4e00\u7801\u4ed8\u5730\u5740\uff08pay.one.code.url\uff09\u672a\u914d\u7f6e");
            }
            combBusiRspDataBo.setOneCodeUrl(payOneCodeUrl + orderId + "/" + reqBo.getTotalFee());
            String combBusiRspDataStr = JSON.toJSONString((Object)combBusiRspDataBo);
            retBo.setBusiRspData(combBusiRspDataStr);
            retBo.setUrl(cashierTemplateUrl);
            retBo.setOrderId(orderId);
            retBo.setRespCode("0000");
            retBo.setRespDesc("\u6210\u529f");
            return retBo;
        }
        Long payMethod = Long.valueOf(reqBo.getPayMethod());
        PayAble payAble = this.payAbleManager.getPayAbleByPayMethod(payMethod);
        PayProCreateOrderPayTransBusiReqBo createTransBo = new PayProCreateOrderPayTransBusiReqBo();
        this.sortTransBo(reqBo, payMethod, createOrderRetBo, createTransBo);
        PayProCreateOrderPayTransBusiRspBo createTransRetBo = this.payProCreateOrderPayTransBusiService.createPayTrans(createTransBo);
        if (!"0000".equals(createTransRetBo.getRespCode())) {
            retBo.setRespCode("3007");
            retBo.setRespDesc("\u8c03\u7528\u5199trans\u8868busi\u670d\u52a1\u5931\u8d25\uff1a" + createTransRetBo.getRespDesc());
            return retBo;
        }
        PayProQueryPayParaBusiReqBo qryPayParaBo = new PayProQueryPayParaBusiReqBo();
        qryPayParaBo.setPayMethod(payMethod);
        qryPayParaBo.setMerchantId(Long.valueOf(reqBo.getMerchantId()));
        PayProQueryPayParaBusiRspBo payProQueryPayParaBusiRspBo = this.payProQueryPayParaBusiService.queryPayPara(qryPayParaBo);
        if (!"0000".equals(payProQueryPayParaBusiRspBo.getRespCode())) {
            retBo.setRespCode("3007");
            retBo.setRespDesc("\u67e5\u8be2\u652f\u4ed8\u53c2\u6570\u5931\u8d25\uff1a" + payProQueryPayParaBusiRspBo.getRespDesc());
            return retBo;
        }
        PayAbleDealPayReqBo payAbleReqBo = new PayAbleDealPayReqBo();
        this.sortPayAbleBo(reqBo, payProQueryPayParaBusiRspBo, payAbleReqBo, createTransRetBo, busiDataBo, orderId);
        PayAbleDealPayRspBo payAbleRet = new PayAbleDealPayRspBo();
        boolean callAble = true;
        try {
            payAbleRet = payAble.dealPay(payAbleReqBo);
        }
        catch (Exception e) {
            LOGGER.error("\u8c03\u7528payable\u5b9e\u73b0\u7c7b\u4e0b\u5355\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            payAbleRet.setRespDesc("\u8c03\u7528payable\u5b9e\u73b0\u7c7b\u4e0b\u5355\u5f02\u5e38\uff1a" + e.getMessage());
            callAble = false;
        }
        if (!"0000".equals(payAbleRet.getRespCode()) || !callAble) {
            PayProOrderRevertCombServiceReqBo revertReqBo = new PayProOrderRevertCombServiceReqBo();
            revertReqBo.setOrderId(orderId);
            revertReqBo.setOutOrderId(reqBo.getOutOrderId());
            revertReqBo.setBusId(reqBo.getBusiId());
            revertReqBo.setPayOrderId(createTransRetBo.getPayOrderId());
            PayProOrderRevertCombServiceRspBo revertRetBo = this.payProOrderRevertCombService.revertOrder(revertReqBo);
            if (!"0000".equals(revertRetBo.getRespCode())) {
                LOGGER.error("\u56de\u6eda\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\uff1a" + revertRetBo.getRespDesc());
                retBo.setRespCode("3007");
                retBo.setRespDesc(payAbleRet.getRespDesc() + "||" + revertRetBo.getRespDesc());
                return retBo;
            }
            retBo.setRespCode("3007");
            retBo.setRespDesc(payAbleRet.getRespDesc());
            return retBo;
        }
        if ("0000".equals(payAbleRet.getRespCode()) && "SUCCESS".equals(payAbleRet.getPayResultCode())) {
            PayProUpdateOrderTransBusiReqBo updateOrderBo = new PayProUpdateOrderTransBusiReqBo();
            updateOrderBo.setOrderId(Long.valueOf(orderId));
            updateOrderBo.setPayOrderId(createTransRetBo.getPayOrderId());
            updateOrderBo.setPayNotifyTime(this.queryDBDateBusiService.getDBDate());
            updateOrderBo.setOrderStatus("A10");
            updateOrderBo.setPayNotifyMsg(payAbleRet.getPayResultMsg());
            updateOrderBo.setPayNotifyTransId(payAbleRet.getPayNotifyTransId());
            updateOrderBo.setTradeTime(payAbleRet.getTradeTime());
            updateOrderBo.setPayNotifyCode("0");
            updateOrderBo.setPayOrderId(createTransRetBo.getPayOrderId());
            PayProUpdateOrderTransBusiRspBo payProUpdateOrderTransBusiRspBo = this.payProUpdateOrderTransBusiService.updateOrderData(updateOrderBo);
            if (!"0000".equals(payProUpdateOrderTransBusiRspBo.getRespCode())) {
                retBo.setRespCode("3003");
                retBo.setRespDesc("\u5373\u65f6\u652f\u4ed8\u8fd4\u56de\u65f6\u66f4\u65b0\u6570\u636e\u5931\u8d25\uff1a" + payProUpdateOrderTransBusiRspBo.getRespDesc());
                return retBo;
            }
            CallBackNoticeReqBo callBackNoticeReqBo = new CallBackNoticeReqBo();
            callBackNoticeReqBo.setOrderId(Long.valueOf(orderId));
            CallBackNoticeRspBo callBackNoticeRspBo = this.callBackNoticeService.dealPayPutMq(callBackNoticeReqBo);
            if ("0000".equals(callBackNoticeRspBo.getRspCode())) {
                LOGGER.info("\u8ba2\u5355\uff1a" + orderId + "\u53d1\u9001\u6d88\u606f\u961f\u5217\u6210\u529f");
            }
        }
        this.sortRetBo(reqBo, payAbleRet, retBo);
        return retBo;
    }

    private String queryCashierTemplate(PayProOrderCombServiceReqBo reqBo, PayProOrderCombServiceRspBo retBo) {
        String cashierTemplateUrl = null;
        QueryCashierReqBo queryCashierReqBo = new QueryCashierReqBo();
        queryCashierReqBo.setBusiId(reqBo.getBusiId());
        queryCashierReqBo.setReqWay(reqBo.getReqWay());
        QueryCashierRspBo queryCashierRspBo = this.queryCashierService.queryCashier(queryCashierReqBo);
        if (!"0000".equals(queryCashierRspBo.getRspCode())) {
            retBo.setRespCode(queryCashierRspBo.getRspCode());
            retBo.setRespDesc(queryCashierRspBo.getRspName());
            return null;
        }
        cashierTemplateUrl = queryCashierRspBo.getCashierTemplateUrl();
        if (StringUtils.isEmpty((Object)cashierTemplateUrl)) {
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u8be5\u63a5\u5165\u65b9\u5f0f\u5bf9\u5e94\u7684\u6536\u94f6\u53f0\u6ca1\u6709\u914d\u7f6e\u6536\u94f6\u53f0\u5730\u5740");
            return cashierTemplateUrl;
        }
        return cashierTemplateUrl;
    }

    private void sortRetBo(PayProOrderCombServiceReqBo reqBo, PayAbleDealPayRspBo payAbleRet, PayProOrderCombServiceRspBo retBo) {
        String busiRspData = this.generateRspDataStr(reqBo, payAbleRet);
        BeanUtils.copyProperties((Object)payAbleRet, (Object)retBo);
        retBo.setOutOrderId(reqBo.getOutOrderId());
        retBo.setOrderId(payAbleRet.getOrderId().toString());
        retBo.setPayFee(payAbleRet.getPayFee().toString());
        retBo.setBusiRspData(busiRspData);
        retBo.setMerchantId(reqBo.getMerchantId());
        retBo.setRemark(reqBo.getRemark());
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
    }

    private String generateRspDataStr(PayProOrderCombServiceReqBo reqBo, PayAbleDealPayRspBo payAbleRet) {
        JSONObject json = new JSONObject();
        if (!StringUtils.isEmpty((Object)payAbleRet.getBusiRspDataBo())) {
            json = JSONObject.parseObject((String)payAbleRet.getBusiRspDataBo());
        }
        if (!StringUtils.isEmpty((Object)reqBo.getRedirectUrl())) {
            json.put("redirectUrl", (Object)reqBo.getRedirectUrl());
        }
        if (!StringUtils.isEmpty((Object)payAbleRet.getPayResultCode())) {
            json.put("tradeTime", (Object)payAbleRet.getTradeTime());
            json.put("payNotifyTransId", (Object)payAbleRet.getPayNotifyTransId());
            json.put("payResultCode", (Object)payAbleRet.getPayResultCode());
            json.put("payResultMsg", (Object)payAbleRet.getPayResultMsg());
        }
        json.put("qrCodeUrl", (Object)payAbleRet.getQrCodeUrl());
        json.put("webUrl", (Object)payAbleRet.getWebUrl());
        json.put("htmlBody", (Object)payAbleRet.getHtmlBody());
        json.put("orderInfoStr", (Object)payAbleRet.getOrderInfoStr());
        String busiRspData = json.toJSONString();
        LOGGER.info("busiRspData\u4e3a:" + busiRspData);
        return busiRspData;
    }

    private void sortPayAbleBo(PayProOrderCombServiceReqBo reqBo, PayProQueryPayParaBusiRspBo payProQueryPayParaBusiRspBo, PayAbleDealPayReqBo payAbleReqBo, PayProCreateOrderPayTransBusiRspBo createTransRetBo, PayProOrderCreateCombBusiReqDataBo busiDataBo, String orderId) {
        BeanUtils.copyProperties((Object)reqBo, (Object)payAbleReqBo);
        payAbleReqBo.setOrderId(Long.valueOf(orderId));
        payAbleReqBo.setBusiId(Long.valueOf(reqBo.getBusiId()));
        payAbleReqBo.setPayOrderId(createTransRetBo.getPayOrderId());
        payAbleReqBo.setPayFee(Long.valueOf(reqBo.getTotalFee()));
        payAbleReqBo.setParaMap(payProQueryPayParaBusiRspBo.getDetailAttrs());
        payAbleReqBo.setDetailName(reqBo.getDetailName());
        payAbleReqBo.setBusiReqData(reqBo.getBusiReqData());
        if (busiDataBo != null) {
            payAbleReqBo.setAuthCode(busiDataBo.getAuthCode());
            payAbleReqBo.setHbfqNum(busiDataBo.getHbfqNum());
            payAbleReqBo.setHbfqSellerPercent(busiDataBo.getHbfqSellerPercent());
        }
    }

    private void sortCreateOrderBo(PayProOrderCombServiceReqBo reqBo, PayProPreparedOrderCombReqBo createOrderBo) {
        BeanUtils.copyProperties((Object)reqBo, (Object)createOrderBo);
        createOrderBo.setBusiId(Long.valueOf(reqBo.getBusiId()));
        createOrderBo.setOutRemark(reqBo.getRemark());
    }

    private void sortTransBo(PayProOrderCombServiceReqBo reqBo, Long payMethod, PayProPreparedOrderCombRspBo createOrderRetBo, PayProCreateOrderPayTransBusiReqBo createTransBo) {
        createTransBo.setOrderId(Long.valueOf(Long.parseLong(createOrderRetBo.getOrderId())));
        createTransBo.setBusiId(createOrderRetBo.getBusiId());
        createTransBo.setPayMethod(payMethod);
        createTransBo.setMerchantId(Long.valueOf(Long.parseLong(reqBo.getMerchantId())));
        createTransBo.setPayFee(Long.valueOf(Long.parseLong(reqBo.getTotalFee())));
    }

    private String validateArgs(PayProOrderCombServiceReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getBusiId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'busiId'\u4e0d\u80fd\u4e3a\u7a7a'";
        }
        if (StringUtils.isEmpty((Object)reqBo.getMerchantId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'merchantId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getOutOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'outOrderId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (reqBo.getOutOrderId().trim().length() > 64) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'outOrderId'\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc764";
        }
        if (StringUtils.isEmpty((Object)reqBo.getBusiCode()) && StringUtils.isEmpty((Object)reqBo.getBusiId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'busiCode','busiId'\u4e0d\u80fd\u4e3a\u540c\u65f6\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getTotalFee())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'totalFee'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (!StringUtils.isEmpty((Object)reqBo.getPayMethod())) {
            try {
                Long.parseLong(reqBo.getPayMethod());
            }
            catch (NumberFormatException e) {
                return "\u5165\u53c2\u5bf9\u8c61\u719f\u5c5e\u6027\u2019payMethod\u2018\u53ea\u80fd\u4e3a\u6570\u5b57";
            }
        } else if (StringUtils.isEmpty((Object)reqBo.getReqWay())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'reqWay\u4e0d\u80fd\u4e3a\u7a7a(\u5f53payMethod\u4e3a\u7a7a\u65f6\u5fc5\u4f20)'";
        }
        if (!(StringUtils.isEmpty((Object)reqBo.getRedirectUrl()) || reqBo.getRedirectUrl().trim().startsWith(HTTP_PREFIX) || reqBo.getRedirectUrl().trim().startsWith(HTTPS_PREFIX))) {
            return "redirectUrl\u5fc5\u987b\u4ee5'http://'\u6216\u8005'https://'\u5f00\u5934";
        }
        if (!(StringUtils.isEmpty((Object)reqBo.getNotifyUrl()) || reqBo.getNotifyUrl().trim().startsWith(HTTP_PREFIX) || reqBo.getNotifyUrl().trim().startsWith(HTTPS_PREFIX))) {
            return "notifyUrl\u5fc5\u987b\u4ee5'http://'\u6216\u8005'https://'\u5f00\u5934";
        }
        if (StringUtils.isEmpty((Object)reqBo.getExtTime())) {
            String expTime = this.payPropertiesVo.getValueByKey("pay.order.expire.time");
            if (StringUtils.isEmpty((Object)expTime)) {
                reqBo.setExtTime(DEFAULT_EXPIRE_TIME);
            } else {
                reqBo.setExtTime(expTime);
            }
        }
        return null;
    }
}

