/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.config.mq;

import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.RedisCacheStore;
import com.ohaotian.plugin.mq.proxy.impl.ProxyMessageRegister;
import com.ohaotian.plugin.mq.proxy.impl.ProxyProducerFactoryBean;
import com.ohaotian.plugin.mq.proxy.internal.ProxyMessageConfig;
import com.tydic.payment.pay.busi.impl.CallBackNoticeConsume;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.PropertiesFactoryBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MqConfiguration {
    @Value(value="${PAY_NOTIFY_PID}")
    private String payNotifyPid;
    @Value(value="${PAY_NOTIFY_CID}")
    private String payNotifyCid;
    @Value(value="${PAY_NOTIFY_TOPIC}")
    private String payNotifyTopic;
    @Value(value="${mq.strategy}")
    public String mqStrategy;
    @Value(value="${mq.enable}")
    private String mqEnable;
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private AutowireCapableBeanFactory autowireCapableBeanFactory;
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());

    @Bean
    public DefaultProxyMessageConfig defaultProxyMessageConfig() {
        DefaultProxyMessageConfig config = new DefaultProxyMessageConfig();
        config.setId(this.payNotifyPid);
        this.LOGGER.info("PAY_NOTIFY_PID = " + this.payNotifyPid);
        return config;
    }

    @Bean
    public PropertiesFactoryBean propertiesFactoryBean() {
        PropertiesFactoryBean propertiesFactoryBean = new PropertiesFactoryBean();
        propertiesFactoryBean.setProperties(this.payPropertiesVo.getProperties());
        return propertiesFactoryBean;
    }

    @Bean(value={"callBack"}, initMethod="startup", destroyMethod="shutdown")
    public ProxyProducerFactoryBean proxyProducerFactoryBean() {
        ProxyProducerFactoryBean proxyProducerFactoryBean = new ProxyProducerFactoryBean();
        proxyProducerFactoryBean.setMessageConfig((ProxyMessageConfig)this.defaultProxyMessageConfig());
        return proxyProducerFactoryBean;
    }

    @Bean(value={"callBackNoticeConsume"})
    public CallBackNoticeConsume callBackNoticeConsume() {
        CallBackNoticeConsume callBackNoticeConsume = new CallBackNoticeConsume();
        callBackNoticeConsume.setId(this.payNotifyCid);
        callBackNoticeConsume.setSubject(this.payNotifyTopic);
        this.LOGGER.info("PAY_NOTIFY_CID = " + this.payNotifyCid);
        this.LOGGER.info("PAY_NOTIFY_TOPIC = " + this.payNotifyTopic);
        String[] tags = new String[]{"*"};
        callBackNoticeConsume.setTags(tags);
        return callBackNoticeConsume;
    }

    @Bean(initMethod="startup", destroyMethod="shutdown")
    public ProxyMessageRegister proxyMessageRegister() {
        ProxyMessageRegister proxyMessageRegister = new ProxyMessageRegister();
        proxyMessageRegister.setStrategy(this.mqStrategy);
        proxyMessageRegister.setEnable(this.mqEnable);
        this.LOGGER.info("mq.strategy = " + this.mqStrategy);
        this.LOGGER.info("mq.enable = " + this.mqEnable);
        return proxyMessageRegister;
    }

    @Bean
    public RedisCacheStore redisCacheStore() {
        RedisCacheStore redisCacheStore = new RedisCacheStore();
        return redisCacheStore;
    }
}

