/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.payable.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.payment.pay.bestpay.util.BestPayAppResponseBean;
import com.tydic.payment.pay.bestpay.util.BestPayNotifyDataBean;
import com.tydic.payment.pay.bestpay.util.BestPaySign;
import com.tydic.payment.pay.bestpay.util.HttpClientPost;
import com.tydic.payment.pay.busi.PayProGetParamsBusiService;
import com.tydic.payment.pay.busi.QueryDBDateBusiService;
import com.tydic.payment.pay.busi.bo.PayAbleCallBackReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleCallBackRspBo;
import com.tydic.payment.pay.busi.bo.PayAbleQryPayStatusReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleQryPayStatusRspBo;
import com.tydic.payment.pay.busi.bo.PayAbleRefundReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleRefundRspBo;
import com.tydic.payment.pay.busi.bo.PayProGetParamsBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayProGetParamsBusiRspBo;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.payable.api.PayAble;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public abstract class AbstractBastPayAble
implements PayAble {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private final Map<String, File> fileCache = new HashMap<String, File>();
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Resource
    private FileClient fileClient;
    @Autowired
    private PayProGetParamsBusiService payProGetParamsBusiService;

    public PayAbleRefundRspBo dealRefund(PayAbleRefundReqBo reqBo) {
        this.LOGGER.info("\u8fdb\u5165\u7ffc\u652f\u4ed8\u9000\u6b3e\u65b9\u6cd5\uff1a" + reqBo);
        PayAbleRefundRspBo retBo = new PayAbleRefundRspBo();
        String validateStr = this.validateRefundArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            this.LOGGER.error("\u7ffc\u652f\u4ed8\u9000\u6b3e\u65b9\u6cd5\uff0c\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("2044");
            retBo.setRespDesc("\u7ffc\u652f\u4ed8\u9000\u6b3e\u65b9\u6cd5\uff0c\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        String bestRefundRequestUrl = this.payPropertiesVo.getValueByKey("bestpay.app.refund.url");
        if (StringUtils.isEmpty((Object)bestRefundRequestUrl)) {
            this.LOGGER.error("\u7ffc\u652f\u4ed8\u8bf7\u6c42\u5730\u5740\u4e3a\u7a7a\uff0c\u8bf7\u914d\u7f6e\uff1abestpay.app.refund.url");
            retBo.setRespCode("2044");
            retBo.setRespDesc("\u7ffc\u652f\u4ed8\u8bf7\u6c42\u5730\u5740\u4e3a\u7a7a\uff0c\u8bf7\u914d\u7f6e\uff1abestpay.app.refund.url");
            return retBo;
        }
        String bestPayCallbackUrl = this.payPropertiesVo.getValueByKey("bestpay.app.callback.url");
        if (StringUtils.isEmpty((Object)bestPayCallbackUrl)) {
            this.LOGGER.error("\u7ffc\u652f\u4ed8\u56de\u8c03\u5730\u5740\u4e3a\u7a7a\uff0c\u8bf7\u914d\u7f6e\uff1abestpay.app.callback.url");
            retBo.setRespCode("2044");
            retBo.setRespDesc("\u7ffc\u652f\u4ed8\u56de\u8c03\u5730\u5740\u4e3a\u7a7a\uff0c\u8bf7\u914d\u7f6e\uff1abestpay.app.callback.url");
            return retBo;
        }
        Map paramMap = reqBo.getParaMap();
        String merchantId = (String)paramMap.get("merchantId");
        HashMap<String, String> dataMap = new HashMap<String, String>(16);
        this.assertMap(reqBo, dataMap, bestPayCallbackUrl);
        String sign = this.generateSign(paramMap, dataMap);
        dataMap.put("sign", sign);
        String bestPayRefDataStr = JSON.toJSONString(dataMap);
        this.LOGGER.info("\u7ffc\u652f\u4ed8\u9000\u6b3e\u63a5\u53e3\u5165\u53c2\uff1a" + bestPayRefDataStr);
        String response = null;
        try {
            response = HttpClientPost.reqPost((String)bestRefundRequestUrl, (String)bestPayRefDataStr);
        }
        catch (Exception e) {
            this.LOGGER.error("\u8c03\u7528\u7ffc\u652f\u4ed8\u9000\u6b3e\u63a5\u53e3\u53d1\u751f\u5f02\u5e38\uff1a" + e);
            retBo.setRespCode("2044");
            retBo.setRespDesc("\u5411\u7ffc\u652f\u4ed8\u4e0b\u5355\u65f6\u53d1\u751f\u5f02\u5e38\uff1a" + e);
            return retBo;
        }
        this.LOGGER.info("\u7ffc\u652f\u4ed8\u9000\u6b3e\u63a5\u53e3\u8fd4\u56de\u7684\u62a5\u6587\uff1a" + response);
        JSONObject bestRetJson = JSONObject.parseObject((String)response);
        if (!"true".equals(bestRetJson.getString("success"))) {
            this.LOGGER.error("\u5411\u7ffc\u652f\u4ed8\u9000\u6b3e\u5931\u8d25\uff1a" + bestRetJson.get((Object)"errorMsg"));
            retBo.setRespCode("2044");
            retBo.setRespDesc("\u5411\u7ffc\u652f\u4ed8\u9000\u6b3e\u5931\u8d25\uff1a" + bestRetJson.getString("errorMsg"));
            return retBo;
        }
        boolean signFlag = this.checkSign(paramMap, response);
        if (!signFlag) {
            this.LOGGER.error("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
            retBo.setRespCode("2044");
            retBo.setRespDesc("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
            return retBo;
        }
        String result = bestRetJson.getString("result");
        BestPayAppResponseBean bestRetBean = (BestPayAppResponseBean)JSONObject.toJavaObject((JSON)JSON.parseObject((String)result), BestPayAppResponseBean.class);
        if (!"success".equals(bestRetBean.getTradeStatus())) {
            retBo.setRespCode("2044");
            retBo.setRespDesc("\u9000\u6b3e\u5931\u8d25");
            return retBo;
        }
        BeanUtils.copyProperties((Object)reqBo, (Object)retBo);
        retBo.setRefundTransId(bestRetBean.getTradeNo());
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    public PayAbleQryPayStatusRspBo qryPayStatus(PayAbleQryPayStatusReqBo reqBo) {
        this.LOGGER.info("\u7ffc\u652f\u4ed8\u8ba2\u5355\u67e5\u8be2\u65b9\u6cd5\uff1a" + reqBo);
        PayAbleQryPayStatusRspBo retBo = new PayAbleQryPayStatusRspBo();
        String validateStr = this.validateQueryArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            this.LOGGER.error("\u7ffc\u652f\u4ed8\u8ba2\u5355\u67e5\u8be2\uff0c\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("2045");
            retBo.setRespDesc("\u7ffc\u652f\u4ed8\u8ba2\u5355\u67e5\u8be2\uff0c\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        String bestPayQueryUrl = this.payPropertiesVo.getValueByKey("bestpay.app.query.url");
        if (StringUtils.isEmpty((Object)bestPayQueryUrl)) {
            this.LOGGER.error("\u7ffc\u652f\u4ed8\u8bf7\u6c42\u5730\u5740\u4e3a\u7a7a\uff0c\u8bf7\u914d\u7f6e\uff1abestpay.app.query.url");
            retBo.setRespCode("2045");
            retBo.setRespDesc("\u7ffc\u652f\u4ed8\u8bf7\u6c42\u5730\u5740\u4e3a\u7a7a\uff0c\u8bf7\u914d\u7f6e\uff1abestpay.app.query.url");
            return retBo;
        }
        Map paramMap = reqBo.getParaMap();
        HashMap<String, String> qryReqDataMap = new HashMap<String, String>(16);
        qryReqDataMap.put("outTradeNo", reqBo.getPayOrderId());
        qryReqDataMap.put("merchantNo", (String)paramMap.get("merchantId"));
        qryReqDataMap.put("tradeDate", reqBo.getTradeTime());
        String sign = this.generateSign(paramMap, qryReqDataMap);
        qryReqDataMap.put("sign", sign);
        String qryReqDataStr = JSON.toJSONString(qryReqDataMap);
        this.LOGGER.info("\u7ffc\u652f\u4ed8\u8ba2\u5355\u67e5\u8be2\u63a5\u53e3\u5165\u53c2\uff1a" + qryReqDataStr);
        String responseStr = null;
        try {
            responseStr = HttpClientPost.reqPost((String)bestPayQueryUrl, (String)qryReqDataStr);
        }
        catch (IOException e) {
            this.LOGGER.error("\u8c03\u7528\u7ffc\u652f\u4ed8\u63a5\u53e3\u65f6\u53d1\u751f\u5f02\u5e38\uff1a" + e);
            retBo.setRespCode("2045");
            retBo.setRespDesc("\u8c03\u7528\u7ffc\u652f\u4ed8\u63a5\u53e3\u65f6\u53d1\u751f\u5f02\u5e38\uff1a" + e);
            return retBo;
        }
        this.LOGGER.info("\u7ffc\u652f\u4ed8\u8fd4\u56de\u7684\u62a5\u6587\u4e3a\uff1a" + responseStr);
        JSONObject bestRetJson = JSONObject.parseObject((String)responseStr);
        if (!"true".equals(bestRetJson.getString("success"))) {
            this.LOGGER.error("\u8c03\u7528\u7ffc\u652f\u4ed8\u8ba2\u5355\u67e5\u8be2\u63a5\u53e3\u5931\u8d25\uff1a" + bestRetJson.get((Object)"errorMsg"));
            retBo.setRespCode("2045");
            retBo.setRespDesc("\u8c03\u7528\u7ffc\u652f\u4ed8\u8ba2\u5355\u67e5\u8be2\u63a5\u53e3\u5931\u8d25\uff1a" + bestRetJson.getString("errorMsg"));
            return retBo;
        }
        boolean signFlag = this.checkSign(paramMap, responseStr);
        if (!signFlag) {
            this.LOGGER.error("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
            retBo.setRespCode("2043");
            retBo.setRespDesc("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
            return retBo;
        }
        String result = bestRetJson.getString("result");
        BestPayAppResponseBean bestRetBean = (BestPayAppResponseBean)JSONObject.toJavaObject((JSON)JSON.parseObject((String)result), BestPayAppResponseBean.class);
        BeanUtils.copyProperties((Object)reqBo, (Object)retBo);
        retBo.setPayStatus(this.setPayStatus(bestRetBean));
        if (!StringUtils.isEmpty((Object)bestRetBean.getTradeAmt())) {
            retBo.setRealFee(Long.valueOf(bestRetBean.getTradeAmt()));
        }
        retBo.setTradeTime(bestRetBean.getPayFinishedDate());
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    public PayAbleCallBackRspBo dealCallBack(PayAbleCallBackReqBo reqBo) {
        this.LOGGER.info("\u8fdb\u5165\u7ffc\u652f\u4ed8\u56de\u8c03\u5904\u7406\u65b9\u6cd5\uff1a" + reqBo);
        PayAbleCallBackRspBo retBo = new PayAbleCallBackRspBo();
        if (StringUtils.isEmpty((Object)reqBo.getReqData())) {
            this.LOGGER.error("\u7ffc\u652f\u4ed8\u56de\u8c03\u5904\u7406\u65b9\u6cd5\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a\u53c2\u6570'reqData'\u4e0d\u80fd\u4e3a\u7a7a");
            retBo.setRespCode("2046");
            retBo.setRespDesc("\u7ffc\u652f\u4ed8\u56de\u8c03\u5904\u7406\u65b9\u6cd5\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a\u53c2\u6570'reqData'\u4e0d\u80fd\u4e3a\u7a7a");
            return retBo;
        }
        JSONObject reqDataJson = JSONObject.parseObject((String)reqBo.getReqData());
        this.LOGGER.info("jsonObject:" + reqDataJson);
        BestPayNotifyDataBean notifyDataBean = (BestPayNotifyDataBean)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)reqDataJson.getString("result")), BestPayNotifyDataBean.class);
        this.LOGGER.info("\u8f6c\u6362\u540e\u7684\u56de\u8c03\u5bf9\u8c61\uff1a" + notifyDataBean);
        if (StringUtils.isEmpty((Object)notifyDataBean.getTradeNo())) {
            this.LOGGER.error("\u5c06\u62a5\u6587\u8f6c\u6362\u4e3a\u5bf9\u8c61\u5931\u8d25");
            retBo.setRespCode("2046");
            retBo.setRespDesc("\u5c06\u62a5\u6587\u8f6c\u6362\u4e3a\u5bf9\u8c61\u5931\u8d25");
            return retBo;
        }
        PayProGetParamsBusiReqBo getParamsBusiReqBo = new PayProGetParamsBusiReqBo();
        getParamsBusiReqBo.setPayOrderId(notifyDataBean.getOutTradeNo());
        PayProGetParamsBusiRspBo getParamsBusiRspBo = this.payProGetParamsBusiService.getParamMap(getParamsBusiReqBo);
        if (!"0000".equals(getParamsBusiRspBo.getRespCode())) {
            this.LOGGER.error("\u83b7\u53d6\u652f\u4ed8\u673a\u6784\u53c2\u6570map\u5931\u8d25\uff1a" + getParamsBusiRspBo.getRespDesc());
            retBo.setRespCode("2046");
            retBo.setRespDesc("\u83b7\u53d6\u652f\u4ed8\u673a\u6784\u53c2\u6570map\u5931\u8d25\uff1a" + getParamsBusiRspBo.getRespDesc());
            return retBo;
        }
        boolean signFlag = this.checkSign(getParamsBusiRspBo.getParamMap(), reqBo.getReqData());
        if (!signFlag) {
            this.LOGGER.error("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
            retBo.setRespCode("2046");
            retBo.setRespDesc("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
            return retBo;
        }
        retBo.setPayNotifyTransId(notifyDataBean.getTradeNo());
        retBo.setPayOrderId(notifyDataBean.getOutTradeNo());
        String tradeDate = notifyDataBean.getTradeFinishedDate();
        String[] DateStrs = tradeDate.split(" ");
        tradeDate = DateStrs[5] + DateStrs[1] + DateStrs[2] + DateStrs[3].replace(":", "");
        retBo.setTradeTime(tradeDate);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private String setPayStatus(BestPayAppResponseBean bestRetBean) {
        switch (bestRetBean.getTradeStatus()) {
            case "SUCCESS": {
                return "SUCCESS";
            }
            case "FAIL": {
                return "FAIL";
            }
            case "CLOSE": {
                return "CLOSED";
            }
            case "WAITFORPAY": {
                return "PAYING";
            }
        }
        return null;
    }

    private String validateRefundArgs(PayAbleRefundReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'payOrderId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getRefundOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'refundOrderId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getRefundFee())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'refundFee'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (reqBo.getParaMap() == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'paramMap'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        String validateMapStr = this.validateParaMap(reqBo.getParaMap());
        if (!StringUtils.isEmpty((Object)validateMapStr)) {
            return validateMapStr;
        }
        return null;
    }

    private String validateQueryArgs(PayAbleQryPayStatusReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'payOrderId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getTradeTime())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'createTime'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (reqBo.getParaMap() == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'paraMap'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        String validateMapStr = this.validateParaMap(reqBo.getParaMap());
        if (!StringUtils.isEmpty((Object)validateMapStr)) {
            return validateMapStr;
        }
        return null;
    }

    protected String validateParaMap(Map<String, String> paramMap) {
        if (StringUtils.isEmpty((Object)paramMap.get("merchantId"))) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'paramMap'\u4e2d\u7684'merchantId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)paramMap.get("priKeyPwd"))) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'paramMap'\u4e2d\u7684'priKeyPwd'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)paramMap.get("priKeyFile"))) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'paramMap'\u4e2d\u7684'priKeyFile'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)paramMap.get("pubKeyFile"))) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'paramMap'\u4e2d\u7684'pubKeyFile'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }

    private void assertMap(PayAbleRefundReqBo reqBo, Map<String, String> dataMap, String bestPayCallbackUrl) {
        Map paramMap = reqBo.getParaMap();
        String merchantId = (String)paramMap.get("merchantId");
        dataMap.put("outRequestNo", reqBo.getRefundOrderId());
        dataMap.put("merchantNo", merchantId);
        dataMap.put("outTradeNo", reqBo.getPayOrderId());
        dataMap.put("refundAmt", reqBo.getRefundFee() + "");
        dataMap.put("requestDate", new DateTime((Object)this.queryDBDateBusiService.getDBDate()).toString("yyyy-MM-dd HH:mm:ss"));
        dataMap.put("operator", merchantId);
        dataMap.put("tradeChannel", "APP");
        dataMap.put("accessCode", "CASHIER");
        dataMap.put("ccy", "156");
        dataMap.put("institutionCode", merchantId);
        dataMap.put("notifyUrl", bestPayCallbackUrl);
        dataMap.put("institutionType", "MERCHANT");
    }

    protected String generateSign(Map<String, String> paramMap, Map<String, String> dataMap) {
        String priKeyFile = paramMap.get("priKeyFile");
        String priKeyPwd = paramMap.get("priKeyPwd");
        File signFile = null;
        if (this.fileCache.get(priKeyFile) == null) {
            signFile = this.fileClient.downloadToFile("payCenter/" + priKeyFile);
            this.fileCache.put(priKeyFile, signFile);
        } else {
            signFile = this.fileCache.get(priKeyFile);
        }
        String sign = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(signFile);
            sign = BestPaySign.getSign(dataMap, (InputStream)fis, (String)priKeyPwd);
            fis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.LOGGER.info("\u751f\u6210\u7684\u7b7e\u540d\u4e3a\uff1a" + sign);
        return sign;
    }

    protected boolean checkSign(Map<String, String> paramMap, String responseStr) {
        boolean flag = false;
        String pubKeyFile = paramMap.get("pubKeyFile");
        File signFile = null;
        if (this.fileCache.get(pubKeyFile) == null) {
            signFile = this.fileClient.downloadToFile("payCenter/" + pubKeyFile);
            this.fileCache.put(pubKeyFile, signFile);
        } else {
            signFile = this.fileCache.get(pubKeyFile);
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(signFile);
            flag = BestPaySign.validateSign((String)responseStr, (InputStream)fis);
            fis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }
}

