/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.payable.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayRequest;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.request.AlipayTradeCreateRequest;
import com.alipay.api.response.AlipayTradeCreateResponse;
import com.tydic.payment.pay.busi.bo.PayAbleBusiReqDataBo;
import com.tydic.payment.pay.busi.bo.PayAbleBusiRspDataBo;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayRspBo;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.constant.PayProConstants;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.payable.api.PayAble;
import com.tydic.payment.pay.payable.impl.AbstractAliPayAble;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class AliPayAppletPayAbleImpl
extends AbstractAliPayAble
implements PayAble {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private PayPropertiesVo payPropertiesVo;

    public Long getPayMethod() {
        return PayProConstants.PayMethod.ALI_APPLET.getPayMethod();
    }

    public PayAbleDealPayRspBo dealPay(PayAbleDealPayReqBo reqBo) {
        this.LOGGER.info("\u8fdb\u5165\u652f\u4ed8\u5b9d\u5c0f\u7a0b\u5e8f\uff08\u65b0\uff09\u652f\u4ed8\u80fd\u529b\u5b9e\u73b0\u7c7b" + reqBo);
        PayAbleDealPayRspBo retBo = new PayAbleDealPayRspBo();
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            this.LOGGER.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("2057");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        String aliOpenApiDomain = this.payPropertiesVo.getAliOpenApiDomain();
        String aliNotifyUrl = this.payPropertiesVo.getAliNotifyUrl();
        if (StringUtils.isEmpty((Object)aliOpenApiDomain)) {
            this.LOGGER.error("\u652f\u4ed8\u5b9d\u8bf7\u6c42\u5730\u5740(aliOpenApiDomain)\u672a\u914d\u7f6e");
            throw new BusinessException("6034", "\u652f\u4ed8\u5b9d\u8bf7\u6c42\u5730\u5740(aliOpenApiDomain)\u672a\u914d\u7f6e");
        }
        if (StringUtils.isEmpty((Object)aliNotifyUrl)) {
            this.LOGGER.error("\u652f\u4ed8\u5b9d\u56de\u8c03\u5730\u5740(aliNotifyUrl)\u672a\u914d\u7f6e");
            throw new BusinessException("6034", "\u652f\u4ed8\u5b9d\u56de\u8c03\u5730\u5740(aliNotifyUrl)\u672a\u914d\u7f6e");
        }
        Map paramMap = reqBo.getParaMap();
        String appId = (String)paramMap.get("appid");
        String privateKey = (String)paramMap.get("privateKey");
        String publicKey = (String)paramMap.get("publicKey");
        PayAbleBusiReqDataBo reqDataBo = (PayAbleBusiReqDataBo)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)reqBo.getBusiReqData()), PayAbleBusiReqDataBo.class);
        DefaultAlipayClient alipayClient = new DefaultAlipayClient(aliOpenApiDomain, appId, privateKey, "json", "UTF-8", publicKey, "RSA2");
        AlipayTradeCreateRequest request = new AlipayTradeCreateRequest();
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
        dataMap.put("out_trade_no", reqBo.getPayOrderId());
        dataMap.put("total_amount", MoneyUtils.fenToYuan((Long)reqBo.getPayFee()).toString());
        dataMap.put("seller_id", reqDataBo.getSellerId());
        dataMap.put("buyer_logon_id", reqDataBo.getBuyerLoginId());
        dataMap.put("buyer_id", reqDataBo.getBuyerId());
        dataMap.put("subject", reqBo.getDetailName());
        dataMap.put("timeout_express", reqBo.getExtTime() + "m");
        request.setNotifyUrl(aliNotifyUrl);
        request.setBizContent(JSON.toJSONString(dataMap));
        this.LOGGER.info("\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a" + JSON.toJSONString(dataMap));
        AlipayTradeCreateResponse response = null;
        try {
            response = (AlipayTradeCreateResponse)alipayClient.execute((AlipayRequest)request);
        }
        catch (AlipayApiException e) {
            this.LOGGER.error("\u8c03\u7528\u652f\u4ed8\u5b9dSDK\u65b9\u6cd5\uff1a'sdkExecute'\u5f02\u5e38" + (Object)((Object)e));
            retBo.setRespCode("2057");
            retBo.setRespDesc("\u8c03\u7528\u652f\u4ed8\u5b9dSDK\u65b9\u6cd5\uff1a'sdkExecute'\u5f02\u5e38" + (Object)((Object)e));
            return retBo;
        }
        if (!response.isSuccess()) {
            retBo.setRespCode("2057");
            retBo.setRespDesc("\u652f\u4ed8\u5b9d\u8fd4\u56de\u9519\u8bef\uff1amsg=" + response.getMsg() + ",subMsg=" + response.getSubMsg());
            return retBo;
        }
        this.LOGGER.info("\u652f\u4ed8\u5b9dSDK\u8fd4\u56de\u7684body\uff1a" + response.getBody());
        PayAbleBusiRspDataBo rspBusiDataBo = new PayAbleBusiRspDataBo();
        rspBusiDataBo.setTradeNo(response.getTradeNo());
        BeanUtils.copyProperties((Object)reqBo, (Object)retBo);
        retBo.setBusiRspDataBo(JSON.toJSONString((Object)rspBusiDataBo));
        retBo.setPayNotifyTransId(response.getTradeNo());
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private String validateArgs(PayAbleDealPayReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getDetailName())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'detailName'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayFee())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'payFee'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'payOrderId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getParaMap())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'paraMap'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        Map paraMap = reqBo.getParaMap();
        String appId = (String)paraMap.get("appid");
        String publicKey = (String)paraMap.get("publicKey");
        String privateKey = (String)paraMap.get("privateKey");
        if (StringUtils.isEmpty((Object)appId)) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'paraMap'\u4e2dkey(appId)\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)privateKey)) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'paraMap'\u4e2dkey(privateKey)\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)publicKey)) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'paraMap'\u4e2dkey(publicKey)\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getExtTime())) {
            reqBo.setExtTime("3");
        }
        if (StringUtils.isEmpty((Object)reqBo.getBusiReqData())) {
            return "\u5165\u53c2\u5151\u73b0\u5c5e\u6027'busiReqData'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        PayAbleBusiReqDataBo reqDataBo = (PayAbleBusiReqDataBo)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)reqBo.getBusiReqData()), PayAbleBusiReqDataBo.class);
        if (StringUtils.isEmpty((Object)reqDataBo.getBuyerId()) && StringUtils.isEmpty((Object)reqDataBo.getBuyerLoginId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'busiReqData'\u4e2d'buyerId'\u548c'buyerLoginId'\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a";
        }
        return null;
    }
}

