/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.payable.impl;

import com.alibaba.fastjson.JSONObject;
import com.alipay.api.AlipayMobilePublicMultiMediaClient;
import com.alipay.api.internal.util.AlipaySignature;
import com.tydic.payment.pay.busi.QueryDBDateBusiService;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayRspBo;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.constant.PayProConstants;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.payable.impl.AbstractAliPayAble;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class AliPayJsapiPayAbleImpl
extends AbstractAliPayAble {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAliPayAble.class);
    private static final String PRODUCT_CODE = "QUICK_MSECURITY_PAY";
    private static final String CHARSET = "UTF-8";
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;

    public Long getPayMethod() {
        return PayProConstants.PayMethod.ALI_XCX.getPayMethod();
    }

    public PayAbleDealPayRspBo dealPay(PayAbleDealPayReqBo reqBo) {
        String encodeStr;
        String sign;
        PayAbleDealPayRspBo retBo = new PayAbleDealPayRspBo();
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            LOGGER.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("2031");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        String aliNotifyUrl = this.payPropertiesVo.getAliNotifyUrl();
        if (StringUtils.isEmpty((Object)aliNotifyUrl)) {
            LOGGER.error("\u652f\u4ed8\u5b9d\u56de\u8c03\u5730\u5740'aliNotifuUrl'\u672a\u914d\u7f6e");
            throw new BusinessException("6029", "\u652f\u4ed8\u5b9d\u56de\u8c03\u5730\u5740'aliNotifuUrl'\u672a\u914d\u7f6e");
        }
        Map paraMap = reqBo.getParaMap();
        String privateKey = (String)paraMap.get("privateKey");
        String appId = (String)paraMap.get("appid");
        String timeStr = new DateTime((Object)this.queryDBDateBusiService.getDBDate()).toString("yyyy-MM-dd HH:mm:ss");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("subject", (Object)reqBo.getDetailName());
        jsonObject.put("out_trade_no", (Object)reqBo.getPayOrderId());
        jsonObject.put("timeout_express", (Object)(reqBo.getExtTime() + "m"));
        jsonObject.put("total_amount", (Object)MoneyUtils.fenToYuan((Long)reqBo.getPayFee()).toString());
        jsonObject.put("product_code", (Object)PRODUCT_CODE);
        jsonObject.put("goods_type", (Object)"1");
        String jsonStr = jsonObject.toJSONString();
        HashMap<String, String> reqMap = new HashMap<String, String>(16);
        reqMap.put("app_id", appId);
        reqMap.put("method", "alipay.trade.app.pay");
        reqMap.put("charset", CHARSET);
        reqMap.put("format", "JSON");
        reqMap.put("sign_type", "RSA2");
        reqMap.put("timestamp", timeStr);
        reqMap.put("version", "1.0");
        reqMap.put("notify_url", aliNotifyUrl);
        reqMap.put("biz_content", jsonStr);
        String signContent = AlipaySignature.getSignContent(reqMap);
        try {
            sign = AlipaySignature.rsa256Sign((String)signContent, (String)privateKey, (String)CHARSET);
        }
        catch (Exception e) {
            LOGGER.error("\u53c2\u6570\u7b7e\u540d\u5f02\u5e38" + e);
            throw new BusinessException("6029", "\u53c2\u6570\u7b7e\u540d\u5f02\u5e38" + e);
        }
        reqMap.put("sign", sign);
        try {
            encodeStr = AlipayMobilePublicMultiMediaClient.buildQuery(reqMap, (String)CHARSET);
        }
        catch (Exception e) {
            LOGGER.error("\u53c2\u6570\u8fdb\u884cEncode\u5f02\u5e38");
            throw new BusinessException("6029", "\u53c2\u6570\u8fdb\u884cEncode\u5f02\u5e38");
        }
        BeanUtils.copyProperties((Object)reqBo, (Object)retBo);
        retBo.setOrderInfoStr(encodeStr);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private String validateArgs(PayAbleDealPayReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getDetailName())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'detailName'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getParaMap())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'paraMap'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'payOrderId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        Map paraMap = reqBo.getParaMap();
        String appId = (String)paraMap.get("appid");
        String publicKey = (String)paraMap.get("publicKey");
        String privateKey = (String)paraMap.get("privateKey");
        if (StringUtils.isEmpty((Object)appId)) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'paraMap'\u4e2dkey(appId)\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)privateKey)) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'paraMap'\u4e2dkey(privateKey)\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)publicKey)) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'paraMap'\u4e2dkey(publicKey)\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getExtTime())) {
            reqBo.setExtTime("3");
        }
        return null;
    }
}

