/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.payable.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayRequest;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.request.AlipayTradeAppPayRequest;
import com.alipay.api.response.AlipayTradeAppPayResponse;
import com.tydic.payment.pay.busi.bo.PayAbleAliPayNotifyDataBean;
import com.tydic.payment.pay.busi.bo.PayAbleBusiReqDataBo;
import com.tydic.payment.pay.busi.bo.PayAbleBusiRspDataBo;
import com.tydic.payment.pay.busi.bo.PayAbleCallBackReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleCallBackRspBo;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayRspBo;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.constant.PayProConstants;
import com.tydic.payment.pay.payable.impl.AbstractAliPayAble;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class AliSignAgreementAbleImpl
extends AbstractAliPayAble {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private static final String CHANNEL = "ALIPAYAPP";
    @Autowired
    private PayPropertiesVo payPropertiesVo;

    public Long getPayMethod() {
        return PayProConstants.PayMethod.ALI_SING.getPayMethod();
    }

    public PayAbleDealPayRspBo dealPay(PayAbleDealPayReqBo reqBo) {
        AlipayTradeAppPayResponse response;
        this.LOGGER.info("\u8fdb\u5165\u652f\u4ed8\u5b9d\u6263\u6b3e\u540e\u7b7e\u7ea6\u5b9e\u73b0\u7c7b\uff1a" + reqBo);
        PayAbleDealPayRspBo retBo = new PayAbleDealPayRspBo();
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            retBo.setRespCode("2050");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        String aliNotifyUrl = this.payPropertiesVo.getValueByKey("ali.pay.new.notify.url");
        String serverUrl = this.payPropertiesVo.getAliOpenApiDomain();
        if (StringUtils.isEmpty((Object)aliNotifyUrl)) {
            this.LOGGER.error("\u652f\u4ed8\u5b9d\u56de\u8c03\u5730\u5740'ali.pay.new.notify.url'\u672a\u914d\u7f6e");
            retBo.setRespCode("2050");
            retBo.setRespDesc("\u652f\u4ed8\u5b9d\u56de\u8c03\u5730\u5740'ali.pay.new.notify.url'\u672a\u914d\u7f6e");
            return retBo;
        }
        if (StringUtils.isEmpty((Object)serverUrl)) {
            this.LOGGER.error("\u652f\u4ed8\u5b9d\u8bf7\u6c42\u5730\u5740'aliOpenApiDomain'\u672a\u914d\u7f6e");
            retBo.setRespCode("2050");
            retBo.setRespDesc("\u652f\u4ed8\u5b9d\u8bf7\u6c42\u5730\u5740'aliOpenApiDomain'\u672a\u914d\u7f6e");
            return retBo;
        }
        Map paraMap = reqBo.getParaMap();
        String privateKey = (String)paraMap.get("privateKey");
        String appId = (String)paraMap.get("appid");
        String publicKey = (String)paraMap.get("publicKey");
        PayAbleBusiReqDataBo reqDataBo = (PayAbleBusiReqDataBo)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)reqBo.getBusiReqData()), PayAbleBusiReqDataBo.class);
        DefaultAlipayClient alipayClient = new DefaultAlipayClient(serverUrl, appId, privateKey, "json", "UTF-8", publicKey, "RSA2");
        AlipayTradeAppPayRequest request = new AlipayTradeAppPayRequest();
        request.setNotifyUrl(aliNotifyUrl);
        String bizContentStr = this.sortBizContent(reqDataBo, reqBo);
        request.setBizContent(bizContentStr);
        try {
            response = (AlipayTradeAppPayResponse)alipayClient.sdkExecute((AlipayRequest)request);
        }
        catch (AlipayApiException e) {
            this.LOGGER.error("\u8c03\u7528\u652f\u4ed8\u5b9dSDK\u65b9\u6cd5\uff1a'sdkExecute'\u5f02\u5e38" + (Object)((Object)e));
            retBo.setRespCode("2050");
            retBo.setRespDesc("\u8c03\u7528\u652f\u4ed8\u5b9dSDK\u65b9\u6cd5\uff1a'sdkExecute'\u5f02\u5e38" + (Object)((Object)e));
            return retBo;
        }
        if (!response.isSuccess()) {
            retBo.setRespCode("2050");
            retBo.setRespDesc("\u652f\u4ed8\u5b9d\u8fd4\u56de\u9519\u8bef\uff1amsg=" + response.getMsg() + ",subMsg=" + response.getSubMsg());
            return retBo;
        }
        this.LOGGER.info("\u652f\u4ed8\u5b9dSDK\u8fd4\u56de\u7684body:" + response.getBody());
        PayAbleBusiRspDataBo rspBusiDataBo = new PayAbleBusiRspDataBo();
        rspBusiDataBo.setOrderInfoStr(response.getBody());
        BeanUtils.copyProperties((Object)reqBo, (Object)retBo);
        retBo.setBusiRspDataBo(JSON.toJSONString((Object)rspBusiDataBo));
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    @Override
    public PayAbleCallBackRspBo dealCallBack(PayAbleCallBackReqBo reqBo) {
        boolean isSuccess;
        this.LOGGER.info("\u5f00\u59cb\u5904\u7406\u652f\u4ed8\u5b9d\u7b7e\u7ea6\u56de\u8c03\u4fe1\u606f:" + reqBo);
        PayAbleCallBackRspBo retBo = new PayAbleCallBackRspBo();
        if (StringUtils.isEmpty((Object)reqBo.getReqData())) {
            this.LOGGER.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'reqData'\u4e0d\u80fd\u4e3a\u7a7a");
            retBo.setRespCode("2055");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'reqData'\u4e0d\u80fd\u4e3a\u7a7a");
            return retBo;
        }
        JSONObject reqDataJson = JSONObject.parseObject((String)reqBo.getReqData());
        PayAbleAliPayNotifyDataBean notifyDataBean = (PayAbleAliPayNotifyDataBean)JSONObject.toJavaObject((JSON)reqDataJson, PayAbleAliPayNotifyDataBean.class);
        this.LOGGER.info("\u56de\u8c03\u53c2\u6570\u8f6c\u4e3a\u7684\u5bf9\u8c61\u4e3a\uff1a" + notifyDataBean);
        String agreementNo = notifyDataBean.getAgreement_no();
        String contractId = notifyDataBean.getExternal_agreement_no();
        if (agreementNo == null) {
            this.LOGGER.info("-----------\u83b7\u53d6agreementNo\u5931\u8d25\uff0c\u8c03\u7528\u652f\u4ed8\u7ed3\u679c\u56de\u8c03\u89e3\u6790\u65b9\u6cd5-----------");
            return super.dealCallBack(reqBo);
        }
        try {
            isSuccess = super.signatureValidation(reqBo, null, contractId);
        }
        catch (Exception e) {
            this.LOGGER.error("\u6821\u9a8c\u7b7e\u540d\u5f02\u5e38\uff1a" + e.getMessage());
            retBo.setRespCode("2055");
            retBo.setRespDesc("\u6821\u9a8c\u7b7e\u540d\u5f02\u5e38\uff1a" + e.getMessage());
            return retBo;
        }
        if (!isSuccess) {
            this.LOGGER.error("\u6821\u9a8c\u7b7e\u540d\u5931\u8d25");
            retBo.setRespCode("2055");
            retBo.setRespDesc("\u6821\u9a8c\u7b7e\u540d\u5931\u8d25");
            return retBo;
        }
        retBo.setAgreementFlag(true);
        retBo.setContractId(contractId);
        retBo.setStatus(notifyDataBean.getStatus());
        retBo.setAgreementNo(agreementNo);
        retBo.setSignTime(notifyDataBean.getSign_time());
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private String sortBizContent(PayAbleBusiReqDataBo reqDataBo, PayAbleDealPayReqBo reqBo) {
        HashMap<String, Object> bizContentMap = new HashMap<String, Object>(16);
        bizContentMap.put("total_amount", MoneyUtils.fenToYuan((Long)reqBo.getPayFee()).toString());
        bizContentMap.put("product_code", reqDataBo.getProductCode());
        bizContentMap.put("subject", reqBo.getDetailName());
        bizContentMap.put("body", reqBo.getDetailName());
        bizContentMap.put("out_trade_no", reqBo.getPayOrderId());
        HashMap<String, Object> signParaMap = new HashMap<String, Object>(16);
        signParaMap.put("personal_product_code", reqDataBo.getPersonalProductCode());
        signParaMap.put("sign_scene", reqDataBo.getSignScene());
        signParaMap.put("external_agreement_no", reqDataBo.getContractId());
        HashMap<String, String> accessMap = new HashMap<String, String>(16);
        accessMap.put("channel", CHANNEL);
        HashMap<String, Object> periodMap = new HashMap<String, Object>(16);
        periodMap.put("period_type", reqDataBo.getPeriodType());
        periodMap.put("period", reqDataBo.getPeriod());
        periodMap.put("execute_time", reqDataBo.getExecuteTime());
        periodMap.put("single_amount", MoneyUtils.fenToYuan((String)reqDataBo.getSingleAmount()));
        signParaMap.put("access_params", accessMap);
        signParaMap.put("period_rule_params", periodMap);
        bizContentMap.put("agreement_sign_params", signParaMap);
        String jsonStr = JSON.toJSONString(bizContentMap);
        this.LOGGER.info("\u652f\u4ed8\u5b9d\u63a5\u53e3\u5165\u53c2\u4fe1\u606f\uff1a" + jsonStr);
        return jsonStr;
    }

    private String validateArgs(PayAbleDealPayReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getDetailName())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'detailName'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayFee())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'payFee'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'payOrderId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getParaMap())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'paraMap'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        Map paraMap = reqBo.getParaMap();
        String appId = (String)paraMap.get("appid");
        String publicKey = (String)paraMap.get("publicKey");
        String privateKey = (String)paraMap.get("privateKey");
        if (StringUtils.isEmpty((Object)appId)) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'paraMap'\u4e2dkey(appId)\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)privateKey)) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'paraMap'\u4e2dkey(privateKey)\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)publicKey)) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'paraMap'\u4e2dkey(publicKey)\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getExtTime())) {
            reqBo.setExtTime("3");
        }
        if (StringUtils.isEmpty((Object)reqBo.getBusiReqData())) {
            return "\u5165\u53c2\u5151\u73b0\u5c5e\u6027'busiReqData'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        PayAbleBusiReqDataBo reqDataBo = (PayAbleBusiReqDataBo)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)reqBo.getBusiReqData()), PayAbleBusiReqDataBo.class);
        if (StringUtils.isEmpty((Object)reqDataBo.getContractId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'busiReqData'\u4e2d'contractId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqDataBo.getProductCode())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'busiReqData'\u4e2d'productCode'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqDataBo.getPeriodType())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'busiReqData'\u4e2d'periodType'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqDataBo.getPeriod())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'busiReqData'\u4e2d'period'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqDataBo.getExecuteTime())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'busiReqData'\u4e2d'executeTime'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqDataBo.getSingleAmount())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'busiReqData'\u4e2d'singleAmount'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqDataBo.getPersonalProductCode())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'busiReqData'\u4e2d'personalProductCode'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqDataBo.getSignScene())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'busiReqData'\u4e2d'signScene'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

