/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.payable.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.payment.pay.bestpay.util.BestPayAppResponseBean;
import com.tydic.payment.pay.bestpay.util.HttpClientPost;
import com.tydic.payment.pay.busi.QueryDBDateBusiService;
import com.tydic.payment.pay.busi.bo.PayAbleBusiReqDataBo;
import com.tydic.payment.pay.busi.bo.PayAbleBusiRspDataBo;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayRspBo;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.constant.PayProConstants;
import com.tydic.payment.pay.payable.impl.AbstractBastPayAble;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BestPayAppPayAbleImpl
extends AbstractBastPayAble {
    private Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;
    @Autowired
    private PayPropertiesVo payPropertiesVo;

    public Long getPayMethod() {
        return PayProConstants.PayMethod.BEST_PAY.getPayMethod();
    }

    public PayAbleDealPayRspBo dealPay(PayAbleDealPayReqBo reqBo) {
        this.LOGGER.info("\u7ffc\u652f\u4ed8\u80fd\u529b\u5b9e\u73b0\u7c7b\uff1a" + reqBo);
        PayAbleDealPayRspBo retBo = new PayAbleDealPayRspBo();
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            this.LOGGER.error("\u7ffc\u652f\u4ed8\u80fd\u529b\u5b9e\u73b0\u7c7b\uff0c\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("2043");
            retBo.setRespDesc("\u7ffc\u652f\u4ed8\u80fd\u529b\u5b9e\u73b0\u7c7b\uff0c\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        String bestPayRequestUrl = this.payPropertiesVo.getValueByKey("bestpay.app.request.url");
        if (StringUtils.isEmpty((Object)bestPayRequestUrl)) {
            this.LOGGER.error("\u7ffc\u652f\u4ed8\u8bf7\u6c42\u5730\u5740\u4e3a\u7a7a\uff0c\u8bf7\u914d\u7f6e\uff1abestpay.app.request.url");
            retBo.setRespCode("2043");
            retBo.setRespDesc("\u7ffc\u652f\u4ed8\u8bf7\u6c42\u5730\u5740\u4e3a\u7a7a\uff0c\u8bf7\u914d\u7f6e\uff1abestpay.app.request.url");
            return retBo;
        }
        String bestPayCallbackUrl = this.payPropertiesVo.getValueByKey("bestpay.app.callback.url");
        if (StringUtils.isEmpty((Object)bestPayCallbackUrl)) {
            this.LOGGER.error("\u7ffc\u652f\u4ed8\u56de\u8c03\u5730\u5740\u4e3a\u7a7a\uff0c\u8bf7\u914d\u7f6e\uff1abestpay.app.callback.url");
            retBo.setRespCode("2043");
            retBo.setRespDesc("\u7ffc\u652f\u4ed8\u56de\u8c03\u5730\u5740\u4e3a\u7a7a\uff0c\u8bf7\u914d\u7f6e\uff1abestpay.app.callback.url");
            return retBo;
        }
        Map<String, String> dataMap = this.assignMap(reqBo);
        Map paramMap = reqBo.getParaMap();
        String sign = this.generateSign(paramMap, dataMap);
        dataMap.put("sign", sign);
        String bestPayReqData = JSON.toJSONString(dataMap);
        this.LOGGER.info("\u7ffc\u652f\u4ed8\u63a5\u53e3\u5165\u53c2\uff1a" + bestPayReqData);
        String responseStr = null;
        try {
            responseStr = HttpClientPost.reqPost((String)bestPayRequestUrl, (String)bestPayReqData);
        }
        catch (IOException e) {
            this.LOGGER.error("\u5411\u7ffc\u652f\u4ed8\u4e0b\u5355\u65f6\u53d1\u751f\u5f02\u5e38\uff1a" + e);
            retBo.setRespCode("2043");
            retBo.setRespDesc("\u5411\u7ffc\u652f\u4ed8\u4e0b\u5355\u65f6\u53d1\u751f\u5f02\u5e38\uff1a" + e);
            return retBo;
        }
        this.LOGGER.info("\u7ffc\u652f\u4ed8\u8fd4\u56de\u7684\u62a5\u6587\uff1a" + responseStr);
        JSONObject bestRetJson = JSONObject.parseObject((String)responseStr);
        if (!"true".equals(bestRetJson.getString("success"))) {
            this.LOGGER.error("\u5411\u7ffc\u652f\u4ed8\u4e0b\u5355\u5931\u8d25\uff1a" + bestRetJson.get((Object)"errorMsg"));
            retBo.setRespCode("2043");
            retBo.setRespDesc("\u5411\u7ffc\u652f\u4ed8\u4e0b\u5355\u5931\u8d25\uff1a" + bestRetJson.getString("errorMsg"));
            return retBo;
        }
        boolean signFlag = this.checkSign(paramMap, responseStr);
        if (!signFlag) {
            this.LOGGER.error("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
            retBo.setRespCode("2043");
            retBo.setRespDesc("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
            return retBo;
        }
        String result = bestRetJson.getString("result");
        BestPayAppResponseBean bestRetBean = (BestPayAppResponseBean)JSONObject.toJavaObject((JSON)JSON.parseObject((String)result), BestPayAppResponseBean.class);
        PayAbleBusiRspDataBo busiRspDataBo = new PayAbleBusiRspDataBo();
        busiRspDataBo.setBestPayJson(this.assemblePayJson(reqBo, bestRetBean));
        BeanUtils.copyProperties((Object)reqBo, (Object)retBo);
        retBo.setBusiRspDataBo(JSON.toJSONString((Object)busiRspDataBo));
        retBo.setPayNotifyTransId(bestRetBean.getTradeNo());
        retBo.setPayResultCode(bestRetBean.getTradeStatus());
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private String validateArgs(PayAbleDealPayReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getBusiReqData())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'busiReqData'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'payOrderId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getDetailName())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'detailName'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getExtTime())) {
            reqBo.setExtTime("1800");
        } else {
            reqBo.setExtTime(Integer.parseInt(reqBo.getExtTime()) * 60 + "");
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayFee())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'payFee'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        PayAbleBusiReqDataBo busiReqDataBo = (PayAbleBusiReqDataBo)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)reqBo.getBusiReqData()), PayAbleBusiReqDataBo.class);
        if (StringUtils.isEmpty((Object)busiReqDataBo.getAccountId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'busiReqData'\u4e2d\u7684'accountId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (reqBo.getParaMap() == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'paraMap'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        String validateMapStr = this.validateParaMap(reqBo.getParaMap());
        if (!StringUtils.isEmpty((Object)validateMapStr)) {
            return validateMapStr;
        }
        return null;
    }

    private Map<String, String> assignMap(PayAbleDealPayReqBo reqBo) {
        String callbackUrl = this.payPropertiesVo.getValueByKey("bestpay.app.callback.url");
        Map paramMap = reqBo.getParaMap();
        Date dbDate = this.queryDBDateBusiService.getDBDate();
        HashMap<String, String> postData = new HashMap<String, String>(16);
        postData.put("institutionCode", (String)paramMap.get("merchantId"));
        postData.put("institutionType", "MERCHANT");
        postData.put("merchantNo", (String)paramMap.get("merchantId"));
        postData.put("requestDate", new DateTime((Object)dbDate).toString("yyyy-MM-dd HH:mm:ss"));
        postData.put("notifyUrl", callbackUrl);
        postData.put("operator", (String)paramMap.get("merchantId"));
        postData.put("tradeChannel", "APP");
        postData.put("accessCode", "CASHIER");
        postData.put("mediumType", "WIRELESS");
        postData.put("ccy", "156");
        postData.put("timeout", reqBo.getExtTime());
        postData.put("outTradeNo", reqBo.getPayOrderId());
        postData.put("tradeAmt", reqBo.getPayFee().toString());
        postData.put("subject", reqBo.getDetailName());
        postData.put("storeCode", "yzfmall001");
        if (reqBo.getBusiReqData() != null) {
            PayAbleBusiReqDataBo busiReqDataBo = (PayAbleBusiReqDataBo)JSONObject.toJavaObject((JSON)JSON.parseObject((String)reqBo.getBusiReqData()), PayAbleBusiReqDataBo.class);
            postData.put("goodsInfo", busiReqDataBo.getGoodsInfo());
        }
        JSONObject data = new JSONObject();
        data.put("service_identify", (Object)"10000001");
        data.put("product_type", (Object)1);
        data.put("subject", (Object)reqBo.getDetailName());
        data.put("boby", (Object)reqBo.getDetailName());
        data.put("goods_count", (Object)"1");
        String riskControlInfo = "[" + data + "]";
        postData.put("riskControlInfo", riskControlInfo);
        this.LOGGER.info("\u672a\u7b7e\u540d\u524d\u7684\u53c2\u6570MAP:" + postData);
        return postData;
    }

    private Map<String, String> assemblePayJson(PayAbleDealPayReqBo reqBo, BestPayAppResponseBean bestRetBean) {
        Map paramMap = reqBo.getParaMap();
        PayAbleBusiReqDataBo busiReqDataBo = (PayAbleBusiReqDataBo)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)reqBo.getBusiReqData()), PayAbleBusiReqDataBo.class);
        HashMap<String, String> postData = new HashMap<String, String>(16);
        postData.put("INSTITUTIONCODE", (String)paramMap.get("merchantId"));
        postData.put("INSTITUTIONTYPE", "MERCHANT");
        postData.put("SIGNTYPE", "CA");
        postData.put("SERVICE", "mobile.security.pay");
        postData.put("MERCHANTID", (String)paramMap.get("merchantId"));
        postData.put("SUBMERCHANTID", "deprecated");
        postData.put("BACKMERCHANTURL", "deprecated");
        postData.put("ORDERSEQ", bestRetBean.getTradeprodNo());
        postData.put("ORDERREQTRANSEQ", bestRetBean.getOutTradeNo());
        postData.put("TRADENO", bestRetBean.getTradeNo());
        postData.put("ORDERTIME", "deprecated");
        postData.put("ORDERVALIDITYTIME", "deprecated");
        postData.put("ORDERAMOUNT", reqBo.getPayFee().toString());
        postData.put("CURTYPE", "156");
        postData.put("PRODUCTID", "04");
        postData.put("PRODUCTDESC", reqBo.getDetailName());
        postData.put("PRODUCTAMOUNT", reqBo.getPayFee().toString());
        postData.put("ATTACHAMOUNT", "0.00");
        postData.put("BUSITYPE", "04");
        postData.put("SWTICHACC", "true");
        postData.put("ACCOUNTID", busiReqDataBo.getAccountId());
        postData.put("SUBJECT", reqBo.getDetailName());
        postData.put("SIGN", this.generateSign(paramMap, postData));
        this.LOGGER.info("\u524d\u7aef\u6240\u9700dataMap:" + postData);
        return postData;
    }
}

