/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.payable.impl;

import com.tydic.payment.pay.busi.PayProWxUnifiedOrderBusiService;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayRspBo;
import com.tydic.payment.pay.busi.bo.PayProWxUnifiedOrderBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayProWxUnifiedOrderBusiRspBo;
import com.tydic.payment.pay.constant.PayProConstants;
import com.tydic.payment.pay.payable.api.PayAble;
import com.tydic.payment.pay.payable.impl.AbstractWxPayAble;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class WxPayQrCodePayAbleImpl
extends AbstractWxPayAble
implements PayAble {
    private static final Logger LOG = LoggerFactory.getLogger(WxPayQrCodePayAbleImpl.class);
    @Autowired
    private PayProWxUnifiedOrderBusiService payProWxUnifiedOrderBusiService;
    private static final String NATIVE = "NATIVE";

    public Long getPayMethod() {
        return PayProConstants.PayMethod.WX_QR.getPayMethod();
    }

    public PayAbleDealPayRspBo dealPay(PayAbleDealPayReqBo reqBo) {
        PayAbleDealPayRspBo retBo = new PayAbleDealPayRspBo();
        String validataArgStr = this.validataArg(reqBo);
        if (!StringUtils.isEmpty((Object)validataArgStr)) {
            retBo.setRespCode("2012");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validataArgStr);
            return retBo;
        }
        PayProWxUnifiedOrderBusiReqBo payProWxUnifiedOrderBusiReqBo = new PayProWxUnifiedOrderBusiReqBo();
        payProWxUnifiedOrderBusiReqBo.setParaMap(reqBo.getParaMap());
        payProWxUnifiedOrderBusiReqBo.setBody(reqBo.getDetailName());
        payProWxUnifiedOrderBusiReqBo.setPayOrderId(reqBo.getPayOrderId());
        payProWxUnifiedOrderBusiReqBo.setPayMethod(PayProConstants.PayMethod.WX_QR.getPayMethod() + "");
        payProWxUnifiedOrderBusiReqBo.setTradeType(NATIVE);
        payProWxUnifiedOrderBusiReqBo.setSpbillCreateIp(reqBo.getCreateIpAddress());
        payProWxUnifiedOrderBusiReqBo.setTotalFee(reqBo.getPayFee() + "");
        payProWxUnifiedOrderBusiReqBo.setExtTime(reqBo.getExtTime());
        PayProWxUnifiedOrderBusiRspBo unifiedRetBo = this.payProWxUnifiedOrderBusiService.unifiedOrder(payProWxUnifiedOrderBusiReqBo);
        LOG.info("\u8c03\u7528\u7edf\u4e00\u4e0b\u5355\u63a5\u53e3\u8fd4\u56de\u503c\u4e3a\uff1a" + unifiedRetBo);
        if (!"0000".equals(unifiedRetBo.getRespCode())) {
            retBo.setRespCode("2012");
            retBo.setRespDesc("\u8c03\u7528\u5fae\u4fe1\u7edf\u4e00\u4e0b\u5355busi\u670d\u52a1\u5931\u8d25\uff1a" + unifiedRetBo.getRespDesc());
            return retBo;
        }
        BeanUtils.copyProperties((Object)reqBo, (Object)retBo);
        retBo.setQrCodeUrl(unifiedRetBo.getCodeUrl());
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        retBo.setPayOrderId(unifiedRetBo.getPayOrderId());
        return retBo;
    }

    private String validataArg(PayAbleDealPayReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getDetailName())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027detailName\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getParaMap())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027paraMap\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayFee())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027payFee\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027payOrderId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        Map paraMap = reqBo.getParaMap();
        String appId = (String)paraMap.get("appid");
        String mchId = (String)paraMap.get("mchid");
        String signKey = (String)paraMap.get("signkey");
        if (StringUtils.isEmpty((Object)appId)) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027paraMap\u4e2d(appId)\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)mchId)) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027paraMap\u4e2d(mchId)\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)signKey)) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027paraMap\u4e2d(signKey)\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

