/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.bill.busi.impl;

import com.tydic.payment.bill.busi.BillCompareDiffQueryBusiService;
import com.tydic.payment.bill.busi.bo.BillCompareDiffQueryReqBO;
import com.tydic.payment.bill.busi.bo.BillCompareDiffQueryRspBO;
import com.tydic.payment.pay.dao.BillCompareDiffMapper;
import com.tydic.payment.pay.dao.po.BillCompareDiffPO;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="billCompareDiffQueryBusiService")
public class BillCompareDiffQueryBusiServiceImpl
implements BillCompareDiffQueryBusiService {
    @Autowired
    private BillCompareDiffMapper billCompareDiffMapper;

    public List<BillCompareDiffQueryRspBO> query(BillCompareDiffQueryReqBO reqBO) {
        List<BillCompareDiffPO> pos = this.billCompareDiffMapper.queryByBillDateDiff(reqBO.getBillDate(), reqBO.getPaymentInsId(), reqBO.getPaymentMchId());
        if (pos == null || pos.size() < 1) {
            return new ArrayList<BillCompareDiffQueryRspBO>();
        }
        ArrayList<BillCompareDiffQueryRspBO> bos = new ArrayList<BillCompareDiffQueryRspBO>(pos.size());
        for (BillCompareDiffPO po : pos) {
            BillCompareDiffQueryRspBO bo = new BillCompareDiffQueryRspBO();
            BeanUtils.copyProperties((Object)po, (Object)bo);
            bos.add(bo);
        }
        return bos;
    }

    public boolean hasOrder(BillCompareDiffQueryRspBO diff) {
        if (Objects.equals("01", diff.getOrderType())) {
            BillCompareDiffPO po = this.billCompareDiffMapper.queryTypeOrder(diff.getOrderId(), diff.getBillDate(), diff.getPayOrderId(), "02");
            return po != null;
        }
        if (Objects.equals("02", diff.getOrderType())) {
            BillCompareDiffPO po = this.billCompareDiffMapper.queryTypeOrder(diff.getOrderId(), diff.getBillDate(), diff.getPayOrderId(), "01");
            return po != null;
        }
        return false;
    }
}

